/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.breadcrumbbar;

import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.plaf.basic.BasicToggleButtonUI;
import org.fife.ui.breadcrumbbar.BreadcrumbBarButtonColorSet;
import org.fife.ui.breadcrumbbar.ButtonBorder;

public class BreadcrumbBarToggleButtonUI
extends BasicToggleButtonUI {
    private BreadcrumbBarButtonColorSet colors = new BreadcrumbBarButtonColorSet();

    public BreadcrumbBarButtonColorSet getColorSet() {
        return this.colors;
    }

    @Override
    protected void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        b.setMargin(new Insets(5, 3, 5, 3));
        b.setRolloverEnabled(true);
        b.setFocusable(false);
        b.setBorder(new ButtonBorder());
        b.setOpaque(false);
        this.colors.initialize(b);
        b.putClientProperty("breadcrumbBorderColor", this.colors.borderColor);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        if (model.isSelected() || model.isPressed()) {
            g.setColor(this.colors.pressedC1);
            g.fillRect(0, 0, b.getWidth(), b.getHeight() / 2);
            g.setColor(this.colors.pressedC2);
            g.fillRect(0, b.getHeight() / 2, b.getWidth(), b.getHeight() / 2);
            c.setForeground(this.colors.pressedFG);
        } else if (model.isRollover() || model.isArmed()) {
            g.setColor(this.colors.rolloverC1);
            g.fillRect(0, 0, b.getWidth(), b.getHeight() / 2);
            g.setColor(this.colors.rolloverC2);
            g.fillRect(0, b.getHeight() / 2, b.getWidth(), b.getHeight() / 2);
            c.setForeground(this.colors.rolloverFG);
        } else {
            c.setForeground(this.colors.defaultFG);
        }
        super.paint(g, c);
    }
}

