/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.dockablewindows;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.lang.reflect.Field;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.TabbedPaneUI;
import javax.swing.table.JTableHeader;
import org.fife.ui.UIUtil;
import org.fife.ui.WebLookAndFeelUtils;
import org.fife.ui.dockablewindows.Actions;
import org.fife.ui.dockablewindows.DockableWindow;
import org.fife.ui.dockablewindows.DockableWindowPanel;
import org.fife.ui.dockablewindows.DockableWindowUtil;
import org.fife.ui.dockablewindows.DockedWindowTabbedPaneUI;
import org.fife.util.DarculaUtil;
import org.fife.util.SubstanceUtil;

class DockableWindowGroup
extends JPanel {
    private static final long serialVersionUID = 1L;
    private DockableWindowPanel.ContentPanel parent;
    private JTabbedPane tabbedPane;
    private TitlePanel titlePanel;

    DockableWindowGroup(DockableWindowPanel.ContentPanel parent) {
        this.parent = parent;
        this.setLayout(new BorderLayout());
        this.tabbedPane = new DockedTabbedPane();
        this.add(this.tabbedPane);
        this.titlePanel = new TitlePanel("Hello world");
        this.tabbedPane.addChangeListener(this.titlePanel);
        this.add((Component)this.titlePanel, "North");
    }

    public boolean addDockableWindow(DockableWindow window) {
        this.tabbedPane.addTab(window.getDockableWindowName(), window.getIcon(), window);
        this.titlePanel.stateChanged(null);
        return true;
    }

    public int containsDockableWindow(DockableWindow window) {
        int count = this.tabbedPane.getTabCount();
        for (int i = 0; i < count; ++i) {
            Component c = this.tabbedPane.getComponentAt(i);
            if (c != window) continue;
            return i;
        }
        return -1;
    }

    public void focusActiveDockableWindow() {
        DockableWindow dwind = this.getDockableWindowAt(this.tabbedPane.getSelectedIndex());
        dwind.focused();
    }

    public int getDockableWindowCount() {
        return this.tabbedPane.getTabCount();
    }

    public DockableWindow[] getDockableWindows() {
        int count = this.tabbedPane.getTabCount();
        DockableWindow[] windows = new DockableWindow[count];
        for (int i = 0; i < count; ++i) {
            windows[i] = (DockableWindow)this.tabbedPane.getComponentAt(i);
        }
        return windows;
    }

    public DockableWindow getDockableWindowAt(int index) {
        return (DockableWindow)this.tabbedPane.getComponentAt(index);
    }

    public void refreshTabName(int index) {
        if (index >= 0 && index < this.tabbedPane.getTabCount()) {
            DockableWindow w = (DockableWindow)this.tabbedPane.getComponentAt(index);
            String name = w.getDockableWindowName();
            this.tabbedPane.setTitleAt(index, name);
            this.refreshTabTitle(index);
        }
    }

    public void refreshTabTitle(int index) {
        if (index == this.tabbedPane.getSelectedIndex()) {
            DockableWindow w = (DockableWindow)this.tabbedPane.getComponentAt(index);
            String title = w.getDockableWindowTitle();
            this.titlePanel.setTitle(title);
        }
    }

    public boolean removeDockableWindow(DockableWindow window) {
        int index = this.containsDockableWindow(window);
        if (index > -1) {
            this.tabbedPane.removeTabAt(index);
            this.titlePanel.stateChanged(null);
            return true;
        }
        return false;
    }

    public void setActiveDockableWindow(int index) {
        if (index >= 0 && index < this.tabbedPane.getTabCount()) {
            this.tabbedPane.setSelectedIndex(index);
        }
    }

    private class TitlePanel
    extends JPanel
    implements ChangeListener {
        private JLabel label;
        private JToolBar tb;
        private JButton minimizeButton;
        private Color gradient1;
        private Color gradient2;

        TitlePanel(String title) {
            super(new BorderLayout());
            this.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
            this.refreshGradientColors();
            this.label = new JLabel(title);
            this.refreshLabelForeground();
            this.add(this.label);
            this.minimizeButton = new JButton(new MinimizeAction());
            this.minimizeButton.setOpaque(false);
            this.minimizeButton.setContentAreaFilled(false);
            this.tb = new JToolBar();
            this.tb.setRollover(true);
            this.tb.setFloatable(false);
            this.tb.setOpaque(false);
            this.tb.setBorder(null);
            this.tb.add(this.minimizeButton);
            WebLookAndFeelUtils.fixToolbar(this.tb, true);
            this.add((Component)this.tb, "After");
        }

        public Color darker(Color c) {
            double factor = 0.85;
            return new Color(Math.max((int)((double)c.getRed() * 0.85), 0), Math.max((int)((double)c.getGreen() * 0.85), 0), Math.max((int)((double)c.getBlue() * 0.85), 0));
        }

        @Override
        public Dimension getMinimumSize() {
            Dimension d = this.getPreferredSize();
            d.width = 32;
            return d;
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension d = super.getPreferredSize();
            d.height = 20;
            return d;
        }

        private boolean getUseCustomColors() {
            String laf = UIManager.getLookAndFeel().getClass().getName();
            return laf.endsWith("WindowsLookAndFeel") || laf.endsWith("MetalLookAndFeel");
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2d = (Graphics2D)g;
            GradientPaint paint = new GradientPaint(0.0f, 0.0f, this.gradient1, 0.0f, this.getHeight(), this.gradient2);
            Paint oldPaint = g2d.getPaint();
            g2d.setPaint(paint);
            Rectangle bounds = this.getBounds();
            g2d.fillRect(0, 0, bounds.width, bounds.height);
            g2d.setPaint(oldPaint);
            g2d.setColor(DockableWindowUtil.getDockableWindowBorderColor());
            g2d.drawLine(0, 0, bounds.width - 1, 0);
            g2d.drawLine(0, 0, 0, bounds.height - 1);
            g2d.drawLine(bounds.width - 1, 0, bounds.width - 1, bounds.height - 1);
            g2d.drawLine(0, bounds.height - 1, bounds.width - 1, bounds.height - 1);
        }

        public void setTitle(String title) {
            this.label.setText(title);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            int index = DockableWindowGroup.this.tabbedPane.getSelectedIndex();
            if (index > -1) {
                DockableWindow w = DockableWindowGroup.this.getDockableWindowAt(index);
                this.setTitle(w.getDockableWindowTitle());
            }
        }

        private void refreshGradientColors() {
            this.gradient2 = null;
            this.gradient1 = null;
            if (this.getUseCustomColors()) {
                this.gradient1 = new Color(225, 233, 241);
                this.gradient2 = new Color(153, 180, 209);
            } else if (SubstanceUtil.isSubstanceInstalled()) {
                try {
                    this.gradient1 = SubstanceUtil.getSubstanceColor("ultraLightColor");
                    this.gradient2 = SubstanceUtil.getSubstanceColor("lightColor");
                }
                catch (RuntimeException re) {
                    throw re;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (WebLookAndFeelUtils.isWebLookAndFeelInstalled()) {
                this.getWebLookAndFeelGradientColors();
            }
            if (this.gradient1 == null) {
                this.gradient1 = UIManager.getColor("TextField.selectionBackground");
                if (this.gradient1 == null) {
                    this.gradient1 = UIManager.getColor("textHighlight");
                    if (this.gradient1 == null) {
                        this.gradient1 = new Color(153, 180, 209);
                    }
                }
                this.gradient2 = this.darker(this.gradient1);
            }
        }

        private void getWebLookAndFeelGradientColors() {
            JTableHeader header = new JTableHeader();
            Class<?> clazz = header.getUI().getClass();
            try {
                Field f1 = clazz.getDeclaredField("topBgColor");
                Field f2 = clazz.getDeclaredField("bottomBgColor");
                this.gradient1 = (Color)f1.get(null);
                this.gradient2 = (Color)f2.get(null);
            }
            catch (Exception e) {
                this.gradient2 = null;
                this.gradient1 = null;
                e.printStackTrace();
            }
        }

        private void refreshLabelForeground() {
            Color c = null;
            if (this.getUseCustomColors()) {
                c = UIManager.getColor("Label.foreground");
            } else if (SubstanceUtil.isSubstanceInstalled()) {
                c = UIManager.getColor("Label.foreground");
            } else if (WebLookAndFeelUtils.isWebLookAndFeelInstalled()) {
                c = new JTableHeader().getForeground();
            }
            if (c == null && (c = UIManager.getColor("TextField.selectionForeground")) == null && (c = UIManager.getColor("nimbusSelectedText")) == null && (c = UIManager.getColor("textHighlightText")) == null) {
                c = Color.black;
            }
            c = new Color(c.getRed(), c.getGreen(), c.getBlue());
            this.label.setForeground(c);
        }

        @Override
        public void updateUI() {
            super.updateUI();
            if (this.label != null) {
                this.label.updateUI();
            }
            this.refreshGradientColors();
            if (this.label != null) {
                this.refreshLabelForeground();
            }
            if (this.tb != null) {
                WebLookAndFeelUtils.fixToolbar(this.tb, true);
            }
        }

        private class MinimizeAction
        extends AbstractAction {
            MinimizeAction() {
                this.putValue("ShortDescription", DockableWindow.getString("Button.Minimize"));
                ImageIcon icon = new ImageIcon(this.getClass().getResource("minimize.png"));
                this.putValue("SmallIcon", icon);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                DockableWindowGroup.this.parent.setCollapsed(true);
            }
        }
    }

    private class DockedTabbedPane
    extends JTabbedPane {
        private JPopupMenu popup;

        DockedTabbedPane() {
            super(3);
            this.setTabLayoutPolicy(1);
            this.enableEvents(16L);
        }

        private JPopupMenu getPopupMenu() {
            if (this.popup == null) {
                DockableWindowPanel dwindPanel = DockableWindowGroup.this.parent.getDockableWindowPanel();
                this.popup = Actions.createRedockPopupMenu(dwindPanel);
            }
            return this.popup;
        }

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            RenderingHints old = UIUtil.setNativeRenderingHints(g2d);
            super.paintComponent(g);
            g2d.setRenderingHints(old);
        }

        @Override
        protected void processMouseEvent(MouseEvent e) {
            if (SwingUtilities.isRightMouseButton(e)) {
                int y;
                int x;
                int index;
                if (e.isPopupTrigger() && (index = this.indexAtLocation(x = e.getX(), y = e.getY())) != -1) {
                    this.setSelectedIndex(index);
                    DockableWindow dwind = (DockableWindow)this.getSelectedComponent();
                    this.putClientProperty("DockableWindow", dwind);
                    JPopupMenu popup = this.getPopupMenu();
                    popup.show(this, x, y);
                }
            } else {
                super.processMouseEvent(e);
            }
        }

        @Override
        public void setSelectedIndex(int index) {
            super.setSelectedIndex(index);
            final DockableWindow dwind = (DockableWindow)this.getSelectedComponent();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    dwind.focused();
                }
            });
        }

        @Override
        public void setUI(TabbedPaneUI ui) {
            if (!DarculaUtil.isDarculaUI(ui)) {
                ui = new DockedWindowTabbedPaneUI();
            }
            super.setUI(ui);
        }
    }
}

