/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.dockablewindows;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.plaf.SplitPaneUI;
import org.fife.ui.CleanSplitPaneUI;
import org.fife.ui.WebLookAndFeelUtils;
import org.fife.ui.dockablewindows.Actions;
import org.fife.ui.dockablewindows.DockableWindow;
import org.fife.ui.dockablewindows.DockableWindowConstants;
import org.fife.ui.dockablewindows.DockableWindowEvent;
import org.fife.ui.dockablewindows.DockableWindowGroup;
import org.fife.ui.dockablewindows.DockableWindowListener;
import org.fife.ui.dockablewindows.FloatingWindow;

public class DockableWindowPanel
extends JPanel
implements DockableWindowListener,
PropertyChangeListener,
DockableWindowConstants {
    public static final int LARGE_ON_SIDES = 0;
    public static final int LARGE_ON_TOP_AND_BOTTOM = 1;
    private ContentPanel[] panels;
    private FloatingWindow[] floatingWindows;
    private SortedSet<String> listeningTo;
    private int dockingStyle;
    protected List<DockableWindow> windowList;
    private int[] panelToLocationMap = new int[]{0, 2, 1, 3, 1, 3, 0, 2};

    public DockableWindowPanel() {
        int i;
        this.panels = new ContentPanel[4];
        for (i = 0; i < 4; ++i) {
            this.panels[i] = new ContentPanel();
            this.panels[i].setDockableWindowsLocation(this.panelToLocationMap[i]);
        }
        for (i = 0; i < 3; ++i) {
            this.panels[i + 1].add(this.panels[i]);
        }
        this.setDockingStyle(0);
        this.setLayout(new GridLayout(1, 1));
        this.add(this.panels[3]);
        ComponentOrientation orientation = ComponentOrientation.getOrientation(this.getLocale());
        this.applyComponentOrientation(orientation);
        this.setBorder(BorderFactory.createEmptyBorder(0, 3, 2, 3));
        this.listeningTo = new TreeSet<String>();
    }

    public boolean addDockableWindow(DockableWindow window) {
        int pos = window.getPosition();
        if (!DockableWindow.isValidPosition(pos)) {
            throw new IllegalArgumentException("Invalid position");
        }
        this.addDockableWindowToList(window);
        if (!window.isActive()) {
            this.addListeners(window);
            return true;
        }
        switch (pos) {
            case 4: {
                if (this.floatingWindows == null) {
                    this.floatingWindows = new FloatingWindow[1];
                } else {
                    FloatingWindow[] temp = new FloatingWindow[this.floatingWindows.length + 1];
                    System.arraycopy(this.floatingWindows, 0, temp, 0, this.floatingWindows.length);
                    this.floatingWindows = temp;
                }
                int current = this.floatingWindows.length - 1;
                this.floatingWindows[current] = this.createFloatingWindowFrame(window);
                Window focused = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
                this.floatingWindows[current].setVisible(true);
                if (focused != null) {
                    focused.requestFocus();
                }
                this.addListeners(window);
                return true;
            }
        }
        for (int p = 0; p < 4; ++p) {
            if (this.panelToLocationMap[p] != pos) continue;
            ContentPanel cp = this.panels[p];
            boolean rc = cp.addDockableWindow(window);
            if (rc) {
                this.addListeners(window);
            }
            return rc;
        }
        return false;
    }

    private synchronized void addDockableWindowToList(DockableWindow window) {
        if (this.windowList == null) {
            this.windowList = new ArrayList<DockableWindow>();
        }
        this.windowList.add(window);
    }

    private void addListeners(DockableWindow window) {
        if (!this.listeningTo.contains(window.getDockableWindowName())) {
            window.addDockableWindowListener(this);
            window.addPropertyChangeListener(this);
        }
    }

    private FloatingWindow createFloatingWindowFrame(DockableWindow window) {
        FloatingWindow temp = new FloatingWindow(window);
        Window parentWind = SwingUtilities.getWindowAncestor(this);
        if (parentWind instanceof JFrame) {
            temp.setIconImage(((JFrame)parentWind).getIconImage());
        }
        temp.pack();
        return temp;
    }

    @Override
    public void dockableWindowPositionChanged(DockableWindowEvent e) {
        DockableWindow window = (DockableWindow)e.getSource();
        this.removeDockableWindow(window);
        if (!this.addDockableWindow(window)) {
            throw new InternalError("Couldn't add dockable window");
        }
    }

    @Override
    public void dockableWindowPositionWillChange(DockableWindowEvent e) {
    }

    public boolean focusDockableWindowGroup(int group) {
        if (group < 0 || group >= 4) {
            throw new IllegalArgumentException("group must be a valid value from DockableWindowConstants.");
        }
        ContentPanel cp = this.panels[this.panelToLocationMap[group]];
        if (cp.windowPanel != null) {
            if (cp.collapsed) {
                cp.setCollapsed(false);
            }
            cp.windowPanel.focusActiveDockableWindow();
            return true;
        }
        return false;
    }

    public JPanel getContentPanel() {
        return this.panels[0].getRegularContent();
    }

    public int getDividerLocation(int splitPane) {
        return this.panels[this.panelToLocationMap[splitPane]].getDividerLocation();
    }

    public DockableWindow[] getDockableWindows() {
        DockableWindow[] windows = new DockableWindow[this.windowList.size()];
        return this.windowList.toArray(windows);
    }

    public int getFocusedDockableWindowGroup() {
        Component focused = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (focused == null) {
            return -1;
        }
        for (Container parent = focused.getParent(); parent != null; parent = parent.getParent()) {
            if (parent instanceof DockableWindowGroup) {
                for (int i = 0; i < 4; ++i) {
                    int panelIndex = this.panelToLocationMap[i];
                    if (this.panels[panelIndex] == null || parent != this.panels[panelIndex].windowPanel) continue;
                    return i;
                }
                return -1;
            }
            if (!(parent instanceof JLayeredPane)) continue;
            return -1;
        }
        return -1;
    }

    public boolean hasDockableWindowGroup(int group) {
        if (group < 0 || group >= 4) {
            throw new IllegalArgumentException("Dockable window group must be a constant from DockableWindowConstants");
        }
        return this.panels[this.panelToLocationMap[group]].getDockableWindowCount() > 0;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        block7: {
            DockableWindow w;
            String name;
            block8: {
                int i;
                block6: {
                    name = e.getPropertyName();
                    w = (DockableWindow)e.getSource();
                    if (!"DockableWindowActive".equals(name)) break block6;
                    this.removeDockableWindow(w);
                    this.addDockableWindow(w);
                    break block7;
                }
                if (!"DockableWindowName".equals(name)) break block8;
                boolean found = false;
                for (i = 0; i < this.panels.length; ++i) {
                    int index = this.panels[i].containsDockableWindow(w);
                    if (index <= -1) continue;
                    this.panels[i].windowPanel.refreshTabName(index);
                    found = true;
                    break;
                }
                if (found) break block7;
                for (i = 0; i < this.floatingWindows.length; ++i) {
                    if (w != this.floatingWindows[i].getDockableWindow()) continue;
                    this.floatingWindows[i].refreshTitle();
                }
                break block7;
            }
            if ("DockableWindowTitle".equals(name)) {
                boolean found = false;
                for (int i = 0; i < this.panels.length; ++i) {
                    int index = this.panels[i].containsDockableWindow(w);
                    if (index <= -1) continue;
                    this.panels[i].windowPanel.refreshTabTitle(index);
                    found = true;
                    break;
                }
                if (!found) {
                    int count = this.floatingWindows == null ? 0 : this.floatingWindows.length;
                    for (int i = 0; i < count; ++i) {
                        if (w != this.floatingWindows[i].getDockableWindow()) continue;
                        this.floatingWindows[i].refreshTitle();
                    }
                }
            }
        }
    }

    public boolean removeContentPanel(Container contentPanel) {
        Component[] comps = this.panels[0].getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (!comps[i].equals(contentPanel)) continue;
            this.panels[0].remove(contentPanel);
            return true;
        }
        return false;
    }

    public boolean removeDockableWindow(DockableWindow window) {
        if (!this.removeDockableWindowFromList(window)) {
            return false;
        }
        for (int p = 0; p < 4; ++p) {
            if (!this.panels[p].removeDockableWindowImpl(window)) continue;
            return true;
        }
        int numFloating = this.floatingWindows == null ? 0 : this.floatingWindows.length;
        for (int p = 0; p < numFloating; ++p) {
            DockableWindow possible = this.floatingWindows[p].getDockableWindow();
            if (possible != window) continue;
            this.floatingWindows[p].remove(0);
            this.floatingWindows[p].setVisible(false);
            this.floatingWindows[p].dispose();
            FloatingWindow[] temp = new FloatingWindow[numFloating - 1];
            System.arraycopy(this.floatingWindows, 0, temp, 0, p);
            System.arraycopy(this.floatingWindows, p + 1, temp, p, numFloating - p - 1);
            this.floatingWindows = temp;
            return true;
        }
        return false;
    }

    private boolean removeDockableWindowFromList(DockableWindow window) {
        return this.windowList.remove(window);
    }

    public void setContentPanel(Container contentPanel) {
        this.panels[0].add(contentPanel);
    }

    public void setDividerLocation(int splitPane, int pos) {
        this.panels[this.panelToLocationMap[splitPane]].setDividerLocation(pos);
    }

    public void setDockingStyle(int style) {
        if (this.dockingStyle != style && (style == 0 || style == 1)) {
            this.dockingStyle = style;
        }
    }

    final class ContentPanel
    extends JPanel {
        private JSplitPane splitPane;
        private DockableWindowGroup windowPanel;
        private Component mainContent;
        private int dockableWindowsLocation;
        private int dividerLocation;
        private boolean collapsed;
        private CollapsedPanel collapsedPanel;

        ContentPanel() {
            super(new BorderLayout());
        }

        public boolean addDockableWindow(DockableWindow window) {
            if (this.splitPane == null) {
                Component comp2;
                Component comp1;
                int split;
                this.mainContent = this.getComponent(0);
                this.windowPanel = new DockableWindowGroup(this);
                this.windowPanel.addDockableWindow(window);
                double resizeWeight = 0.0;
                switch (this.dockableWindowsLocation) {
                    case 0: {
                        split = 0;
                        resizeWeight = 0.0;
                        comp1 = this.windowPanel;
                        comp2 = this.mainContent;
                        break;
                    }
                    case 1: {
                        split = 1;
                        resizeWeight = 0.0;
                        comp1 = this.windowPanel;
                        comp2 = this.mainContent;
                        break;
                    }
                    case 2: {
                        split = 0;
                        resizeWeight = 1.0;
                        comp1 = this.mainContent;
                        comp2 = this.windowPanel;
                        break;
                    }
                    default: {
                        split = 1;
                        resizeWeight = 1.0;
                        comp1 = this.mainContent;
                        comp2 = this.windowPanel;
                    }
                }
                this.remove(0);
                this.splitPane = new JSplitPane(split, true, comp1, comp2){

                    @Override
                    public void setUI(SplitPaneUI ui) {
                        super.setUI(new CleanSplitPaneUI());
                    }
                };
                this.splitPane.setResizeWeight(resizeWeight);
                this.splitPane.setDividerLocation(this.dividerLocation);
                this.splitPane.applyComponentOrientation(this.getComponentOrientation());
                this.add(this.splitPane);
                this.validate();
                return true;
            }
            boolean added = this.windowPanel.addDockableWindow(window);
            if (added && this.collapsed) {
                this.collapsedPanel.refreshDockableWindowButtons();
            }
            return added;
        }

        public int containsDockableWindow(DockableWindow window) {
            return this.windowPanel == null ? -1 : this.windowPanel.containsDockableWindow(window);
        }

        public int getDividerLocation() {
            return this.splitPane != null ? this.splitPane.getDividerLocation() : -1;
        }

        int getDockableWindowCount() {
            return this.windowPanel == null ? 0 : this.windowPanel.getDockableWindowCount();
        }

        DockableWindowPanel getDockableWindowPanel() {
            return DockableWindowPanel.this;
        }

        public JPanel getRegularContent() {
            return (JPanel)this.mainContent;
        }

        public boolean removeDockableWindowImpl(DockableWindow window) {
            if (this.windowPanel != null) {
                boolean rc = this.windowPanel.removeDockableWindow(window);
                if (this.collapsed) {
                    this.collapsedPanel.refreshDockableWindowButtons();
                }
                if (this.windowPanel != null && this.windowPanel.getDockableWindowCount() == 0) {
                    this.removeAll();
                    if (this.splitPane != null) {
                        this.dividerLocation = this.splitPane.getDividerLocation();
                    }
                    this.splitPane = null;
                    this.windowPanel = null;
                    this.collapsedPanel = null;
                    this.collapsed = false;
                    this.add(this.mainContent);
                    this.revalidate();
                }
                return rc;
            }
            return false;
        }

        public void setCollapsed(boolean collapsed) {
            if (collapsed != this.collapsed) {
                this.collapsed = collapsed;
                if (collapsed) {
                    this.dividerLocation = this.splitPane.getDividerLocation();
                    this.remove(this.splitPane);
                    if (this.collapsedPanel == null) {
                        this.collapsedPanel = new CollapsedPanel(this.dockableWindowsLocation);
                    }
                    switch (this.dockableWindowsLocation) {
                        case 0: {
                            this.add((Component)this.collapsedPanel, "North");
                            this.add(this.splitPane.getBottomComponent());
                            break;
                        }
                        case 1: {
                            this.add((Component)this.collapsedPanel, "West");
                            this.add(this.splitPane.getRightComponent());
                            break;
                        }
                        case 2: {
                            this.add((Component)this.collapsedPanel, "South");
                            this.add(this.splitPane.getTopComponent());
                            break;
                        }
                        default: {
                            this.add((Component)this.collapsedPanel, "East");
                            this.add(this.splitPane.getLeftComponent());
                            break;
                        }
                    }
                } else {
                    while (this.getComponentCount() > 0) {
                        this.remove(0);
                    }
                    switch (this.dockableWindowsLocation) {
                        case 0: 
                        case 1: {
                            this.splitPane.setBottomComponent(this.mainContent);
                            break;
                        }
                        default: {
                            this.splitPane.setTopComponent(this.mainContent);
                        }
                    }
                    this.add(this.splitPane);
                    if (this.splitPane != null) {
                        this.splitPane.setDividerLocation(this.dividerLocation);
                    }
                }
                this.revalidate();
                this.repaint();
            }
        }

        public void setDividerLocation(int location) {
            if (location != this.dividerLocation) {
                this.dividerLocation = location;
                if (this.splitPane != null) {
                    this.splitPane.setDividerLocation(location);
                }
            }
        }

        public void setDockableWindowsLocation(int location) {
            this.dockableWindowsLocation = location;
        }

        @Override
        public void updateUI() {
            super.updateUI();
            if (this.splitPane != null && !this.splitPane.isDisplayable()) {
                SwingUtilities.updateComponentTreeUI(this.splitPane);
            }
            if (this.collapsedPanel != null && !this.collapsedPanel.isDisplayable()) {
                SwingUtilities.updateComponentTreeUI(this.collapsedPanel);
            }
        }

        private class CollapsedPanel
        extends JPanel
        implements MouseListener {
            private JToolBar toolbar;
            private JPopupMenu contextMenu;

            CollapsedPanel(int dockableWindowLocation) {
                this.setLayout(new BorderLayout());
                int orientation = dockableWindowLocation == 0 || dockableWindowLocation == 2 ? 0 : 1;
                this.toolbar = new JToolBar(orientation);
                this.toolbar.setOpaque(false);
                this.toolbar.setFloatable(false);
                this.toolbar.setBorder(null);
                this.refreshDockableWindowButtons();
                boolean isHorizontal = orientation == 0;
                this.add((Component)this.toolbar, isHorizontal ? "After" : "North");
                this.setBorder(isHorizontal ? BorderFactory.createEmptyBorder(0, 0, 0, 5) : BorderFactory.createEmptyBorder(5, 0, 0, 0));
            }

            private void maybeShowPopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    JButton popupButton = (JButton)e.getSource();
                    if (this.contextMenu == null) {
                        this.contextMenu = Actions.createRedockPopupMenu(DockableWindowPanel.this);
                    }
                    this.contextMenu.show(popupButton, e.getX(), e.getY());
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            public int refreshDockableWindowButtons() {
                while (this.toolbar.getComponentCount() > 0) {
                    this.toolbar.getComponent(0).removeMouseListener(this);
                    this.toolbar.remove(0);
                }
                int i = 0;
                while (i < ContentPanel.this.windowPanel.getDockableWindowCount()) {
                    DockableWindow dwind = ContentPanel.this.windowPanel.getDockableWindowAt(i);
                    Icon icon = dwind.getIcon();
                    JButton b = new JButton(icon);
                    b.setToolTipText(dwind.getDockableWindowName());
                    b.setOpaque(false);
                    b.putClientProperty("DockableWindow", dwind);
                    final int index = i++;
                    b.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            ContentPanel.this.windowPanel.setActiveDockableWindow(index);
                            ContentPanel.this.setCollapsed(false);
                        }
                    });
                    b.addMouseListener(this);
                    this.toolbar.add(b);
                }
                WebLookAndFeelUtils.fixToolbar(this.toolbar, true);
                this.toolbar.revalidate();
                return this.toolbar.getComponentCount();
            }

            @Override
            public void updateUI() {
                super.updateUI();
                if (this.toolbar != null) {
                    WebLookAndFeelUtils.fixToolbar(this.toolbar, true);
                }
            }
        }
    }
}

