/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.modifiabletable;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.fife.ui.RScrollPane;
import org.fife.ui.UIUtil;
import org.fife.ui.modifiabletable.ModifiableTableChangeEvent;
import org.fife.ui.modifiabletable.ModifiableTableListener;
import org.fife.ui.modifiabletable.RowHandler;

public class ModifiableTable
extends JPanel {
    public static final int ADD = 1;
    public static final int REMOVE = 2;
    public static final int MODIFY = 4;
    public static final int ADD_REMOVE = 3;
    public static final int ADD_REMOVE_MODIFY = 7;
    public static final int MOVE_UP_DOWN = 8;
    public static final int ALL_BUTTONS = 15;
    public static final String TOP = "North";
    public static final String BOTTOM = "South";
    public static final String LEFT = "West";
    public static final String RIGHT = "East";
    public static final String PROPERTY_PANELS_NON_OPAQUE = "ModifiableTable.nonOpaquePanels";
    private JTable table;
    private JButton addButton;
    private JButton removeButton;
    private JButton modifyButton;
    private JButton moveUpButton;
    private JButton moveDownButton;
    private RowHandler rowHandler;
    private int firstMovableRow;
    private Listener listener;
    private EventListenerList listenerList;
    private static final String ADD_COMMAND = "AddCommand";
    private static final String REMOVE_COMMAND = "RemoveCommand";
    private static final String MODIFY_COMMAND = "ModifyCommand";
    private static final String MOVE_UP_COMMAND = "MoveUpCommand";
    private static final String MOVE_DOWN_COMMAND = "MoveDownCommand";

    public ModifiableTable(DefaultTableModel model) {
        this(model, null);
    }

    public ModifiableTable(DefaultTableModel model, Object[] columnNames) {
        this(model, columnNames, BOTTOM, 7);
    }

    public ModifiableTable(DefaultTableModel model, String buttonLocation, int buttons) {
        this(model, null, buttonLocation, buttons);
    }

    public ModifiableTable(DefaultTableModel model, String buttonLocation, int buttons, List<? extends Action> customButtons) {
        this(model, null, buttonLocation, buttons, customButtons);
    }

    public ModifiableTable(DefaultTableModel model, Object[] columnNames, String buttonLocation, int buttons) {
        this(model, columnNames, buttonLocation, buttons, null);
    }

    public ModifiableTable(DefaultTableModel model, Object[] columnNames, String buttonLocation, int buttons, List<? extends Action> customButtons) {
        if (Boolean.getBoolean(PROPERTY_PANELS_NON_OPAQUE)) {
            this.setOpaque(false);
        }
        this.listener = new Listener();
        this.table = this.createTable(model, columnNames);
        this.listenerList = new EventListenerList();
        this.setLayout(new BorderLayout());
        this.add(new RScrollPane(this.table));
        this.add((Component)this.createButtonPanel(buttonLocation, buttons, customButtons), buttonLocation);
        UIUtil.fixJTableRendererOrientations(this.table);
    }

    public void addModifiableTableListener(ModifiableTableListener l) {
        this.listenerList.add(ModifiableTableListener.class, l);
    }

    protected void addRow() {
        Object[] newData;
        if (this.rowHandler != null && (newData = this.rowHandler.getNewRowInfo(null)) != null) {
            ((DefaultTableModel)this.table.getModel()).addRow(newData);
            this.fireModifiableTableEvent(0, this.table.getRowCount() - 1);
        }
    }

    protected JPanel createButtonPanel(String buttonLocation, int buttons, List<? extends Action> customButtons) {
        JPanel panel = null;
        JPanel buttonPanel = null;
        if (Boolean.getBoolean(PROPERTY_PANELS_NON_OPAQUE)) {
            panel = UIUtil.newTabbedPanePanel();
            buttonPanel = UIUtil.newTabbedPanePanel(new BorderLayout());
        } else {
            panel = new JPanel();
            buttonPanel = new JPanel(new BorderLayout());
        }
        ResourceBundle msg = ResourceBundle.getBundle(ModifiableTable.class.getName());
        int buttonCount = 0;
        if ((buttons & 1) == 1) {
            this.addButton = new JButton(msg.getString("Button.Add"));
            this.addButton.setActionCommand(ADD_COMMAND);
            this.addButton.addActionListener(this.listener);
            panel.add(this.addButton);
            ++buttonCount;
        }
        if ((buttons & 2) == 2) {
            this.removeButton = new JButton(msg.getString("Button.Remove"));
            this.removeButton.setActionCommand(REMOVE_COMMAND);
            this.removeButton.addActionListener(this.listener);
            this.removeButton.setEnabled(false);
            panel.add(this.removeButton);
            ++buttonCount;
        }
        if ((buttons & 4) == 4) {
            this.modifyButton = new JButton(msg.getString("Button.Modify"));
            this.modifyButton.setActionCommand(MODIFY_COMMAND);
            this.modifyButton.addActionListener(this.listener);
            this.modifyButton.setEnabled(false);
            panel.add(this.modifyButton);
            ++buttonCount;
        }
        if ((buttons & 8) == 8) {
            this.moveUpButton = new JButton(msg.getString("Button.MoveUp"));
            this.moveUpButton.setActionCommand(MOVE_UP_COMMAND);
            this.moveUpButton.addActionListener(this.listener);
            this.moveUpButton.setEnabled(false);
            panel.add(this.moveUpButton);
            this.moveDownButton = new JButton(msg.getString("Button.MoveDown"));
            this.moveDownButton.setActionCommand(MOVE_DOWN_COMMAND);
            this.moveDownButton.addActionListener(this.listener);
            this.moveDownButton.setEnabled(false);
            panel.add(this.moveDownButton);
            buttonCount += 2;
        }
        if (customButtons != null) {
            for (Action action : customButtons) {
                JButton extraButton = new JButton(action);
                panel.add(extraButton);
                ++buttonCount;
            }
        }
        String buttonLoc2 = null;
        if (RIGHT.equals(buttonLocation)) {
            panel.setLayout(new GridLayout(buttonCount, 1, 5, 5));
            buttonLoc2 = "First";
            buttonPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        } else if (LEFT.equals(buttonLocation)) {
            panel.setLayout(new GridLayout(buttonCount, 1, 5, 5));
            buttonLoc2 = "First";
            buttonPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        } else if (TOP.equals(buttonLocation)) {
            panel.setLayout(new GridLayout(1, buttonCount, 5, 5));
            buttonLoc2 = "Before";
            buttonPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        } else {
            panel.setLayout(new GridLayout(1, buttonCount, 5, 5));
            buttonLoc2 = "Before";
            buttonPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        }
        buttonPanel.add((Component)panel, buttonLoc2);
        return buttonPanel;
    }

    private JTable createTable(DefaultTableModel model, Object[] columnNames) {
        if (columnNames != null) {
            model.setColumnIdentifiers(columnNames);
        }
        JTable table = new JTable(model){

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                Component comp = super.prepareRenderer(renderer, row, column);
                comp.setEnabled(this.isEnabled());
                return comp;
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return false;
            }
        };
        table.setShowGrid(false);
        table.setFillsViewportHeight(true);
        table.setSelectionMode(0);
        table.getSelectionModel().addListSelectionListener(this.listener);
        table.addMouseListener(this.listener);
        return table;
    }

    private void ensureSelectedRowIsVisible() {
        Rectangle cellBounds;
        int row = this.table.getSelectedRow();
        if (row > -1 && (cellBounds = this.table.getCellRect(row, 0, true)) != null) {
            this.table.scrollRectToVisible(cellBounds);
        }
    }

    protected void fireModifiableTableEvent(int change, int row) {
        Object[] listeners = this.listenerList.getListenerList();
        if (listeners.length > 0) {
            ModifiableTableChangeEvent e = new ModifiableTableChangeEvent(this, change, row);
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != ModifiableTableListener.class) continue;
                ((ModifiableTableListener)listeners[i + 1]).modifiableTableChanged(e);
            }
        }
    }

    private Object[] getContentsOfRow(int row) {
        int columnCount = this.table.getColumnCount();
        Object[] data = new Object[columnCount];
        TableModel model = this.table.getModel();
        for (int i = 0; i < columnCount; ++i) {
            data[i] = model.getValueAt(row, i);
        }
        return data;
    }

    public Vector<?> getDataVector() {
        return ((DefaultTableModel)this.getTable().getModel()).getDataVector();
    }

    public int getFirstMovableRow() {
        return this.firstMovableRow;
    }

    public int getSelectedRow() {
        return this.table.getSelectedRow();
    }

    public JTable getTable() {
        return this.table;
    }

    protected void modifyRow() {
        if (this.rowHandler != null) {
            int selectedRow = this.table.getSelectedRow();
            if (selectedRow > -1 && this.rowHandler.canModifyRow(selectedRow)) {
                Object[] oldData = this.getContentsOfRow(selectedRow);
                Object[] newData = this.rowHandler.getNewRowInfo(oldData);
                if (newData != null) {
                    int columnCount = this.table.getColumnCount();
                    for (int i = 0; i < columnCount; ++i) {
                        this.table.getModel().setValueAt(newData[i], selectedRow, i);
                    }
                    this.fireModifiableTableEvent(1, selectedRow);
                }
            } else {
                UIManager.getLookAndFeel().provideErrorFeedback(this.table);
            }
        }
    }

    protected void moveRow(int amt) {
        int selectedRow = this.table.getSelectedRow();
        if (selectedRow >= 0 && selectedRow + amt >= 0 && selectedRow + amt < this.table.getRowCount()) {
            Object[] row1 = this.getContentsOfRow(selectedRow + amt);
            Object[] row2 = this.getContentsOfRow(selectedRow);
            int colCount = row1.length;
            TableModel model = this.table.getModel();
            for (int i = 0; i < colCount; ++i) {
                model.setValueAt(row1[i], selectedRow, i);
                model.setValueAt(row2[i], selectedRow + amt, i);
            }
            this.table.getSelectionModel().setSelectionInterval(selectedRow + amt, selectedRow + amt);
            this.ensureSelectedRowIsVisible();
            this.fireModifiableTableEvent(1, selectedRow + amt);
            this.fireModifiableTableEvent(1, selectedRow);
        } else {
            UIManager.getLookAndFeel().provideErrorFeedback(this.table);
        }
    }

    public void removeModifiableTableListener(ModifiableTableListener l) {
        this.listenerList.remove(ModifiableTableListener.class, l);
    }

    protected void removeRow() {
        if (this.rowHandler != null) {
            int row = this.table.getSelectedRow();
            if (row == -1) {
                UIManager.getLookAndFeel().provideErrorFeedback(this);
            } else if (this.rowHandler.canRemoveRow(row)) {
                DefaultTableModel model = (DefaultTableModel)this.table.getModel();
                model.removeRow(row);
                int rowCount = model.getRowCount();
                if (rowCount > row) {
                    this.table.setRowSelectionInterval(row, row);
                } else if (rowCount > 0 && rowCount == row) {
                    this.table.setRowSelectionInterval(row - 1, row - 1);
                }
                this.fireModifiableTableEvent(2, row);
            }
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (enabled != this.isEnabled()) {
            super.setEnabled(enabled);
            if (this.addButton != null) {
                this.addButton.setEnabled(enabled);
            }
            this.listener.valueChanged(null);
            this.table.setEnabled(enabled);
        }
    }

    public void setFirstMovableRow(int firstMovableRow) {
        this.firstMovableRow = Math.max(0, firstMovableRow);
    }

    public void setRowHandler(RowHandler handler) {
        this.rowHandler = handler;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.rowHandler != null) {
            this.rowHandler.updateUI();
        }
    }

    class Listener
    extends MouseAdapter
    implements ActionListener,
    ListSelectionListener {
        Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (ModifiableTable.ADD_COMMAND.equals(command)) {
                ModifiableTable.this.addRow();
            } else if (ModifiableTable.REMOVE_COMMAND.equals(command)) {
                ModifiableTable.this.removeRow();
            } else if (ModifiableTable.MODIFY_COMMAND.equals(command)) {
                ModifiableTable.this.modifyRow();
            } else if (ModifiableTable.MOVE_UP_COMMAND.equals(command)) {
                ModifiableTable.this.moveRow(-1);
            } else if (ModifiableTable.MOVE_DOWN_COMMAND.equals(command)) {
                ModifiableTable.this.moveRow(1);
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2 && e.getButton() == 1) {
                ModifiableTable.this.modifyRow();
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            boolean selection;
            if (ModifiableTable.this.rowHandler == null) {
                return;
            }
            int row = ModifiableTable.this.table.getSelectedRow();
            boolean bl = selection = row > -1 && ModifiableTable.this.isEnabled();
            if (ModifiableTable.this.modifyButton != null) {
                boolean canModify = ModifiableTable.this.rowHandler.canModifyRow(row);
                ModifiableTable.this.modifyButton.setEnabled(selection && canModify);
            }
            if (ModifiableTable.this.removeButton != null) {
                boolean canRemove = ModifiableTable.this.rowHandler.canRemoveRow(row);
                ModifiableTable.this.removeButton.setEnabled(selection && canRemove);
            }
            if (ModifiableTable.this.moveUpButton != null) {
                ModifiableTable.this.moveUpButton.setEnabled(selection && row > ModifiableTable.this.getFirstMovableRow());
                ModifiableTable.this.moveDownButton.setEnabled(selection && row >= ModifiableTable.this.getFirstMovableRow() && row < ModifiableTable.this.table.getRowCount() - 1);
            }
        }
    }
}

