/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextfilechooser;

import java.awt.Component;
import java.awt.Desktop;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.fife.ui.UIUtil;
import org.fife.ui.rtextfilechooser.DefaultFilePasteCallback;
import org.fife.ui.rtextfilechooser.FileListTransferable;
import org.fife.ui.rtextfilechooser.FilePasteThread;
import org.fife.ui.rtextfilechooser.FileSelector;
import org.fife.ui.rtextfilechooser.RTextFileChooser;
import org.fife.ui.rtextfilechooser.Utilities;
import org.fife.ui.rtextfilechooser.extras.FileIOExtras;

public interface Actions {

    public static class UpOneLevelAction
    extends FileChooserAction {
        public UpOneLevelAction(RTextFileChooser chooser) {
            super(chooser);
            this.putValue("Name", this.getString("UpOneLevel"));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(8, 0));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File parent = this.chooser.getCurrentDirectory().getParentFile();
            if (parent != null) {
                this.chooser.setCurrentDirectory(parent);
            } else {
                UIManager.getLookAndFeel().provideErrorFeedback(this.chooser);
            }
        }
    }

    public static class PropertiesAction
    extends FileChooserAction {
        private FileSelector selector;

        public PropertiesAction(FileSelector selector) {
            super((RTextFileChooser)null);
            this.putValue("Name", "Properties");
            int alt = 8;
            KeyStroke ks = KeyStroke.getKeyStroke(10, 8);
            this.putValue("AcceleratorKey", ks);
            this.selector = selector;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File[] selected;
            FileIOExtras extras = FileIOExtras.getInstance();
            if (extras == null) {
                UIManager.getLookAndFeel().provideErrorFeedback(null);
                return;
            }
            if (this.selector instanceof RTextFileChooser) {
                RTextFileChooser chooser = (RTextFileChooser)this.selector;
                selected = chooser.getView().getSelectedFiles();
            } else {
                selected = this.selector.getSelectedFiles();
            }
            Window parent = SwingUtilities.getWindowAncestor((Component)((Object)this.selector));
            for (int i = 0; i < selected.length; ++i) {
                extras.showFilePropertiesDialog(parent, selected[i]);
            }
        }
    }

    public static class SystemOpenAction
    extends FileChooserAction {
        private FileSelector chooser;
        private OpenMethod method;

        public SystemOpenAction(FileSelector chooser, OpenMethod method) {
            super((RTextFileChooser)null);
            this.chooser = chooser;
            this.method = method;
            this.putValue("Name", this.getString(method.localizationKey));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File file = this.chooser.getSelectedFile();
            if (file == null) {
                UIManager.getLookAndFeel().provideErrorFeedback(null);
                return;
            }
            Desktop desktop = UIUtil.getDesktop();
            if (desktop != null && !SystemOpenAction.openImpl(desktop, this.method, file) && !SystemOpenAction.openImpl(desktop, this.method.opposite(), file)) {
                UIManager.getLookAndFeel().provideErrorFeedback(null);
            }
        }

        private static boolean openImpl(Desktop desktop, OpenMethod method, File file) {
            boolean success = false;
            if (desktop.isSupported(method.method)) {
                try {
                    switch (method.method) {
                        case OPEN: {
                            desktop.open(file);
                            success = true;
                            break;
                        }
                        default: {
                            desktop.edit(file);
                            success = true;
                            break;
                        }
                    }
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
            return success;
        }

        public static enum OpenMethod {
            OPEN(Desktop.Action.OPEN, "SystemOpenViewer"),
            EDIT(Desktop.Action.EDIT, "SystemOpenEditor");

            private Desktop.Action method;
            private String localizationKey;

            private OpenMethod(Desktop.Action method, String localizationKey) {
                this.method = method;
                this.localizationKey = localizationKey;
            }

            private OpenMethod opposite() {
                return this == OPEN ? EDIT : OPEN;
            }
        }
    }

    public static class RenameAction
    extends FileChooserAction {
        public RenameAction(RTextFileChooser chooser) {
            super(chooser);
            this.putValue("Name", this.getString("Rename"));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(113, 0));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File file = this.chooser.getView().getSelectedFile();
            if (file == null) {
                UIManager.getLookAndFeel().provideErrorFeedback(this.chooser);
                return;
            }
            String oldName = file.getName();
            String newName = JOptionPane.showInputDialog(this.chooser, this.chooser.getString("NewNamePrompt") + oldName + ":", oldName);
            if (newName != null && !newName.equals(oldName)) {
                try {
                    File newFile;
                    if (newName.indexOf(File.separatorChar) == -1) {
                        newName = this.chooser.getCurrentDirectory().getCanonicalPath() + File.separatorChar + newName;
                    }
                    if (!file.renameTo(newFile = new File(newName))) {
                        throw new Exception(this.chooser.getString("RenameFailText"));
                    }
                    this.chooser.refreshView();
                }
                catch (Exception e2) {
                    JOptionPane.showMessageDialog(this.chooser, this.chooser.getString("RenameErrorMessage") + e2, this.chooser.errorDialogTitle, 0);
                }
            }
        }
    }

    public static class RefreshAction
    extends FileChooserAction {
        public RefreshAction(RTextFileChooser chooser) {
            super(chooser);
            this.putValue("Name", this.getString("Refresh"));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(116, 0));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.chooser.refreshView();
        }
    }

    public static class PasteAction
    extends FileChooserAction {
        public PasteAction(RTextFileChooser chooser) {
            super(chooser);
            this.putValue("Name", this.getString("Paste"));
            int mod = chooser.getToolkit().getMenuShortcutKeyMask();
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(86, mod));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File destDir = this.chooser.getCurrentDirectory();
            boolean copying = false;
            if (destDir.isDirectory()) {
                Clipboard clip = this.chooser.getToolkit().getSystemClipboard();
                Transferable contents = clip.getContents(null);
                DataFlavor accepted = DataFlavor.javaFileListFlavor;
                try {
                    List files = (List)contents.getTransferData(accepted);
                    Window parent = SwingUtilities.getWindowAncestor(this.chooser);
                    DefaultFilePasteCallback callback = new DefaultFilePasteCallback(parent){

                        @Override
                        public void pasteOperationCompleted(int pasteCount) {
                            super.pasteOperationCompleted(pasteCount);
                            PasteAction.this.chooser.refreshView();
                        }
                    };
                    if (files != null && files.size() > 0) {
                        FilePasteThread.paste(parent, files, destDir, callback);
                        copying = true;
                    }
                }
                catch (UnsupportedFlavorException ufe) {
                    ufe.printStackTrace();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
            if (!copying) {
                UIManager.getLookAndFeel().provideErrorFeedback(this.chooser);
            }
        }

        public void checkEnabledState() {
            this.setEnabled(Utilities.getClipboardContainsFileList());
        }
    }

    public static abstract class FileChooserAction
    extends AbstractAction {
        protected RTextFileChooser chooser;
        private static ResourceBundle msg = ResourceBundle.getBundle("org.fife.ui.rtextfilechooser.FileChooserPopup");

        public FileChooserAction(RTextFileChooser chooser) {
            this.chooser = chooser;
        }

        protected String getString(String key) {
            return msg.getString(key);
        }
    }

    public static class DeleteAction
    extends FileChooserAction {
        private boolean hard;

        public DeleteAction(RTextFileChooser chooser, boolean hard) {
            super(chooser);
            this.putValue("Name", this.getString("Delete"));
            this.hard = hard;
            int modifiers = hard ? 1 : 0;
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(127, modifiers));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File[] files = this.chooser.getView().getSelectedFiles();
            if (files == null || files.length == 0) {
                UIManager.getLookAndFeel().provideErrorFeedback(this.chooser);
                return;
            }
            FileIOExtras extras = FileIOExtras.getInstance();
            if (!this.hard && extras != null) {
                this.handleDeleteNative(files, extras);
            } else {
                this.handleDeleteViaJava(files);
            }
        }

        private void handleDeleteNative(File[] files, FileIOExtras extras) {
            Window parent = SwingUtilities.getWindowAncestor(this.chooser);
            if (extras.moveToRecycleBin(parent, files, true, true)) {
                this.refresh();
            } else {
                UIManager.getLookAndFeel().provideErrorFeedback(this.chooser);
            }
        }

        private void handleDeleteViaJava(File[] files) {
            int choice;
            int count = files.length;
            if (count == 1) {
                String fileName = files[0].getName();
                choice = JOptionPane.showConfirmDialog(this.chooser, this.chooser.getString("DeleteConfirmPrompt") + fileName + "?");
            } else {
                choice = JOptionPane.showConfirmDialog(this.chooser, this.chooser.getString("DeleteMultipleConfirmPrompt"));
            }
            if (choice == 0) {
                for (int i = 0; i < count; ++i) {
                    if (files[i].delete()) continue;
                    Object[] arguments = new Object[]{files[i].getName()};
                    String msg = MessageFormat.format(this.chooser.getString("DeleteFailText"), arguments);
                    JOptionPane.showMessageDialog(this.chooser, msg, this.chooser.errorDialogTitle, 0);
                }
                this.refresh();
            }
        }

        private void refresh() {
            this.chooser.refreshView();
            this.chooser.focusFileNameField(true);
        }
    }

    public static class CopyFullPathAction
    extends FileChooserAction {
        private FileSelector chooser;

        public CopyFullPathAction(FileSelector chooser) {
            super((RTextFileChooser)null);
            this.chooser = chooser;
            this.putValue("Name", this.getString("CopyFullPath"));
            int mod = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(67, mod |= 1));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File[] files = null;
            files = this.chooser instanceof RTextFileChooser ? ((RTextFileChooser)this.chooser).getView().getSelectedFiles() : this.chooser.getSelectedFiles();
            if (files == null || files.length == 0) {
                UIManager.getLookAndFeel().provideErrorFeedback(null);
                return;
            }
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            StringBuilder sb = new StringBuilder(files[0].getAbsolutePath());
            for (int i = 1; i < files.length; ++i) {
                sb.append('\n').append(files[i].getAbsolutePath());
            }
            StringSelection transferable = new StringSelection(sb.toString());
            clipboard.setContents(transferable, transferable);
        }
    }

    public static class CopyAction
    extends FileChooserAction {
        private FileSelector chooser;

        public CopyAction(FileSelector chooser) {
            super((RTextFileChooser)null);
            this.chooser = chooser;
            this.putValue("Name", this.getString("Copy"));
            int mod = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(67, mod));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File[] files = null;
            files = this.chooser instanceof RTextFileChooser ? ((RTextFileChooser)this.chooser).getView().getSelectedFiles() : this.chooser.getSelectedFiles();
            if (files == null || files.length == 0) {
                UIManager.getLookAndFeel().provideErrorFeedback(null);
                return;
            }
            List<File> fileList = Arrays.asList(files);
            FileListTransferable flt = new FileListTransferable(fileList);
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(flt, flt);
        }
    }

    public static class AddToFavoritesAction
    extends FileChooserAction {
        public AddToFavoritesAction(RTextFileChooser chooser) {
            super(chooser);
            this.putValue("Name", chooser.getString("AddToFavorites"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File dir = this.chooser.getCurrentDirectory();
            this.chooser.addToFavorites(dir.getAbsolutePath());
            this.chooser.focusFileNameField(false);
        }
    }
}

