/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextfilechooser;

import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.fife.ui.FileExplorerTableModel;
import org.fife.ui.rtextfilechooser.FileChooserViewRendererFactory;
import org.fife.ui.rtextfilechooser.FileChooserViewTransferHandler;
import org.fife.ui.rtextfilechooser.MouseListener;
import org.fife.ui.rtextfilechooser.RTextFileChooser;
import org.fife.ui.rtextfilechooser.RTextFileChooserView;
import org.fife.ui.rtextfilechooser.SelectionListener;
import org.fife.ui.rtextfilechooser.Utilities;

class DetailsView
extends JTable
implements RTextFileChooserView {
    private RTextFileChooser chooser;
    private MouseListener mouseListener;
    private ViewKeyListener keyListener;
    private SelectionListener selectionListener;
    private String readStr;
    private String writeStr;
    private String readWriteStr;
    private transient int displayCount;
    private transient Thread attributeThread;
    private static final int MAX_NAME_COLUMN_SIZE = 150;
    private static final Object ATTRIBUTES_LOCK = new Object();

    DetailsView(RTextFileChooser chooser, String nameString, String sizeString, String typeString, String statusString, String lastModifiedString) {
        this.chooser = chooser;
        this.readStr = chooser.getString("Read");
        this.writeStr = chooser.getString("Write");
        this.readWriteStr = chooser.getString("ReadWrite");
        DetailsViewModel dvm = new DetailsViewModel(nameString, typeString, statusString, sizeString, lastModifiedString);
        FileExplorerTableModel sorter = new FileExplorerTableModel(dvm);
        this.setModel(sorter);
        sorter.setTable(this);
        this.fixKeyboardShortcuts();
        this.setIntercellSpacing(new Dimension(0, 0));
        this.setShowGrid(false);
        this.setColumnSelectionAllowed(false);
        int columnCount = this.getColumnCount();
        TableColumnModel columnModel = this.getColumnModel();
        TableCellRenderer renderer = FileChooserViewRendererFactory.createTableFileNameRenderer(chooser);
        this.getColumnModel().getColumn(0).setCellRenderer(renderer);
        for (int i = 1; i < columnCount; ++i) {
            renderer = FileChooserViewRendererFactory.createDefaultTableRenderer();
            columnModel.getColumn(i).setCellRenderer(renderer);
        }
        sorter.setColumnComparator(File.class, new FileComparator());
        ComponentOrientation orientation = chooser.getComponentOrientation();
        this.applyComponentOrientation(orientation);
        for (int i = 0; i < columnCount; ++i) {
            Component c = (Component)((Object)columnModel.getColumn(i).getCellRenderer());
            c.applyComponentOrientation(orientation);
        }
        this.mouseListener = new MouseListener(chooser);
        this.addMouseListener(this.mouseListener);
        this.keyListener = new ViewKeyListener();
        this.addKeyListener(this.keyListener);
        this.selectionListener = new SelectionListener(chooser);
        this.getSelectionModel().addListSelectionListener(this.selectionListener);
        this.setTransferHandler(new FileChooserViewTransferHandler(this));
        this.setDragEnabled(true);
        this.setFillsViewportHeight(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFileAttributes(AttributeBatch batch) {
        Object object = ATTRIBUTES_LOCK;
        synchronized (object) {
            if (batch.getDisplayCount() != this.displayCount) {
                return;
            }
            FileExplorerTableModel tevm = (FileExplorerTableModel)this.getModel();
            DetailsViewModel model = (DetailsViewModel)tevm.getTableModel();
            for (int i = 0; i < batch.getSize(); ++i) {
                int row = batch.getStart() + i;
                FileAttributes attrs = batch.getAttributes(i);
                model.setValueAt(attrs.status, row, 2);
                FileSizeWrapper sizeWrapper = new FileSizeWrapper(attrs.size);
                model.setValueAt(sizeWrapper, row, 3);
                FileModifiedWrapper modWrapper = new FileModifiedWrapper(attrs.modified);
                model.setValueAt(modWrapper, row, 4);
            }
        }
    }

    @Override
    public void clearDisplayedFiles() {
        ((DefaultTableModel)this.getModel()).setRowCount(0);
    }

    @Override
    public void ensureFileIsVisible(File file) {
        int row = this.getRowFor(file);
        if (row != -1) {
            this.scrollRectToVisible(this.getCellRect(row, 0, true));
        }
    }

    private void fixKeyboardShortcuts() {
        InputMap im = this.getInputMap(1);
        im.put(KeyStroke.getKeyStroke(10, 0, false), "none");
        im.put(KeyStroke.getKeyStroke(113, 0), "none");
        im.put(KeyStroke.getKeyStroke("shift DELETE"), "none");
    }

    @Override
    public Color getDefaultFileColor() {
        return this.getForeground();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getDisplayCount() {
        Object object = ATTRIBUTES_LOCK;
        synchronized (object) {
            return this.displayCount;
        }
    }

    @Override
    public int getDisplayedFileCount() {
        return this.getRowCount();
    }

    @Override
    public File getFileAtPoint(Point p) {
        int row = this.rowAtPoint(p);
        return row == -1 ? null : (File)this.getValueAt(row, 0);
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        int rowHeight = this.getRowHeight();
        Dimension d = super.getPreferredScrollableViewportSize();
        if (d == null) {
            d = new Dimension(480, rowHeight * 8);
        } else {
            d.height = rowHeight * 8;
        }
        return d;
    }

    private int getRowFor(File file) {
        TableColumnModel columnModel = this.getColumnModel();
        int column = columnModel.getColumn(0).getModelIndex();
        TableModel tableModel = this.getModel();
        int rowCount = this.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            File temp = (File)tableModel.getValueAt(i, column);
            if (!file.equals(temp)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public File getSelectedFile() {
        int index = this.getSelectedRow();
        return index == -1 ? null : (File)this.getValueAt(index, 0);
    }

    @Override
    public File[] getSelectedFiles() {
        int[] selectedRows = this.getSelectedRows();
        int num = selectedRows.length;
        Object[] objArray = new Object[num];
        int column = this.convertColumnIndexToView(0);
        for (int i = 0; i < num; ++i) {
            objArray[i] = this.getValueAt(selectedRows[i], column);
        }
        int length = objArray.length;
        File[] fileArray = new File[length];
        System.arraycopy(objArray, 0, fileArray, 0, length);
        return fileArray;
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        String tip = null;
        int row = this.rowAtPoint(e.getPoint());
        if (row == -1) {
            return null;
        }
        File file = (File)this.getModel().getValueAt(row, 0);
        if (file == null || file.isDirectory()) {
            return null;
        }
        tip = this.chooser.getToolTipFor(file);
        return tip;
    }

    private void initFileNameColumnSize() {
        TableModel model = this.getModel();
        TableColumn column = null;
        Component comp = null;
        int headerWidth = 0;
        int maxWidth = 0;
        int cellWidth = 0;
        TableCellRenderer headerRenderer = this.getTableHeader().getDefaultRenderer();
        int col = this.convertColumnIndexToView(0);
        column = this.getColumnModel().getColumn(col);
        comp = headerRenderer.getTableCellRendererComponent(this, column.getHeaderValue(), false, false, 0, 0);
        headerWidth = comp.getPreferredSize().width;
        TableCellRenderer renderer = this.getDefaultRenderer(model.getColumnClass(0));
        int rowCount = this.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            comp = renderer.getTableCellRendererComponent(this, this.getValueAt(i, col), false, false, i, col);
            cellWidth = comp.getPreferredSize().width;
            if (maxWidth >= cellWidth) continue;
            maxWidth = cellWidth;
        }
        int width = Math.min(Math.max(headerWidth, maxWidth), 150);
        column.setPreferredWidth(width);
        column.setWidth(width);
    }

    @Override
    public void removeAllListeners() {
        this.removeMouseListener(this.mouseListener);
        this.removeKeyListener(this.keyListener);
        this.getSelectionModel().removeListSelectionListener(this.selectionListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restartAttributeThread(List<File> files) {
        Object object = ATTRIBUTES_LOCK;
        synchronized (object) {
            ++this.displayCount;
            if (this.attributeThread != null) {
                this.attributeThread.interrupt();
            }
            this.attributeThread = new Thread(new AttributeRunnable(this.displayCount, files));
            this.attributeThread.start();
        }
    }

    @Override
    public void selectFileAtPoint(Point p) {
        int row = this.rowAtPoint(p);
        this.setRowSelectionInterval(row, row);
    }

    @Override
    public void setDisplayedFiles(List<File> files) {
        DetailsViewModel tableModel = (DetailsViewModel)((FileExplorerTableModel)this.getModel()).getTableModel();
        tableModel.setContents(files);
        this.initFileNameColumnSize();
        this.restartAttributeThread(files);
    }

    @Override
    public void setMultiSelectionEnabled(boolean enabled) {
        this.getSelectionModel().setSelectionMode(enabled ? 2 : 0);
    }

    @Override
    public void setSelectedFiles(File[] files) {
        int num = files.length;
        if (num > 0) {
            int[] rows = new int[num];
            for (int i = 0; i < num; ++i) {
                rows[i] = this.getRowFor(files[i]);
                if (rows[i] == -1) continue;
                this.addRowSelectionInterval(rows[i], rows[i]);
            }
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
        TableColumnModel tcm = this.getColumnModel();
        for (int i = 0; i < this.getColumnCount(); ++i) {
            TableCellRenderer r = tcm.getColumn(i).getCellRenderer();
            if (!(r instanceof JComponent)) continue;
            ((JComponent)((Object)r)).updateUI();
        }
    }

    private class ViewKeyListener
    extends KeyAdapter {
        private String typed;
        private long lastTime;

        private ViewKeyListener() {
        }

        private int getNextMatch(String text, int fromRow) {
            String fileName;
            Object value;
            int row;
            text = text.toUpperCase();
            FileExplorerTableModel model = (FileExplorerTableModel)DetailsView.this.getModel();
            for (row = fromRow; row < DetailsView.this.getRowCount(); ++row) {
                value = model.getValueAt(row, 0);
                fileName = value instanceof File ? ((File)value).getName() : value.toString();
                if (!(fileName = fileName.toUpperCase()).startsWith(text)) continue;
                return row;
            }
            for (row = 0; row < fromRow; ++row) {
                value = model.getValueAt(row, 0);
                fileName = value instanceof File ? ((File)value).getName() : value.toString();
                if (!(fileName = fileName.toUpperCase()).startsWith(text)) continue;
                return row;
            }
            return -1;
        }

        @Override
        public void keyTyped(KeyEvent e) {
            int matchRow;
            FileExplorerTableModel model = (FileExplorerTableModel)DetailsView.this.getModel();
            if (model == null || model.getRowCount() == 0) {
                return;
            }
            long time = e.getWhen();
            this.typed = time < this.lastTime + 1000L ? (this.typed == null ? String.valueOf(e.getKeyChar()) : this.typed + e.getKeyChar()) : String.valueOf(e.getKeyChar());
            this.lastTime = time;
            int startRow = DetailsView.this.getSelectedRow();
            if (startRow == -1) {
                startRow = 0;
            }
            if ((matchRow = this.getNextMatch(this.typed, startRow)) != -1) {
                DetailsView.this.getSelectionModel().setSelectionInterval(matchRow, matchRow);
                DetailsView.this.ensureFileIsVisible(DetailsView.this.getSelectedFile());
            }
        }
    }

    private static class FileSizeWrapper
    implements Comparable<FileSizeWrapper> {
        private long size;

        FileSizeWrapper(long size) {
            this.size = size;
        }

        @Override
        public int compareTo(FileSizeWrapper w2) {
            if (this.size == w2.size) {
                return 0;
            }
            return this.size < w2.size ? -1 : 1;
        }

        public String toString() {
            return this.size == -1L ? "" : Utilities.getFileSizeStringFor(this.size, true);
        }
    }

    private static class FileModifiedWrapper
    implements Comparable<FileModifiedWrapper> {
        private long modified;

        FileModifiedWrapper(long modified) {
            this.modified = modified;
        }

        @Override
        public int compareTo(FileModifiedWrapper w2) {
            if (this.modified == w2.modified) {
                return 0;
            }
            return this.modified < w2.modified ? -1 : 1;
        }

        public String toString() {
            return this.modified == -1L ? "" : Utilities.getLastModifiedString(this.modified);
        }
    }

    private static class FileComparator
    implements Comparator<File> {
        private FileComparator() {
        }

        @Override
        public int compare(File f1, File f2) {
            boolean f1IsDir = f1.isDirectory();
            boolean f2IsDir = f2.isDirectory();
            if (f1IsDir) {
                if (!f2IsDir) {
                    return -1;
                }
                return f1.compareTo(f2);
            }
            if (f2IsDir) {
                return 1;
            }
            return f1.compareTo(f2);
        }
    }

    private class FileAttributes {
        private String status;
        private long size;
        private long modified;

        FileAttributes(File file) {
            this.size = file.isDirectory() ? -1L : file.length();
            boolean canRead = file.canRead();
            boolean canWrite = file.canWrite();
            this.status = canRead ? (canWrite ? DetailsView.this.readWriteStr : DetailsView.this.readStr) : (canWrite ? DetailsView.this.writeStr : null);
            this.modified = file.lastModified();
        }
    }

    private class DetailsViewModel
    extends DefaultTableModel {
        DetailsViewModel(String nameHeader, String typeHeader, String statusHeader, String sizeHeader, String lastModifiedHeader) {
            Object[] columnNames = new String[]{nameHeader, typeHeader, statusHeader, sizeHeader, lastModifiedHeader};
            this.setColumnIdentifiers(columnNames);
        }

        public void setContents(Collection<File> data) {
            this.setRowCount(0);
            for (File file : data) {
                this.dataVector.add(this.getTableObjectVectorForFile(file));
            }
        }

        @Override
        public Class<?> getColumnClass(int column) {
            switch (column) {
                case 0: {
                    return File.class;
                }
                case 3: {
                    return FileSizeWrapper.class;
                }
                case 4: {
                    return FileModifiedWrapper.class;
                }
            }
            return Object.class;
        }

        private Vector<?> getTableObjectVectorForFile(File file) {
            String description = DetailsView.this.chooser.getDescription(file);
            Vector<Object> temp = new Vector<Object>(5);
            temp.add(0, file);
            temp.add(1, description);
            temp.add(2, null);
            temp.add(3, null);
            temp.add(4, null);
            return temp;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }
    }

    private class AttributeRunnable
    implements Runnable {
        private int displayCount;
        private List<File> files;
        private static final int BATCH_SIZE = 15;

        AttributeRunnable(int displayCount, List<File> files) {
            this.displayCount = displayCount;
            this.files = files;
        }

        @Override
        public void run() {
            int i = 0;
            while (i < this.files.size()) {
                if (this.shouldStop()) {
                    return;
                }
                int max = Math.min(i + 15, this.files.size());
                final AttributeBatch batch = new AttributeBatch(this.displayCount, i);
                for (int j = i; j < max; ++j) {
                    File file = this.files.get(j);
                    batch.addAttributes(new FileAttributes(file));
                }
                if (this.shouldStop()) {
                    return;
                }
                i = max;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DetailsView.this.addFileAttributes(batch);
                    }
                });
            }
        }

        private boolean shouldStop() {
            return Thread.currentThread().isInterrupted() || this.displayCount != DetailsView.this.getDisplayCount();
        }
    }

    private class AttributeBatch {
        private int displayCount;
        private int start;
        private List<FileAttributes> fileAttrs;

        AttributeBatch(int displayCount, int start) {
            this.displayCount = displayCount;
            this.start = start;
            this.fileAttrs = new ArrayList<FileAttributes>();
        }

        void addAttributes(FileAttributes attrs) {
            this.fileAttrs.add(attrs);
        }

        FileAttributes getAttributes(int index) {
            return this.fileAttrs.get(index);
        }

        int getDisplayCount() {
            return this.displayCount;
        }

        public int getSize() {
            return this.fileAttrs.size();
        }

        public int getStart() {
            return this.start;
        }
    }
}

