/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextfilechooser;

import java.awt.Component;
import java.io.File;
import javax.swing.JTable;
import org.fife.ui.rtextfilechooser.FileTypeInfo;
import org.fife.ui.rtextfilechooser.RTextFileChooser;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.renderers.SubstanceDefaultTableCellRenderer;
import org.pushingpixels.substance.internal.ui.SubstanceTableUI;

class DetailsViewSubstanceFileNameRenderer
extends SubstanceDefaultTableCellRenderer {
    private RTextFileChooser chooser;

    DetailsViewSubstanceFileNameRenderer(RTextFileChooser chooser) {
        this.chooser = chooser;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focused, int row, int column) {
        super.getTableCellRendererComponent(table, value, selected, focused, row, column);
        File file = (File)value;
        String fileName = file.getName();
        if (this.chooser.isOpenedFile(file)) {
            fileName = "<html><u>" + fileName + "</u>";
        }
        this.setText(fileName);
        FileTypeInfo info = this.chooser.getFileTypeInfoFor(file);
        this.setIcon(info.icon);
        if (!selected && !DetailsViewSubstanceFileNameRenderer.substanceAndRollover(table, row, column)) {
            if (this.chooser.getShowHiddenFiles() && file.isHidden()) {
                this.setForeground(this.chooser.getHiddenFileColor());
            } else {
                this.setForeground(info.labelTextColor);
            }
        }
        return this;
    }

    private static boolean substanceAndRollover(JTable table, int row, int col) {
        SubstanceTableUI.TableCellId cellId;
        SubstanceTableUI ui = (SubstanceTableUI)table.getUI();
        ComponentState state = ui.getCellState(cellId = new SubstanceTableUI.TableCellId(row, col));
        return state == ComponentState.ROLLOVER_ARMED || state == ComponentState.ROLLOVER_SELECTED || state == ComponentState.ROLLOVER_UNSELECTED;
    }
}

