/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextfilechooser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.filechooser.FileSystemView;
import org.fife.ui.EscapableDialog;
import org.fife.ui.GUIWorkerThread;
import org.fife.ui.RListSelectionModel;
import org.fife.ui.RScrollPane;
import org.fife.ui.ResizableFrameContentPane;
import org.fife.ui.SelectableLabel;
import org.fife.ui.UIUtil;
import org.fife.ui.rtextfilechooser.DefaultFilePasteCallback;
import org.fife.ui.rtextfilechooser.FilePasteCallback;
import org.fife.ui.rtextfilechooser.Utilities;

class FilePasteThread
extends GUIWorkerThread {
    private Window parent;
    private List<File> files;
    private File destDir;
    private FilePasteCallback callback;
    private UserDecisions decisions;
    private int pasteCount;
    private int total;
    private String errorDialogTitle;
    private String confirmationDialogTitle;
    private static final ResourceBundle MSG = ResourceBundle.getBundle("org.fife.ui.rtextfilechooser.FilePaste");

    FilePasteThread(Frame parent, List<File> files, File destDir, FilePasteCallback callback) {
        this.parent = parent;
        this.init(files, destDir, callback);
    }

    FilePasteThread(Dialog parent, List<File> files, File destDir, FilePasteCallback callback) {
        this.parent = parent;
        this.init(files, destDir, callback);
    }

    @Override
    public Object construct() {
        if (this.files == null || this.files.size() == 0) {
            return null;
        }
        this.pasteCount = 0;
        this.total = 0;
        ArrayList<FileTreeNode> toCopy = new ArrayList<FileTreeNode>();
        for (File file : this.files) {
            if (file.isDirectory()) {
                toCopy.add(this.getFilesRecursive(file));
            } else {
                toCopy.add(new FileTreeNode(file, false));
            }
            ++this.total;
        }
        this.doCopy(toCopy, this.destDir);
        return null;
    }

    private void copyFileImpl(File source, File dest) {
        block3: {
            try {
                if (!source.equals(dest)) {
                    Utilities.copyFile(source, dest);
                }
            }
            catch (IOException ioe) {
                String msg = FilePasteThread.getString("Error.CopyingFiles", source.getName(), ioe.getMessage());
                String title = this.getErrorDialogTitle();
                int rc = JOptionPane.showConfirmDialog(this.parent, msg, title, 0, 0);
                if (rc == 0) break block3;
                this.decisions.cancelEverything = true;
            }
        }
    }

    private static File createUniqueDestFile(File dir, String name) {
        String orig = name;
        int lastDot = name.lastIndexOf(46);
        File test = new File(dir, name = lastDot > -1 ? name.substring(0, lastDot) + ".copy" + name.substring(lastDot) : name + ".copy");
        if (!test.exists()) {
            return test;
        }
        int count = 1;
        while ((test = new File(dir, name = lastDot > -1 ? orig.substring(0, lastDot) + ".copy." + count + orig.substring(lastDot) : name + ".copy." + count)).exists()) {
            ++count;
        }
        return test;
    }

    private void doCopy(List<FileTreeNode> copyMap, File toDir) {
        if (copyMap == null || copyMap.isEmpty()) {
            return;
        }
        for (FileTreeNode node : copyMap) {
            if (this.decisions.cancelEverything) {
                return;
            }
            File file = node.node;
            List children = node.children;
            if (children == null) {
                File dest = new File(toDir, file.getName());
                this.doCopyFile(file, dest);
                continue;
            }
            if (this.callback != null && this.callback.filePasteUpdate(++this.pasteCount, this.total, file)) {
                this.decisions.cancelEverything = true;
                return;
            }
            File newDir = new File(toDir, file.getName());
            if (newDir.isFile()) {
                String msg = FilePasteThread.getString("Error.DirectoryExistsAsFile", newDir.getAbsolutePath());
                CannotCopyDialog ccd = null;
                ccd = this.parent instanceof Dialog ? new CannotCopyDialog((Dialog)this.parent, msg) : new CannotCopyDialog((Frame)this.parent, msg);
                ccd.setVisible(true);
                if (ccd.continueCopying) continue;
                this.decisions.cancelEverything = true;
                continue;
            }
            if (newDir.isDirectory()) {
                if (this.decisions.dirNameCollision == 0) {
                    DirExistsDialog ded = null;
                    ded = this.parent instanceof Dialog ? new DirExistsDialog((Dialog)this.parent, newDir) : new DirExistsDialog((Frame)this.parent, newDir);
                    ded.setVisible(true);
                    boolean doCopy = ded.getCopyFilesIntoDirectory();
                    boolean rememberDecision = ded.getRememberDecision();
                    if (rememberDecision) {
                        this.decisions.dirNameCollision = doCopy ? 1 : 3;
                    }
                    if (!doCopy) {
                        this.total -= FilePasteThread.getSizeRecursive(children);
                        if (this.callback == null || !this.callback.filePasteUpdate(this.pasteCount, this.total, null)) continue;
                        this.decisions.cancelEverything = true;
                        return;
                    }
                } else if (this.decisions.dirNameCollision == 3) {
                    this.total -= FilePasteThread.getSizeRecursive(children);
                    if (this.callback == null || !this.callback.filePasteUpdate(this.pasteCount, this.total, null)) continue;
                    this.decisions.cancelEverything = true;
                    return;
                }
            } else if (!this.makeDir(newDir, file)) {
                return;
            }
            this.doCopy(children, newDir);
        }
    }

    private void doCopyFile(File file, File dest) {
        if (dest.isFile()) {
            if (this.callback != null) {
                if (this.decisions.nameCollision == 3) {
                    --this.total;
                } else if (this.callback.filePasteUpdate(++this.pasteCount, this.total, file)) {
                    this.decisions.cancelEverything = true;
                    return;
                }
            }
            if (this.decisions.nameCollision == 0) {
                NameCollisionResolver r = new NameCollisionResolver(file, dest);
                try {
                    SwingUtilities.invokeAndWait(r);
                }
                catch (InvocationTargetException ite) {
                    ite.printStackTrace();
                    return;
                }
                catch (InterruptedException ie) {
                    ie.printStackTrace();
                    return;
                }
                int result = r.result;
                boolean doForAll = r.doForAll;
                switch (result) {
                    case 0: {
                        this.copyFileImpl(file, dest);
                        if (!doForAll) break;
                        this.decisions.nameCollision = 1;
                        break;
                    }
                    case 1: {
                        if (!doForAll) break;
                        this.decisions.nameCollision = 3;
                        break;
                    }
                    case 2: {
                        File toDir = dest.getParentFile();
                        dest = FilePasteThread.createUniqueDestFile(toDir, file.getName());
                        this.copyFileImpl(file, dest);
                        if (!doForAll) break;
                        this.decisions.nameCollision = 2;
                        break;
                    }
                    case 3: {
                        this.decisions.cancelEverything = true;
                        return;
                    }
                }
            } else if (this.decisions.nameCollision == 1) {
                this.copyFileImpl(file, dest);
            } else if (this.decisions.nameCollision == 2) {
                File toDir = dest.getParentFile();
                dest = FilePasteThread.createUniqueDestFile(toDir, file.getName());
                this.copyFileImpl(file, dest);
            }
        } else if (dest.isDirectory()) {
            if (this.callback != null && this.callback.filePasteUpdate(++this.pasteCount, this.total, file)) {
                this.decisions.cancelEverything = true;
                return;
            }
            String msg = FilePasteThread.getString("Error.FileExistsAsDirectory", dest.getAbsolutePath());
            CannotCopyDialog ccd = null;
            ccd = this.parent instanceof Dialog ? new CannotCopyDialog((Dialog)this.parent, msg) : new CannotCopyDialog((Frame)this.parent, msg);
            ccd.setVisible(true);
            if (!ccd.continueCopying) {
                this.decisions.cancelEverything = true;
            }
        } else {
            if (this.callback != null && this.callback.filePasteUpdate(++this.pasteCount, this.total, file)) {
                this.decisions.cancelEverything = true;
            }
            this.copyFileImpl(file, dest);
        }
    }

    @Override
    public void finished() {
        if (this.callback != null) {
            this.callback.pasteOperationCompleted(this.pasteCount);
        }
    }

    private String getConfirmationDialogTitle() {
        if (this.confirmationDialogTitle != null) {
            return this.confirmationDialogTitle;
        }
        return MSG.getString("ConfirmationDialog.Title");
    }

    private String getErrorDialogTitle() {
        if (this.errorDialogTitle != null) {
            return this.errorDialogTitle;
        }
        return MSG.getString("ErrorDialog.Title");
    }

    private FileTreeNode getFilesRecursive(File dir) {
        FileTreeNode node = new FileTreeNode(dir, true);
        File[] children = dir.listFiles();
        int count = children == null ? 0 : children.length;
        for (int i = 0; i < count; ++i) {
            File child = children[i];
            if (child.isDirectory()) {
                node.addChild(this.getFilesRecursive(child));
            }
            ++this.total;
        }
        return node;
    }

    private static int getSizeRecursive(List<FileTreeNode> map) {
        int count = 0;
        for (FileTreeNode node : map) {
            ++count;
            if (node.children == null) continue;
            count += FilePasteThread.getSizeRecursive(node.children);
        }
        return count;
    }

    private static String getString(String key) {
        return MSG.getString(key);
    }

    private static String getString(String key, String ... args) {
        String str = MSG.getString(key);
        return MessageFormat.format(str, args);
    }

    private void init(List<File> files, File destDir, FilePasteCallback callback) {
        this.files = files;
        this.destDir = destDir;
        this.callback = callback;
        this.decisions = new UserDecisions();
    }

    private boolean makeDir(File dir, File contentsToCopyInDir) {
        int rc = 0;
        if (!dir.mkdir()) {
            String msg = FilePasteThread.getString("Error.CreatingDirectory", dir.getAbsolutePath(), contentsToCopyInDir.getAbsolutePath());
            String title = this.getConfirmationDialogTitle();
            rc = JOptionPane.showConfirmDialog(null, msg, title, 0);
        }
        return rc == 0;
    }

    public static void paste(Window parent, List<File> files, File destDir, FilePasteCallback callback) {
        FilePasteThread thread = null;
        thread = parent instanceof Frame ? new FilePasteThread((Frame)parent, files, destDir, callback) : new FilePasteThread((Dialog)parent, files, destDir, callback);
        thread.start();
    }

    public void setConfirmationDialogTitle(String title) {
        this.confirmationDialogTitle = title;
    }

    public void setErrorDialogTitle(String title) {
        this.errorDialogTitle = title;
    }

    public static void main(String[] args) throws Exception {
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        ArrayList<File> files = new ArrayList<File>();
        files.add(new File("C:/temp/test.java"));
        files.add(new File("C:/temp/FilePasteTestInput"));
        File dest = new File("C:/temp/FilePasteTest");
        dest.mkdir();
        Window parent = null;
        DefaultFilePasteCallback callback = new DefaultFilePasteCallback(parent){

            @Override
            public void pasteOperationCompleted(int pasteCount) {
                super.pasteOperationCompleted(pasteCount);
                System.exit(0);
            }
        };
        FilePasteThread.paste(parent, files, dest, callback);
    }

    private static final class FileTreeNode {
        private File node;
        private List<FileTreeNode> children;

        private FileTreeNode(File node, boolean isDir) {
            this.node = node;
            if (isDir) {
                this.children = new ArrayList<FileTreeNode>();
            }
        }

        private void addChild(FileTreeNode child) {
            if (this.children == null) {
                this.children = new ArrayList<FileTreeNode>();
            }
            this.children.add(child);
        }
    }

    private static class UserDecisions {
        private static final int PROMPT = 0;
        private static final int OVERWRITE = 1;
        private static final int RENAME = 2;
        private static final int SKIP = 3;
        private int nameCollision = 0;
        private int dirNameCollision = 0;
        private boolean cancelEverything;

        UserDecisions() {
        }
    }

    private class NameCollisionResolver
    implements Runnable {
        private int result;
        private boolean doForAll;
        private File file;
        private File dest;

        NameCollisionResolver(File file, File dest) {
            this.file = file;
            this.dest = dest;
            this.result = 0;
            this.doForAll = false;
        }

        @Override
        public void run() {
            NameCollisionDialog ncd = null;
            ncd = FilePasteThread.this.parent instanceof Frame ? new NameCollisionDialog((Frame)FilePasteThread.this.parent, this.file, this.dest) : new NameCollisionDialog((Dialog)FilePasteThread.this.parent, this.file, this.dest);
            ncd.setVisible(true);
            this.result = ncd.getResult();
            this.doForAll = ncd.getDoForAll();
        }
    }

    private class NameCollisionDialog
    extends JDialog
    implements ActionListener {
        private JList list;
        private JCheckBox doForAllCB;
        private JButton okButton;
        private int result;

        NameCollisionDialog(Dialog parent, File source, File dest) {
            super(parent);
            this.init(source, dest);
        }

        NameCollisionDialog(Frame parent, File source, File dest) {
            super(parent);
            this.init(source, dest);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (this.okButton == source) {
                this.result = this.list.getSelectedIndex();
                this.setVisible(false);
            }
        }

        public boolean getDoForAll() {
            return this.doForAllCB.isSelected();
        }

        public int getResult() {
            return this.result;
        }

        private Container createTopPanel(File source, File dest) {
            Box topPanel = Box.createVerticalBox();
            String temp = FilePasteThread.getString("Dialog.NameCollision.FileExists", new String[]{source.getAbsolutePath()});
            JLabel label = new JLabel(temp);
            JPanel temp2 = new JPanel(new BorderLayout());
            temp2.add((Component)label, "Before");
            topPanel.add(temp2);
            topPanel.add(Box.createVerticalStrut(5));
            String title = FilePasteThread.getString("Dialog.NameCollision.CurrentFile");
            topPanel.add(new FileInfoPanel(title, dest));
            topPanel.add(Box.createVerticalStrut(5));
            title = FilePasteThread.getString("Dialog.NameCollision.FileBeingCopied");
            topPanel.add(new FileInfoPanel(title, source));
            topPanel.add(Box.createVerticalGlue());
            return topPanel;
        }

        private void init(File source, File dest) {
            this.setTitle(FilePasteThread.getString("Dialog.NameCollision.Title"));
            ResizableFrameContentPane cp = new ResizableFrameContentPane(new BorderLayout(0, 15));
            cp.setBorder(UIUtil.getEmpty5Border());
            cp.add((Component)this.createTopPanel(source, dest), "North");
            Box middle = Box.createVerticalBox();
            JLabel label = new JLabel(FilePasteThread.getString("Dialog.NameCollision.WhatToDo"));
            JPanel temp2 = new JPanel(new BorderLayout());
            temp2.add((Component)label, "Before");
            middle.add(temp2);
            String[] choices = new String[]{FilePasteThread.getString("Dialog.NameCollision.Overwrite"), FilePasteThread.getString("Dialog.NameCollision.Skip"), FilePasteThread.getString("Dialog.NameCollision.CopyWithNewName"), FilePasteThread.getString("Dialog.NameCollision.CancelRemainingFiles")};
            this.list = new JList<String>(choices);
            this.list.setSelectionModel(new RListSelectionModel());
            this.list.setSelectedIndex(0);
            RScrollPane sp = new RScrollPane(this.list);
            middle.add(sp);
            middle.add(Box.createVerticalStrut(5));
            this.doForAllCB = UIUtil.newCheckBox(MSG, "Dialog.NameCollision.RememberForFutureFiles");
            JPanel temp = new JPanel(new BorderLayout());
            temp.add((Component)this.doForAllCB, "Before");
            middle.add(temp);
            middle.add(Box.createVerticalGlue());
            temp = new JPanel(new BorderLayout());
            temp.add((Component)middle, "North");
            cp.add(temp);
            this.okButton = UIUtil.newButton(MSG, "Button.OK");
            this.okButton.addActionListener(this);
            Container footer = UIUtil.createButtonFooter(this.okButton);
            cp.add((Component)footer, "South");
            this.setContentPane(cp);
            this.getRootPane().setDefaultButton(this.okButton);
            this.setModal(true);
            this.pack();
            this.setDefaultCloseOperation(2);
            this.setLocationRelativeTo(this.getParent());
            this.result = 3;
        }
    }

    private static class FileInfoPanel
    extends JPanel {
        FileInfoPanel(String title, File file) {
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(title), BorderFactory.createEmptyBorder(0, 5, 0, 5)));
            this.setLayout(new BorderLayout(10, 0));
            Icon fileIcon = FileInfoPanel.getIcon(file);
            this.add((Component)new JLabel(fileIcon), "Before");
            String text = "<html><b>" + file.getName() + "</b><br>" + file.getAbsolutePath() + "<br>" + MSG.getString("FileInfo.Size") + " " + Utilities.getFileSizeStringFor(file) + "<br>" + MSG.getString("FileInfo.DateModified") + " " + Utilities.getLastModifiedString(file.lastModified());
            SelectableLabel label = new SelectableLabel(text);
            this.add(label);
        }

        private static Icon getIcon(File file) {
            Icon icon = null;
            try {
                Class<?> sfClazz = Class.forName("sun.awt.shell.ShellFolder");
                Method m = sfClazz.getMethod("getShellFolder", File.class);
                Object shellFolder = m.invoke(null, file);
                if (shellFolder != null) {
                    m = sfClazz.getMethod("getIcon", Boolean.TYPE);
                    Image image = (Image)m.invoke(shellFolder, Boolean.TRUE);
                    if (image != null) {
                        icon = new ImageIcon(image);
                    }
                }
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (icon == null) {
                icon = FileSystemView.getFileSystemView().getSystemIcon(file);
            }
            return icon;
        }
    }

    private class DirExistsDialog
    extends JDialog
    implements ActionListener {
        private JCheckBox rememberCB;
        private JButton yes;
        private JButton no;
        private boolean copyFilesIntoDirectory;

        DirExistsDialog(Dialog parent, File dir) {
            super(parent);
            this.init(dir);
        }

        DirExistsDialog(Frame parent, File dir) {
            super(parent);
            this.init(dir);
        }

        boolean getCopyFilesIntoDirectory() {
            return this.copyFilesIntoDirectory;
        }

        private boolean getRememberDecision() {
            return this.rememberCB.isSelected();
        }

        private void init(File dir) {
            ResizableFrameContentPane cp = new ResizableFrameContentPane(new BorderLayout(0, 20));
            cp.setBorder(BorderFactory.createCompoundBorder(UIUtil.getEmpty5Border(), UIUtil.getEmpty5Border()));
            JPanel topPanel = new JPanel(new BorderLayout(20, 0));
            cp.add((Component)topPanel, "North");
            Icon icon = UIManager.getIcon("OptionPane.questionIcon");
            if (icon != null) {
                JLabel iconLabel = new JLabel(icon);
                iconLabel.setVerticalAlignment(1);
                topPanel.add((Component)iconLabel, "Before");
            }
            Box topText = Box.createVerticalBox();
            String message = FilePasteThread.getString("Dialog.DirExists.Text", new String[]{dir.getAbsolutePath()});
            if (message.startsWith("<html>")) {
                topText.add(new SelectableLabel(message));
            } else {
                int newline = 0;
                int lastNewline = 0;
                while ((newline = message.indexOf(10, lastNewline)) > -1) {
                    String temp = message.substring(lastNewline, newline);
                    if (temp.length() == 0) {
                        temp = " ";
                    }
                    topText.add(new JLabel(temp));
                    lastNewline = newline + 1;
                }
                if (lastNewline < message.length() - 1) {
                    topText.add(new JLabel(message.substring(lastNewline)));
                }
            }
            topText.add(Box.createVerticalGlue());
            JPanel temp = new JPanel(new BorderLayout());
            temp.add(topText);
            topPanel.add(temp);
            JPanel bottom = new JPanel(new BorderLayout());
            this.rememberCB = UIUtil.newCheckBox(MSG, "Dialog.DirExists.RememberMyDecision");
            temp = new JPanel(new BorderLayout());
            temp.add((Component)this.rememberCB, "Before");
            bottom.add((Component)temp, "North");
            this.yes = UIUtil.newButton(MSG, "Dialog.DirExists.Yes");
            this.yes.addActionListener(this);
            this.no = UIUtil.newButton(MSG, "Dialog.DirExists.No");
            this.no.addActionListener(this);
            Container buttonPanel = UIUtil.createButtonFooter(this.yes, this.no, 0);
            buttonPanel.add((Component)this.rememberCB, "Before");
            bottom.add((Component)buttonPanel, "South");
            cp.add((Component)bottom, "South");
            this.setTitle(FilePasteThread.this.getConfirmationDialogTitle());
            this.setContentPane(cp);
            this.getRootPane().setDefaultButton(this.yes);
            this.setDefaultCloseOperation(2);
            this.setModal(true);
            this.pack();
            Dimension size = this.getSize();
            if (size.width < 400) {
                size.width = 400;
                this.setSize(size);
            }
            this.setLocationRelativeTo(this.getParent());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (this.yes == source) {
                this.copyFilesIntoDirectory = true;
            } else if (this.no == source) {
                this.copyFilesIntoDirectory = false;
            }
            this.setVisible(false);
        }
    }

    private class CannotCopyDialog
    extends EscapableDialog
    implements ActionListener {
        private JButton okButton;
        private boolean continueCopying;

        CannotCopyDialog(Dialog parent, String msg) {
            super((Window)parent);
            this.init(msg);
        }

        CannotCopyDialog(Frame parent, String msg) {
            super((Window)parent);
            this.init(msg);
        }

        private void init(String msg) {
            ResizableFrameContentPane cp = new ResizableFrameContentPane(new BorderLayout(0, 15));
            cp.setBorder(UIUtil.getEmpty5Border());
            SelectableLabel desc = new SelectableLabel(msg);
            cp.add((Component)desc, "North");
            this.okButton = UIUtil.newButton(MSG, "Dialog.CannotCopy.ContinueCopyingFiles");
            this.okButton.addActionListener(this);
            JButton cancelButton = UIUtil.newButton(MSG, "Dialog.CannotCopy.CancelRemainingCopies");
            cancelButton.addActionListener(this);
            Container footer = UIUtil.createButtonFooter(this.okButton, cancelButton);
            cp.add((Component)footer, "South");
            this.setContentPane(cp);
            this.getRootPane().setDefaultButton(this.okButton);
            this.setModal(true);
            this.pack();
            this.setDefaultCloseOperation(2);
            this.setLocationRelativeTo(this.getParent());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (this.okButton == source) {
                this.continueCopying = true;
            }
            this.escapePressed();
        }
    }
}

