/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextfilechooser;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.ResourceBundle;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileSystemView;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.fife.ui.ToolTipTree;
import org.fife.ui.rtextfilechooser.Actions;
import org.fife.ui.rtextfilechooser.FileChooserIconManager;
import org.fife.ui.rtextfilechooser.FileDisplayNames;
import org.fife.ui.rtextfilechooser.FileListTransferable;
import org.fife.ui.rtextfilechooser.FileSelector;
import org.fife.ui.rtextfilechooser.FileSystemTreeActions;
import org.fife.ui.rtextfilechooser.RootManager;
import org.fife.ui.rtextfilechooser.SubstanceFileSystemTreeRenderer;
import org.fife.ui.rtextfilechooser.Utilities;
import org.fife.util.SubstanceUtil;

public class FileSystemTree
extends ToolTipTree
implements FileSelector {
    public static final String EXPANDED_PROPERTY = "FileSystemTree.treeExpanded";
    public static final String WILL_EXPAND_PROPERTY = "FileSystemTree.treeWillExpand";
    private static final String DUMMY_FILE_NAME = "dummy";
    private static final File DUMMY_FILE = new File("dummy");
    private FileSystemTreeModel treeModel;
    private FileSystemTreeNode root;
    private FileSystemView fileSystemView;
    protected FileChooserIconManager iconManager;
    protected JPopupMenu popup;
    private JMenu openInMenu;
    private Actions.SystemOpenAction systemEditAction;
    private Actions.SystemOpenAction systemViewAction;
    private Actions.CopyAction copyAction;
    private Actions.CopyFullPathAction copyPathAction;
    private FileSystemTreeActions.PasteAction pasteAction;
    private FileSystemTreeActions.DeleteAction deleteAction;
    private FileSystemTreeActions.DeleteAction hardDeleteAction;
    protected FileSystemTreeActions.NewFileAction newFileAction;
    private FileSystemTreeActions.NewFolderAction newFolderAction;
    private FileSystemTreeActions.RefreshAction refreshAction;
    private Actions.PropertiesAction propertiesAction;
    private TreeCellRenderer cellRenderer;

    public FileSystemTree() {
        this.fileSystemView = FileSystemView.getFileSystemView();
        this.iconManager = new FileChooserIconManager();
        this.root = new FileSystemTreeNode();
        Iterator<File> i = RootManager.getInstance().iterator();
        while (i.hasNext()) {
            File aRoot = i.next();
            this.root.add(this.createTreeNodeForImpl(aRoot, true));
        }
        this.init();
    }

    public FileSystemTree(File rootDir) {
        if (rootDir == null || !rootDir.isDirectory()) {
            throw new IllegalArgumentException("Invalid root dir: " + rootDir);
        }
        this.fileSystemView = FileSystemView.getFileSystemView();
        this.iconManager = new FileChooserIconManager();
        this.root = new FileSystemTreeNode();
        this.root.add(this.createTreeNodeForImpl(rootDir, true));
        this.init();
    }

    protected void collapseAllNodes() {
        for (int i = this.getRowCount() - 1; i >= 0; --i) {
            this.collapseRow(i);
        }
    }

    protected void configurePopupMenuActions() {
        File selectedFile = this.getSelectedFile();
        this.openInMenu.setEnabled(selectedFile != null);
        this.systemEditAction.setEnabled(selectedFile != null);
        this.systemViewAction.setEnabled(selectedFile != null);
        boolean enable = selectedFile != null;
        this.copyAction.setEnabled(enable);
        this.copyPathAction.setEnabled(enable);
        this.deleteAction.setEnabled(enable);
        enable = selectedFile != null && selectedFile.isDirectory() || selectedFile == null && this.root.getFile() != null;
        this.refreshAction.setEnabled(enable);
        this.propertiesAction.setEnabled(selectedFile != null);
        enable = selectedFile != null && selectedFile.isDirectory() || selectedFile == null && this.root.getFile() != null;
        this.newFileAction.setEnabled(enable);
        this.newFolderAction.setEnabled(enable);
        this.pasteAction.setEnabled(enable && Utilities.getClipboardContainsFileList());
    }

    @Override
    public String convertValueToText(Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        File file;
        if (value instanceof FileSystemTreeNode && (file = ((FileSystemTreeNode)value).getFile()) != null) {
            return file.getName();
        }
        return super.convertValueToText(value, selected, expanded, leaf, row, hasFocus);
    }

    protected JPopupMenu createPopupMenu() {
        JPopupMenu popup = new JPopupMenu();
        ResourceBundle bundle = ResourceBundle.getBundle(FileSystemTree.class.getName());
        this.openInMenu = new JMenu(bundle.getString("PopupMenu.OpenIn"));
        this.systemEditAction = new Actions.SystemOpenAction(this, Actions.SystemOpenAction.OpenMethod.EDIT);
        this.openInMenu.add(this.systemEditAction);
        this.systemViewAction = new Actions.SystemOpenAction(this, Actions.SystemOpenAction.OpenMethod.OPEN);
        this.openInMenu.add(this.systemViewAction);
        popup.add(this.openInMenu);
        popup.addSeparator();
        popup.add(this.copyAction);
        popup.add(this.copyPathAction);
        popup.add(this.pasteAction);
        popup.add(this.deleteAction);
        popup.addSeparator();
        popup.add(new JMenuItem(this.newFileAction));
        popup.add(new JMenuItem(this.newFolderAction));
        popup.addSeparator();
        popup.add(new JMenuItem(this.refreshAction));
        popup.addSeparator();
        popup.add(new JMenuItem(this.propertiesAction));
        popup.applyComponentOrientation(this.getComponentOrientation());
        return popup;
    }

    private TreeCellRenderer createTreeCellRenderer() {
        if (SubstanceUtil.isSubstanceInstalled()) {
            return new SubstanceFileSystemTreeRenderer(this);
        }
        return new FileSystemTreeRenderer();
    }

    public FileSystemTreeNode createTreeNodeFor(File file) {
        return this.createTreeNodeForImpl(file, file.isDirectory());
    }

    protected FileSystemTreeNode createTreeNodeForImpl(File file, boolean directory) {
        FileSystemTreeNode dmtn = new FileSystemTreeNode(file);
        if (directory) {
            dmtn.add(new FileSystemTreeNode(DUMMY_FILE));
        }
        return dmtn;
    }

    private synchronized void displayPopupMenu(Point p) {
        TreePath path;
        if (this.popup == null) {
            this.popup = this.createPopupMenu();
        }
        if ((path = this.getPathForLocation(p.x, p.y)) != null) {
            this.setSelectionPath(path);
            this.scrollPathToVisible(path);
        } else {
            this.clearSelection();
        }
        this.configurePopupMenuActions();
        this.popup.show(this, p.x, p.y);
    }

    protected File[] filterAndSort(File[] files) {
        int num = files.length;
        ArrayList<File> dirList = new ArrayList<File>();
        ArrayList<File> fileList = new ArrayList<File>();
        for (int i = 0; i < num; ++i) {
            if (files[i].isDirectory()) {
                dirList.add(files[i]);
                continue;
            }
            fileList.add(files[i]);
        }
        Collections.sort(fileList);
        Collections.sort(dirList);
        dirList.addAll(fileList);
        File[] fileArray = new File[dirList.size()];
        return dirList.toArray(fileArray);
    }

    @Override
    public void fireTreeExpanded(TreePath e) {
        super.fireTreeExpanded(e);
        this.firePropertyChange(EXPANDED_PROPERTY, null, null);
    }

    @Override
    public void fireTreeWillExpand(TreePath e) throws ExpandVetoException {
        this.firePropertyChange(WILL_EXPAND_PROPERTY, null, null);
        super.fireTreeWillExpand(e);
        FileSystemTreeNode dmtn = (FileSystemTreeNode)e.getLastPathComponent();
        int childCount = dmtn.getChildCount();
        if (childCount == 1 && ((FileSystemTreeNode)dmtn.getChildAt(0)).containsFile(DUMMY_FILE)) {
            this.refreshChildren(dmtn);
        }
    }

    private static FileSystemTreeNode getChildRepresentingFile(FileSystemTreeNode node, Object file) {
        if (file == null) {
            return null;
        }
        int childCount = node.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            FileSystemTreeNode child = (FileSystemTreeNode)node.getChildAt(i);
            if (!file.equals(child.getUserObject())) continue;
            return child;
        }
        return null;
    }

    protected String getName(File file) {
        return FileDisplayNames.get().getName(file);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        size.width = Math.max(size.width, 300);
        return size;
    }

    public File getRoot() {
        return this.root.getFile();
    }

    @Override
    public File getSelectedFile() {
        Object comp;
        TreePath path = this.getSelectionPath();
        if (path != null && (comp = path.getLastPathComponent()) instanceof FileSystemTreeNode) {
            FileSystemTreeNode node = (FileSystemTreeNode)comp;
            return (File)node.getUserObject();
        }
        return null;
    }

    @Override
    public File[] getSelectedFiles() {
        File file = this.getSelectedFile();
        if (file != null) {
            return new File[]{file};
        }
        return new File[0];
    }

    public String getSelectedFileName() {
        File file = this.getSelectedFile();
        return file != null ? file.getAbsolutePath() : null;
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        Object comp;
        int y;
        String tip = null;
        int x = e.getX();
        TreePath path = this.getPathForLocation(x, y = e.getY());
        if (path != null && (comp = path.getLastPathComponent()) != null && comp instanceof FileSystemTreeNode) {
            FileSystemTreeNode node = (FileSystemTreeNode)comp;
            return this.getName((File)node.getUserObject());
        }
        return tip;
    }

    private void init() {
        TreeSelectionModel tsm = this.getSelectionModel();
        tsm.setSelectionMode(1);
        tsm.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                FileSystemTree.this.scrollPathToVisible(e.getPath());
            }
        });
        this.treeModel = new FileSystemTreeModel(this.root);
        this.setModel(this.treeModel);
        this.cellRenderer = this.createTreeCellRenderer();
        this.setCellRenderer(this.cellRenderer);
        this.enableEvents(16L);
        this.setShowsRootHandles(true);
        this.setRootVisible(false);
        this.setTransferHandler(new TreeTransferHandler());
        this.setDragEnabled(true);
        this.copyAction = new Actions.CopyAction(this);
        this.copyPathAction = new Actions.CopyFullPathAction(this);
        this.pasteAction = new FileSystemTreeActions.PasteAction(this);
        this.deleteAction = new FileSystemTreeActions.DeleteAction(null, this, false);
        this.hardDeleteAction = new FileSystemTreeActions.DeleteAction(null, this, true);
        this.newFileAction = new FileSystemTreeActions.NewFileAction(this);
        this.newFolderAction = new FileSystemTreeActions.NewFolderAction(this);
        this.refreshAction = new FileSystemTreeActions.RefreshAction(this);
        this.propertiesAction = new Actions.PropertiesAction(this);
        this.installKeyboardActions();
    }

    protected void installKeyboardActions() {
        InputMap im = this.getInputMap();
        ActionMap am = this.getActionMap();
        im.put((KeyStroke)this.copyAction.getValue("AcceleratorKey"), "Copy");
        am.put("Copy", this.copyAction);
        im.put((KeyStroke)this.copyPathAction.getValue("AcceleratorKey"), "CopyFullPath");
        am.put("CopyFullPath", this.copyPathAction);
        im.put((KeyStroke)this.pasteAction.getValue("AcceleratorKey"), "Paste");
        am.put("Paste", this.pasteAction);
        im.put((KeyStroke)this.deleteAction.getValue("AcceleratorKey"), "Delete");
        am.put("Delete", this.deleteAction);
        im.put((KeyStroke)this.hardDeleteAction.getValue("AcceleratorKey"), "HardDelete");
        am.put("HardDelete", this.hardDeleteAction);
        im.put((KeyStroke)this.refreshAction.getValue("AcceleratorKey"), "Refresh");
        am.put("Refresh", this.refreshAction);
        im.put((KeyStroke)this.propertiesAction.getValue("AcceleratorKey"), "OnAltEnter");
        am.put("OnAltEnter", this.propertiesAction);
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        super.processMouseEvent(e);
        if (e.isPopupTrigger()) {
            this.displayPopupMenu(e.getPoint());
        }
    }

    void refreshChildren(FileSystemTreeNode node) {
        if (node == null) {
            node = (FileSystemTreeNode)this.getModel().getRoot();
        }
        if (node != null) {
            node.removeAllChildren();
            File file = node.getFile();
            if (file.isDirectory()) {
                File[] filteredChildren;
                File[] children = this.fileSystemView.getFiles(file, false);
                for (File filteredChild : filteredChildren = this.filterAndSort(children)) {
                    node.add(this.createTreeNodeFor(filteredChild));
                }
            }
            ((FileSystemTreeModel)this.getModel()).nodeStructureChanged(node);
        }
    }

    public void setRoot(File rootFile) {
        if (rootFile == null) {
            this.root = new FileSystemTreeNode();
            Iterator<File> i = RootManager.getInstance().iterator();
            while (i.hasNext()) {
                File aRoot = i.next();
                this.root.add(this.createTreeNodeForImpl(aRoot, true));
            }
        } else if (rootFile.isDirectory()) {
            int count;
            this.root = new FileSystemTreeNode(rootFile);
            File[] children = rootFile.listFiles();
            int n = count = children == null ? 0 : children.length;
            if (count > 0) {
                children = this.filterAndSort(children);
            }
            for (int i = 0; i < count; ++i) {
                this.root.add(this.createTreeNodeForImpl(children[i], children[i].isDirectory()));
            }
        } else {
            throw new IllegalArgumentException("root must be 'null' or a directory");
        }
        this.treeModel = new FileSystemTreeModel(this.root);
        this.setModel(this.treeModel);
    }

    public boolean setSelectedFile(File file) {
        this.collapseAllNodes();
        if (file == null || !file.exists()) {
            this.clearSelection();
            return false;
        }
        ArrayList<File> parents = new ArrayList<File>();
        for (File f2 = file; f2 != null; f2 = f2.getParentFile()) {
            parents.add(f2);
        }
        int numParents = parents.size();
        FileSystemTreeNode temp = this.root;
        TreePath path = null;
        for (int i = numParents - 1; i >= 0; --i) {
            if ((temp = FileSystemTree.getChildRepresentingFile(temp, parents.get(i))) == null) {
                this.clearSelection();
                return false;
            }
            path = new TreePath(temp.getPath());
            this.expandPath(path);
        }
        final TreePath path2 = path;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FileSystemTree.this.setSelectionPath(path2);
                FileSystemTree.this.scrollPathToVisible(path2);
            }
        });
        return true;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.cellRenderer != null) {
            this.cellRenderer = this.createTreeCellRenderer();
            this.setCellRenderer(this.cellRenderer);
        }
        if (this.popup != null) {
            SwingUtilities.updateComponentTreeUI(this.popup);
        }
    }

    private static class TreeTransferHandler
    extends TransferHandler {
        private TreeTransferHandler() {
        }

        @Override
        public boolean canImport(JComponent comp, DataFlavor[] flavors) {
            return false;
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            ArrayList<File> list = null;
            FileSystemTree tree = (FileSystemTree)c;
            File file = tree.getSelectedFile();
            if (file != null) {
                list = new ArrayList<File>(1);
                list.add(file);
            }
            return new FileListTransferable(list);
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 1;
        }
    }

    private class FileSystemTreeRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 1L;

        private FileSystemTreeRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            Object userObj = ((DefaultMutableTreeNode)value).getUserObject();
            if (userObj instanceof File) {
                File file = (File)userObj;
                this.setText(FileSystemTree.this.getName(file));
                this.setIcon(FileSystemTree.this.iconManager.getIcon(file));
            }
            return this;
        }
    }

    public static class FileSystemTreeNode
    extends DefaultMutableTreeNode {
        public FileSystemTreeNode() {
        }

        public FileSystemTreeNode(Object userObject) {
            super(userObject);
        }

        public boolean containsFile(File file) {
            return file != null && file.equals(this.userObject);
        }

        public boolean equals(Object o2) {
            if (o2 instanceof FileSystemTreeNode) {
                File f2 = ((FileSystemTreeNode)o2).getFile();
                File file = this.getFile();
                if (file == null) {
                    return f2 == null;
                }
                return f2 != null && file.equals(f2);
            }
            return false;
        }

        public File getFile() {
            return (File)this.userObject;
        }

        public int hashCode() {
            return this.userObject == null ? 0 : this.userObject.hashCode();
        }

        @Override
        public String toString() {
            File file = this.getFile();
            String fileName = file == null ? "<null>" : file.getAbsolutePath();
            return "[FileSystemTreeNode: file=" + fileName + "]";
        }
    }

    public static class FileSystemTreeModel
    extends DefaultTreeModel {
        FileSystemTreeModel(TreeNode root) {
            super(root);
        }

        @Override
        public void insertNodeInto(MutableTreeNode child, MutableTreeNode parent, int index) {
            FileSystemTreeNode fstParent = (FileSystemTreeNode)parent;
            if (fstParent.containsFile(DUMMY_FILE)) {
                fstParent.removeAllChildren();
                parent.insert(child, 0);
                this.fireTreeNodesChanged(this, this.getPathToRoot(child), new int[]{0}, new Object[]{child});
            } else {
                super.insertNodeInto(child, fstParent, index);
            }
        }
    }
}

