/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextfilechooser;

import java.awt.Component;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.EventObject;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.DefaultCellEditor;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreePath;
import org.fife.ui.rtextfilechooser.DefaultFilePasteCallback;
import org.fife.ui.rtextfilechooser.FilePasteThread;
import org.fife.ui.rtextfilechooser.FileSystemTree;
import org.fife.ui.rtextfilechooser.RTextFileChooser;
import org.fife.ui.rtextfilechooser.extras.FileIOExtras;

class FileSystemTreeActions {
    FileSystemTreeActions() {
    }

    static class RefreshAction
    extends AbstractTreeAction {
        RefreshAction(FileSystemTree tree) {
            super(tree);
            this.putValue("Name", this.getString("Refresh"));
            this.putValue("MnemonicKey", new Integer(this.getString("RefreshMnemonic").charAt(0)));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(116, 0));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TreePath path = this.tree.getSelectionPath();
            if (path != null) {
                FileSystemTree.FileSystemTreeNode node = (FileSystemTree.FileSystemTreeNode)path.getLastPathComponent();
                File file = node.getFile();
                DefaultTreeModel model = (DefaultTreeModel)this.tree.getModel();
                if (!file.exists()) {
                    int count = path.getPathCount();
                    if (count > 1) {
                        node = (FileSystemTree.FileSystemTreeNode)path.getPathComponent(count - 2);
                        this.tree.refreshChildren(node);
                        model.reload(node);
                    } else {
                        this.tree.removeSelectionPath(path);
                        model.reload(node);
                    }
                } else if (file.isDirectory()) {
                    this.tree.refreshChildren(node);
                    model.reload(node);
                } else {
                    int count = path.getPathCount();
                    if (count > 1) {
                        node = (FileSystemTree.FileSystemTreeNode)path.getPathComponent(count - 2);
                        this.tree.refreshChildren(node);
                        model.reload(node);
                    } else {
                        this.tree.removeSelectionPath(path);
                        model.reload(node);
                    }
                }
            } else if (this.tree.getRoot() != null) {
                this.tree.refreshChildren(null);
            }
        }
    }

    static class PasteAction
    extends AbstractTreeAction {
        PasteAction(FileSystemTree tree) {
            super(tree);
            this.putValue("Name", this.getString("Paste"));
            this.putValue("MnemonicKey", new Integer(this.getString("PasteMnemonic").charAt(0)));
            int mod = tree.getToolkit().getMenuShortcutKeyMask();
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(86, mod));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FileSystemTree.FileSystemTreeNode node;
            File destDir;
            final TreePath path = this.tree.getSelectionPath();
            boolean copying = false;
            if (path != null && (destDir = (node = (FileSystemTree.FileSystemTreeNode)path.getLastPathComponent()).getFile()).isDirectory()) {
                Clipboard clip = this.tree.getToolkit().getSystemClipboard();
                Transferable contents = clip.getContents(null);
                DataFlavor accepted = DataFlavor.javaFileListFlavor;
                try {
                    List files = (List)contents.getTransferData(accepted);
                    Window parent = SwingUtilities.getWindowAncestor(this.tree);
                    DefaultFilePasteCallback callback = new DefaultFilePasteCallback(parent){

                        @Override
                        public void pasteOperationCompleted(int pasteCount) {
                            super.pasteOperationCompleted(pasteCount);
                            PasteAction.this.tree.refreshChildren(node);
                            ((DefaultTreeModel)PasteAction.this.tree.getModel()).reload(node);
                            PasteAction.this.tree.expandPath(path);
                        }
                    };
                    if (files != null && files.size() > 0) {
                        FilePasteThread.paste(parent, files, destDir, callback);
                        copying = true;
                    }
                }
                catch (UnsupportedFlavorException ufe) {
                    ufe.printStackTrace();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
            if (!copying) {
                UIManager.getLookAndFeel().provideErrorFeedback(this.tree);
            }
        }
    }

    static class NewFolderAction
    extends AbstractNewFileOrFolderAction {
        NewFolderAction(FileSystemTree tree) {
            super(tree, "NewFolder");
        }

        @Override
        protected boolean createFileOrFolderImpl(File file) {
            return file.mkdir();
        }

        @Override
        protected FileSystemTree.FileSystemTreeNode createTreeNode(File root) {
            String name = File.separatorChar == '/' ? "newDir" : "New Folder";
            File f = new File(root, name);
            return this.tree.createTreeNodeForImpl(f, true);
        }
    }

    static class NewFileAction
    extends AbstractNewFileOrFolderAction {
        NewFileAction(FileSystemTree tree) {
            super(tree, "NewFile");
        }

        @Override
        protected boolean createFileOrFolderImpl(File file) {
            boolean res = false;
            try {
                res = file.createNewFile();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            return res;
        }

        @Override
        protected FileSystemTree.FileSystemTreeNode createTreeNode(File root) {
            String name = File.separatorChar == '/' ? "newFile" : "NewFile.txt";
            File f = new File(root, name);
            return new FileSystemTree.FileSystemTreeNode(f);
        }
    }

    private static abstract class AbstractNewFileOrFolderAction
    extends AbstractTreeAction
    implements CellEditorListener {
        protected TreeCellEditor editor;

        protected AbstractNewFileOrFolderAction(FileSystemTree tree, String keyRoot) {
            super(tree);
            this.putValue("Name", this.getString(keyRoot));
            this.putValue("MnemonicKey", new Integer(this.getString(keyRoot + "Mnemonic").charAt(0)));
        }

        @Override
        public final void actionPerformed(ActionEvent e) {
            TreePath path = this.tree.getSelectionPath();
            if (path != null) {
                FileSystemTree.FileSystemTreeNode parentNode = (FileSystemTree.FileSystemTreeNode)path.getLastPathComponent();
                File root = parentNode.getFile();
                if (root.isDirectory()) {
                    this.handleNewFileOrFolder(path, parentNode);
                } else {
                    UIManager.getLookAndFeel().provideErrorFeedback(this.tree);
                }
            } else if (this.tree.getRoot() != null) {
                FileSystemTree.FileSystemTreeNode rootNode = (FileSystemTree.FileSystemTreeNode)this.tree.getModel().getRoot();
                this.handleNewFileOrFolder(path, rootNode);
            }
        }

        protected abstract boolean createFileOrFolderImpl(File var1);

        protected abstract FileSystemTree.FileSystemTreeNode createTreeNode(File var1);

        @Override
        public final void editingCanceled(ChangeEvent e) {
            TreePath path = this.tree.getSelectionPath();
            FileSystemTree.FileSystemTreeNode node = (FileSystemTree.FileSystemTreeNode)path.getLastPathComponent();
            FileSystemTree.FileSystemTreeNode parent = null;
            if (node != null) {
                parent = (FileSystemTree.FileSystemTreeNode)node.getParent();
                this.tree.refreshChildren(parent);
                ((DefaultTreeModel)this.tree.getModel()).reload(parent);
            }
            this.editor.removeCellEditorListener(this);
            this.editor = null;
            this.tree.setCellEditor(null);
            this.tree.setEditable(false);
            if (parent != null) {
                this.tree.setSelectedFile(parent.getFile());
            }
        }

        @Override
        public final void editingStopped(ChangeEvent e) {
            File file = (File)this.editor.getCellEditorValue();
            FileSystemTree.FileSystemTreeNode node = (FileSystemTree.FileSystemTreeNode)this.tree.getSelectionPath().getLastPathComponent();
            if (node != null) {
                node.setUserObject(file);
                boolean res = this.createFileOrFolderImpl(file);
                if (!res) {
                    UIManager.getLookAndFeel().provideErrorFeedback(this.tree);
                }
                this.tree.iconManager.removeIconFor(file);
                FileSystemTree.FileSystemTreeNode parent = (FileSystemTree.FileSystemTreeNode)node.getParent();
                this.tree.refreshChildren(parent);
                ((DefaultTreeModel)this.tree.getModel()).reload(parent);
                this.tree.scrollPathToVisible(this.tree.getSelectionPath());
            }
            this.editor.removeCellEditorListener(this);
            this.editor = null;
            this.tree.setCellEditor(null);
            this.tree.setEditable(false);
            this.tree.requestFocusInWindow();
        }

        private void handleNewFileOrFolder(TreePath path, FileSystemTree.FileSystemTreeNode parentNode) {
            File root = parentNode.getFile();
            FileSystemTree.FileSystemTreeNode newChild = this.createTreeNode(root);
            this.tree.refreshChildren(parentNode);
            DefaultTreeModel model = (DefaultTreeModel)this.tree.getModel();
            model.insertNodeInto(newChild, parentNode, 0);
            this.tree.expandPath(path);
            int parentRow = this.tree.getRowForPath(path);
            int newRow = parentRow + 1;
            TreePath newChildPath = this.tree.getPathForRow(newRow);
            this.tree.setSelectionPath(newChildPath);
            this.tree.setEditable(true);
            this.editor = new FileTreeCellEditor(this.tree, (DefaultTreeCellRenderer)this.tree.getCellRenderer(), root, false);
            this.editor.addCellEditorListener(this);
            this.tree.setCellEditor(this.editor);
            this.tree.startEditingAtPath(newChildPath);
        }
    }

    private static class FileTreeCellEditor
    implements TreeCellEditor {
        private FileSystemTree tree;
        private File root;
        private DefaultTreeCellEditor delegate;

        FileTreeCellEditor(final FileSystemTree fst, DefaultTreeCellRenderer renderer, File root, final boolean dir) {
            this.tree = fst;
            this.root = root;
            this.delegate = new DefaultTreeCellEditor(this.tree, renderer){

                @Override
                protected TreeCellEditor createTreeCellEditor() {
                    TreeCellEditor editor = super.createTreeCellEditor();
                    if (editor instanceof DefaultCellEditor) {
                        DefaultCellEditor dce = (DefaultCellEditor)editor;
                        dce.getComponent().addFocusListener(new FocusAdapter(){

                            @Override
                            public void focusLost(FocusEvent e) {
                                if (!e.isTemporary()) {
                                    this.cancelCellEditing();
                                }
                            }
                        });
                    }
                    return editor;
                }

                @Override
                protected void determineOffset(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row) {
                    this.editingIcon = dir ? fst.iconManager.getFolderIcon() : fst.iconManager.fileIcon;
                    this.offset = this.editingIcon != null ? this.renderer.getIconTextGap() + this.editingIcon.getIconWidth() : this.renderer.getIconTextGap();
                }
            };
        }

        @Override
        public Component getTreeCellEditorComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row) {
            FileSystemTree.FileSystemTreeNode fstn = (FileSystemTree.FileSystemTreeNode)value;
            value = fstn.getFile().getName();
            return this.delegate.getTreeCellEditorComponent(tree, value, selected, expanded, leaf, row);
        }

        @Override
        public void addCellEditorListener(CellEditorListener l) {
            this.delegate.addCellEditorListener(l);
        }

        @Override
        public void cancelCellEditing() {
            this.delegate.cancelCellEditing();
        }

        private boolean fileAlreadyExists() {
            File temp = new File(this.root, this.delegate.getCellEditorValue().toString());
            if (temp.exists()) {
                UIManager.getLookAndFeel().provideErrorFeedback(this.tree);
                return true;
            }
            return false;
        }

        @Override
        public Object getCellEditorValue() {
            return new File(this.root, this.delegate.getCellEditorValue().toString());
        }

        @Override
        public boolean isCellEditable(EventObject e) {
            return this.delegate.isCellEditable(e);
        }

        @Override
        public void removeCellEditorListener(CellEditorListener l) {
            this.delegate.removeCellEditorListener(l);
        }

        @Override
        public boolean shouldSelectCell(EventObject e) {
            return this.delegate.shouldSelectCell(e);
        }

        @Override
        public boolean stopCellEditing() {
            if (this.fileAlreadyExists()) {
                return false;
            }
            return this.delegate.stopCellEditing();
        }
    }

    static class DeleteAction
    extends AbstractTreeAction {
        private Window window;
        private boolean hard;

        DeleteAction(Window parent, FileSystemTree tree, boolean hard) {
            super(tree);
            this.putValue("Name", this.getString("Delete"));
            this.hard = hard;
            int modifiers = hard ? 1 : 0;
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(127, modifiers));
            this.window = parent;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File[] files;
            if (this.window == null) {
                this.window = SwingUtilities.getWindowAncestor(this.tree);
            }
            if ((files = this.tree.getSelectedFiles()) == null || files.length == 0) {
                UIManager.getLookAndFeel().provideErrorFeedback(this.window);
                return;
            }
            FileIOExtras extras = FileIOExtras.getInstance();
            if (!this.hard && extras != null) {
                this.handleDeleteNative(files, extras);
            } else {
                this.handleDeleteViaJava(files);
            }
        }

        private void handleDeleteNative(File[] files, FileIOExtras extras) {
            if (extras.moveToRecycleBin(this.window, files, true, true)) {
                this.refresh();
            } else {
                UIManager.getLookAndFeel().provideErrorFeedback(this.window);
            }
        }

        private void handleDeleteViaJava(File[] files) {
            int choice;
            int count = files.length;
            if (count == 1) {
                String fileName = files[0].getName();
                choice = JOptionPane.showConfirmDialog(this.window, RTextFileChooser.MSG.getString("DeleteConfirmPrompt") + fileName + "?");
            } else {
                choice = JOptionPane.showConfirmDialog(this.window, RTextFileChooser.MSG.getString("DeleteMultipleConfirmPrompt"));
            }
            if (choice == 0) {
                for (int i = 0; i < count; ++i) {
                    if (files[i].delete()) continue;
                    Object[] arguments = new Object[]{files[i].getName()};
                    String msg = MessageFormat.format(RTextFileChooser.MSG.getString("DeleteFailText"), arguments);
                    JOptionPane.showMessageDialog(this.window, msg, RTextFileChooser.MSG.getString("Error"), 0);
                }
                this.refresh();
            }
        }

        private void refresh() {
            FileSystemTree.FileSystemTreeNode node = (FileSystemTree.FileSystemTreeNode)this.tree.getLastSelectedPathComponent();
            if (node != null) {
                FileSystemTree.FileSystemTreeNode parent = (FileSystemTree.FileSystemTreeNode)node.getParent();
                this.tree.refreshChildren(parent);
                ((DefaultTreeModel)this.tree.getModel()).reload(parent);
            }
        }
    }

    static abstract class AbstractTreeAction
    extends AbstractAction {
        protected FileSystemTree tree;
        private static ResourceBundle msg = ResourceBundle.getBundle("org.fife.ui.rtextfilechooser.FileSystemTree");

        AbstractTreeAction(FileSystemTree tree) {
            this.tree = tree;
        }

        protected String getString(String key) {
            return msg.getString(key);
        }
    }
}

