/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextfilechooser;

import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyVetoException;
import java.io.File;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.DesktopPaneUI;
import javax.swing.plaf.InternalFrameUI;
import javax.swing.plaf.basic.BasicInternalFrameUI;
import javax.swing.text.Segment;
import javax.swing.text.Utilities;
import org.fife.ui.rtextfilechooser.FileTypeInfo;
import org.fife.ui.rtextfilechooser.IconDesktopPane;
import org.fife.ui.rtextfilechooser.MouseListener;
import org.fife.ui.rtextfilechooser.RTextFileChooser;
import org.fife.ui.rtextfilechooser.RTextFileChooserView;

class IconsView
extends IconDesktopPane
implements RTextFileChooserView {
    private static final int SPACING = 10;
    private static final int DEFAULT_ICON_WIDTH = 64;
    private static final int DEFAULT_ROW_SIZE = 5;
    private RTextFileChooser chooser;
    private Color selectionForeground;
    private Color selectionBackground;
    private MouseListener mouseListener;

    IconsView(RTextFileChooser chooser) {
        this.chooser = chooser;
        this.setImportantColors();
        ComponentOrientation orientation = chooser.getComponentOrientation();
        this.applyComponentOrientation(orientation);
        this.mouseListener = new MouseListener(chooser);
        this.addMouseListener(this.mouseListener);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                IconsView.this.refresh();
            }
        });
    }

    @Override
    public void clearDisplayedFiles() {
        this.clearSelection();
        Component[] components = this.getComponents();
        int componentCount = components.length;
        for (int i = 0; i < componentCount; ++i) {
            if (!(components[i] instanceof IconInternalFrame)) continue;
            this.remove(components[i]);
        }
        if (componentCount > 0) {
            this.repaint();
        }
    }

    @Override
    public void clearSelection() {
        JInternalFrame[] frames = this.getSelectedFrames();
        if (frames == null) {
            return;
        }
        int count = frames.length;
        for (int i = 0; i < count; ++i) {
            try {
                frames[i].setSelected(false);
                continue;
            }
            catch (PropertyVetoException pve) {
                // empty catch block
            }
        }
    }

    @Override
    public void ensureFileIsVisible(File file) {
        System.err.println("Not implemented!");
    }

    @Override
    public Color getDefaultFileColor() {
        return this.getForeground();
    }

    @Override
    public int getDisplayedFileCount() {
        return this.getComponentCount();
    }

    @Override
    public File getFileAtPoint(Point p) {
        Component c = this.getComponentAt(p);
        if (c instanceof IconInternalFrame) {
            return ((IconInternalFrame)c).getFile();
        }
        return null;
    }

    @Override
    public File getSelectedFile() {
        IconInternalFrame frame = (IconInternalFrame)this.getSelectedFrame();
        if (frame != null) {
            return frame.getFile();
        }
        return null;
    }

    @Override
    public File[] getSelectedFiles() {
        JInternalFrame[] frames = this.getSelectedFrames();
        File[] files = null;
        if (frames != null) {
            int num = frames.length;
            files = new File[num];
            for (int i = 0; i < num; ++i) {
                files[i] = ((IconInternalFrame)frames[i]).getFile();
            }
            return files;
        }
        return new File[0];
    }

    public void refresh() {
        Dimension size = this.getVisibleRect().getSize();
        int defaultWidth = 370;
        int width = size.width < defaultWidth ? defaultWidth : size.width;
        int x = 10;
        int y = 10;
        JInternalFrame[] frames = this.getAllFrames();
        int num = frames == null ? 0 : frames.length;
        for (int i = 0; i < num; ++i) {
            frames[i].setLocation(x, y);
            if ((x += 74) + 64 <= width) continue;
            x = 10;
            y += frames[i].getHeight() + 10;
        }
        size.height = y + 64;
        this.setPreferredSize(size);
        this.setSize(size);
    }

    @Override
    public void removeAllListeners() {
        this.clearDisplayedFiles();
        this.removeMouseListener(this.mouseListener);
    }

    @Override
    public void selectFileAtPoint(Point p) {
        this.clearSelection();
        Component c = this.getComponentAt(p);
        if (c instanceof IconInternalFrame) {
            IconInternalFrame frame = (IconInternalFrame)c;
            this.addSelectedFrame(frame);
            try {
                frame.setSelected(true);
            }
            catch (PropertyVetoException pve) {
                // empty catch block
            }
        }
    }

    @Override
    public void setDisplayedFiles(List<File> files) {
        this.clearDisplayedFiles();
        for (File file : files) {
            FileTypeInfo info = this.chooser.getFileTypeInfoFor(file);
            Color fg = this.chooser.getShowHiddenFiles() && file.isHidden() ? this.chooser.getHiddenFileColor() : info.labelTextColor;
            IconInternalFrame frame = new IconInternalFrame(file, info.icon, fg);
            this.add(frame);
            try {
                frame.setSelected(false);
            }
            catch (PropertyVetoException pve) {}
        }
        this.refresh();
    }

    private void setImportantColors() {
        this.setForeground(new JLabel().getForeground());
        JList list = new JList();
        this.setBackground(list.getBackground());
        this.selectionForeground = list.getSelectionForeground();
        this.selectionBackground = list.getSelectionBackground();
    }

    @Override
    public void setMultiSelectionEnabled(boolean enabled) {
    }

    @Override
    public void setSelectedFiles(File[] files) {
        this.clearSelection();
        int componentCount = this.getComponentCount();
        int numToSelect = files.length;
        block0: for (int i = 0; i < numToSelect; ++i) {
            for (int j = 0; j < componentCount; ++j) {
                IconInternalFrame frame = (IconInternalFrame)this.getComponent(j);
                if (!frame.getFile().equals(files[i])) continue;
                this.addSelectedFrame(frame);
                continue block0;
            }
        }
    }

    @Override
    public void setUI(DesktopPaneUI ui) {
        super.setUI(ui);
        this.setImportantColors();
    }

    class IconInternalFrame
    extends JInternalFrame
    implements java.awt.event.MouseListener,
    MouseMotionListener {
        private static final long serialVersionUID = 1L;
        private JLabel label;
        private File file;
        private int defaultHeight;
        private Color unselectedFG;
        int _x;
        int _y;
        int __x;
        int __y;
        Rectangle startingBounds;

        IconInternalFrame(File file, Icon icon, Color fg) {
            this(file, icon, fg, 0, 0);
        }

        IconInternalFrame(File file, Icon icon, Color color, int x, int y) {
            this.file = file;
            this.unselectedFG = color;
            this.enableEvents(32L);
            this.label = new IconLabel(file.getName(), icon, 0);
            this.label.addMouseListener(this);
            this.label.addMouseMotionListener(this);
            this.label.setVerticalTextPosition(3);
            this.label.setHorizontalTextPosition(0);
            this.getContentPane().add(this.label);
            this.setBorder(null);
            this.pack();
            this.setLocation(x, y);
            this.defaultHeight = this.getPreferredSize().height;
            this.setSize(64, this.defaultHeight);
            this.setVisible(true);
        }

        public File getFile() {
            return this.file;
        }

        public String getHTMLFileName(String fileName) {
            int br = 0;
            int count = 0;
            Font font = this.getFont();
            if (font == null) {
                return "";
            }
            FontMetrics fm = this.getFontMetrics(font);
            String result = "";
            do {
                Segment s = new Segment(fileName.toCharArray(), 0, fileName.length());
                br = Utilities.getBreakLocation(s, fm, 0, this.getWidth() - 8, null, 0);
                result = result + fileName.substring(0, br);
                if ((fileName = fileName.substring(br)).length() > 0) {
                    result = result + "<br>";
                }
                ++count;
            } while (fileName.length() > 0);
            this.setSize(64, this.defaultHeight + (count - 1) * fm.getHeight());
            return result;
        }

        @Override
        public void setSelected(boolean selected) throws PropertyVetoException {
            super.setSelected(selected);
            IconsView.this.chooser.synchronizeTextFieldWithView();
            if (selected) {
                this.label.setForeground(IconsView.this.selectionForeground);
                String text = this.file.getName();
                String beginning = null;
                String ending = null;
                if (IconsView.this.chooser.isOpenedFile(this.file) && IconsView.this.chooser.getStyleOpenFiles()) {
                    beginning = "<html><body><center><u>";
                    ending = "</u></center></body></html>";
                } else {
                    beginning = "<html><body><center>";
                    ending = "</center></body></html>";
                }
                this.label.setText(beginning + this.getHTMLFileName(text) + ending);
            } else {
                this.label.setForeground(this.unselectedFG);
                String beginning = null;
                String ending = null;
                if (IconsView.this.chooser.isOpenedFile(this.file)) {
                    beginning = "";
                    ending = "";
                } else {
                    beginning = "";
                    ending = "";
                }
                this.label.setText(beginning + this.file.getName() + ending);
                this.setSize(64, this.defaultHeight);
            }
        }

        @Override
        public void setUI(InternalFrameUI ui) {
            super.setUI(new BasicInternalFrameUI(this){

                @Override
                protected MouseInputAdapter createBorderListener(JInternalFrame w) {
                    return null;
                }

                @Override
                protected void installMouseHandlers(JComponent c) {
                }
            });
            this.setRootPaneCheckingEnabled(false);
            ((BasicInternalFrameUI)this.getUI()).setNorthPane(null);
            this.setRootPaneCheckingEnabled(true);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            int modifiers = e.getModifiers();
            if ((modifiers & 0x10) == 16) {
                Point p = SwingUtilities.convertPoint(this, e.getX(), e.getY(), null);
                this.__x = e.getX();
                this.__y = e.getY();
                this._x = p.x;
                this._y = p.y;
                this.startingBounds = this.getBounds();
                if (!IconsView.this.chooser.isMultiSelectionEnabled() || (modifiers & 1) == 0 && (modifiers & 2) == 0) {
                    IconsView.this.clearSelection();
                }
                try {
                    this.setSelected(true);
                }
                catch (PropertyVetoException e1) {
                    // empty catch block
                }
                Insets i = this.getInsets();
                Point ep = new Point(this.__x, this.__y);
                if (ep.x > i.left && ep.y > i.top && ep.x < this.getWidth() - i.right) {
                    IconsView.this.getDesktopManager().beginDraggingFrame(this);
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            int modifiers = e.getModifiers();
            if ((modifiers & 0x10) != 0) {
                IconsView.this.getDesktopManager().endDraggingFrame(this);
                this._x = 0;
                this._y = 0;
                this.__x = 0;
                this.__y = 0;
                this.startingBounds = null;
            } else {
                Point p = e.getPoint();
                Component source = (Component)e.getSource();
                if (source != IconsView.this) {
                    p = SwingUtilities.convertPoint(source, p, IconsView.this);
                }
                IconsView.this.mouseListener.mouseClicked(new MouseEvent(IconsView.this, 500, e.getWhen(), e.getModifiers(), p.x, p.y, 1, e.isPopupTrigger(), e.getButton()));
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (this.startingBounds == null) {
                return;
            }
            Point p = SwingUtilities.convertPoint(this, e.getX(), e.getY(), null);
            int deltaX = this._x - p.x;
            int deltaY = this._y - p.y;
            Insets i = this.getInsets();
            if ((e.getModifiers() & 0x10) != 16) {
                return;
            }
            Dimension s = this.getParent().getSize();
            int pWidth = s.width;
            int pHeight = s.height;
            int newX = this.startingBounds.x - deltaX;
            int newY = this.startingBounds.y - deltaY;
            if (newX + i.left <= -this.__x) {
                newX = -this.__x - i.left + 1;
            }
            if (newY + i.top <= -this.__y) {
                newY = -this.__y - i.top + 1;
            }
            if (newX + this.__x + i.right >= pWidth) {
                newX = pWidth - this.__x - i.right - 1;
            }
            if (newY + this.__y + i.bottom >= pHeight) {
                newY = pHeight - this.__y - i.bottom - 1;
            }
            IconsView.this.getDesktopManager().dragFrame(this, newX, newY);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Point p = e.getPoint();
            Component source = (Component)e.getSource();
            if (source != IconsView.this) {
                p = SwingUtilities.convertPoint(source, p, IconsView.this);
            }
            IconsView.this.mouseListener.mouseClicked(new MouseEvent(IconsView.this, e.getID(), e.getWhen(), e.getModifiers(), p.x, p.y, e.getClickCount(), e.isPopupTrigger(), e.getButton()));
        }

        @Override
        public void processMouseEvent(MouseEvent e) {
            switch (e.getID()) {
                case 501: {
                    this.mousePressed(e);
                    return;
                }
                case 502: {
                    this.mouseReleased(e);
                    return;
                }
                case 500: {
                    this.mouseClicked(e);
                }
            }
        }

        @Override
        public void processMouseMotionEvent(MouseEvent e) {
            switch (e.getID()) {
                case 506: {
                    this.mouseDragged(e);
                    return;
                }
            }
        }

        @Override
        public String toString() {
            return "[IconInternalFrame: file==" + this.getFile() + "]";
        }
    }

    class IconLabel
    extends JLabel {
        private static final long serialVersionUID = 1L;

        IconLabel(String name, Icon icon, int format) {
            super(name, icon, format);
            this.setToolTipText("freaky");
        }

        @Override
        public Point getToolTipLocation(MouseEvent e) {
            Point p = e.getPoint();
            p.x += 10;
            p.y += 10;
            return p;
        }

        @Override
        public String getToolTipText(MouseEvent e) {
            String tip = null;
            MouseEvent e2 = SwingUtilities.convertMouseEvent(this, e, IconsView.this);
            Component component = IconsView.this.getComponentAt(e2.getPoint());
            if (component instanceof IconInternalFrame) {
                IconInternalFrame frame = (IconInternalFrame)component;
                File file = frame.getFile();
                if (file == null || file.isDirectory()) {
                    return null;
                }
                tip = IconsView.this.chooser.getToolTipFor(file);
            }
            return tip;
        }

        @Override
        public boolean isOpaque() {
            return true;
        }

        @Override
        public void paint(Graphics g) {
            g.setColor(IconsView.this.getBackground());
            Rectangle bounds = this.getBounds();
            IconInternalFrame frame = (IconInternalFrame)this.getParent().getParent().getParent().getParent();
            if (frame == null || !frame.isSelected()) {
                g.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
            } else {
                Icon icon = this.getIcon();
                int iconHeight = icon.getIconHeight();
                g.fillRect(0, 0, bounds.width, iconHeight);
                g.setColor(IconsView.this.selectionBackground);
                g.fillRect(0, iconHeight + 1, bounds.width, bounds.height - iconHeight);
            }
            this.getUI().paint(g, this);
        }
    }
}

