/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextfilechooser;

import java.awt.Color;
import java.awt.Component;
import java.io.File;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import org.fife.ui.UIUtil;
import org.fife.ui.rtextfilechooser.FileTypeInfo;
import org.fife.ui.rtextfilechooser.RTextFileChooser;

class ListViewCellRenderer
extends DefaultListCellRenderer {
    private RTextFileChooser chooser;

    ListViewCellRenderer(RTextFileChooser chooser) {
        this.chooser = chooser;
        this.setOpaque(true);
    }

    private Color getForegroundColor(File file, FileTypeInfo fti) {
        Color color = this.chooser.getShowHiddenFiles() && file.isHidden() ? this.chooser.getHiddenFileColor() : fti.labelTextColor;
        return color;
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        File file = (File)value;
        FileTypeInfo info = this.chooser.getFileTypeInfoFor(file);
        String fileName = file.getName();
        boolean isAlreadyOpened = this.chooser.isOpenedFile(file);
        String text = fileName;
        if (isAlreadyOpened && this.chooser.getStyleOpenFiles()) {
            if (info.labelTextColor == null) {
                text = this.chooser.addOpenFileStyleHtml(fileName);
            } else {
                Color fg = null;
                if (isSelected) {
                    fg = list.getSelectionForeground();
                } else {
                    fg = this.getForegroundColor(file, info);
                    if (fg == null) {
                        fg = list.getSelectionForeground();
                    }
                }
                String color = UIUtil.getHTMLFormatForColor(fg);
                text = "<font color=\"" + color + "\">" + fileName + "</font>";
                text = this.chooser.addOpenFileStyleHtml(text);
            }
        }
        this.setText(text);
        this.setIcon(info.icon);
        if (!isSelected) {
            this.setForeground(this.getForegroundColor(file, info));
        }
        return this;
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        if (this.getComponentOrientation().isLeftToRight()) {
            int w2 = Math.min(width, this.getPreferredSize().width + 4);
            super.setBounds(x, y, w2, height);
        } else {
            super.setBounds(x, y, width, height);
        }
    }
}

