/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextfilechooser;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import org.fife.ui.LabelValueComboBox;
import org.fife.ui.OptionsDialogPanel;
import org.fife.ui.RColorSwatchesButton;
import org.fife.ui.ResizableFrameContentPane;
import org.fife.ui.UIUtil;
import org.fife.ui.modifiabletable.AbstractRowHandler;
import org.fife.ui.modifiabletable.ModifiableTable;
import org.fife.ui.modifiabletable.ModifiableTableChangeEvent;
import org.fife.ui.modifiabletable.ModifiableTableListener;
import org.fife.ui.rtextfilechooser.FileChooserOwner;
import org.fife.ui.rtextfilechooser.RTextFileChooser;
import org.fife.ui.rtextfilechooser.SubstanceTextColorCellRenderer;
import org.fife.ui.rtextfilechooser.TextColorCellRenderer;
import org.fife.util.SubstanceUtil;

public class RTextFileChooserOptionPanel
extends OptionsDialogPanel
implements ActionListener,
ModifiableTableListener {
    private static final long serialVersionUID = 1L;
    private static final String AUTO_COMPLETE_PROPERTY = "AutoComplete";
    private static final String COLOR_CHANGED_PROPERTY = "ColorChanged";
    private static final String HIDDEN_FILES_PROPERTY = "HiddenFiles";
    private static final String OFFER_SUGGESTIONS_PROPERTY = "OfferSuggestions";
    private static final String OPEN_FILES_STYLE_PROPERTY = "OpenFilesStyle";
    private static final String STYLE_OPEN_FILES_PROPERTY = "StyleOpenFiles";
    private JCheckBox hiddenFilesCheckBox;
    private JCheckBox offerSuggestionsCB;
    private JCheckBox autoCompleteCheckBox;
    private RColorSwatchesButton hiddenColorButton;
    private ColorTableModel colorTableModel;
    private static String defaultColorString;
    private LabelValueComboBox<String, String> openFilesStyleCombo;
    private JCheckBox styleOpenFilesCheckBox;
    private static final String MAPPING_DIALOG_BUNDLE = "org.fife.ui.rtextfilechooser.ExtensionColorMappingDialog";

    public RTextFileChooserOptionPanel() {
        ComponentOrientation orientation = ComponentOrientation.getOrientation(this.getLocale());
        ResourceBundle msg = ResourceBundle.getBundle("org.fife.ui.rtextfilechooser.FileChooser");
        defaultColorString = msg.getString("DefaultColorLabel");
        this.setName(msg.getString("FileChooser"));
        this.setBorder(UIUtil.getEmpty5Border());
        this.setLayout(new BorderLayout());
        Box temp = Box.createVerticalBox();
        temp.setBorder(new OptionsDialogPanel.OptionPanelBorder(msg.getString("General")));
        this.hiddenFilesCheckBox = this.createCheckBox(msg, HIDDEN_FILES_PROPERTY);
        Box temp2 = this.createHorizontalBox();
        this.hiddenColorButton = new RColorSwatchesButton();
        temp2.add(this.hiddenFilesCheckBox);
        temp2.add(this.hiddenColorButton);
        temp2.add(Box.createHorizontalGlue());
        temp.add(temp2);
        temp2 = this.createStyleOpenFilesPanel(msg);
        temp.add(temp2);
        this.offerSuggestionsCB = this.createCheckBox(msg, OFFER_SUGGESTIONS_PROPERTY);
        this.addLeftAligned(temp, this.offerSuggestionsCB);
        this.autoCompleteCheckBox = this.createCheckBox(msg, AUTO_COMPLETE_PROPERTY);
        this.addLeftAligned(temp, this.autoCompleteCheckBox, 0, 20);
        this.add((Component)temp, "North");
        JPanel customColorsPanel = new JPanel(new BorderLayout());
        customColorsPanel.setBorder(new OptionsDialogPanel.OptionPanelBorder(msg.getString("Colors")));
        this.colorTableModel = new ColorTableModel(msg.getString("Extension"), msg.getString("Color"));
        ModifiableTable modifiableTable = new ModifiableTable(this.colorTableModel);
        modifiableTable.setRowHandler(new FileChooserRowHandler());
        modifiableTable.addModifiableTableListener(this);
        JTable colorTable = modifiableTable.getTable();
        colorTable.setPreferredScrollableViewportSize(new Dimension(300, 200));
        colorTable.getColumnModel().getColumn(1).setCellRenderer(RTextFileChooserOptionPanel.createTextColorCellRenderer());
        customColorsPanel.add(modifiableTable);
        this.add(customColorsPanel);
        this.applyComponentOrientation(orientation);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if (HIDDEN_FILES_PROPERTY.equals(actionCommand)) {
            boolean checked = this.hiddenFilesCheckBox.isSelected();
            this.hiddenColorButton.setEnabled(checked);
            this.firePropertyChange(HIDDEN_FILES_PROPERTY, !checked, checked);
        } else if (OFFER_SUGGESTIONS_PROPERTY.equals(actionCommand)) {
            boolean checked = this.offerSuggestionsCB.isSelected();
            this.autoCompleteCheckBox.setEnabled(checked);
            this.firePropertyChange(OFFER_SUGGESTIONS_PROPERTY, !checked, checked);
        } else if (AUTO_COMPLETE_PROPERTY.equals(actionCommand)) {
            boolean checked = this.autoCompleteCheckBox.isSelected();
            this.firePropertyChange(AUTO_COMPLETE_PROPERTY, !checked, checked);
        } else if (STYLE_OPEN_FILES_PROPERTY.equals(actionCommand)) {
            boolean checked = this.styleOpenFilesCheckBox.isSelected();
            this.openFilesStyleCombo.setEnabled(checked);
            this.firePropertyChange(STYLE_OPEN_FILES_PROPERTY, !checked, checked);
        } else if (OPEN_FILES_STYLE_PROPERTY.equals(actionCommand)) {
            String style = this.openFilesStyleCombo.getSelectedValue();
            this.firePropertyChange(OPEN_FILES_STYLE_PROPERTY, null, style);
        }
    }

    public void configureFileChooser(RTextFileChooser chooser) {
        chooser.setShowHiddenFiles(this.hiddenFilesCheckBox.isSelected());
        chooser.setHiddenFileColor(this.hiddenColorButton.getColor());
        chooser.setFileSystemAware(this.offerSuggestionsCB.isSelected());
        chooser.setAutoCompleteFileNames(this.autoCompleteCheckBox.isSelected());
        chooser.clearExtensionColorMap();
        chooser.setStyleOpenFiles(this.styleOpenFilesCheckBox.isSelected());
        String style = this.openFilesStyleCombo.getSelectedValue();
        chooser.setOpenFilesStyle(Integer.parseInt(style));
        int rowCount = this.colorTableModel.getRowCount();
        for (int i = 1; i < rowCount; ++i) {
            String ext = (String)this.colorTableModel.getValueAt(i, 0);
            Color color = (Color)this.colorTableModel.getValueAt(i, 1);
            chooser.setColorForExtension(ext, color);
        }
    }

    private JCheckBox createCheckBox(ResourceBundle msg, String root) {
        JCheckBox cb = new JCheckBox(msg.getString(root + "Label"));
        cb.setMnemonic((int)msg.getString(root + "Mnemonic").charAt(0));
        cb.setActionCommand(root);
        cb.addActionListener(this);
        return cb;
    }

    private Box createStyleOpenFilesPanel(ResourceBundle msg) {
        Box panel = this.createHorizontalBox();
        this.openFilesStyleCombo = new LabelValueComboBox();
        UIUtil.fixComboOrientation(this.openFilesStyleCombo);
        this.openFilesStyleCombo.addLabelValuePair(msg.getString("Underline"), "2");
        this.openFilesStyleCombo.setActionCommand(OPEN_FILES_STYLE_PROPERTY);
        this.openFilesStyleCombo.addActionListener(this);
        String text = msg.getString("StyleOpenFilesLabel");
        int pos = text.indexOf("{0}");
        if (pos == -1) {
            pos = text.length();
        }
        String beg = text.substring(0, pos);
        String end = text.substring(pos + 3);
        this.styleOpenFilesCheckBox = new JCheckBox(beg);
        this.styleOpenFilesCheckBox.setMnemonic((int)msg.getString("StyleOpenFilesMnemonic").charAt(0));
        this.styleOpenFilesCheckBox.setActionCommand(STYLE_OPEN_FILES_PROPERTY);
        this.styleOpenFilesCheckBox.addActionListener(this);
        panel.add(this.styleOpenFilesCheckBox);
        panel.add(this.openFilesStyleCombo);
        if (end.length() > 0) {
            panel.add(new JLabel(end));
        }
        panel.add(Box.createHorizontalGlue());
        return panel;
    }

    private static TableCellRenderer createTextColorCellRenderer() {
        Object renderer = SubstanceUtil.isSubstanceInstalled() ? new SubstanceTextColorCellRenderer() : new TextColorCellRenderer();
        return renderer;
    }

    @Override
    protected void doApplyImpl(Frame owner) {
        if (!(owner instanceof FileChooserOwner)) {
            throw new IllegalArgumentException("owner must be a FileChooserOwner");
        }
        FileChooserOwner fco = (FileChooserOwner)((Object)owner);
        this.configureFileChooser(fco.getFileChooser());
    }

    @Override
    protected OptionsDialogPanel.OptionsPanelCheckResult ensureValidInputsImpl() {
        return null;
    }

    @Override
    public JComponent getTopJComponent() {
        return this.hiddenFilesCheckBox;
    }

    public void initialize(RTextFileChooser chooser) {
        boolean showHiddenFiles = chooser.getShowHiddenFiles();
        this.hiddenFilesCheckBox.setSelected(showHiddenFiles);
        this.hiddenColorButton.setColor(chooser.getHiddenFileColor());
        this.hiddenColorButton.setEnabled(showHiddenFiles);
        this.styleOpenFilesCheckBox.setSelected(chooser.getStyleOpenFiles());
        this.openFilesStyleCombo.setSelectedValue("" + chooser.getOpenFilesStyle());
        this.openFilesStyleCombo.setEnabled(chooser.getStyleOpenFiles());
        this.setOfferSuggestionsSelected(chooser.getFileSystemAware());
        this.autoCompleteCheckBox.setSelected(chooser.getAutoCompleteFileNames());
        this.colorTableModel.initCustomColorTable(chooser);
    }

    @Override
    public void modifiableTableChanged(ModifiableTableChangeEvent e) {
        this.hasUnsavedChanges = true;
        this.firePropertyChange(COLOR_CHANGED_PROPERTY, null, (Object)e.getRow());
    }

    private void setOfferSuggestionsSelected(boolean selected) {
        this.offerSuggestionsCB.setSelected(selected);
        this.autoCompleteCheckBox.setEnabled(selected);
    }

    @Override
    protected void setValuesImpl(Frame owner) {
        if (!(owner instanceof FileChooserOwner)) {
            throw new IllegalArgumentException("owner must be a FileChooserOwner");
        }
        FileChooserOwner fco = (FileChooserOwner)((Object)owner);
        this.initialize(fco.getFileChooser());
    }

    class FileChooserRowHandler
    extends AbstractRowHandler {
        private ExtensionColorMappingDialog dialog;

        FileChooserRowHandler() {
        }

        @Override
        public boolean canModifyRow(int row) {
            return row > 0;
        }

        @Override
        public Object[] getNewRowInfo(Object[] oldData) {
            if (this.dialog == null) {
                this.dialog = new ExtensionColorMappingDialog(RTextFileChooserOptionPanel.this.getOptionsDialog());
            }
            if (oldData == null) {
                this.dialog.setData(null, null);
            } else {
                this.dialog.setData((String)oldData[0], (Color)oldData[1]);
            }
            int rc = this.dialog.showMappingDialog();
            if (rc == 0) {
                return new Object[]{this.dialog.getExtension(), this.dialog.getColor()};
            }
            return null;
        }

        @Override
        public void updateUI() {
            if (this.dialog != null) {
                SwingUtilities.updateComponentTreeUI(this.dialog);
            }
        }
    }

    static class ExtensionColorMappingDialog
    extends JDialog
    implements ActionListener,
    ChangeListener,
    DocumentListener {
        static final int OK = 0;
        static final int CANCEL = 1;
        private JTextField extensionField;
        private JColorChooser colorChooser;
        private JButton okButton;
        private JButton cancelButton;
        private int rc;

        ExtensionColorMappingDialog(JDialog owner) {
            super(owner);
            ComponentOrientation orientation = ComponentOrientation.getOrientation(this.getLocale());
            ResourceBundle msg = ResourceBundle.getBundle(RTextFileChooserOptionPanel.MAPPING_DIALOG_BUNDLE);
            ResizableFrameContentPane contentPane = new ResizableFrameContentPane(new BorderLayout());
            contentPane.setBorder(UIUtil.getEmpty5Border());
            Box topPanel = Box.createVerticalBox();
            JPanel temp = new JPanel(new BorderLayout());
            temp.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
            JLabel label = UIUtil.newLabel(msg, "Extension");
            JPanel temp2 = new JPanel(new BorderLayout());
            temp2.add(label);
            if (orientation.isLeftToRight()) {
                temp2.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
            } else {
                temp2.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            }
            temp.add((Component)temp2, "Before");
            this.extensionField = new JTextField();
            this.extensionField.getDocument().addDocumentListener(this);
            label.setLabelFor(this.extensionField);
            temp.add(this.extensionField);
            topPanel.add(temp);
            this.colorChooser = new JColorChooser();
            this.colorChooser.getSelectionModel().addChangeListener(this);
            topPanel.add(this.colorChooser);
            contentPane.add((Component)topPanel, "North");
            this.okButton = UIUtil.newButton(msg, "OK.Text", "OK.Mnemonic");
            this.okButton.addActionListener(this);
            this.cancelButton = UIUtil.newButton(msg, "Cancel.Text", "Cancel.Mnemonic");
            this.cancelButton.addActionListener(this);
            Container buttons = UIUtil.createButtonFooter(this.okButton, this.cancelButton);
            contentPane.add((Component)buttons, "South");
            this.setTitle(msg.getString("Title"));
            this.setContentPane(contentPane);
            this.getRootPane().setDefaultButton(this.okButton);
            this.setModal(true);
            this.applyComponentOrientation(orientation);
            this.pack();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == this.okButton) {
                this.rc = 0;
            }
            this.setVisible(false);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }

        public Color getColor() {
            return this.colorChooser.getColor();
        }

        public String getExtension() {
            return this.extensionField.getText();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.okButton.setEnabled(true);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.okButton.setEnabled(this.extensionField.getDocument().getLength() > 0);
        }

        public void setData(String extension, Color color) {
            this.extensionField.setText(extension);
            this.colorChooser.setColor(color);
        }

        @Override
        public void setVisible(boolean visible) {
            if (visible) {
                String extension = this.extensionField.getText();
                this.extensionField.setEnabled(!extension.equals(defaultColorString));
            }
            super.setVisible(visible);
        }

        public int showMappingDialog() {
            this.rc = 1;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ExtensionColorMappingDialog.this.extensionField.requestFocusInWindow();
                    ExtensionColorMappingDialog.this.extensionField.selectAll();
                }
            });
            this.setLocationRelativeTo(this.getOwner());
            this.okButton.setEnabled(false);
            this.setVisible(true);
            return this.rc;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.okButton.setEnabled(this.extensionField.getDocument().getLength() > 0);
        }
    }

    private static class ColorTableModel
    extends DefaultTableModel {
        private static final long serialVersionUID = 1L;

        ColorTableModel(String extensionHeader, String colorHeader) {
            super(new Object[]{extensionHeader, colorHeader}, 0);
        }

        void initCustomColorTable(RTextFileChooser chooser) {
            this.setRowCount(0);
            Vector<Object> v = new Vector<Object>(2);
            v.add(defaultColorString);
            v.add(chooser.getDefaultFileColor());
            this.addRow(v);
            Map<String, Color> map = chooser.getCustomColorsMap();
            Set<String> keySet = map.keySet();
            if (keySet != null) {
                for (String extension : keySet) {
                    v = new Vector(2);
                    v.add(extension);
                    v.add(map.get(extension));
                    this.addRow(v);
                }
            }
        }
    }
}

