/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextfilechooser;

import java.io.File;
import java.util.regex.Pattern;
import javax.swing.filechooser.FileFilter;

class WildcardFileFilter
extends FileFilter {
    private Pattern pattern;

    WildcardFileFilter() {
    }

    public void setPattern(String globPattern) {
        char[] gPat = globPattern.toCharArray();
        int gpatLength = gPat.length;
        char[] rPat = new char[gpatLength * 2];
        boolean isWin32 = File.separatorChar == '\\';
        boolean inBrackets = false;
        int j = 0;
        if (isWin32) {
            int len = gpatLength;
            if (globPattern.endsWith("*.*")) {
                len -= 2;
            }
            block15: for (int i = 0; i < len; ++i) {
                switch (gPat[i]) {
                    case '*': {
                        rPat[j++] = 46;
                        rPat[j++] = 42;
                        continue block15;
                    }
                    case '\\': {
                        rPat[j++] = 92;
                        rPat[j++] = 92;
                        continue block15;
                    }
                    default: {
                        if ("+()^$.{}[]".indexOf(gPat[i]) >= 0) {
                            rPat[j++] = 92;
                        }
                        rPat[j++] = gPat[i];
                    }
                }
            }
        } else {
            block16: for (int i = 0; i < gpatLength; ++i) {
                switch (gPat[i]) {
                    case '*': {
                        if (!inBrackets) {
                            rPat[j++] = 46;
                        }
                        rPat[j++] = 42;
                        continue block16;
                    }
                    case '?': {
                        rPat[j++] = inBrackets ? 63 : 46;
                        continue block16;
                    }
                    case '[': {
                        inBrackets = true;
                        rPat[j++] = gPat[i];
                        if (i >= gpatLength - 1) continue block16;
                        switch (gPat[i + 1]) {
                            case '!': 
                            case '^': {
                                rPat[j++] = 94;
                                ++i;
                                break;
                            }
                            case ']': {
                                rPat[j++] = gPat[++i];
                            }
                        }
                        continue block16;
                    }
                    case ']': {
                        rPat[j++] = gPat[i];
                        inBrackets = false;
                        continue block16;
                    }
                    case '\\': {
                        if (i == 0 && gpatLength > 1 && gPat[1] == '~') {
                            rPat[j++] = gPat[++i];
                            continue block16;
                        }
                        rPat[j++] = 92;
                        if (i < gPat.length - 1 && "*?[]".indexOf(gPat[i + 1]) >= 0) {
                            rPat[j++] = gPat[++i];
                            continue block16;
                        }
                        rPat[j++] = 92;
                        continue block16;
                    }
                    default: {
                        if (!Character.isLetterOrDigit(gPat[i])) {
                            rPat[j++] = 92;
                        }
                        rPat[j++] = gPat[i];
                    }
                }
            }
        }
        this.pattern = Pattern.compile(new String(rPat, 0, j), 2);
    }

    @Override
    public boolean accept(File f) {
        if (f == null) {
            return false;
        }
        if (f.isDirectory()) {
            return true;
        }
        return this.pattern.matcher(f.getName()).matches();
    }

    @Override
    public String getDescription() {
        return "You never see me!";
    }
}

