/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextfilechooser.extras;

import java.awt.Window;
import java.io.File;
import org.fife.ui.rtextfilechooser.extras.Win32FileIOExtras;
import org.fife.ui.rtextfilechooser.extras.x64FileIOExtras;

public abstract class FileIOExtras {
    private static FileIOExtras instance;
    private static boolean loaded;

    protected FileIOExtras() {
    }

    public static synchronized FileIOExtras getInstance() {
        if (!loaded) {
            loaded = true;
            String os = System.getProperty("os.name");
            if (os.toLowerCase().contains("windows")) {
                String arch = System.getProperty("os.arch");
                try {
                    if ("x86".equals(arch)) {
                        instance = new Win32FileIOExtras();
                    } else if ("amd64".equals(arch)) {
                        instance = new x64FileIOExtras();
                    }
                }
                catch (UnsatisfiedLinkError ule) {
                    instance = null;
                }
            }
        }
        return instance;
    }

    public boolean moveToRecycleBin(Window parent, File[] files, boolean confirmation, boolean silent) {
        if (files == null || files.length == 0) {
            return true;
        }
        String[] fileNames = new String[files.length];
        for (int i = 0; i < files.length; ++i) {
            fileNames[i] = files[i].getAbsolutePath();
        }
        return this.moveToRecycleBin(parent, fileNames, confirmation, silent);
    }

    public abstract boolean moveToRecycleBin(Window var1, String[] var2, boolean var3, boolean var4);

    public boolean showFilePropertiesDialog(Window parent, File file) {
        return this.showFilePropertiesDialog(parent, file.getAbsolutePath());
    }

    public abstract boolean showFilePropertiesDialog(Window var1, String var2);

    public static void main(String[] args) {
        FileIOExtras extras;
        if (args.length == 0) {
            System.err.println("Usage: FileIOExtras <absolute-fileName>");
            System.exit(1);
        }
        if ((extras = FileIOExtras.getInstance()) != null) {
            boolean success = extras.moveToRecycleBin(null, args, true, true);
            System.out.println("Success: " + success);
        } else {
            System.out.println("Extras not supported or dll not found");
        }
    }
}

