/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextfilechooser.extras;

import java.awt.Component;
import java.awt.Window;
import java.lang.reflect.Field;
import org.fife.ui.rtextfilechooser.extras.FileIOExtras;

class Win32FileIOExtras
extends FileIOExtras {
    Win32FileIOExtras() {
        this.loadNativeLibrary();
    }

    public static long getHwnd(Component c) {
        long hwnd = 0L;
        try {
            Class<?> clazz = Class.forName("sun.awt.windows.WComponentPeer");
            Field hwndField = clazz.getDeclaredField("hwnd");
            hwndField.setAccessible(true);
            Object val = hwndField.get(c.getPeer());
            if (val instanceof Long) {
                hwnd = (Long)val;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return hwnd;
    }

    protected void loadNativeLibrary() {
        System.loadLibrary("Win32FileIOExtras");
    }

    @Override
    public boolean moveToRecycleBin(Window parent, String[] files, boolean confirmation, boolean silent) {
        long hwnd = parent != null ? Win32FileIOExtras.getHwnd(parent) : 0L;
        return this.moveToRecycleBinImpl(hwnd, files, confirmation, silent);
    }

    protected native boolean moveToRecycleBinImpl(long var1, String[] var3, boolean var4, boolean var5);

    @Override
    public boolean showFilePropertiesDialog(Window parent, String file) {
        long hwnd = parent != null ? Win32FileIOExtras.getHwnd(parent) : 0L;
        return this.showFilePropertiesDialogImpl(hwnd, file);
    }

    protected native boolean showFilePropertiesDialogImpl(long var1, String var3);
}

