/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextfilechooser.filters;

import java.io.File;
import javax.swing.filechooser.FileFilter;
import org.fife.ui.OS;
import org.fife.ui.rtextfilechooser.Utilities;

public class ExtensionFileFilter
extends FileFilter {
    private String description;
    private String[] extensions;
    private boolean caseCheck;

    public ExtensionFileFilter(String description, String extension) {
        this(description, CaseCheck.SYSTEM_CASE_CHECK, extension);
    }

    public ExtensionFileFilter(String description, String ... extensions) {
        this(description, CaseCheck.SYSTEM_CASE_CHECK, extensions);
    }

    public ExtensionFileFilter(String description, CaseCheck caseCheck, String extension) {
        this(description, caseCheck, true, extension);
    }

    public ExtensionFileFilter(String description, CaseCheck caseCheck, String ... extensions) {
        this(description, caseCheck, true, extensions);
    }

    public ExtensionFileFilter(String description, CaseCheck caseCheck, boolean showExtensions, String extension) {
        this.extensions = new String[1];
        this.caseCheck = ExtensionFileFilter.doCaseCheck(caseCheck);
        this.extensions[0] = this.caseCheck ? extension : extension.toLowerCase();
        StringBuilder buf = new StringBuilder(description);
        if (showExtensions) {
            buf.append(" (*.").append(this.extensions[0]).append(")");
        }
        this.description = buf.toString();
    }

    public ExtensionFileFilter(String description, CaseCheck caseCheck, boolean showExtensions, String ... extensions) {
        int extCount = extensions == null ? 0 : extensions.length;
        this.extensions = new String[extCount];
        this.caseCheck = ExtensionFileFilter.doCaseCheck(caseCheck);
        if (this.caseCheck) {
            System.arraycopy(extensions, 0, this.extensions, 0, extCount);
        } else {
            for (int i = 0; i < extCount; ++i) {
                this.extensions[i] = extensions[i].toLowerCase();
            }
        }
        StringBuilder buf = new StringBuilder(description);
        if (showExtensions && extCount > 0) {
            buf.append(" (");
            for (int i = 0; i < extCount - 1; ++i) {
                buf.append("*.").append(extensions[i]).append(", ");
            }
            buf.append("*.").append(extensions[extCount - 1]).append(")");
        }
        this.description = buf.toString();
    }

    @Override
    public boolean accept(File f) {
        if (f.isDirectory()) {
            return true;
        }
        String extension = Utilities.getExtension(f.getName());
        if (extension == null) {
            return false;
        }
        if (this.caseCheck) {
            extension = extension.toLowerCase();
        }
        int extensionCount = this.extensions.length;
        for (int i = 0; i < extensionCount; ++i) {
            if (!this.extensions[i].equals(extension)) continue;
            return true;
        }
        return false;
    }

    private static boolean doCaseCheck(CaseCheck requestedCheck) {
        switch (requestedCheck) {
            case CASE_CHECK: {
                return true;
            }
            case NO_CASE_CHECK: {
                return false;
            }
        }
        return OS.get().isCaseSensitive();
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return this.getDescription();
    }

    public static enum CaseCheck {
        SYSTEM_CASE_CHECK,
        CASE_CHECK,
        NO_CASE_CHECK;

    }
}

