/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextfilechooser.filters;

import java.io.File;
import java.util.ResourceBundle;
import javax.swing.filechooser.FileFilter;
import org.fife.ui.rtextfilechooser.Utilities;

public class ImageFileFilter
extends FileFilter {
    private String description;
    private static final String MSG = "org.fife.ui.rtextfilechooser.filters.ImageFileFilter";

    public ImageFileFilter() {
        ResourceBundle msg = ResourceBundle.getBundle(MSG);
        this.description = msg.getString("Desc");
    }

    @Override
    public boolean accept(File f) {
        if (f.isDirectory()) {
            return true;
        }
        String extension = Utilities.getExtension(f.getName());
        if (extension != null) {
            extension = extension.toLowerCase();
        }
        return ImageFileFilter.isValidExtension(extension);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    private static boolean isValidExtension(String ext) {
        return ext != null && ("gif".equals(ext) || "jpg".equals(ext) || "png".equals(ext) || "bmp".equals(ext));
    }

    public String toString() {
        return this.getDescription();
    }
}

