/*
 * Decompiled with CFR 0.152.
 */
package org.fife.util;

import java.awt.Window;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.fife.util.TranslucencyUtil;

class Java6TranslucencyUtil
extends TranslucencyUtil {
    private static final String CLASS_NAME = "com.sun.awt.AWTUtilities";

    Java6TranslucencyUtil() {
    }

    @Override
    public float getOpacity(Window w) {
        float opacity = 1.0f;
        if (this.isTranslucencySupported(false)) {
            try {
                Class<?> clazz = Class.forName(CLASS_NAME);
                Method m = clazz.getDeclaredMethod("getWindowOpacity", Window.class);
                opacity = ((Float)m.invoke(null, w)).floatValue();
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return opacity;
    }

    @Override
    public boolean isTranslucencySupported(boolean perPixel) {
        String fieldName = perPixel ? "PERPIXEL_TRANSLUCENT" : "TRANSLUCENT";
        boolean supported = false;
        try {
            Field transField = null;
            Class<?> enumClazz = Class.forName("com.sun.awt.AWTUtilities$Translucency");
            Field[] fields = enumClazz.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                if (!fieldName.equals(fields[i].getName())) continue;
                transField = fields[i];
                break;
            }
            if (transField != null) {
                Class<?> awtUtilClazz = Class.forName(CLASS_NAME);
                Method m = awtUtilClazz.getDeclaredMethod("isTranslucencySupported", enumClazz);
                Boolean res = (Boolean)m.invoke(null, transField.get(null));
                supported = res;
            }
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            e.printStackTrace();
            supported = false;
        }
        return supported;
    }

    @Override
    public boolean setOpacity(Window w, float value) {
        if (!this.isTranslucencySupported(false)) {
            return false;
        }
        boolean supported = true;
        try {
            Class<?> clazz = Class.forName(CLASS_NAME);
            Method m = clazz.getDeclaredMethod("setWindowOpacity", Window.class, Float.TYPE);
            m.invoke(null, w, new Float(value));
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            supported = false;
        }
        return supported;
    }

    @Override
    public boolean setOpaque(Window w, boolean opaque) {
        if (!opaque && !this.isTranslucencySupported(true)) {
            return false;
        }
        try {
            Class<?> clazz = Class.forName(CLASS_NAME);
            Method m = clazz.getDeclaredMethod("setWindowOpaque", Window.class, Boolean.TYPE);
            m.invoke(null, w, new Boolean(opaque));
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

