/*
 * Decompiled with CFR 0.152.
 */
package org.fife.util;

import java.awt.Color;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Window;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.fife.util.TranslucencyUtil;

class Java7TranslucencyUtil
extends TranslucencyUtil {
    Java7TranslucencyUtil() {
    }

    @Override
    public float getOpacity(Window w) {
        float opacity = 1.0f;
        if (this.isTranslucencySupported(false)) {
            try {
                Method m = Window.class.getMethod("getOpacity", new Class[0]);
                opacity = ((Float)m.invoke((Object)w, new Object[0])).floatValue();
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return opacity;
    }

    @Override
    public boolean isTranslucencySupported(boolean perPixel) {
        String fieldName = perPixel ? "PERPIXEL_TRANSLUCENT" : "TRANSLUCENT";
        boolean supported = false;
        try {
            Field transField = null;
            Class<?> enumClazz = Class.forName("java.awt.GraphicsDevice$WindowTranslucency");
            Field[] fields = enumClazz.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                if (!fieldName.equals(fields[i].getName())) continue;
                transField = fields[i];
                break;
            }
            if (transField != null) {
                GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
                GraphicsDevice device = env.getDefaultScreenDevice();
                Class<?> deviceClazz = device.getClass();
                Method m = deviceClazz.getMethod("isWindowTranslucencySupported", enumClazz);
                Boolean res = (Boolean)m.invoke((Object)device, transField.get(null));
                supported = res;
            }
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            e.printStackTrace();
            supported = false;
        }
        return supported;
    }

    @Override
    public boolean setOpacity(Window w, float value) {
        if (!this.isTranslucencySupported(false)) {
            return false;
        }
        boolean supported = true;
        try {
            Method m = Window.class.getMethod("setOpacity", Float.TYPE);
            m.invoke((Object)w, new Float(value));
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            supported = false;
        }
        return supported;
    }

    @Override
    public boolean setOpaque(Window w, boolean opaque) {
        if (!opaque && !this.isTranslucencySupported(true)) {
            return false;
        }
        if (opaque) {
            w.setBackground(Color.white);
        } else {
            w.setBackground(new Color(0, 0, 0, 0));
        }
        return true;
    }
}

