/*
 * Decompiled with CFR 0.152.
 */
package org.fife.util;

import java.awt.Color;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;

public final class SubstanceUtil {
    public static final String FOREGROUND_COLOR = "ForegroundColor";
    public static final String ULTRA_LIGHT_COLOR = "UltraLightColor";
    public static final String EXTRA_LIGHT_COLOR = "ExtraLightColor";
    public static final String LIGHT_COLOR = "LightColor";
    public static final String MID_COLOR = "MidColor";
    public static final String DARK_COLOR = "DarkColor";
    public static final String ULTRA_DARK_COLOR = "UltraDarkColor";
    public static final String LINE_COLOR = "LineColor";
    public static final String SELECTION_BG_COLOR = "SelectionBackgroundColor";
    public static final String SELECTION_FG_COLOR = "SelectionForegroundColor";
    public static final String BACKGROUND_FILL_COLOR = "BackgroundFillColor";
    public static final String TEXT_BG_FILL_COLOR = "TextBackgroundFillColor";
    public static final String FOCUS_RING_COLOR = "FocusRingColor";
    private static final String PKG = "org.pushingpixels.substance.api.";
    private static final String LAFWIDGET_PKG = "org.pushingpixels.lafwidget.";

    private SubstanceUtil() {
    }

    public static long getAnimationSpeed() throws Exception {
        long speed = -1L;
        ClassLoader cl = (ClassLoader)UIManager.get("ClassLoader");
        if (cl != null) {
            String managerClassName = "org.pushingpixels.lafwidget.animation.AnimationConfigurationManager";
            Class<?> managerClazz = Class.forName(managerClassName, true, cl);
            Method m = managerClazz.getMethod("getInstance", new Class[0]);
            Object manager = m.invoke(null, new Object[0]);
            m = managerClazz.getMethod("getTimelineDuration", new Class[0]);
            Long millis = (Long)m.invoke(manager, new Object[0]);
            speed = millis;
        }
        return speed;
    }

    public static Color getSubstanceColor(String name) throws Exception {
        Class<?> clazz;
        Color color = null;
        name = Character.toUpperCase(name.charAt(0)) + name.substring(1);
        LookAndFeel laf = UIManager.getLookAndFeel();
        ClassLoader cl = (ClassLoader)UIManager.get("ClassLoader");
        if (cl != null && (clazz = Class.forName("org.pushingpixels.substance.api.SubstanceLookAndFeel", true, cl)).isInstance(laf)) {
            Class<?> skinClazz = Class.forName("org.pushingpixels.substance.api.SubstanceSkin", true, cl);
            Method m = clazz.getDeclaredMethod("getCurrentSkin", new Class[0]);
            Object skin = m.invoke(null, new Object[0]);
            Class<?> decAreaTypeClazz = Class.forName("org.pushingpixels.substance.api.DecorationAreaType", true, cl);
            Field decAreaTypeField = decAreaTypeClazz.getDeclaredField("GENERAL");
            Object decAreaType = decAreaTypeField.get(null);
            m = skinClazz.getDeclaredMethod("getActiveColorScheme", decAreaTypeClazz);
            Object colorScheme = m.invoke(skin, decAreaType);
            Class<?> colorSchemeClazz = Class.forName("org.pushingpixels.substance.api.SubstanceColorScheme", true, cl);
            m = colorSchemeClazz.getMethod("get" + name, new Class[0]);
            color = (Color)m.invoke(colorScheme, new Object[0]);
        }
        return color;
    }

    public static boolean isSubstanceInstalled() {
        return SubstanceUtil.isASubstanceLookAndFeel(UIManager.getLookAndFeel());
    }

    public static boolean isASubstanceLookAndFeel(LookAndFeel laf) {
        return SubstanceUtil.isASubstanceLookAndFeel(laf.getClass().getName());
    }

    public static boolean isASubstanceLookAndFeel(String lafName) {
        return lafName.contains(".Substance");
    }

    public static void setAnimationSpeed(long millis) throws Exception {
        ClassLoader cl = (ClassLoader)UIManager.get("ClassLoader");
        if (cl != null) {
            String managerClassName = "org.pushingpixels.lafwidget.animation.AnimationConfigurationManager";
            Class<?> managerClazz = Class.forName(managerClassName, true, cl);
            Method m = managerClazz.getMethod("getInstance", new Class[0]);
            Object manager = m.invoke(null, new Object[0]);
            m = managerClazz.getMethod("setTimelineDuration", Long.TYPE);
            m.invoke(manager, new Long(millis));
        }
    }
}

