/*
 * Decompiled with CFR 0.152.
 */
package org.fife.com.swabunga.spell.engine;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.fife.com.swabunga.spell.engine.SpellDictionaryASpell;

public class GenericSpellDictionary
extends SpellDictionaryASpell {
    private static final int INITIAL_CAPACITY = 16384;
    protected HashMap<String, LinkedList<String>> mainDictionary = new HashMap(16384);
    private File dictFile = null;

    public GenericSpellDictionary(File wordList) throws FileNotFoundException, IOException {
        this(wordList, (File)null);
    }

    public GenericSpellDictionary(File wordList, File phonetic) throws FileNotFoundException, IOException {
        super(phonetic);
        this.dictFile = wordList;
        this.createDictionary(new BufferedReader(new FileReader(wordList)));
    }

    @Override
    public boolean addWord(String word) {
        this.putWord(word);
        if (this.dictFile != null) {
            try {
                FileWriter w = new FileWriter(this.dictFile.toString(), true);
                w.write(word);
                w.write("\n");
                w.close();
            }
            catch (IOException ex) {
                System.out.println("Error writing to dictionary file");
                ex.printStackTrace();
                return false;
            }
        }
        return true;
    }

    protected void createDictionary(BufferedReader in) throws IOException {
        String line = "";
        while (line != null) {
            line = in.readLine();
            if (line == null) continue;
            line = new String(line.toCharArray());
            this.putWord(line);
        }
    }

    protected void putWord(String word) {
        String code = this.getCode(word);
        LinkedList<String> list = this.mainDictionary.get(code);
        if (list != null) {
            list.add(word);
        } else {
            list = new LinkedList();
            list.add(word);
            this.mainDictionary.put(code, list);
        }
    }

    @Override
    public List<String> getWords(String code) {
        List mainDictResult = this.mainDictionary.get(code);
        if (mainDictResult == null) {
            return new Vector<String>();
        }
        return mainDictResult;
    }

    @Override
    public boolean isCorrect(String word) {
        List<String> possible = this.getWords(this.getCode(word));
        if (possible.contains(word)) {
            return true;
        }
        return possible.contains(word.toLowerCase());
    }
}

