/*
 * Decompiled with CFR 0.152.
 */
package org.fife.com.swabunga.spell.engine;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import org.fife.com.swabunga.spell.engine.SpellDictionaryASpell;

public class SpellDictionaryHashMap
extends SpellDictionaryASpell {
    private static final int INITIAL_CAPACITY = 16384;
    protected Hashtable<String, List<String>> mainDictionary = new Hashtable(16384);
    private File dictFile = null;

    public SpellDictionaryHashMap() throws IOException {
        super((File)null);
    }

    public SpellDictionaryHashMap(Reader wordList) throws IOException {
        super((File)null);
        this.createDictionary(new BufferedReader(wordList));
    }

    public SpellDictionaryHashMap(File wordList) throws FileNotFoundException, IOException {
        this(new FileReader(wordList));
        this.dictFile = wordList;
    }

    public SpellDictionaryHashMap(File wordList, File phonetic) throws FileNotFoundException, IOException {
        super(phonetic);
        this.dictFile = wordList;
        this.createDictionary(new BufferedReader(new FileReader(wordList)));
    }

    public SpellDictionaryHashMap(File wordList, File phonetic, String phoneticEncoding) throws FileNotFoundException, IOException {
        super(phonetic, phoneticEncoding);
        this.dictFile = wordList;
        this.createDictionary(new BufferedReader(new FileReader(wordList)));
    }

    public SpellDictionaryHashMap(Reader wordList, Reader phonetic) throws IOException {
        super(phonetic);
        this.dictFile = null;
        this.createDictionary(new BufferedReader(wordList));
    }

    public void addDictionary(File wordList) throws FileNotFoundException, IOException {
        this.addDictionaryHelper(new BufferedReader(new FileReader(wordList)));
    }

    public void addDictionary(Reader wordList) throws IOException {
        this.addDictionaryHelper(new BufferedReader(wordList));
    }

    @Override
    public boolean addWord(String word) {
        this.putWord(word);
        if (this.dictFile != null) {
            try {
                BufferedWriter w = new BufferedWriter(new FileWriter(this.dictFile, true));
                w.write(word);
                w.write("\n");
                w.close();
                return true;
            }
            catch (IOException ex) {
                System.out.println("Error writing to dictionary file");
                ex.printStackTrace();
            }
        }
        return false;
    }

    protected void createDictionary(BufferedReader in) throws IOException {
        String line;
        while ((line = in.readLine()) != null) {
            if (line.length() <= 0) continue;
            this.putWord(line);
        }
    }

    protected void addDictionaryHelper(BufferedReader in) throws IOException {
        String line;
        while ((line = in.readLine()) != null) {
            if (line.length() <= 0) continue;
            this.putWordUnique(line);
        }
    }

    protected void putWord(String word) {
        String code = this.getCode(word);
        List<String> list = this.mainDictionary.get(code);
        if (list == null) {
            list = new ArrayList<String>();
            this.mainDictionary.put(code, list);
        }
        list.add(word);
    }

    protected void putWordUnique(String word) {
        String code = this.getCode(word);
        List<String> list = this.mainDictionary.get(code);
        if (list != null) {
            boolean isAlready = false;
            for (int i = 0; i < list.size(); ++i) {
                if (!word.equalsIgnoreCase(list.get(i))) continue;
                isAlready = true;
                break;
            }
            if (!isAlready) {
                list.add(word);
            }
        } else {
            list = new ArrayList<String>();
            list.add(word);
            this.mainDictionary.put(code, list);
        }
    }

    @Override
    public List<String> getWords(String code) {
        List<String> mainDictResult = this.mainDictionary.get(code);
        if (mainDictResult == null) {
            return Collections.emptyList();
        }
        return mainDictResult;
    }

    @Override
    public boolean isCorrect(String word) {
        List<String> possible = this.getWords(this.getCode(word));
        if (possible.contains(word)) {
            return true;
        }
        return possible.contains(word.toLowerCase());
    }
}

