/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea.spell.demo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.fife.ui.rsyntaxtextarea.ErrorStrip;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.SyntaxConstants;
import org.fife.ui.rsyntaxtextarea.parser.Parser;
import org.fife.ui.rsyntaxtextarea.spell.SpellingParser;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;

public class DemoRootPane
extends JRootPane
implements HyperlinkListener,
SyntaxConstants {
    private RTextScrollPane scrollPane;
    private RSyntaxTextArea textArea = this.createTextArea();
    private SpellingParser parser;
    private ToggleSpellCheckingAction toggleAction;
    private static final String INPUT_FILE = "Input.java";

    public DemoRootPane() {
        this.scrollPane = new RTextScrollPane((RTextArea)this.textArea, true);
        ErrorStrip es = new ErrorStrip(this.textArea);
        JPanel temp = new JPanel(new BorderLayout());
        temp.add((Component)this.scrollPane);
        temp.add((Component)es, "After");
        this.getContentPane().add(temp);
        this.setJMenuBar(this.createMenuBar());
    }

    @Override
    public void addNotify() {
        super.addNotify();
        new Thread(){

            @Override
            public void run() {
                DemoRootPane.this.parser = DemoRootPane.this.createSpellingParser();
                if (DemoRootPane.this.parser != null) {
                    try {
                        File userDict = File.createTempFile("spellDemo", ".txt");
                        DemoRootPane.this.parser.setUserDictionary(userDict);
                        System.out.println("User dictionary: " + userDict.getAbsolutePath());
                    }
                    catch (IOException ioe) {
                        System.err.println("Can't open user dictionary: " + ioe.getMessage());
                    }
                    catch (SecurityException se) {
                        System.err.println("Can't open user dictionary: " + se.getMessage());
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            DemoRootPane.this.textArea.addParser((Parser)DemoRootPane.this.parser);
                            DemoRootPane.this.toggleAction.setEnabled(true);
                        }
                    });
                }
            }
        }.start();
    }

    private JMenuBar createMenuBar() {
        JMenuBar mb = new JMenuBar();
        JMenu menu = new JMenu("Options");
        this.toggleAction = new ToggleSpellCheckingAction();
        this.toggleAction.setEnabled(false);
        JCheckBoxMenuItem cbItem = new JCheckBoxMenuItem(this.toggleAction);
        cbItem.setSelected(true);
        menu.add(cbItem);
        menu.addSeparator();
        JMenuItem item = new JMenuItem(new AboutAction());
        menu.add(item);
        mb.add(menu);
        return mb;
    }

    private SpellingParser createSpellingParser() {
        File zip = new File("src/main/dist/english_dic.zip");
        try {
            return SpellingParser.createEnglishSpellingParser(zip, true);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return null;
        }
    }

    private RSyntaxTextArea createTextArea() {
        RSyntaxTextArea textArea = new RSyntaxTextArea(25, 70);
        textArea.setSyntaxEditingStyle("text/java");
        ClassLoader cl = this.getClass().getClassLoader();
        InputStream in = cl.getResourceAsStream(INPUT_FILE);
        try {
            BufferedReader r = null;
            r = in != null ? new BufferedReader(new InputStreamReader(in)) : new BufferedReader(new FileReader(INPUT_FILE));
            textArea.read((Reader)r, null);
            r.close();
        }
        catch (IOException ioe) {
            textArea.setText("// Type Java source.  Comments are spell checked.");
        }
        textArea.setCaretPosition(0);
        textArea.discardAllEdits();
        textArea.addHyperlinkListener((HyperlinkListener)this);
        textArea.requestFocusInWindow();
        textArea.setMarkOccurrences(true);
        return textArea;
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            URL url = e.getURL();
            if (url == null) {
                UIManager.getLookAndFeel().provideErrorFeedback(null);
            } else {
                JOptionPane.showMessageDialog(this, "URL clicked:\n" + url.toString());
            }
        }
    }

    private class ToggleSpellCheckingAction
    extends AbstractAction {
        private boolean enabled;

        public ToggleSpellCheckingAction() {
            this.putValue("Name", "Toggle Spell Checking");
            this.enabled = true;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean bl = this.enabled = !this.enabled;
            if (this.enabled) {
                DemoRootPane.this.textArea.addParser((Parser)DemoRootPane.this.parser);
            } else {
                DemoRootPane.this.textArea.removeParser((Parser)DemoRootPane.this.parser);
            }
        }
    }

    private class AboutAction
    extends AbstractAction {
        public AboutAction() {
            this.putValue("Name", "About Spell Checker...");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JOptionPane.showMessageDialog(DemoRootPane.this, "<html><b>Spell Checker</b> - An add-on for RSyntaxTextArea<br>that does spell checking in code comments.<br>Version 2.5.4<br>Licensed under the LGPL", "About Spell Checker", 1);
        }
    }
}

