/*
 * Decompiled with CFR 0.152.
 */
package org.fife.com.swabunga.spell.engine;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Vector;
import org.fife.com.swabunga.spell.engine.Transformator;
import org.fife.com.swabunga.util.StringUtility;

public class GenericTransformator
implements Transformator {
    private static final char[] defaultEnglishAlphabet = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
    public static final char ALPHABET_START = '[';
    public static final char ALPHABET_END = ']';
    public static final String KEYWORD_ALPHBET = "alphabet";
    public static final String[] IGNORED_KEYWORDS = new String[]{"version", "followup", "collapse_result"};
    public static final char STARTMULTI = '(';
    public static final char ENDMULTI = ')';
    public static final String DIGITCODE = "0";
    public static final String REPLACEVOID = "_";
    private Object[] ruleArray = null;
    private char[] alphabetString = defaultEnglishAlphabet;

    public GenericTransformator(File phonetic) throws IOException {
        this.buildRules(new BufferedReader(new FileReader(phonetic)));
        this.alphabetString = this.washAlphabetIntoReplaceList(this.getReplaceList());
    }

    public GenericTransformator(File phonetic, String encoding) throws IOException {
        this.buildRules(new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(phonetic), encoding)));
        this.alphabetString = this.washAlphabetIntoReplaceList(this.getReplaceList());
    }

    public GenericTransformator(Reader phonetic) throws IOException {
        this.buildRules(new BufferedReader(phonetic));
        this.alphabetString = this.washAlphabetIntoReplaceList(this.getReplaceList());
    }

    private char[] washAlphabetIntoReplaceList(char[] alphabet) {
        HashMap<String, Character> letters = new HashMap<String, Character>(alphabet.length);
        for (char c : alphabet) {
            String tmp = String.valueOf(c);
            String code = this.transform(tmp);
            if (letters.containsKey(code)) continue;
            letters.put(code, Character.valueOf(c));
        }
        Object[] tmpCharacters = letters.values().toArray();
        char[] washedArray = new char[tmpCharacters.length];
        for (int i = 0; i < tmpCharacters.length; ++i) {
            washedArray[i] = ((Character)tmpCharacters[i]).charValue();
        }
        return washedArray;
    }

    public char[] getCodeReplaceList() {
        Vector<String> tmp = new Vector<String>();
        if (this.ruleArray == null) {
            return null;
        }
        for (Object o : this.ruleArray) {
            TransformationRule rule = (TransformationRule)o;
            if (rule.getReplaceExp().length() != 1) continue;
            tmp.addElement(rule.getReplaceExp());
        }
        char[] replacements = new char[tmp.size()];
        for (int i = 0; i < tmp.size(); ++i) {
            replacements[i] = ((String)tmp.elementAt(i)).charAt(0);
        }
        return replacements;
    }

    @Override
    public char[] getReplaceList() {
        return this.alphabetString;
    }

    @Override
    public String transform(String word) {
        if (this.ruleArray == null) {
            return null;
        }
        StringBuilder str = new StringBuilder(word.toUpperCase());
        int strLength = str.length();
        int startPos = 0;
        int add = 1;
        while (startPos < strLength) {
            add = 1;
            if (Character.isDigit(str.charAt(startPos))) {
                StringUtility.replace(str, startPos, startPos + DIGITCODE.length(), DIGITCODE);
                startPos += add;
                continue;
            }
            for (Object o : this.ruleArray) {
                TransformationRule rule = (TransformationRule)o;
                if (rule.startsWithExp() && startPos > 0 || startPos + rule.lengthOfMatch() > strLength || !rule.isMatching(str, startPos)) continue;
                String replaceExp = rule.getReplaceExp();
                add = replaceExp.length();
                StringUtility.replace(str, startPos, startPos + rule.getTakeOut(), replaceExp);
                strLength -= rule.getTakeOut();
                strLength += add;
                break;
            }
            startPos += add;
        }
        return str.toString();
    }

    private void buildRules(BufferedReader in) throws IOException {
        String read = null;
        Vector<TransformationRule> ruleList = new Vector<TransformationRule>();
        while ((read = in.readLine()) != null) {
            this.buildRule(this.realTrimmer(read), ruleList);
        }
        this.ruleArray = new TransformationRule[ruleList.size()];
        ruleList.copyInto(this.ruleArray);
    }

    private void buildRule(String str, Vector<TransformationRule> ruleList) {
        if (str.length() < 1) {
            return;
        }
        for (String ignoredKeyword : IGNORED_KEYWORDS) {
            if (!str.startsWith(ignoredKeyword)) continue;
            return;
        }
        if (str.startsWith(KEYWORD_ALPHBET)) {
            int start = str.indexOf(91);
            int end = str.lastIndexOf(93);
            if (end != -1 && start != -1) {
                this.alphabetString = str.substring(++start, end).toCharArray();
            }
            return;
        }
        TransformationRule rule = null;
        StringBuilder matchExp = new StringBuilder();
        StringBuilder replaceExp = new StringBuilder();
        boolean start = false;
        boolean end = false;
        int takeOutPart = 0;
        int matchLength = 0;
        boolean match = true;
        boolean inMulti = false;
        for (int i = 0; i < str.length(); ++i) {
            if (Character.isWhitespace(str.charAt(i))) {
                match = false;
                continue;
            }
            if (match) {
                if (!this.isReservedChar(str.charAt(i))) {
                    matchExp.append(str.charAt(i));
                    if (!inMulti) {
                        ++takeOutPart;
                        ++matchLength;
                    }
                    if (str.charAt(i) == '(' || str.charAt(i) == ')') {
                        boolean bl = inMulti = !inMulti;
                    }
                }
                if (str.charAt(i) == '-') {
                    --takeOutPart;
                }
                if (str.charAt(i) == '^') {
                    start = true;
                }
                if (str.charAt(i) != '$') continue;
                end = true;
                continue;
            }
            replaceExp.append(str.charAt(i));
        }
        if (replaceExp.toString().equals(REPLACEVOID)) {
            replaceExp = new StringBuilder();
        }
        rule = new TransformationRule(matchExp.toString(), replaceExp.toString(), takeOutPart, matchLength, start, end);
        ruleList.addElement(rule);
    }

    private boolean isReservedChar(char ch) {
        return ch == '<' || ch == '>' || ch == '^' || ch == '$' || ch == '-' || Character.isDigit(ch);
    }

    private String realTrimmer(String row) {
        int pos = row.indexOf(35);
        if (pos != -1) {
            row = row.substring(0, pos);
        }
        return row.trim();
    }

    private static class TransformationRule {
        private String replace;
        private char[] match;
        private int takeOut;
        private int matchLength;
        private boolean start;
        private boolean end;

        public TransformationRule(String match, String replace, int takeout, int matchLength, boolean start, boolean end) {
            this.match = match.toCharArray();
            this.replace = replace;
            this.takeOut = takeout;
            this.matchLength = matchLength;
            this.start = start;
            this.end = end;
        }

        public boolean isMatching(CharSequence word, int wordPos) {
            boolean matching = true;
            boolean inMulti = false;
            boolean multiMatch = false;
            for (char c : this.match) {
                char matchCh = c;
                if (matchCh == '(' || matchCh == ')') {
                    boolean bl = inMulti = !inMulti;
                    if (!inMulti) {
                        matching &= multiMatch;
                        continue;
                    }
                    multiMatch = false;
                    continue;
                }
                if (matchCh != word.charAt(wordPos)) {
                    if (inMulti) {
                        multiMatch |= false;
                    } else {
                        matching = false;
                    }
                } else if (inMulti) {
                    multiMatch |= true;
                } else {
                    matching = true;
                }
                if (!inMulti) {
                    ++wordPos;
                }
                if (!matching) break;
            }
            if (this.end && wordPos != word.length()) {
                matching = false;
            }
            return matching;
        }

        public String getReplaceExp() {
            return this.replace;
        }

        public int getTakeOut() {
            return this.takeOut;
        }

        public boolean startsWithExp() {
            return this.start;
        }

        public int lengthOfMatch() {
            return this.matchLength;
        }

        public String toString() {
            return "Match:" + String.valueOf(this.match) + " Replace:" + this.replace + " TakeOut:" + this.takeOut + " MatchLength:" + this.matchLength + " Start:" + this.start + " End:" + this.end;
        }
    }
}

