/*
 * Decompiled with CFR 0.152.
 */
package org.fife.com.swabunga.spell.engine;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.fife.com.swabunga.spell.engine.Configuration;

public class PropertyConfiguration
extends Configuration {
    public Properties prop = new Properties();
    public URL filename;

    public PropertyConfiguration() {
        try {
            this.filename = this.getClass().getClassLoader().getResource("org/fife/com/swabunga/spell/engine/configuration.properties");
            InputStream in = this.filename.openStream();
            this.prop.load(in);
        }
        catch (IOException e) {
            System.err.println("Could not load Properties file :");
            e.printStackTrace();
        }
    }

    @Override
    public boolean getBoolean(String key) {
        return Boolean.parseBoolean(this.prop.getProperty(key));
    }

    @Override
    public int getInteger(String key) {
        return Integer.parseInt(this.prop.getProperty(key), 10);
    }

    @Override
    public void setBoolean(String key, boolean value) {
        String string = null;
        string = value ? "true" : "false";
        this.prop.setProperty(key, string);
        this.save();
    }

    @Override
    public void setInteger(String key, int value) {
        this.prop.setProperty(key, Integer.toString(value));
        this.save();
    }

    public void save() {
        try {
            File file = new File(this.filename.getFile());
            FileOutputStream fout = new FileOutputStream(file);
            this.prop.store(fout, "HEADER");
            fout.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

