/*
 * Decompiled with CFR 0.152.
 */
package org.fife.com.swabunga.spell.engine;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.fife.com.swabunga.spell.engine.Configuration;
import org.fife.com.swabunga.spell.engine.DoubleMeta;
import org.fife.com.swabunga.spell.engine.EditDistance;
import org.fife.com.swabunga.spell.engine.GenericTransformator;
import org.fife.com.swabunga.spell.engine.SpellDictionary;
import org.fife.com.swabunga.spell.engine.Transformator;
import org.fife.com.swabunga.spell.engine.Word;

public abstract class SpellDictionaryASpell
implements SpellDictionary {
    private Transformator tf;

    public SpellDictionaryASpell(File phonetic) throws IOException {
        this.tf = phonetic == null ? new DoubleMeta() : new GenericTransformator(phonetic);
    }

    public SpellDictionaryASpell(File phonetic, String encoding) throws IOException {
        this.tf = phonetic == null ? new DoubleMeta() : new GenericTransformator(phonetic, encoding);
    }

    public SpellDictionaryASpell(Reader phonetic) throws IOException {
        this.tf = phonetic == null ? new DoubleMeta() : new GenericTransformator(phonetic);
    }

    @Override
    public List<Word> getSuggestions(String word, int threshold) {
        return this.getSuggestions(word, threshold, null);
    }

    @Override
    public List<Word> getSuggestions(String word, int threshold, int[][] matrix) {
        int j;
        char b;
        char a;
        int i;
        if (matrix == null) {
            matrix = new int[0][0];
        }
        HashMap<String, String> nearmisscodes = new HashMap<String, String>();
        String code = this.getCode(word);
        nearmisscodes.put(code, code);
        List<Word> phoneticList = this.getWordsFromCode(word, nearmisscodes);
        nearmisscodes = new HashMap();
        char[] charArray = word.toCharArray();
        for (i = 0; i < word.length() - 1; ++i) {
            a = charArray[i];
            charArray[i] = b = charArray[i + 1];
            charArray[i + 1] = a;
            String s = this.getCode(new String(charArray));
            nearmisscodes.put(s, s);
            charArray[i] = a;
            charArray[i + 1] = b;
        }
        char[] replacelist = this.tf.getReplaceList();
        charArray = word.toCharArray();
        for (i = 0; i < word.length(); ++i) {
            char original = charArray[i];
            for (j = 0; j < replacelist.length; ++j) {
                charArray[i] = replacelist[j];
                String s = this.getCode(new String(charArray));
                nearmisscodes.put(s, s);
            }
            charArray[i] = original;
        }
        word = word + " ";
        charArray = word.toCharArray();
        int iy = charArray.length - 1;
        while (true) {
            for (j = 0; j < replacelist.length; ++j) {
                charArray[iy] = replacelist[j];
                String s = this.getCode(new String(charArray));
                nearmisscodes.put(s, s);
            }
            if (iy == 0) break;
            charArray[iy] = charArray[iy - 1];
            --iy;
        }
        word = word.trim();
        charArray = word.toCharArray();
        char[] charArray2 = new char[charArray.length - 1];
        System.arraycopy(charArray, 0, charArray2, 0, charArray2.length);
        a = charArray[charArray.length - 1];
        int ii = charArray2.length;
        while (true) {
            String s = this.getCode(new String(charArray));
            nearmisscodes.put(s, s);
            if (ii == 0) break;
            b = a;
            a = charArray2[ii - 1];
            charArray2[ii - 1] = b;
            --ii;
        }
        nearmisscodes.remove(code);
        List<Word> wordlist = this.getWordsFromCode(word, nearmisscodes);
        if (wordlist.size() == 0 && phoneticList.size() == 0) {
            this.addBestGuess(word, phoneticList, matrix);
        }
        phoneticList.sort(new Word());
        wordlist.sort(new Word());
        phoneticList.addAll(wordlist);
        return phoneticList;
    }

    private void addBestGuess(String word, List<Word> wordList, int[][] matrix) {
        if (matrix == null) {
            matrix = new int[0][0];
        }
        if (wordList.size() != 0) {
            throw new InvalidParameterException("the wordList vector must be empty");
        }
        int bestScore = Integer.MAX_VALUE;
        String code = this.getCode(word);
        List<String> simwordlist = this.getWords(code);
        LinkedList<Word> candidates = new LinkedList<Word>();
        for (String similar : simwordlist) {
            int distance = EditDistance.getDistance(word, similar, matrix);
            if (distance > bestScore) continue;
            bestScore = distance;
            candidates.add(new Word(similar, distance));
        }
        for (Word candidate : candidates) {
            if (candidate.getCost() != bestScore) continue;
            wordList.add(candidate);
        }
    }

    private List<Word> getWordsFromCode(String word, HashMap<String, String> codes) {
        Configuration config = Configuration.getConfiguration();
        ArrayList<Word> result = new ArrayList<Word>();
        int[][] matrix = new int[0][0];
        int configDistance = config.getInteger("SPELL_THRESHOLD");
        for (String code : codes.keySet()) {
            List<String> simwordlist = this.getWords(code);
            for (String similar : simwordlist) {
                int distance = EditDistance.getDistance(word, similar, matrix);
                if (distance >= configDistance) continue;
                result.add(new Word(similar, distance));
            }
        }
        return result;
    }

    public String getCode(String word) {
        return this.tf.transform(word);
    }

    protected abstract List<String> getWords(String var1);

    @Override
    public boolean isCorrect(String word) {
        List<String> possible = this.getWords(this.getCode(word));
        if (possible.contains(word)) {
            return true;
        }
        return possible.contains(word.toLowerCase());
    }
}

