/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea.spell;

import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.zip.ZipFile;
import javax.swing.UIManager;
import javax.swing.event.EventListenerList;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.Document;
import javax.swing.text.Element;
import org.fife.com.swabunga.spell.engine.SpellDictionary;
import org.fife.com.swabunga.spell.engine.SpellDictionaryHashMap;
import org.fife.com.swabunga.spell.engine.Word;
import org.fife.com.swabunga.spell.event.DocumentWordTokenizer;
import org.fife.com.swabunga.spell.event.SpellCheckEvent;
import org.fife.com.swabunga.spell.event.SpellCheckListener;
import org.fife.com.swabunga.spell.event.SpellChecker;
import org.fife.com.swabunga.spell.event.StringWordTokenizer;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rsyntaxtextarea.parser.AbstractParser;
import org.fife.ui.rsyntaxtextarea.parser.DefaultParseResult;
import org.fife.ui.rsyntaxtextarea.parser.DefaultParserNotice;
import org.fife.ui.rsyntaxtextarea.parser.ExtendedHyperlinkListener;
import org.fife.ui.rsyntaxtextarea.parser.ParseResult;
import org.fife.ui.rsyntaxtextarea.parser.Parser;
import org.fife.ui.rsyntaxtextarea.parser.ParserNotice;
import org.fife.ui.rsyntaxtextarea.spell.DefaultSpellCheckableTokenIdentifier;
import org.fife.ui.rsyntaxtextarea.spell.SpellCheckableTokenIdentifier;
import org.fife.ui.rsyntaxtextarea.spell.event.SpellingParserEvent;
import org.fife.ui.rsyntaxtextarea.spell.event.SpellingParserListener;

public class SpellingParser
extends AbstractParser
implements SpellCheckListener,
ExtendedHyperlinkListener {
    private DefaultParseResult result = new DefaultParseResult((Parser)this);
    private SpellChecker sc;
    private RSyntaxDocument doc;
    private int startOffs;
    private int errorCount;
    private int maxErrorCount;
    private boolean allowAdd;
    private boolean allowIgnore;
    private Color squiggleUnderlineColor;
    private String noticePrefix;
    private String noticeSuffix;
    private EventListenerList listenerList;
    private SpellCheckableTokenIdentifier spellCheckableTokenIdentifier;
    private File dictionaryFile;
    private static final String MSG = "org.fife.ui.rsyntaxtextarea.spell.SpellingParser";
    private static final ResourceBundle msg = ResourceBundle.getBundle("org.fife.ui.rsyntaxtextarea.spell.SpellingParser");
    private static final String ADD = "add";
    private static final String IGNORE = "ignore";
    private static final String REPLACE = "replace";
    private static final String TOOLTIP_TEXT_FORMAT = "<html><body dir='{0}'><img src='lightbulb.png' width='16' height='16'>{1}<hr><img src='spellcheck.png' width='16' height='16'>{2}<br>{3}<br>&nbsp;";
    private static final int DEFAULT_MAX_ERROR_COUNT = 100;

    public SpellingParser(SpellDictionary dict) {
        this.sc = new SpellChecker(dict);
        this.sc.addSpellCheckListener(this);
        this.setSquiggleUnderlineColor(Color.BLUE);
        this.setHyperlinkListener(this);
        this.setMaxErrorCount(100);
        this.setAllowAdd(true);
        this.setAllowIgnore(true);
        this.setSpellCheckableTokenIdentifier(new DefaultSpellCheckableTokenIdentifier());
        String temp = msg.getString("IncorrectSpelling");
        int offs = temp.indexOf("{0}");
        this.noticePrefix = temp.substring(0, offs);
        this.noticeSuffix = temp.substring(offs + 3);
        this.listenerList = new EventListenerList();
    }

    public void addSpellingParserListener(SpellingParserListener l) {
        this.listenerList.add(SpellingParserListener.class, l);
    }

    public static SpellingParser createEnglishSpellingParser(File zip, boolean american) throws IOException {
        return SpellingParser.createEnglishSpellingParser(zip, american, true);
    }

    public static SpellingParser createEnglishSpellingParser(File zip, boolean american, boolean programming) throws IOException {
        SpellDictionaryHashMap dict;
        try (ZipFile zf = new ZipFile(zip);){
            InputStream in = zf.getInputStream(zf.getEntry("eng_com.dic"));
            BufferedReader r = new BufferedReader(new InputStreamReader(in));
            Object object = null;
            try {
                dict = new SpellDictionaryHashMap(r);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (r != null) {
                    if (object != null) {
                        try {
                            r.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        r.close();
                    }
                }
            }
            ArrayList<String> others = american ? new ArrayList<String>(Arrays.asList("color", "labeled", "center", "ize", "yze")) : new ArrayList<String>(Arrays.asList("colour", "labelled", "centre", "ise", "yse"));
            if (programming) {
                others.add("programming");
            }
            for (String other : others) {
                in = zf.getInputStream(zf.getEntry(other + ".dic"));
                BufferedReader r2 = new BufferedReader(new InputStreamReader(in));
                Throwable throwable = null;
                try {
                    dict.addDictionary(r2);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (r2 == null) continue;
                    if (throwable != null) {
                        try {
                            r2.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    r2.close();
                }
            }
        }
        return new SpellingParser(dict);
    }

    private void fireSpellingParserEvent(SpellingParserEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != SpellingParserListener.class) continue;
            ((SpellingParserListener)listeners[i + 1]).spellingParserEvent(e);
        }
    }

    public boolean getAllowAdd() {
        return this.allowAdd;
    }

    public boolean getAllowIgnore() {
        return this.allowIgnore;
    }

    public URL getImageBase() {
        return this.getClass().getResource("/org/fife/ui/rsyntaxtextarea/spell/");
    }

    private int getLineOfOffset(int offs) {
        return this.doc.getDefaultRootElement().getElementIndex(offs);
    }

    public int getMaxErrorCount() {
        return this.maxErrorCount;
    }

    public SpellCheckableTokenIdentifier getSpellCheckableTokenIdentifier() {
        return this.spellCheckableTokenIdentifier;
    }

    public Color getSquiggleUnderlineColor() {
        return this.squiggleUnderlineColor;
    }

    public File getUserDictionary() {
        return this.dictionaryFile;
    }

    public void linkClicked(RSyntaxTextArea textArea, HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            String desc = e.getDescription();
            int temp = desc.indexOf("://");
            String operation = desc.substring(0, temp);
            String[] tokens = desc.substring(temp + 3).split(",");
            switch (operation) {
                case "replace": {
                    int offs = Integer.parseInt(tokens[0]);
                    int len = Integer.parseInt(tokens[1]);
                    String replacement = tokens[2];
                    textArea.replaceRange(replacement, offs, offs + len);
                    textArea.setSelectionStart(offs);
                    textArea.setSelectionEnd(offs + replacement.length());
                    break;
                }
                case "add": {
                    String word;
                    if (this.dictionaryFile == null) {
                        UIManager.getLookAndFeel().provideErrorFeedback((Component)textArea);
                    }
                    if (this.sc.addToDictionary(word = tokens[0])) {
                        textArea.forceReparsing((Parser)this);
                        SpellingParserEvent se = new SpellingParserEvent(this, textArea, 0, word);
                        this.fireSpellingParserEvent(se);
                        break;
                    }
                    UIManager.getLookAndFeel().provideErrorFeedback((Component)textArea);
                    break;
                }
                case "ignore": {
                    String word = tokens[0];
                    this.sc.ignoreAll(word);
                    textArea.forceReparsing((Parser)this);
                    SpellingParserEvent se = new SpellingParserEvent(this, textArea, 1, word);
                    this.fireSpellingParserEvent(se);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParseResult parse(RSyntaxDocument doc, String style) {
        Element root = doc.getDefaultRootElement();
        int lineCount = root.getElementCount();
        this.result.clearNotices();
        this.result.setParsedLines(0, lineCount - 1);
        this.doc = doc;
        this.errorCount = 0;
        if (style == null || "text/plain".equals(style)) {
            this.startOffs = 0;
            this.parseEntireDocument(doc);
        } else {
            SpellCheckableTokenIdentifier scti = this.getSpellCheckableTokenIdentifier();
            scti.begin();
            try {
                for (Token t : doc) {
                    if (!scti.isSpellCheckable(t)) continue;
                    this.startOffs = t.getOffset();
                    StringWordTokenizer swt = new StringWordTokenizer(t.getLexeme());
                    int rc = this.sc.checkSpelling(swt);
                    if (rc != -2) continue;
                    break;
                }
            }
            finally {
                scti.end();
            }
        }
        return this.result;
    }

    private void parseEntireDocument(RSyntaxDocument doc) {
        DocumentWordTokenizer dwt = new DocumentWordTokenizer((Document)doc);
        this.sc.checkSpelling(dwt);
    }

    public void removeSpellingParserListener(SpellingParserListener l) {
        this.listenerList.remove(SpellingParserListener.class, l);
    }

    public void setAllowAdd(boolean add) {
        this.allowAdd = add;
    }

    public void setAllowIgnore(boolean ignore) {
        this.allowIgnore = ignore;
    }

    public void setMaxErrorCount(int max) {
        this.maxErrorCount = max;
    }

    public void setSpellCheckableTokenIdentifier(SpellCheckableTokenIdentifier scti) {
        if (scti == null) {
            throw new IllegalArgumentException("SpellCheckableTokenIdentifier cannot be null");
        }
        this.spellCheckableTokenIdentifier = scti;
    }

    public void setSquiggleUnderlineColor(Color color) {
        this.squiggleUnderlineColor = color;
    }

    public void setUserDictionary(File dictionaryFile) throws IOException {
        SpellDictionaryHashMap userDict;
        if (dictionaryFile != null) {
            if (!dictionaryFile.exists()) {
                FileWriter w = new FileWriter(dictionaryFile);
                w.close();
            }
            userDict = new SpellDictionaryHashMap(dictionaryFile);
        } else {
            userDict = new SpellDictionaryHashMap();
        }
        this.sc.setUserDictionary(userDict);
        this.dictionaryFile = dictionaryFile;
    }

    @Override
    public void spellingError(SpellCheckEvent e) {
        String word = e.getInvalidWord();
        int offs = this.startOffs + e.getWordContextPosition();
        int line = this.getLineOfOffset(offs);
        String text = this.noticePrefix + word + this.noticeSuffix;
        SpellingParserNotice notice = new SpellingParserNotice(this, text, line, offs, word, this.sc);
        this.result.addNotice((ParserNotice)notice);
        if (++this.errorCount >= this.maxErrorCount) {
            e.cancel();
        }
    }

    private static class SpellingParserNotice
    extends DefaultParserNotice {
        private String word;
        private SpellChecker sc;

        SpellingParserNotice(SpellingParser parser, String msg, int line, int offs, String word, SpellChecker sc) {
            super((Parser)parser, msg, line, offs, word.length());
            this.setLevel(ParserNotice.Level.INFO);
            this.word = word;
            this.sc = sc;
        }

        public Color getColor() {
            return ((SpellingParser)this.getParser()).getSquiggleUnderlineColor();
        }

        public String getToolTipText() {
            StringBuilder sb = new StringBuilder();
            String spacing = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
            int threshold = this.sc.getConfiguration().getInteger("SPELL_THRESHOLD");
            List<Word> suggestions = this.sc.getSuggestions(this.word, threshold);
            if (suggestions == null || suggestions.size() == 0) {
                sb.append(spacing).append("&#8226;&nbsp;<em>");
                sb.append(msg.getString("None"));
                sb.append("</em><br><br>");
            } else {
                if (Character.isUpperCase(this.word.charAt(0))) {
                    for (Word suggestion : suggestions) {
                        String oldSug = suggestion.getWord();
                        suggestion.setWord(Character.toUpperCase(oldSug.charAt(0)) + oldSug.substring(1));
                    }
                }
                sb.append("<center>");
                sb.append("<table width='75%'>");
                for (int i = 0; i < suggestions.size(); ++i) {
                    Word suggestion;
                    if (i % 2 == 0) {
                        sb.append("<tr>");
                    }
                    sb.append("<td>&#8226;&nbsp;");
                    suggestion = suggestions.get(i);
                    sb.append("<a href=\"").append(SpellingParser.REPLACE).append("://").append(this.getOffset()).append(',').append(this.getLength()).append(',').append(suggestion.getWord()).append("\">").append(suggestion.getWord()).append("</a>").append("</td>");
                    if ((i & 1) != 1) continue;
                    sb.append("</tr>");
                }
                if (suggestions.size() % 2 == 0) {
                    sb.append("<td></td></tr>");
                }
                sb.append("</table>");
                sb.append("</center>");
            }
            SpellingParser sp = (SpellingParser)this.getParser();
            if (sp.getAllowAdd()) {
                sb.append("<img src='add.png' width='16' height='16'>&nbsp;").append("<a href='").append(SpellingParser.ADD).append("://").append(this.word).append("'>").append(msg.getString("ErrorToolTip.AddToDictionary")).append("</a><br>");
            }
            if (sp.getAllowIgnore()) {
                String text = msg.getString("ErrorToolTip.IgnoreWord");
                text = MessageFormat.format(text, this.word);
                sb.append("<img src='cross.png' width='16' height='16'>&nbsp;").append("<a href='").append(SpellingParser.IGNORE).append("://").append(this.word).append("'>").append(text).append("</a>");
            }
            String firstLine = MessageFormat.format(msg.getString("ErrorToolTip.DescHtml"), this.word);
            ComponentOrientation o = ComponentOrientation.getOrientation(Locale.getDefault());
            String dirAttr = o.isLeftToRight() ? "ltr" : "rtl";
            return MessageFormat.format(SpellingParser.TOOLTIP_TEXT_FORMAT, dirAttr, firstLine, msg.getString("ErrorToolTip.SuggestionsHtml"), sb.toString());
        }

        public String toString() {
            return "[SpellingParserNotice: " + this.word + "]";
        }
    }
}

