/*
 * Decompiled with CFR 0.152.
 */
package com.fiftyonred.mock_jedis;

import com.fiftyonred.mock_jedis.MockPipeline;
import java.util.List;
import java.util.Map;
import java.util.Set;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.exceptions.JedisDataException;

public class MockJedis
extends Jedis {
    private MockPipeline pipeline = new MockPipeline();

    public MockJedis(String host) {
        super(host);
    }

    public String set(String key, String value) {
        return (String)this.pipeline.set(key, value).get();
    }

    public String get(String key) {
        return (String)this.pipeline.get(key).get();
    }

    public List<String> mget(String ... keys) {
        if (keys.length <= 0) {
            throw new JedisDataException("ERR wrong number of arguments for 'mget' command");
        }
        return (List)this.pipeline.mget(keys).get();
    }

    public String flushAll() {
        this.pipeline.clear();
        return "OK";
    }

    public Long decrBy(String key, long integer) {
        return (Long)this.pipeline.decrBy(key, integer).get();
    }

    public Long decr(String key) {
        return this.decrBy(key, 1L);
    }

    public Long expire(String key, int seconds) {
        return 1L;
    }

    public Long incr(String key) {
        return this.incrBy(key, 1L);
    }

    public Long incrBy(String key, long integer) {
        return (Long)this.pipeline.incrBy(key, integer).get();
    }

    public String setex(String key, int seconds, String value) {
        return this.set(key, value);
    }

    public Long del(String ... keys) {
        return (Long)this.pipeline.del(keys).get();
    }

    public Long hset(String key, String field, String value) {
        return (Long)this.pipeline.hset(key, field, value).get();
    }

    public String hget(String key, String field) {
        return (String)this.pipeline.hget(key, field).get();
    }

    public Map<String, String> hgetAll(String key) {
        return (Map)this.pipeline.hgetAll(key).get();
    }

    public String hmset(String key, Map<String, String> hash) {
        return (String)this.pipeline.hmset(key, hash).get();
    }

    public List<String> hmget(String key, String ... fields) {
        return (List)this.pipeline.hmget(key, fields).get();
    }

    public Pipeline pipelined() {
        return this.pipeline;
    }

    public Set<String> keys(String pattern) {
        return (Set)this.pipeline.keys(pattern).get();
    }
}

