/*
 * Decompiled with CFR 0.152.
 */
package com.fiftyonred.mock_jedis;

import com.fiftyonred.utils.WildcardMatcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import redis.clients.jedis.BuilderFactory;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.Response;
import redis.clients.util.SafeEncoder;

public class MockPipeline
extends Pipeline {
    private WildcardMatcher wildcardMatcher = new WildcardMatcher();
    private Map<String, String> storage = new HashMap<String, String>();
    private Map<String, Map<String, String>> hashStorage = new HashMap<String, Map<String, String>>();

    public void clear() {
        this.storage.clear();
    }

    public Response<String> set(String key, String value) {
        Response response = new Response(BuilderFactory.STRING);
        this.storage.put(key, value);
        response.set((Object)"OK".getBytes());
        return response;
    }

    public Response<String> setex(String key, int seconds, String value) {
        return this.set(key, value);
    }

    public Response<String> get(String key) {
        Response response = new Response(BuilderFactory.STRING);
        String val = this.storage.get(key);
        response.set((Object)(val != null ? val.getBytes() : null));
        return response;
    }

    public Response<Long> expire(String key, int seconds) {
        Response response = new Response(BuilderFactory.LONG);
        response.set((Object)seconds);
        return response;
    }

    public Response<List<String>> mget(String ... keys) {
        Response response = new Response(BuilderFactory.STRING_LIST);
        ArrayList<byte[]> result = new ArrayList<byte[]>();
        for (String key : keys) {
            if (this.storage.containsKey(key)) {
                result.add(this.storage.get(key).getBytes());
                continue;
            }
            result.add(null);
        }
        response.set(result);
        return response;
    }

    public Response<Long> decr(String key) {
        return this.decrBy(key, 1L);
    }

    public Response<Long> decrBy(String key, long integer) {
        Response response = new Response(BuilderFactory.LONG);
        String val = this.storage.get(key);
        Long result = val == null ? 0L - integer : Long.valueOf(val) - integer;
        this.storage.put(key, result.toString());
        response.set((Object)result);
        return response;
    }

    public Response<Long> incr(String key) {
        return this.incrBy(key, 1L);
    }

    public Response<Long> incrBy(String key, long integer) {
        Response response = new Response(BuilderFactory.LONG);
        String val = this.storage.get(key);
        Long result = val == null ? integer : Long.valueOf(val) + integer;
        this.storage.put(key, result.toString());
        response.set((Object)result);
        return response;
    }

    public Response<Long> del(String ... keys) {
        Response response = new Response(BuilderFactory.LONG);
        Long result = 0L;
        for (String key : keys) {
            String i = this.storage.remove(key);
            if (i == null) continue;
            result = result + 1L;
        }
        response.set((Object)result);
        return response;
    }

    public Response<String> hget(String key, String field) {
        Response response = new Response(BuilderFactory.STRING);
        if (this.hashStorage.containsKey(key)) {
            response.set((Object)this.hashStorage.get(key).get(field).getBytes());
        }
        return response;
    }

    public Response<Map<String, String>> hgetAll(String key) {
        Response response = new Response(BuilderFactory.STRING_MAP);
        Map<String, String> result = this.hashStorage.get(key);
        if (this.hashStorage.containsKey(key)) {
            ArrayList<byte[]> encodedResult = new ArrayList<byte[]>();
            for (String k : result.keySet()) {
                encodedResult.add(SafeEncoder.encode((String)k));
                encodedResult.add(SafeEncoder.encode((String)result.get(k)));
            }
            response.set(encodedResult);
        } else {
            response.set(new ArrayList());
        }
        return response;
    }

    public Response<Long> hset(String key, String field, String value) {
        Response response = new Response(BuilderFactory.LONG);
        Map<Object, Object> m = !this.hashStorage.containsKey(key) ? new HashMap() : this.hashStorage.get(key);
        response.set((Object)(m.containsKey(field) ? 0L : 1L));
        m.put(field, value);
        if (!this.hashStorage.containsKey(key)) {
            this.hashStorage.put(key, m);
        }
        return response;
    }

    public Response<List<String>> hmget(String key, String ... fields) {
        Response response = new Response(BuilderFactory.STRING_LIST);
        ArrayList<byte[]> result = new ArrayList<byte[]>();
        if (!this.hashStorage.containsKey(key)) {
            for (String field : fields) {
                result.add(null);
            }
            response.set(result);
            return response;
        }
        for (String field : fields) {
            String v = this.hashStorage.get(key).get(field);
            result.add(v != null ? v.getBytes() : null);
        }
        response.set(result);
        return response;
    }

    public Response<String> hmset(String key, Map<String, String> hash) {
        Response response = new Response(BuilderFactory.STRING);
        Map<Object, Object> m = !this.hashStorage.containsKey(key) ? new HashMap() : this.hashStorage.get(key);
        for (Map.Entry<String, String> e : hash.entrySet()) {
            m.put(e.getKey(), e.getValue());
        }
        if (!this.hashStorage.containsKey(key)) {
            this.hashStorage.put(key, m);
        }
        response.set((Object)"OK".getBytes());
        return response;
    }

    public void sync() {
    }

    public Response<Set<String>> keys(String pattern) {
        Response response = new Response(BuilderFactory.STRING_SET);
        ArrayList<byte[]> result = new ArrayList<byte[]>();
        this.filterKeys(pattern, this.storage.keySet(), result);
        this.filterKeys(pattern, this.hashStorage.keySet(), result);
        response.set(result);
        return response;
    }

    public void filterKeys(String pattern, Collection<String> collection, List<byte[]> result) {
        for (String key : collection) {
            if (!this.wildcardMatcher.match(key, pattern)) continue;
            result.add(key.getBytes());
        }
    }
}

