/*
 * Decompiled with CFR 0.152.
 */
package com.fiftyonred.mock_jedis;

import com.fiftyonred.mock_jedis.KeyInformation;
import com.fiftyonred.mock_jedis.KeyType;
import com.fiftyonred.utils.WildcardMatcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import redis.clients.jedis.BuilderFactory;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.Response;
import redis.clients.jedis.SortingParams;
import redis.clients.jedis.exceptions.JedisDataException;
import redis.clients.util.SafeEncoder;

public class MockPipeline
extends Pipeline {
    private final WildcardMatcher wildcardMatcher = new WildcardMatcher();
    private final List<Map<String, KeyInformation>> allKeys = new ArrayList<Map<String, KeyInformation>>(16);
    private final List<Map<String, String>> allStorage = new ArrayList<Map<String, String>>(16);
    private final List<Map<String, Map<String, String>>> allHashStorage = new ArrayList<Map<String, Map<String, String>>>(16);
    private final List<Map<String, List<String>>> allListStorage = new ArrayList<Map<String, List<String>>>(16);
    private final List<Map<String, Set<String>>> allSetStorage = new ArrayList<Map<String, Set<String>>>(16);
    private int currentDB;
    private static final int NUM_DBS = 16;
    private Map<String, KeyInformation> keys;
    private Map<String, String> storage;
    private Map<String, Map<String, String>> hashStorage;
    private Map<String, List<String>> listStorage;
    private Map<String, Set<String>> setStorage;

    public MockPipeline() {
        for (int i = 0; i < 16; ++i) {
            this.allKeys.add(new HashMap());
            this.allStorage.add(new HashMap());
            this.allHashStorage.add(new HashMap());
            this.allListStorage.add(new HashMap());
            this.allSetStorage.add(new HashMap());
        }
        this.select(0);
    }

    public int getCurrentDB() {
        return this.currentDB;
    }

    protected static <T> T getRandomElementFromSet(Set<T> set) {
        return (T)set.toArray()[(int)(Math.random() * (double)set.size())];
    }

    public Response<String> ping() {
        Response response = new Response(BuilderFactory.STRING);
        response.set((Object)"PONG".getBytes());
        return response;
    }

    public Response<String> echo(String string) {
        Response response = new Response(BuilderFactory.STRING);
        response.set(this.echo(string.getBytes()).get());
        return response;
    }

    public Response<byte[]> echo(byte[] string) {
        Response response = new Response(BuilderFactory.BYTE_ARRAY);
        response.set((Object)string);
        return response;
    }

    public synchronized Response<Long> dbSize() {
        Response response = new Response(BuilderFactory.LONG);
        response.set((Object)this.keys.size());
        return response;
    }

    public synchronized Response<String> flushAll() {
        Response response = new Response(BuilderFactory.STRING);
        for (int dbNum = 0; dbNum < 16; ++dbNum) {
            this.allKeys.get(dbNum).clear();
            this.allStorage.get(dbNum).clear();
            this.allHashStorage.get(dbNum).clear();
            this.allListStorage.get(dbNum).clear();
        }
        response.set((Object)"OK".getBytes());
        return response;
    }

    public synchronized Response<String> flushDB() {
        Response response = new Response(BuilderFactory.STRING);
        this.keys.clear();
        this.storage.clear();
        this.hashStorage.clear();
        this.listStorage.clear();
        response.set((Object)"OK".getBytes());
        return response;
    }

    public synchronized Response<String> rename(String oldkey, String newkey) {
        if (oldkey.equals(newkey)) {
            throw new JedisDataException("ERR source and destination objects are the same");
        }
        Response response = new Response(BuilderFactory.STRING);
        KeyInformation info = this.keys.get(oldkey);
        switch (info.getType()) {
            case HASH: {
                this.hashStorage.put(newkey, this.hashStorage.get(oldkey));
                this.hashStorage.remove(oldkey);
                break;
            }
            case LIST: {
                this.listStorage.put(newkey, this.listStorage.get(oldkey));
                this.listStorage.remove(oldkey);
                break;
            }
            default: {
                this.storage.put(newkey, this.storage.get(oldkey));
                this.storage.remove(oldkey);
            }
        }
        this.keys.put(newkey, info);
        this.keys.remove(oldkey);
        response.set((Object)"OK".getBytes());
        return response;
    }

    public Response<String> rename(byte[] oldkey, byte[] newkey) {
        return this.rename(new String(oldkey), new String(newkey));
    }

    public synchronized Response<Long> renamenx(String oldkey, String newkey) {
        if (oldkey.equals(newkey)) {
            throw new JedisDataException("ERR source and destination objects are the same");
        }
        Response response = new Response(BuilderFactory.LONG);
        KeyInformation newInfo = this.keys.get(newkey);
        if (newInfo == null) {
            this.rename(oldkey, newkey);
            response.set((Object)1L);
        } else {
            response.set((Object)0L);
        }
        return response;
    }

    public Response<Long> renamenx(byte[] oldkey, byte[] newkey) {
        return this.renamenx(new String(oldkey), new String(newkey));
    }

    public synchronized Response<String> set(String key, String value) {
        Response response = new Response(BuilderFactory.STRING);
        this.createOrUpdateKey(key, KeyType.STRING, true);
        this.storage.put(key, value);
        response.set((Object)"OK".getBytes());
        return response;
    }

    public synchronized Response<String> set(byte[] key, byte[] value) {
        return this.set(new String(key), new String(value));
    }

    public synchronized Response<Long> setnx(String key, String value) {
        Response response = new Response(BuilderFactory.LONG);
        String result = this.getStringFromStorage(key, false);
        if (result == null) {
            this.set(key, value);
            response.set((Object)1L);
        } else {
            response.set((Object)0L);
        }
        return response;
    }

    public synchronized Response<Long> setnx(byte[] key, byte[] value) {
        return this.setnx(new String(key), new String(value));
    }

    public synchronized Response<String> get(String key) {
        Response response = new Response(BuilderFactory.STRING);
        String val = this.getStringFromStorage(key, false);
        response.set((Object)(val == null ? null : val.getBytes()));
        return response;
    }

    public Response<byte[]> get(byte[] key) {
        Response response = new Response(BuilderFactory.BYTE_ARRAY);
        String result = (String)this.get(new String(key)).get();
        response.set((Object)(result == null ? null : result.getBytes()));
        return response;
    }

    public synchronized Response<String> getSet(String key, String value) {
        Response<String> response = this.get(key);
        this.set(key, value);
        return response;
    }

    public synchronized Response<byte[]> getSet(byte[] key, byte[] value) {
        Response<byte[]> response = this.get(key);
        this.set(key, value);
        return response;
    }

    public Response<byte[]> dump(byte[] key) {
        return this.get(key);
    }

    public Response<byte[]> dump(String key) {
        return this.get(key.getBytes());
    }

    public Response<String> restore(String key, int ttl, byte[] serializedValue) {
        return this.setex(key.getBytes(), ttl, serializedValue);
    }

    public Response<String> restore(byte[] key, int ttl, byte[] serializedValue) {
        return this.setex(key, ttl, serializedValue);
    }

    public synchronized Response<Boolean> exists(String key) {
        Response response = new Response(BuilderFactory.BOOLEAN);
        response.set((Object)(this.keys.containsKey(key) ? 1L : 0L));
        return response;
    }

    public synchronized Response<Boolean> exists(byte[] key) {
        return this.exists(new String(key));
    }

    public synchronized Response<String> type(String key) {
        Response response = new Response(BuilderFactory.STRING);
        KeyInformation info = this.keys.get(key);
        if (info != null && info.getType() == KeyType.STRING) {
            response.set((Object)"string".getBytes());
        } else if (info != null && info.getType() == KeyType.LIST) {
            response.set((Object)"list".getBytes());
        } else if (info != null && info.getType() == KeyType.SET) {
            response.set((Object)"set".getBytes());
        } else {
            response.set((Object)"none".getBytes());
        }
        return response;
    }

    public synchronized Response<String> type(byte[] key) {
        return this.type(new String(key));
    }

    public Response<Long> move(String key, int dbIndex) {
        if (dbIndex < 0 || dbIndex > 15) {
            throw new JedisDataException("ERR index out of range");
        }
        Response response = new Response(BuilderFactory.LONG);
        KeyInformation info = this.keys.get(key);
        if (info == null) {
            response.set((Object)0L);
        } else {
            KeyInformation infoNew = this.allKeys.get(dbIndex).get(key);
            if (infoNew == null) {
                this.allKeys.get(dbIndex).put(key, info);
                switch (info.getType()) {
                    case HASH: {
                        this.allHashStorage.get(dbIndex).put(key, this.hashStorage.get(key));
                        this.hashStorage.remove(key);
                        break;
                    }
                    case LIST: {
                        this.allListStorage.get(dbIndex).put(key, this.listStorage.get(key));
                        this.listStorage.remove(key);
                        break;
                    }
                    default: {
                        this.allStorage.get(dbIndex).put(key, this.storage.get(key));
                        this.storage.remove(key);
                    }
                }
                this.keys.remove(key);
                response.set((Object)1L);
            } else {
                response.set((Object)0L);
            }
        }
        return response;
    }

    public synchronized Response<Long> move(byte[] key, int dbIndex) {
        return this.move(new String(key), dbIndex);
    }

    public synchronized Response<String> randomKey() {
        Response response = new Response(BuilderFactory.STRING);
        if (this.keys.size() == 0) {
            response.set(null);
        } else {
            String result = MockPipeline.getRandomElementFromSet(this.keys.keySet());
            response.set((Object)result.getBytes());
        }
        return response;
    }

    public Response<byte[]> randomKeyBinary() {
        Response response = new Response(BuilderFactory.BYTE_ARRAY);
        String result = (String)this.randomKey().get();
        response.set((Object)(result == null ? null : result.getBytes()));
        return response;
    }

    public Response<String> select(int dbIndex) {
        if (dbIndex < 0 || dbIndex > 15) {
            throw new JedisDataException("ERR invalid DB index");
        }
        Response response = new Response(BuilderFactory.STRING);
        this.currentDB = dbIndex;
        this.keys = this.allKeys.get(dbIndex);
        this.storage = this.allStorage.get(dbIndex);
        this.hashStorage = this.allHashStorage.get(dbIndex);
        this.listStorage = this.allListStorage.get(dbIndex);
        this.setStorage = this.allSetStorage.get(dbIndex);
        response.set((Object)"OK".getBytes());
        return response;
    }

    public Response<String> setex(String key, int seconds, String value) {
        return this.psetex(key, seconds * 1000, value);
    }

    public Response<String> setex(byte[] key, int seconds, byte[] value) {
        return this.setex(new String(key), seconds, new String(value));
    }

    public synchronized Response<String> psetex(String key, int milliseconds, String value) {
        Response<String> response = this.set(key, value);
        this.pexpire(key, milliseconds);
        return response;
    }

    public Response<String> psetex(byte[] key, int milliseconds, byte[] value) {
        return this.psetex(new String(key), milliseconds, new String(value));
    }

    public Response<Long> expire(String key, int seconds) {
        return this.expireAt(key, System.currentTimeMillis() / 1000L + (long)seconds);
    }

    public Response<Long> expire(byte[] key, int seconds) {
        return this.expire(new String(key), seconds);
    }

    public Response<Long> expireAt(String key, long seconds) {
        return this.pexpireAt(key, seconds * 1000L);
    }

    public Response<Long> expireAt(byte[] key, long seconds) {
        return this.expireAt(new String(key), seconds);
    }

    public Response<Long> pexpire(String key, int milliseconds) {
        return this.pexpireAt(key, System.currentTimeMillis() + (long)milliseconds);
    }

    public Response<Long> pexpire(byte[] key, int milliseconds) {
        return this.pexpire(new String(key), milliseconds);
    }

    public synchronized Response<Long> pexpireAt(String key, long millisecondsTimestamp) {
        Response response = new Response(BuilderFactory.LONG);
        KeyInformation info = this.keys.get(key);
        if (info == null || info.isTTLSetAndKeyExpired()) {
            response.set((Object)0L);
        } else {
            info.setExpiration(millisecondsTimestamp);
            response.set((Object)1L);
        }
        return response;
    }

    public synchronized Response<Long> pexpireAt(byte[] key, long millisecondsTimestamp) {
        return this.pexpireAt(new String(key), millisecondsTimestamp);
    }

    public Response<Long> ttl(String key) {
        Long pttlInResponse = (Long)this.pttl(key).get();
        Response response = new Response(BuilderFactory.LONG);
        if (pttlInResponse != -1L) {
            if (pttlInResponse > 0L && pttlInResponse < 1000L) {
                pttlInResponse = 1000L;
            }
            response.set((Object)(pttlInResponse / 1000L));
        } else {
            response.set((Object)pttlInResponse);
        }
        return response;
    }

    public synchronized Response<Long> append(String key, String value) {
        Response response = new Response(BuilderFactory.LONG);
        String newVal = this.getStringFromStorage(key, true) + value;
        this.set(key, newVal);
        response.set((Object)newVal.length());
        return response;
    }

    public Response<Long> append(byte[] key, byte[] value) {
        return this.append(new String(key), new String(value));
    }

    public Response<Long> ttl(byte[] key) {
        return this.ttl(new String(key));
    }

    public synchronized Response<Long> pttl(String key) {
        Response response = new Response(BuilderFactory.LONG);
        KeyInformation info = this.keys.get(key);
        response.set((Object)(info == null ? -1L : info.getTTL()));
        return response;
    }

    public synchronized Response<Long> persist(String key) {
        Response response = new Response(BuilderFactory.LONG);
        KeyInformation info = this.keys.get(key);
        if (response == null || info.getTTL() == -1L) {
            response.set((Object)0L);
        } else {
            info.setExpiration(-1L);
            response.set((Object)1L);
        }
        return response;
    }

    public Response<Long> persist(byte[] key) {
        return this.persist(new String(key));
    }

    public synchronized Response<List<String>> mget(String ... keys) {
        if (keys.length <= 0) {
            throw new JedisDataException("ERR wrong number of arguments for 'mget' command");
        }
        Response response = new Response(BuilderFactory.STRING_LIST);
        ArrayList<byte[]> result = new ArrayList<byte[]>();
        for (String key : keys) {
            String val = this.getStringFromStorage(key, false);
            result.add(val == null ? null : val.getBytes());
        }
        response.set(result);
        return response;
    }

    public synchronized Response<List<byte[]>> mget(byte[] ... keys) {
        if (keys.length <= 0) {
            throw new JedisDataException("ERR wrong number of arguments for 'mget' command");
        }
        Response response = new Response(BuilderFactory.BYTE_ARRAY_LIST);
        ArrayList<byte[]> result = new ArrayList<byte[]>();
        for (byte[] key : keys) {
            String val = this.getStringFromStorage(new String(key), false);
            result.add(val == null ? null : val.getBytes());
        }
        response.set(result);
        return response;
    }

    public synchronized Response<String> mset(String ... keys) {
        if (keys.length <= 0 || keys.length % 2 != 0) {
            throw new JedisDataException("ERR wrong number of arguments for 'mset' command");
        }
        for (int i = 0; i < keys.length; i += 2) {
            this.set(keys[i], keys[i + 1]);
        }
        Response response = new Response(BuilderFactory.STRING);
        response.set((Object)"OK".getBytes());
        return response;
    }

    public Response<String> mset(byte[] ... keys) {
        return this.mset(MockPipeline.convertToStrings(keys));
    }

    public synchronized Response<Long> msetnx(String ... keys) {
        if (keys.length <= 0 || keys.length % 2 != 0) {
            throw new JedisDataException("ERR wrong number of arguments for 'msetnx' command");
        }
        long result = 1L;
        for (int i = 0; i < keys.length; i += 2) {
            if ((Long)this.setnx(keys[i], keys[i + 1]).get() != 0L) continue;
            result = 0L;
        }
        Response response = new Response(BuilderFactory.LONG);
        response.set((Object)result);
        return response;
    }

    public Response<Long> msetnx(byte[] ... keys) {
        return this.msetnx(MockPipeline.convertToStrings(keys));
    }

    public Response<Long> decr(String key) {
        return this.decrBy(key, 1L);
    }

    public Response<Long> decr(byte[] key) {
        return this.decr(new String(key));
    }

    public Response<Long> decrBy(String key, long integer) {
        return this.incrBy(key, -integer);
    }

    public Response<Long> decrBy(byte[] key, long integer) {
        return this.decrBy(new String(key), integer);
    }

    public Response<Long> incr(String key) {
        return this.incrBy(key, 1L);
    }

    public Response<Long> incr(byte[] key) {
        return this.incr(new String(key));
    }

    public synchronized Response<Long> incrBy(String key, long integer) {
        long oldValue;
        Response response = new Response(BuilderFactory.LONG);
        String val = this.getStringFromStorage(key, true);
        try {
            oldValue = val == null || "".equals(val) ? 0L : Long.parseLong(val);
        }
        catch (NumberFormatException ignored) {
            throw new JedisDataException("ERR value is not an integer or out of range");
        }
        if (oldValue > 0L ? integer > Long.MAX_VALUE - oldValue : integer < Long.MIN_VALUE - oldValue) {
            throw new JedisDataException("ERR value is not an integer or out of range");
        }
        long result = oldValue + integer;
        this.storage.put(key, Long.toString(result));
        response.set((Object)result);
        return response;
    }

    public Response<Long> incrBy(byte[] key, long integer) {
        return this.incrBy(new String(key), integer);
    }

    public synchronized Response<Double> incrByFloat(String key, double integer) {
        Double result;
        Response response = new Response(BuilderFactory.DOUBLE);
        String val = this.getStringFromStorage(key, true);
        try {
            result = val == null || "".equals(val) ? integer : Double.parseDouble(val) + integer;
        }
        catch (NumberFormatException ignored) {
            throw new JedisDataException("ERR value is not a valid float");
        }
        this.storage.put(key, result.toString());
        response.set((Object)result.toString().getBytes());
        return response;
    }

    public Response<Double> incrByFloat(byte[] key, double integer) {
        return this.incrByFloat(new String(key), integer);
    }

    public Response<List<String>> sort(String key) {
        return this.sort(key, new SortingParams());
    }

    public Response<Long> sort(String key, String dstkey) {
        return this.sort(key, new SortingParams(), dstkey);
    }

    private Comparator<String> makeComparator(Collection<String> params) {
        final int direction = params.contains(Protocol.Keyword.DESC.name().toLowerCase()) ? -1 : 1;
        Comparator<String> comparator = params.contains(Protocol.Keyword.ALPHA.name().toLowerCase()) ? new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2) * direction;
            }
        } : new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                Long i2;
                Long i1;
                try {
                    i1 = Long.parseLong(o1);
                    i2 = Long.parseLong(o2);
                }
                catch (NumberFormatException e) {
                    throw new JedisDataException("ERR One or more scores can't be converted into double");
                }
                return i1.compareTo(i2) * direction;
            }
        };
        return comparator;
    }

    public Response<List<String>> sort(String key, SortingParams sortingParameters) {
        LinkedList result = new LinkedList();
        KeyInformation info = this.keys.get(key);
        if (info != null) {
            switch (info.getType()) {
                case LIST: {
                    result.addAll(this.listStorage.get(key));
                    break;
                }
                case SET: {
                    result.addAll(this.setStorage.get(key));
                    break;
                }
                case SORTED_SET: {
                    throw new RuntimeException("Not implemented");
                }
                default: {
                    throw new JedisDataException("WRONGTYPE Operation against a key holding the wrong kind of value");
                }
            }
        }
        List<String> params = MockPipeline.convertToStrings(sortingParameters.getParams());
        Collections.sort(result, this.makeComparator(params));
        ArrayList<byte[]> byteResult = new ArrayList<byte[]>(result.size());
        int limitpos = params.indexOf(Protocol.Keyword.LIMIT.name().toLowerCase());
        if (limitpos >= 0) {
            int start = Math.max(Integer.parseInt(params.get(limitpos + 1)), 0);
            int end = Math.min(Integer.parseInt(params.get(limitpos + 2)) + start, result.size());
            for (String entry : result.subList(start, end)) {
                byteResult.add(entry.getBytes());
            }
        } else {
            for (String entry : result) {
                byteResult.add(entry.getBytes());
            }
        }
        Response response = new Response(BuilderFactory.STRING_LIST);
        response.set(byteResult);
        return response;
    }

    public Response<Long> sort(String key, SortingParams sortingParameters, String dstkey) {
        List sorted = (List)this.sort(key, sortingParameters).get();
        this.del(dstkey);
        this.keys.put(dstkey, new KeyInformation(KeyType.LIST));
        this.listStorage.put(dstkey, sorted);
        Response response = new Response(BuilderFactory.LONG);
        response.set((Object)sorted.size());
        return response;
    }

    public Response<List<byte[]>> sort(byte[] key) {
        return this.sort(key, new SortingParams());
    }

    public Response<Long> sort(byte[] key, byte[] dstkey) {
        return null;
    }

    public Response<List<byte[]>> sort(byte[] key, SortingParams sortingParameters) {
        return null;
    }

    public Response<Long> sort(byte[] key, SortingParams sortingParameters, byte[] dstkey) {
        return null;
    }

    public Response<Long> strlen(String key) {
        Response response = new Response(BuilderFactory.LONG);
        String val = this.getStringFromStorage(key, false);
        response.set((Object)(val == null ? 0L : (long)val.length()));
        return response;
    }

    public Response<Long> strlen(byte[] key) {
        return this.strlen(new String(key));
    }

    public Response<Long> del(String ... keys) {
        Response response = new Response(BuilderFactory.LONG);
        long result = 0L;
        for (String key : keys) {
            result += ((Long)this.del(key).get()).longValue();
        }
        response.set((Object)result);
        return response;
    }

    public Response<Long> del(byte[] ... keys) {
        Response response = new Response(BuilderFactory.LONG);
        long result = 0L;
        for (byte[] key : keys) {
            result += ((Long)this.del(key).get()).longValue();
        }
        response.set((Object)result);
        return response;
    }

    public synchronized Response<Long> del(String key) {
        Response response = new Response(BuilderFactory.LONG);
        long result = 0L;
        KeyInformation info = this.keys.remove(key);
        if (info != null) {
            switch (info.getType()) {
                case HASH: {
                    this.hashStorage.remove(key);
                    break;
                }
                case LIST: {
                    this.listStorage.remove(key);
                    break;
                }
                default: {
                    this.storage.remove(key);
                }
            }
            ++result;
        }
        response.set((Object)result);
        return response;
    }

    public Response<Long> del(byte[] key) {
        return this.del(new String(key));
    }

    public synchronized Response<String> hget(String key, String field) {
        Response response = new Response(BuilderFactory.STRING);
        Map<String, String> result = this.getHashFromStorage(key, false);
        if (result != null) {
            response.set(result.containsKey(field) ? result.get(field).getBytes() : null);
        }
        return response;
    }

    public synchronized Response<Map<String, String>> hgetAll(String key) {
        Response response = new Response(BuilderFactory.STRING_MAP);
        Map<String, String> result = this.getHashFromStorage(key, false);
        if (result != null) {
            ArrayList<byte[]> encodedResult = new ArrayList<byte[]>();
            for (Map.Entry<String, String> e : result.entrySet()) {
                encodedResult.add(SafeEncoder.encode((String)e.getKey()));
                encodedResult.add(SafeEncoder.encode((String)e.getValue()));
            }
            response.set(encodedResult);
        } else {
            response.set(new ArrayList());
        }
        return response;
    }

    public synchronized Response<Set<String>> hkeys(String key) {
        Response response = new Response(BuilderFactory.STRING_SET);
        Map<String, String> result = this.getHashFromStorage(key, false);
        if (result != null) {
            ArrayList<byte[]> encodedResult = new ArrayList<byte[]>();
            for (String k : result.keySet()) {
                encodedResult.add(SafeEncoder.encode((String)k));
            }
            response.set(encodedResult);
        } else {
            response.set(new ArrayList());
        }
        return response;
    }

    public synchronized Response<List<String>> hvals(String key) {
        Response response = new Response(BuilderFactory.STRING_LIST);
        Map<String, String> result = this.getHashFromStorage(key, false);
        if (result != null) {
            ArrayList<byte[]> encodedResult = new ArrayList<byte[]>();
            for (String v : result.values()) {
                encodedResult.add(SafeEncoder.encode((String)v));
            }
            response.set(encodedResult);
        } else {
            response.set(new ArrayList());
        }
        return response;
    }

    public synchronized Response<Long> hset(String key, String field, String value) {
        Response response = new Response(BuilderFactory.LONG);
        Map<String, String> m = this.getHashFromStorage(key, true);
        response.set((Object)(m.containsKey(field) ? 0L : 1L));
        m.put(field, value);
        return response;
    }

    public synchronized Response<Long> hsetnx(String key, String field, String value) {
        Response response = new Response(BuilderFactory.LONG);
        Map<String, String> m = this.getHashFromStorage(key, true);
        long result = 0L;
        if (!m.containsKey(field)) {
            m.put(field, value);
            result = 1L;
        }
        response.set((Object)result);
        return response;
    }

    public synchronized Response<List<String>> hmget(String key, String ... fields) {
        Response response = new Response(BuilderFactory.STRING_LIST);
        ArrayList<byte[]> result = new ArrayList<byte[]>();
        Map<String, String> hash = this.getHashFromStorage(key, false);
        if (hash == null) {
            for (String field : fields) {
                result.add(null);
            }
            response.set(result);
            return response;
        }
        for (String field : fields) {
            String v = this.getHashFromStorage(key, false).get(field);
            result.add(v != null ? v.getBytes() : null);
        }
        response.set(result);
        return response;
    }

    public synchronized Response<String> hmset(String key, Map<String, String> hash) {
        Response response = new Response(BuilderFactory.STRING);
        Map<String, String> m = this.getHashFromStorage(key, true);
        for (Map.Entry<String, String> e : hash.entrySet()) {
            m.put(e.getKey(), e.getValue());
        }
        response.set((Object)"OK".getBytes());
        return response;
    }

    public synchronized Response<Long> hincrBy(String key, String field, long value) {
        Long result;
        Response response = new Response(BuilderFactory.LONG);
        Map<String, String> m = this.getHashFromStorage(key, true);
        String val = m.get(field);
        if (val == null) {
            val = Long.valueOf(0L).toString();
        }
        try {
            result = Long.valueOf(val) + value;
        }
        catch (NumberFormatException ignored) {
            throw new JedisDataException("ERR value is not an integer or out of range");
        }
        m.put(field, result.toString());
        response.set((Object)result);
        return response;
    }

    public synchronized Response<Double> hincrByFloat(String key, String field, double value) {
        Double result;
        Response response = new Response(BuilderFactory.DOUBLE);
        Map<String, String> m = this.getHashFromStorage(key, true);
        String val = m.get(field);
        if (val == null) {
            val = Double.valueOf(0.0).toString();
        }
        try {
            result = Double.parseDouble(val) + value;
        }
        catch (NumberFormatException ignored) {
            throw new JedisDataException("ERR value is not a valid float");
        }
        m.put(field, result.toString());
        response.set((Object)result.toString().getBytes());
        return response;
    }

    public synchronized Response<Long> hdel(String key, String ... fields) {
        Response response = new Response(BuilderFactory.LONG);
        Map<String, String> m = this.getHashFromStorage(key, true);
        long result = 0L;
        for (String field : fields) {
            if (m.remove(field) == null) continue;
            ++result;
        }
        response.set((Object)result);
        return response;
    }

    public synchronized Response<Boolean> hexists(String key, String field) {
        Response response = new Response(BuilderFactory.BOOLEAN);
        Map<String, String> hash = this.getHashFromStorage(key, false);
        if (hash != null) {
            response.set((Object)(hash.containsKey(field) ? 1L : 0L));
        }
        return response;
    }

    public synchronized Response<Long> hlen(String key) {
        Response response = new Response(BuilderFactory.LONG);
        Map<String, String> hash = this.getHashFromStorage(key, false);
        if (hash != null) {
            response.set((Object)hash.size());
        } else {
            response.set((Object)0L);
        }
        return response;
    }

    public synchronized Response<Long> lpush(String key, String ... string) {
        Response response = new Response(BuilderFactory.LONG);
        List<String> list = this.getListFromStorage(key, true);
        if (list == null) {
            list = new ArrayList<String>();
            this.listStorage.put(key, list);
        }
        Collections.addAll(list, string);
        response.set((Object)list.size());
        return response;
    }

    public Response<Long> lpush(byte[] key, byte[] ... string) {
        return this.lpush(new String(key), MockPipeline.convertToStrings(string));
    }

    public synchronized Response<String> lpop(String key) {
        Response response = new Response(BuilderFactory.STRING);
        List<String> list = this.getListFromStorage(key, true);
        if (list == null || list.isEmpty()) {
            response.set(null);
        } else {
            response.set((Object)list.remove(list.size() - 1).getBytes());
        }
        return response;
    }

    public synchronized Response<byte[]> lpop(byte[] key) {
        Response response = new Response(BuilderFactory.BYTE_ARRAY);
        List<String> list = this.getListFromStorage(new String(key), true);
        if (list == null || list.isEmpty()) {
            response.set(null);
        } else {
            response.set((Object)list.remove(list.size() - 1).getBytes());
        }
        return response;
    }

    public synchronized Response<Long> llen(String key) {
        Response response = new Response(BuilderFactory.LONG);
        List<String> list = this.getListFromStorage(key, false);
        if (list == null) {
            response.set((Object)0L);
        } else {
            response.set((Object)list.size());
        }
        return response;
    }

    public Response<Long> llen(byte[] key) {
        return this.llen(new String(key));
    }

    public Response<List<String>> lrange(String key, long start, long end) {
        Response response = new Response(BuilderFactory.STRING_LIST);
        List<String> full = this.getListFromStorage(key, false);
        ArrayList<byte[]> selected = new ArrayList<byte[]>();
        response.set(selected);
        if (start < 0L) {
            start = Math.max((long)full.size() + start, 0L);
        }
        if (end < 0L) {
            end = (long)full.size() + end;
        }
        if (start > (long)full.size() || start > end) {
            return response;
        }
        end = Math.min((long)(full.size() - 1), end);
        int i = (int)start;
        while ((long)i <= end) {
            selected.add(full.get(i).getBytes());
            ++i;
        }
        return response;
    }

    public Response<List<byte[]>> lrange(byte[] key, long start, long end) {
        Response response = new Response(BuilderFactory.BYTE_ARRAY_LIST);
        List<String> full = this.getListFromStorage(new String(key), false);
        ArrayList<byte[]> selected = new ArrayList<byte[]>();
        response.set(selected);
        if (start < 0L) {
            start = Math.max((long)full.size() + start, 0L);
        }
        if (end < 0L) {
            end = (long)full.size() + end;
        }
        if (start > (long)full.size() || start > end) {
            return response;
        }
        end = Math.min((long)(full.size() - 1), end);
        int i = (int)start;
        while ((long)i <= end) {
            selected.add(full.get(i).getBytes());
            ++i;
        }
        return response;
    }

    public void sync() {
    }

    public synchronized Response<Set<String>> keys(String pattern) {
        Response response = new Response(BuilderFactory.STRING_SET);
        ArrayList<byte[]> result = new ArrayList<byte[]>();
        this.filterKeys(pattern, this.keys.keySet(), result);
        response.set(result);
        return response;
    }

    public Response<Set<byte[]>> keys(byte[] pattern) {
        Response response = new Response(BuilderFactory.BYTE_ARRAY_ZSET);
        ArrayList<byte[]> result = new ArrayList<byte[]>();
        for (String key : (Set)this.keys(new String(pattern)).get()) {
            result.add(key.getBytes());
        }
        response.set(result);
        return response;
    }

    public void filterKeys(String pattern, Collection<String> collection, List<byte[]> result) {
        for (String key : collection) {
            if (!this.wildcardMatcher.match(key, pattern)) continue;
            result.add(key.getBytes());
        }
    }

    protected boolean createOrUpdateKey(String key, KeyType type, boolean resetTTL) {
        KeyInformation info = this.keys.get(key);
        if (info == null) {
            info = new KeyInformation(type);
            this.keys.put(key, info);
            return true;
        }
        if (info.getType() != type) {
            throw new JedisDataException("ERR Operation against a key holding the wrong kind of value");
        }
        if (resetTTL) {
            info.setExpiration(-1L);
        }
        return false;
    }

    protected String getStringFromStorage(String key, boolean createIfNotExist) {
        KeyInformation info = this.keys.get(key);
        if (info == null) {
            if (createIfNotExist) {
                this.createOrUpdateKey(key, KeyType.STRING, true);
                this.storage.put(key, "");
                return "";
            }
            return null;
        }
        if (info.getType() != KeyType.STRING) {
            throw new JedisDataException("ERR Operation against a key holding the wrong kind of value");
        }
        if (info.isTTLSetAndKeyExpired()) {
            this.storage.remove(key);
            this.keys.remove(key);
            return null;
        }
        return this.storage.get(key);
    }

    protected Map<String, String> getHashFromStorage(String key, boolean createIfNotExist) {
        KeyInformation info = this.keys.get(key);
        if (info == null) {
            if (createIfNotExist) {
                this.createOrUpdateKey(key, KeyType.HASH, false);
                HashMap<String, String> result = new HashMap<String, String>();
                this.hashStorage.put(key, result);
                return result;
            }
            return null;
        }
        if (info.getType() != KeyType.HASH) {
            throw new JedisDataException("ERR Operation against a key holding the wrong kind of value");
        }
        if (info.isTTLSetAndKeyExpired()) {
            this.hashStorage.remove(key);
            this.keys.remove(key);
            return null;
        }
        return this.hashStorage.get(key);
    }

    protected List<String> getListFromStorage(String key, boolean createIfNotExist) {
        KeyInformation info = this.keys.get(key);
        if (info == null) {
            if (createIfNotExist) {
                this.createOrUpdateKey(key, KeyType.LIST, false);
                ArrayList<String> result = new ArrayList<String>();
                this.listStorage.put(key, result);
                return result;
            }
            return null;
        }
        if (info.getType() != KeyType.LIST) {
            throw new JedisDataException("ERR Operation against a key holding the wrong kind of value");
        }
        if (info.isTTLSetAndKeyExpired()) {
            this.listStorage.remove(key);
            this.keys.remove(key);
            return null;
        }
        return this.listStorage.get(key);
    }

    protected Set<String> getSetFromStorage(String key, boolean createIfNotExist) {
        KeyInformation info = this.keys.get(key);
        if (info == null) {
            if (createIfNotExist) {
                this.createOrUpdateKey(key, KeyType.SET, false);
                HashSet<String> result = new HashSet<String>();
                this.setStorage.put(key, result);
                return result;
            }
            return null;
        }
        if (info.getType() != KeyType.SET) {
            throw new JedisDataException("ERR Operation against a key holding the wrong kind of value");
        }
        if (info.isTTLSetAndKeyExpired()) {
            this.setStorage.remove(key);
            this.keys.remove(key);
            return null;
        }
        return this.setStorage.get(key);
    }

    protected static String[] convertToStrings(byte[][] b) {
        String[] result = new String[b.length];
        for (int i = 0; i < b.length; ++i) {
            result[i] = new String(b[i]);
        }
        return result;
    }

    protected static List<String> convertToStrings(Collection<byte[]> collection) {
        LinkedList<String> result = new LinkedList<String>();
        for (byte[] entry : collection) {
            result.add(new String(entry));
        }
        return result;
    }

    public synchronized Response<Long> sadd(String key, String ... members) {
        Response response = new Response(BuilderFactory.LONG);
        Set<String> set = this.getSetFromStorage(key, true);
        Long added = 0L;
        for (String s : members) {
            if (!set.add(s)) continue;
            Long l = added;
            Long l2 = added = Long.valueOf(added + 1L);
        }
        response.set((Object)added);
        return response;
    }

    public Response<Long> sadd(byte[] key, byte[] ... members) {
        return this.sadd(new String(key), MockPipeline.convertToStrings(members));
    }

    public synchronized Response<Long> srem(String key, String ... members) {
        Response response = new Response(BuilderFactory.LONG);
        Set<String> set = this.getSetFromStorage(key, true);
        Long removed = 0L;
        for (String s : members) {
            if (!set.remove(s)) continue;
            Long l = removed;
            Long l2 = removed = Long.valueOf(removed + 1L);
        }
        response.set((Object)removed);
        return response;
    }

    public Response<Long> srem(byte[] key, byte[] ... members) {
        return this.srem(new String(key), MockPipeline.convertToStrings(members));
    }

    public synchronized Response<Long> scard(String key) {
        Response response = new Response(BuilderFactory.LONG);
        Set<String> set = this.getSetFromStorage(key, true);
        response.set((Object)set.size());
        return response;
    }

    public Response<Long> scard(byte[] key) {
        return this.scard(new String(key));
    }

    public synchronized Response<Set<String>> sdiff(String ... keys) {
        if (keys.length <= 0) {
            throw new JedisDataException("ERR wrong number of arguments for 'sdiff' command");
        }
        Response response = new Response(BuilderFactory.STRING_SET);
        HashSet<String> firstSet = new HashSet<String>(this.getSetFromStorage(keys[0], true));
        for (int i = 1; i < keys.length; ++i) {
            Set<String> set = this.getSetFromStorage(keys[i], true);
            firstSet.removeAll(set);
        }
        ArrayList<byte[]> builderData = new ArrayList<byte[]>(firstSet.size());
        for (String value : firstSet) {
            builderData.add(value.getBytes());
        }
        response.set(builderData);
        return response;
    }

    public Response<Set<byte[]>> sdiff(byte[] ... keys) {
        Response response = new Response(BuilderFactory.BYTE_ARRAY_ZSET);
        Set members = (Set)this.sdiff(MockPipeline.convertToStrings(keys)).get();
        ArrayList<byte[]> result = new ArrayList<byte[]>(members.size());
        for (String member : members) {
            result.add(member.getBytes());
        }
        response.set(result);
        return response;
    }

    public synchronized Response<Long> sdiffstore(String dstKey, String ... keys) {
        if (keys.length <= 0) {
            throw new JedisDataException("ERR wrong number of arguments for 'sdiff' command");
        }
        Response response = new Response(BuilderFactory.LONG);
        Set diff = (Set)this.sdiff(keys).get();
        Set<String> dst = this.getSetFromStorage(dstKey, true);
        if (dst.size() > 0) {
            dst.clear();
        }
        dst.addAll(diff);
        response.set((Object)diff.size());
        return response;
    }

    public Response<Long> sdiffstore(byte[] dstKey, byte[] ... keys) {
        return this.sdiffstore(new String(dstKey), MockPipeline.convertToStrings(keys));
    }

    public synchronized Response<Set<String>> sinter(String ... keys) {
        if (keys.length <= 0) {
            throw new JedisDataException("ERR wrong number of arguments for 'sinter' command");
        }
        Response response = new Response(BuilderFactory.STRING_SET);
        HashSet<String> firstSet = new HashSet<String>(this.getSetFromStorage(keys[0], true));
        for (int i = 1; i < keys.length; ++i) {
            Set<String> set = this.getSetFromStorage(keys[i], true);
            firstSet.retainAll(set);
        }
        ArrayList<byte[]> builderData = new ArrayList<byte[]>(firstSet.size());
        for (String value : firstSet) {
            builderData.add(value.getBytes());
        }
        response.set(builderData);
        return response;
    }

    public synchronized Response<Set<byte[]>> sinter(byte[] ... keys) {
        Response response = new Response(BuilderFactory.BYTE_ARRAY_ZSET);
        Set members = (Set)this.sinter(MockPipeline.convertToStrings(keys)).get();
        ArrayList<byte[]> result = new ArrayList<byte[]>(members.size());
        for (String member : members) {
            result.add(member.getBytes());
        }
        response.set(result);
        return response;
    }

    public synchronized Response<Long> sinterstore(String dstKey, String ... keys) {
        if (keys.length <= 0) {
            throw new JedisDataException("ERR wrong number of arguments for 'sinterstore' command");
        }
        Response response = new Response(BuilderFactory.LONG);
        Set inter = (Set)this.sinter(keys).get();
        Set<String> dst = this.getSetFromStorage(dstKey, true);
        if (dst.size() > 0) {
            dst.clear();
        }
        dst.addAll(inter);
        response.set((Object)inter.size());
        return response;
    }

    public Response<Long> sinterstore(byte[] dstKey, byte[] ... keys) {
        return this.sinterstore(new String(dstKey), MockPipeline.convertToStrings(keys));
    }

    public synchronized Response<Boolean> sismember(String key, String member) {
        Response response = new Response(BuilderFactory.BOOLEAN);
        Set<String> set = this.getSetFromStorage(key, false);
        response.set((Object)(set.contains(member) ? 1L : 0L));
        return response;
    }

    public Response<Boolean> sismember(byte[] key, byte[] member) {
        return this.sismember(new String(key), new String(member));
    }

    public synchronized Response<Long> smove(String srckey, String dstkey, String member) {
        Response response = new Response(BuilderFactory.LONG);
        Set<String> src = this.getSetFromStorage(srckey, false);
        Set<String> dst = this.getSetFromStorage(dstkey, true);
        if (src.remove(member)) {
            dst.add(member);
            response.set((Object)1L);
        } else {
            response.set((Object)0L);
        }
        return response;
    }

    public Response<Long> smove(byte[] srckey, byte[] dstkey, byte[] member) {
        return this.smove(new String(srckey), new String(dstkey), new String(member));
    }

    public synchronized Response<String> spop(String key) {
        Response<String> response = this.srandmember(key);
        if (response.get() != null) {
            Set<String> src = this.getSetFromStorage(key, false);
            src.remove(response.get());
        }
        return response;
    }

    public Response<byte[]> spop(byte[] key) {
        Response response = new Response(BuilderFactory.BYTE_ARRAY);
        String result = (String)this.spop(new String(key)).get();
        response.set((Object)(result == null ? null : result.getBytes()));
        return response;
    }

    public synchronized Response<String> srandmember(String key) {
        Response response = new Response(BuilderFactory.STRING);
        Set<String> src = this.getSetFromStorage(key, false);
        if (src == null) {
            response.set(null);
        } else {
            String result = MockPipeline.getRandomElementFromSet(src);
            response.set((Object)result.getBytes());
        }
        return response;
    }

    public Response<byte[]> srandmember(byte[] key) {
        Response response = new Response(BuilderFactory.BYTE_ARRAY);
        String result = (String)this.srandmember(new String(key)).get();
        response.set((Object)(result == null ? null : result.getBytes()));
        return response;
    }

    public synchronized Response<Set<String>> smembers(String key) {
        Response response = new Response(BuilderFactory.STRING_SET);
        Set<String> set = this.getSetFromStorage(key, true);
        ArrayList<byte[]> builderData = new ArrayList<byte[]>(set.size());
        for (String s : set) {
            builderData.add(s.getBytes());
        }
        response.set(builderData);
        return response;
    }

    public Response<Set<byte[]>> smembers(byte[] key) {
        Response response = new Response(BuilderFactory.BYTE_ARRAY_ZSET);
        Set members = (Set)this.smembers(new String(key)).get();
        ArrayList<byte[]> result = new ArrayList<byte[]>(members.size());
        for (String member : members) {
            result.add(member.getBytes());
        }
        response.set(result);
        return response;
    }

    public synchronized Response<Set<String>> sunion(String ... keys) {
        if (keys.length <= 0) {
            throw new JedisDataException("ERR wrong number of arguments for 'sunion' command");
        }
        Response response = new Response(BuilderFactory.STRING_SET);
        HashSet<String> firstSet = new HashSet<String>(this.getSetFromStorage(keys[0], true));
        for (int i = 1; i < keys.length; ++i) {
            Set<String> set = this.getSetFromStorage(keys[i], true);
            firstSet.addAll(set);
        }
        ArrayList<byte[]> builderData = new ArrayList<byte[]>(firstSet.size());
        for (String value : firstSet) {
            builderData.add(value.getBytes());
        }
        response.set(builderData);
        return response;
    }

    public Response<Set<byte[]>> sunion(byte[] ... keys) {
        Response response = new Response(BuilderFactory.BYTE_ARRAY_ZSET);
        Set members = (Set)this.sunion(MockPipeline.convertToStrings(keys)).get();
        ArrayList<byte[]> result = new ArrayList<byte[]>(members.size());
        for (String member : members) {
            result.add(member.getBytes());
        }
        response.set(result);
        return response;
    }

    public synchronized Response<Long> sunionstore(String dstKey, String ... keys) {
        if (keys.length <= 0) {
            throw new JedisDataException("ERR wrong number of arguments for 'sunionstore' command");
        }
        Response response = new Response(BuilderFactory.LONG);
        Set inter = (Set)this.sunion(keys).get();
        Set<String> dst = this.getSetFromStorage(dstKey, true);
        if (dst.size() > 0) {
            dst.clear();
        }
        dst.addAll(inter);
        response.set((Object)inter.size());
        return response;
    }

    public Response<Long> sunionstore(byte[] dstKey, byte[] ... keys) {
        return this.sunionstore(new String(dstKey), MockPipeline.convertToStrings(keys));
    }
}

