/*
 * Decompiled with CFR 0.152.
 */
package com.fiftyonred.mock_jedis;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DataContainer
implements Comparable<DataContainer> {
    public static final Charset CHARSET = Charset.forName("UTF-8");
    private final byte[] bytes;
    private final String string;
    private final Source source;
    private final int hash;

    private DataContainer(byte[] bytes, String string, Source source) {
        this.bytes = bytes;
        this.string = string;
        this.source = source;
        this.hash = this.calculateHash(bytes, string, source);
    }

    public static DataContainer from(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        byte[] copy = Arrays.copyOf(bytes, bytes.length);
        String str = new String(copy, Charset.defaultCharset());
        return new DataContainer(copy, str, Source.BYTES);
    }

    public static DataContainer from(String str) {
        if (str == null) {
            return null;
        }
        byte[] bytes = str.getBytes(CHARSET);
        return new DataContainer(bytes, str, Source.STRING);
    }

    public static DataContainer[] from(String[] strings) {
        if (strings == null) {
            return null;
        }
        DataContainer[] result = new DataContainer[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            result[i] = DataContainer.from(strings[i]);
        }
        return result;
    }

    public static DataContainer[] from(byte[][] byteArrays) {
        if (byteArrays == null) {
            return null;
        }
        DataContainer[] result = new DataContainer[byteArrays.length];
        for (int i = 0; i < byteArrays.length; ++i) {
            result[i] = DataContainer.from(byteArrays[i]);
        }
        return result;
    }

    public static Map<DataContainer, DataContainer> fromByteMap(Map<byte[], byte[]> byteMap) {
        if (byteMap == null) {
            return null;
        }
        HashMap<DataContainer, DataContainer> result = new HashMap<DataContainer, DataContainer>(byteMap.size());
        for (Map.Entry<byte[], byte[]> entry : byteMap.entrySet()) {
            result.put(DataContainer.from(entry.getKey()), DataContainer.from(entry.getValue()));
        }
        return result;
    }

    public static Map<DataContainer, DataContainer> fromStringMap(Map<String, String> byteMap) {
        if (byteMap == null) {
            return null;
        }
        HashMap<DataContainer, DataContainer> result = new HashMap<DataContainer, DataContainer>(byteMap.size());
        for (Map.Entry<String, String> entry : byteMap.entrySet()) {
            result.put(DataContainer.from(entry.getKey()), DataContainer.from(entry.getValue()));
        }
        return result;
    }

    public static byte[] toBytes(DataContainer container) {
        if (container == null) {
            return null;
        }
        return container.getBytes();
    }

    public static List<byte[]> toBytes(Collection<DataContainer> containers) {
        if (containers == null) {
            return null;
        }
        ArrayList<byte[]> result = new ArrayList<byte[]>(containers.size());
        for (DataContainer container : containers) {
            result.add(DataContainer.toBytes(container));
        }
        return result;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public String getString() {
        return this.string;
    }

    public Source getSource() {
        return this.source;
    }

    public DataContainer append(DataContainer container) {
        switch (this.source) {
            case BYTES: {
                byte[] a = this.bytes;
                byte[] b = container.bytes;
                byte[] c = new byte[a.length + b.length];
                System.arraycopy(a, 0, c, 0, a.length);
                System.arraycopy(b, 0, c, a.length, b.length);
                return DataContainer.from(c);
            }
            case STRING: {
                return DataContainer.from(this.string + container.getString());
            }
        }
        throw new IllegalStateException("unimplemented");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DataContainer)) {
            return false;
        }
        DataContainer that = (DataContainer)o;
        if (this.source != that.source) {
            return Arrays.equals(this.bytes, that.bytes);
        }
        switch (this.source) {
            case BYTES: {
                return Arrays.equals(this.bytes, that.bytes);
            }
            case STRING: {
                return this.string.equals(that.string);
            }
        }
        throw new IllegalStateException("unimplemented");
    }

    public int hashCode() {
        return this.hash;
    }

    private int calculateHash(byte[] bytes, String string, Source source) {
        switch (source) {
            case BYTES: {
                return Arrays.hashCode(bytes);
            }
            case STRING: {
                return string.hashCode();
            }
        }
        return 0;
    }

    public String toString() {
        return this.string;
    }

    @Override
    public int compareTo(DataContainer o) {
        return this.string.compareTo(o.getString());
    }

    public static enum Source {
        BYTES,
        STRING;

    }
}

