/*
 * Decompiled with CFR 0.152.
 */
package com.fiftyonred.mock_jedis;

import com.fiftyonred.mock_jedis.DataContainer;
import com.fiftyonred.mock_jedis.KeyInformation;
import com.fiftyonred.mock_jedis.KeyType;
import com.fiftyonred.utils.WildcardMatcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.SortingParams;
import redis.clients.jedis.exceptions.JedisDataException;

public class MockStorage {
    private static final int NUM_DBS = 16;
    public static final long MILLISECONDS_IN_SECOND = 1000L;
    private final WildcardMatcher wildcardMatcher = new WildcardMatcher();
    private final List<Map<DataContainer, KeyInformation>> allKeys = new ArrayList<Map<DataContainer, KeyInformation>>(16);
    private final List<Map<DataContainer, DataContainer>> allStorage = new ArrayList<Map<DataContainer, DataContainer>>(16);
    private final List<Map<DataContainer, Map<DataContainer, DataContainer>>> allHashStorage = new ArrayList<Map<DataContainer, Map<DataContainer, DataContainer>>>(16);
    private final List<Map<DataContainer, List<DataContainer>>> allListStorage = new ArrayList<Map<DataContainer, List<DataContainer>>>(16);
    private final List<Map<DataContainer, Set<DataContainer>>> allSetStorage = new ArrayList<Map<DataContainer, Set<DataContainer>>>(16);
    private int currentDB;
    private Map<DataContainer, KeyInformation> keys;
    private Map<DataContainer, DataContainer> storage;
    private Map<DataContainer, Map<DataContainer, DataContainer>> hashStorage;
    private Map<DataContainer, List<DataContainer>> listStorage;
    private Map<DataContainer, Set<DataContainer>> setStorage;

    public MockStorage() {
        for (int i = 0; i < 16; ++i) {
            this.allKeys.add(new HashMap());
            this.allStorage.add(new HashMap());
            this.allHashStorage.add(new HashMap());
            this.allListStorage.add(new HashMap());
            this.allSetStorage.add(new HashMap());
        }
        this.select(0);
    }

    public int getCurrentDB() {
        return this.currentDB;
    }

    private static <T> T getRandomElementFromSet(Set<T> set) {
        return (T)set.toArray()[(int)(Math.random() * (double)set.size())];
    }

    public int dbSize() {
        return this.keys.size();
    }

    public synchronized void flushAll() {
        for (int dbNum = 0; dbNum < 16; ++dbNum) {
            this.allKeys.get(dbNum).clear();
            this.allStorage.get(dbNum).clear();
            this.allHashStorage.get(dbNum).clear();
            this.allListStorage.get(dbNum).clear();
        }
    }

    public synchronized void flushDB() {
        this.keys.clear();
        this.storage.clear();
        this.hashStorage.clear();
        this.listStorage.clear();
    }

    public synchronized void rename(DataContainer oldkey, DataContainer newkey) {
        if (oldkey.equals(newkey)) {
            throw new JedisDataException("ERR source and destination objects are the same");
        }
        KeyInformation info = this.keys.get(oldkey);
        switch (info.getType()) {
            case HASH: {
                this.hashStorage.put(newkey, this.hashStorage.get(oldkey));
                this.hashStorage.remove(oldkey);
                break;
            }
            case LIST: {
                this.listStorage.put(newkey, this.listStorage.get(oldkey));
                this.listStorage.remove(oldkey);
                break;
            }
            case SET: {
                this.setStorage.put(newkey, this.setStorage.get(oldkey));
                this.setStorage.remove(oldkey);
                break;
            }
            default: {
                this.storage.put(newkey, this.storage.get(oldkey));
                this.storage.remove(oldkey);
            }
        }
        this.keys.put(newkey, info);
        this.keys.remove(oldkey);
    }

    public synchronized boolean renamenx(DataContainer oldkey, DataContainer newkey) {
        if (oldkey.equals(newkey)) {
            throw new JedisDataException("ERR source and destination objects are the same");
        }
        KeyInformation newInfo = this.keys.get(newkey);
        if (newInfo == null) {
            this.rename(oldkey, newkey);
            return true;
        }
        return false;
    }

    public synchronized void set(DataContainer key, DataContainer value) {
        this.createOrUpdateKey(key, KeyType.STRING, true);
        this.storage.put(key, value);
    }

    public synchronized boolean setnx(DataContainer key, DataContainer value) {
        DataContainer result = this.getContainerFromStorage(key, false);
        if (result == null) {
            this.set(key, value);
            return true;
        }
        return false;
    }

    public DataContainer get(DataContainer key) {
        return this.getContainerFromStorage(key, false);
    }

    public synchronized DataContainer getSet(DataContainer key, DataContainer value) {
        DataContainer result = this.get(key);
        this.set(key, value);
        return result;
    }

    public boolean exists(DataContainer key) {
        return this.keys.containsKey(key);
    }

    public KeyType type(DataContainer key) {
        KeyInformation info = this.keys.get(key);
        return info == null ? null : info.getType();
    }

    public synchronized boolean move(DataContainer key, int dbIndex) {
        if (dbIndex < 0 || dbIndex >= 16) {
            throw new JedisDataException("ERR index out of range");
        }
        KeyInformation info = this.keys.get(key);
        if (info == null) {
            return false;
        }
        KeyInformation infoNew = this.allKeys.get(dbIndex).get(key);
        if (infoNew == null) {
            this.allKeys.get(dbIndex).put(key, info);
            switch (info.getType()) {
                case HASH: {
                    this.allHashStorage.get(dbIndex).put(key, this.hashStorage.get(key));
                    this.hashStorage.remove(key);
                    break;
                }
                case LIST: {
                    this.allListStorage.get(dbIndex).put(key, this.listStorage.get(key));
                    this.listStorage.remove(key);
                    break;
                }
                default: {
                    this.allStorage.get(dbIndex).put(key, this.storage.get(key));
                    this.storage.remove(key);
                }
            }
            this.keys.remove(key);
            return true;
        }
        return false;
    }

    public synchronized DataContainer randomKey() {
        return this.keys.isEmpty() ? null : MockStorage.getRandomElementFromSet(this.keys.keySet());
    }

    public synchronized void select(int dbIndex) {
        if (dbIndex < 0 || dbIndex >= 16) {
            throw new JedisDataException("ERR invalid DB index");
        }
        this.currentDB = dbIndex;
        this.keys = this.allKeys.get(dbIndex);
        this.storage = this.allStorage.get(dbIndex);
        this.hashStorage = this.allHashStorage.get(dbIndex);
        this.listStorage = this.allListStorage.get(dbIndex);
        this.setStorage = this.allSetStorage.get(dbIndex);
    }

    public synchronized boolean pexpireAt(DataContainer key, long millisecondsTimestamp) {
        KeyInformation info = this.keys.get(key);
        if (info == null || info.isTTLSetAndKeyExpired()) {
            return false;
        }
        info.setExpiration(millisecondsTimestamp);
        return true;
    }

    public synchronized void psetex(DataContainer key, int milliseconds, DataContainer value) {
        this.set(key, value);
        this.pexpireAt(key, System.currentTimeMillis() + (long)milliseconds);
    }

    public long ttl(DataContainer key) {
        Long pttlInResponse = this.pttl(key);
        if (pttlInResponse == -1L) {
            return pttlInResponse;
        }
        if (pttlInResponse > 0L && pttlInResponse < 1000L) {
            pttlInResponse = 1000L;
        }
        return pttlInResponse / 1000L;
    }

    public synchronized long append(DataContainer key, DataContainer value) {
        DataContainer container = this.getContainerFromStorage(key, true);
        DataContainer newVal = container.append(value);
        this.set(key, newVal);
        return newVal.getString().length();
    }

    public synchronized long pttl(DataContainer key) {
        KeyInformation info = this.keys.get(key);
        return info == null ? -1L : info.getTTL();
    }

    public synchronized boolean persist(DataContainer key) {
        KeyInformation info = this.keys.get(key);
        if (info.getTTL() == -1L) {
            return false;
        }
        info.setExpiration(-1L);
        return true;
    }

    public synchronized List<DataContainer> mget(DataContainer ... keys) {
        if (keys.length <= 0) {
            throw new JedisDataException("ERR wrong number of arguments for 'mget' command");
        }
        ArrayList<DataContainer> result = new ArrayList<DataContainer>(keys.length);
        for (DataContainer key : keys) {
            result.add(this.getContainerFromStorage(key, false));
        }
        return result;
    }

    public synchronized void mset(DataContainer ... keysvalues) {
        int l = keysvalues.length;
        if (l <= 0 || l % 2 != 0) {
            throw new JedisDataException("ERR wrong number of arguments for 'mset' command");
        }
        for (int i = 0; i < l; i += 2) {
            this.set(keysvalues[i], keysvalues[i + 1]);
        }
    }

    public synchronized boolean msetnx(DataContainer ... keysvalues) {
        int l = keysvalues.length;
        if (l <= 0 || l % 2 != 0) {
            throw new JedisDataException("ERR wrong number of arguments for 'msetnx' command");
        }
        boolean result = true;
        for (int i = 0; i < l; i += 2) {
            if (this.setnx(keysvalues[i], keysvalues[i + 1])) continue;
            result = false;
        }
        return result;
    }

    public synchronized long incrBy(DataContainer key, long integer) {
        long oldValue;
        DataContainer val = this.getContainerFromStorage(key, true);
        try {
            oldValue = val == null || val.getString().isEmpty() ? 0L : Long.parseLong(val.getString());
        }
        catch (NumberFormatException ignored) {
            throw new JedisDataException("ERR value is not an integer or out of range");
        }
        if (oldValue > 0L ? integer > Long.MAX_VALUE - oldValue : integer < Long.MIN_VALUE - oldValue) {
            throw new JedisDataException("ERR value is not an integer or out of range");
        }
        long result = oldValue + integer;
        this.storage.put(key, DataContainer.from(Long.toString(result)));
        return result;
    }

    public synchronized DataContainer incrByFloat(DataContainer key, double increment) {
        double result;
        DataContainer val = this.getContainerFromStorage(key, true);
        try {
            result = val == null || val.getString().isEmpty() ? increment : Double.parseDouble(val.getString()) + increment;
        }
        catch (NumberFormatException ignored) {
            throw new JedisDataException("ERR value is not a valid float");
        }
        val = DataContainer.from(Double.toString(result));
        this.storage.put(key, val);
        return val;
    }

    private static Comparator<DataContainer> makeComparator(Collection<String> params) {
        final int direction = params.contains(Protocol.Keyword.DESC.name().toLowerCase()) ? -1 : 1;
        Comparator<DataContainer> comparator = params.contains(Protocol.Keyword.ALPHA.name().toLowerCase()) ? new Comparator<DataContainer>(){

            @Override
            public int compare(DataContainer o1, DataContainer o2) {
                return o1.compareTo(o2) * direction;
            }
        } : new Comparator<DataContainer>(){

            @Override
            public int compare(DataContainer o1, DataContainer o2) {
                Long i2;
                Long i1;
                try {
                    i1 = Long.parseLong(o1.getString());
                    i2 = Long.parseLong(o2.getString());
                }
                catch (NumberFormatException e) {
                    throw new JedisDataException("ERR One or more scores can't be converted into double");
                }
                return i1.compareTo(i2) * direction;
            }
        };
        return comparator;
    }

    public List<DataContainer> sort(DataContainer key, SortingParams sortingParameters) {
        ArrayList result = new ArrayList();
        KeyInformation info = this.keys.get(key);
        if (info != null) {
            switch (info.getType()) {
                case LIST: {
                    result.addAll(this.listStorage.get(key));
                    break;
                }
                case SET: {
                    result.addAll(this.setStorage.get(key));
                    break;
                }
                case SORTED_SET: {
                    throw new RuntimeException("Not implemented");
                }
                default: {
                    throw new JedisDataException("WRONGTYPE Operation against a key holding the wrong kind of value");
                }
            }
        }
        List<String> params = MockStorage.convertToStrings(sortingParameters.getParams());
        Collections.sort(result, MockStorage.makeComparator(params));
        ArrayList<DataContainer> filteredResult = new ArrayList<DataContainer>(result.size());
        int limitpos = params.indexOf(Protocol.Keyword.LIMIT.name().toLowerCase());
        if (limitpos >= 0) {
            int start = Math.max(Integer.parseInt(params.get(limitpos + 1)), 0);
            int end = Math.min(Integer.parseInt(params.get(limitpos + 2)) + start, result.size());
            for (DataContainer entry : result.subList(start, end)) {
                filteredResult.add(entry);
            }
        } else {
            for (DataContainer entry : result) {
                filteredResult.add(entry);
            }
        }
        return filteredResult;
    }

    protected static List<String> convertToStrings(Collection<byte[]> collection) {
        ArrayList<String> result = new ArrayList<String>(collection.size());
        for (byte[] entry : collection) {
            result.add(new String(entry, DataContainer.CHARSET));
        }
        return result;
    }

    public synchronized int sort(DataContainer key, SortingParams sortingParameters, DataContainer dstkey) {
        List<DataContainer> sorted = this.sort(key, sortingParameters);
        this.del(dstkey);
        this.keys.put(dstkey, new KeyInformation(KeyType.LIST));
        this.listStorage.put(dstkey, sorted);
        return sorted.size();
    }

    public int strlen(DataContainer key) {
        DataContainer val = this.getContainerFromStorage(key, false);
        return val == null ? 0 : val.getString().length();
    }

    public long del(DataContainer ... keys) {
        long result = 0L;
        for (DataContainer key : keys) {
            if (!this.del(key)) continue;
            ++result;
        }
        return result;
    }

    public synchronized boolean del(DataContainer key) {
        KeyInformation info = this.keys.remove(key);
        if (info == null) {
            return false;
        }
        switch (info.getType()) {
            case HASH: {
                this.hashStorage.remove(key);
                break;
            }
            case LIST: {
                this.listStorage.remove(key);
                break;
            }
            case SET: {
                this.setStorage.remove(key);
                break;
            }
            default: {
                this.storage.remove(key);
            }
        }
        return true;
    }

    public DataContainer hget(DataContainer key, DataContainer field) {
        Map<DataContainer, DataContainer> result = this.getHashFromStorage(key, false);
        if (result == null) {
            return null;
        }
        return result.get(field);
    }

    public Map<DataContainer, DataContainer> hgetAll(DataContainer key) {
        return this.getHashFromStorage(key, false);
    }

    public Set<DataContainer> hkeys(DataContainer key) {
        Map<DataContainer, DataContainer> result = this.getHashFromStorage(key, false);
        return result == null ? null : result.keySet();
    }

    public Collection<DataContainer> hvals(DataContainer key) {
        Map<DataContainer, DataContainer> result = this.getHashFromStorage(key, false);
        return result == null ? null : result.values();
    }

    public synchronized boolean hset(DataContainer key, DataContainer field, DataContainer value) {
        Map<DataContainer, DataContainer> m = this.getHashFromStorage(key, true);
        DataContainer previousValue = m.put(field, value);
        return previousValue == null;
    }

    public synchronized boolean hsetnx(DataContainer key, DataContainer field, DataContainer value) {
        Map<DataContainer, DataContainer> m = this.getHashFromStorage(key, true);
        if (m.containsKey(field)) {
            return false;
        }
        m.put(field, value);
        return true;
    }

    public List<DataContainer> hmget(DataContainer key, DataContainer ... fields) {
        Map<DataContainer, DataContainer> hash = this.getHashFromStorage(key, false);
        if (hash == null) {
            return null;
        }
        ArrayList<DataContainer> result = new ArrayList<DataContainer>();
        for (DataContainer field : fields) {
            result.add(hash.get(field));
        }
        return result;
    }

    public synchronized void hmset(DataContainer key, Map<DataContainer, DataContainer> hash) {
        Map<DataContainer, DataContainer> m = this.getHashFromStorage(key, true);
        for (Map.Entry<DataContainer, DataContainer> e : hash.entrySet()) {
            m.put(e.getKey(), e.getValue());
        }
    }

    public synchronized long hincrBy(DataContainer key, DataContainer field, long value) {
        long result;
        Map<DataContainer, DataContainer> m = this.getHashFromStorage(key, true);
        DataContainer val = m.get(field);
        if (val == null) {
            val = DataContainer.from(Long.valueOf(0L).toString());
        }
        try {
            result = Long.valueOf(val.getString()) + value;
        }
        catch (NumberFormatException ignored) {
            throw new JedisDataException("ERR value is not an integer or out of range");
        }
        m.put(field, DataContainer.from(Long.toString(result)));
        return result;
    }

    public synchronized DataContainer hincrByFloat(DataContainer key, DataContainer field, double increment) {
        double result;
        Map<DataContainer, DataContainer> m = this.getHashFromStorage(key, true);
        DataContainer val = m.get(field);
        if (val == null) {
            val = DataContainer.from(Double.toString(0.0));
        }
        try {
            result = Double.parseDouble(val.toString()) + increment;
        }
        catch (NumberFormatException ignored) {
            throw new JedisDataException("ERR value is not a valid float");
        }
        DataContainer resultContainer = DataContainer.from(Double.toString(result));
        m.put(field, resultContainer);
        return resultContainer;
    }

    public synchronized long hdel(DataContainer key, DataContainer ... fields) {
        Map<DataContainer, DataContainer> m = this.getHashFromStorage(key, true);
        long result = 0L;
        for (DataContainer currentField : fields) {
            if (m.remove(currentField) == null) continue;
            ++result;
        }
        return result;
    }

    public boolean hexists(DataContainer key, DataContainer field) {
        Map<DataContainer, DataContainer> hash = this.getHashFromStorage(key, false);
        return hash != null && hash.containsKey(field);
    }

    public int hlen(DataContainer key) {
        Map<DataContainer, DataContainer> hash = this.getHashFromStorage(key, false);
        return hash == null ? 0 : hash.size();
    }

    public synchronized int lpush(DataContainer key, DataContainer ... string) {
        List<DataContainer> list = this.getListFromStorage(key, true);
        if (list == null) {
            list = new ArrayList<DataContainer>();
            this.listStorage.put(key, list);
        }
        Collections.addAll(list, string);
        return list.size();
    }

    public synchronized DataContainer lpop(DataContainer key) {
        List<DataContainer> list = this.getListFromStorage(key, true);
        return list == null || list.isEmpty() ? null : list.remove(list.size() - 1);
    }

    public synchronized int llen(DataContainer key) {
        List<DataContainer> list = this.getListFromStorage(key, false);
        return list == null ? 0 : list.size();
    }

    public synchronized List<DataContainer> lrange(DataContainer key, long start, long end) {
        List<DataContainer> full = this.getListFromStorage(key, false);
        ArrayList<DataContainer> result = new ArrayList<DataContainer>();
        if (start < 0L) {
            start = Math.max((long)full.size() + start, 0L);
        }
        if (end < 0L) {
            end = (long)full.size() + end;
        }
        if (start > (long)full.size() || start > end) {
            return Collections.emptyList();
        }
        end = Math.min((long)(full.size() - 1), end);
        int i = (int)start;
        while ((long)i <= end) {
            result.add(full.get(i));
            ++i;
        }
        return result;
    }

    public Set<DataContainer> keys(DataContainer pattern) {
        HashSet<DataContainer> result = new HashSet<DataContainer>();
        for (DataContainer key : this.keys.keySet()) {
            if (!this.wildcardMatcher.match(key.getString(), pattern.getString())) continue;
            result.add(key);
        }
        return result;
    }

    protected boolean createOrUpdateKey(DataContainer key, KeyType type, boolean resetTTL) {
        KeyInformation info = this.keys.get(key);
        if (info == null) {
            info = new KeyInformation(type);
            this.keys.put(key, info);
            return true;
        }
        if (info.getType() != type) {
            throw new JedisDataException("ERR Operation against a key holding the wrong kind of value");
        }
        if (resetTTL) {
            info.setExpiration(-1L);
        }
        return false;
    }

    protected DataContainer getContainerFromStorage(DataContainer key, boolean createIfNotExist) {
        KeyInformation info = this.keys.get(key);
        if (info == null) {
            if (createIfNotExist) {
                this.createOrUpdateKey(key, KeyType.STRING, true);
                DataContainer container = DataContainer.from("");
                this.storage.put(key, container);
                return container;
            }
            return null;
        }
        if (info.getType() != KeyType.STRING) {
            throw new JedisDataException("ERR Operation against a key holding the wrong kind of value");
        }
        if (info.isTTLSetAndKeyExpired()) {
            this.storage.remove(key);
            this.keys.remove(key);
            return null;
        }
        return this.storage.get(key);
    }

    protected Map<DataContainer, DataContainer> getHashFromStorage(DataContainer key, boolean createIfNotExist) {
        KeyInformation info = this.keys.get(key);
        if (info == null) {
            if (createIfNotExist) {
                this.createOrUpdateKey(key, KeyType.HASH, false);
                HashMap<DataContainer, DataContainer> result = new HashMap<DataContainer, DataContainer>();
                this.hashStorage.put(key, result);
                return result;
            }
            return null;
        }
        if (info.getType() != KeyType.HASH) {
            throw new JedisDataException("ERR Operation against a key holding the wrong kind of value");
        }
        if (info.isTTLSetAndKeyExpired()) {
            this.hashStorage.remove(key);
            this.keys.remove(key);
            return null;
        }
        return this.hashStorage.get(key);
    }

    protected List<DataContainer> getListFromStorage(DataContainer key, boolean createIfNotExist) {
        KeyInformation info = this.keys.get(key);
        if (info == null) {
            if (createIfNotExist) {
                this.createOrUpdateKey(key, KeyType.LIST, false);
                ArrayList<DataContainer> result = new ArrayList<DataContainer>();
                this.listStorage.put(key, result);
                return result;
            }
            return null;
        }
        if (info.getType() != KeyType.LIST) {
            throw new JedisDataException("ERR Operation against a key holding the wrong kind of value");
        }
        if (info.isTTLSetAndKeyExpired()) {
            this.listStorage.remove(key);
            this.keys.remove(key);
            return null;
        }
        return this.listStorage.get(key);
    }

    protected Set<DataContainer> getSetFromStorage(DataContainer key, boolean createIfNotExist) {
        KeyInformation info = this.keys.get(key);
        if (info == null) {
            if (createIfNotExist) {
                this.createOrUpdateKey(key, KeyType.SET, false);
                HashSet<DataContainer> result = new HashSet<DataContainer>();
                this.setStorage.put(key, result);
                return result;
            }
            return null;
        }
        if (info.getType() != KeyType.SET) {
            throw new JedisDataException("ERR Operation against a key holding the wrong kind of value");
        }
        if (info.isTTLSetAndKeyExpired()) {
            this.setStorage.remove(key);
            this.keys.remove(key);
            return null;
        }
        return this.setStorage.get(key);
    }

    public synchronized long sadd(DataContainer key, DataContainer ... members) {
        Set<DataContainer> set = this.getSetFromStorage(key, true);
        long added = 0L;
        for (DataContainer s : members) {
            if (!set.add(s)) continue;
            ++added;
        }
        return added;
    }

    public synchronized long srem(DataContainer key, DataContainer ... member) {
        Set<DataContainer> set = this.getSetFromStorage(key, true);
        long removed = 0L;
        for (DataContainer s : member) {
            if (!set.remove(s)) continue;
            ++removed;
        }
        return removed;
    }

    public synchronized int scard(DataContainer key) {
        Set<DataContainer> set = this.getSetFromStorage(key, true);
        return set.size();
    }

    public synchronized Set<DataContainer> sdiff(DataContainer ... keys) {
        int l = keys.length;
        if (l <= 0) {
            throw new JedisDataException("ERR wrong number of arguments for 'sdiff' command");
        }
        HashSet<DataContainer> result = new HashSet<DataContainer>(this.getSetFromStorage(keys[0], true));
        for (int i = 1; i < l; ++i) {
            Set<DataContainer> set = this.getSetFromStorage(keys[i], true);
            result.removeAll(set);
        }
        return result;
    }

    public synchronized int sdiffstore(DataContainer dstKey, DataContainer ... keys) {
        if (keys.length <= 0) {
            throw new JedisDataException("ERR wrong number of arguments for 'sdiff' command");
        }
        Set<DataContainer> diff = this.sdiff(keys);
        Set<DataContainer> dst = this.getSetFromStorage(dstKey, true);
        if (!dst.isEmpty()) {
            dst.clear();
        }
        dst.addAll(diff);
        return diff.size();
    }

    public synchronized Set<DataContainer> sinter(DataContainer ... keys) {
        int l = keys.length;
        if (l <= 0) {
            throw new JedisDataException("ERR wrong number of arguments for 'sinter' command");
        }
        HashSet<DataContainer> firstSet = new HashSet<DataContainer>(this.getSetFromStorage(keys[0], true));
        for (int i = 1; i < l; ++i) {
            Set<DataContainer> set = this.getSetFromStorage(keys[i], true);
            firstSet.retainAll(set);
        }
        return firstSet;
    }

    public synchronized int sinterstore(DataContainer dstKey, DataContainer ... keys) {
        if (keys.length <= 0) {
            throw new JedisDataException("ERR wrong number of arguments for 'sinterstore' command");
        }
        Set<DataContainer> inter = this.sinter(keys);
        Set<DataContainer> dst = this.getSetFromStorage(dstKey, true);
        if (!dst.isEmpty()) {
            dst.clear();
        }
        dst.addAll(inter);
        return inter.size();
    }

    public boolean sismember(DataContainer key, DataContainer member) {
        Set<DataContainer> set = this.getSetFromStorage(key, false);
        return set != null && set.contains(member);
    }

    public synchronized boolean smove(DataContainer srckey, DataContainer dstkey, DataContainer member) {
        Set<DataContainer> src = this.getSetFromStorage(srckey, false);
        Set<DataContainer> dst = this.getSetFromStorage(dstkey, true);
        if (!src.remove(member)) {
            return false;
        }
        dst.add(member);
        return true;
    }

    public synchronized DataContainer spop(DataContainer key) {
        DataContainer member = this.srandmember(key);
        if (member != null) {
            Set<DataContainer> src = this.getSetFromStorage(key, false);
            src.remove(member);
        }
        return member;
    }

    public synchronized DataContainer srandmember(DataContainer key) {
        Set<DataContainer> src = this.getSetFromStorage(key, false);
        return src == null ? null : MockStorage.getRandomElementFromSet(src);
    }

    public synchronized Set<DataContainer> smembers(DataContainer key) {
        return this.getSetFromStorage(key, true);
    }

    public synchronized Set<DataContainer> sunion(DataContainer ... keys) {
        int l = keys.length;
        if (l <= 0) {
            throw new JedisDataException("ERR wrong number of arguments for 'sunion' command");
        }
        HashSet<DataContainer> result = new HashSet<DataContainer>(this.getSetFromStorage(keys[0], true));
        for (int i = 1; i < l; ++i) {
            Set<DataContainer> set = this.getSetFromStorage(keys[i], true);
            result.addAll(set);
        }
        return result;
    }

    public synchronized int sunionstore(DataContainer dstkey, DataContainer ... keys) {
        if (keys.length <= 0) {
            throw new JedisDataException("ERR wrong number of arguments for 'sunionstore' command");
        }
        Set<DataContainer> inter = this.sunion(keys);
        Set<DataContainer> dst = this.getSetFromStorage(dstkey, true);
        if (!dst.isEmpty()) {
            dst.clear();
        }
        dst.addAll(inter);
        return inter.size();
    }
}

