/*
 * Decompiled with CFR 0.152.
 */
package com.files.models;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.files.FilesClient;
import com.files.FilesConfig;
import com.files.ListIterator;
import com.files.models.Export;
import com.files.models.ModelInterface;
import com.files.net.HttpMethods;
import com.files.util.ModelUtils;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class FormFieldSet
implements ModelInterface {
    private HashMap<String, Object> options;
    private ObjectMapper objectMapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().disable(new MapperFeature[]{MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS})).disable(new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS})).defaultDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX"))).build();
    @JsonProperty(value="id")
    public Long id;
    @JsonProperty(value="title")
    public String title;
    @JsonProperty(value="form_layout")
    public Long[] formLayout;
    @JsonProperty(value="form_fields")
    public Object[] formFields;
    @JsonProperty(value="skip_name")
    public Boolean skipName;
    @JsonProperty(value="skip_email")
    public Boolean skipEmail;
    @JsonProperty(value="skip_company")
    public Boolean skipCompany;
    @JsonProperty(value="user_id")
    public Long userId;

    public FormFieldSet() {
        this(null, null);
    }

    public FormFieldSet(HashMap<String, Object> parameters) {
        this(parameters, null);
    }

    public FormFieldSet(HashMap<String, Object> parameters, HashMap<String, Object> options) {
        this.options = options;
        try {
            ObjectReader objectReader = this.objectMapper.readerForUpdating((Object)this);
            objectReader.readValue(this.objectMapper.writeValueAsString(parameters));
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }

    public FormFieldSet update() throws IOException {
        HashMap<String, Object> parameters = ModelUtils.toParameterMap(this.objectMapper.writeValueAsString((Object)this));
        return FormFieldSet.update(this.id, parameters, this.options);
    }

    public void delete() throws IOException {
        HashMap<String, Object> parameters = ModelUtils.toParameterMap(this.objectMapper.writeValueAsString((Object)this));
        FormFieldSet.delete(this.id, parameters, this.options);
    }

    public void destroy(HashMap<String, Object> parameters) throws IOException {
        this.delete();
    }

    public void save() throws IOException {
        HashMap<String, Object> parameters = ModelUtils.toParameterMap(this.objectMapper.writeValueAsString((Object)this));
        FormFieldSet.create(parameters, this.options);
    }

    public static ListIterator<FormFieldSet> list() throws RuntimeException {
        return FormFieldSet.list(null, null);
    }

    public static ListIterator<FormFieldSet> list(HashMap<String, Object> parameters) throws RuntimeException {
        return FormFieldSet.list(parameters, null);
    }

    public static ListIterator<FormFieldSet> list(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (parameters.containsKey("user_id") && !(parameters.get("user_id") instanceof Long)) {
            throw new IllegalArgumentException("Bad parameter: user_id must be of type Long parameters[\"user_id\"]");
        }
        if (parameters.containsKey("cursor") && !(parameters.get("cursor") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: cursor must be of type String parameters[\"cursor\"]");
        }
        if (parameters.containsKey("per_page") && !(parameters.get("per_page") instanceof Long)) {
            throw new IllegalArgumentException("Bad parameter: per_page must be of type Long parameters[\"per_page\"]");
        }
        String url = String.format("%s%s/form_field_sets", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase());
        TypeReference<List<FormFieldSet>> typeReference = new TypeReference<List<FormFieldSet>>(){};
        return FilesClient.requestList(url, HttpMethods.RequestMethods.GET, typeReference, parameters, options);
    }

    public static ListIterator<FormFieldSet> all() throws RuntimeException {
        return FormFieldSet.all(null, null);
    }

    public static ListIterator<FormFieldSet> all(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return FormFieldSet.list(parameters, options);
    }

    public static FormFieldSet find(Long id, HashMap<String, Object> parameters) throws RuntimeException {
        return FormFieldSet.find(id, parameters, null);
    }

    public static FormFieldSet find(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return FormFieldSet.find(null, parameters, options);
    }

    public static FormFieldSet find(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (id == null && parameters.containsKey("id") && parameters.get("id") != null) {
            id = (Long)parameters.get("id");
        }
        if (id == null) {
            throw new NullPointerException("Argument or Parameter missing: id parameters[\"id\"]");
        }
        if (!(id instanceof Long)) {
            throw new IllegalArgumentException("Bad parameter: id must be of type Long parameters[\"id\"]");
        }
        Object[] urlParts = new String[]{FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), String.valueOf(id)};
        for (int i = 2; i < urlParts.length; ++i) {
            try {
                urlParts[i] = new URI(null, null, (String)urlParts[i], null).getRawPath();
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        String url = String.format("%s%s/form_field_sets/%s", urlParts);
        TypeReference<FormFieldSet> typeReference = new TypeReference<FormFieldSet>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.GET, typeReference, parameters, options);
    }

    public static FormFieldSet get() throws RuntimeException {
        return FormFieldSet.get(null, null, null);
    }

    public static FormFieldSet get(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return FormFieldSet.find(id, parameters, options);
    }

    public static FormFieldSet create(HashMap<String, Object> parameters) throws RuntimeException {
        return FormFieldSet.create(parameters, null);
    }

    public static FormFieldSet create(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (parameters.containsKey("user_id") && !(parameters.get("user_id") instanceof Long)) {
            throw new IllegalArgumentException("Bad parameter: user_id must be of type Long parameters[\"user_id\"]");
        }
        if (parameters.containsKey("title") && !(parameters.get("title") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: title must be of type String parameters[\"title\"]");
        }
        if (parameters.containsKey("skip_email") && !(parameters.get("skip_email") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: skip_email must be of type Boolean parameters[\"skip_email\"]");
        }
        if (parameters.containsKey("skip_name") && !(parameters.get("skip_name") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: skip_name must be of type Boolean parameters[\"skip_name\"]");
        }
        if (parameters.containsKey("skip_company") && !(parameters.get("skip_company") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: skip_company must be of type Boolean parameters[\"skip_company\"]");
        }
        if (parameters.containsKey("form_fields") && !(parameters.get("form_fields") instanceof Object[])) {
            throw new IllegalArgumentException("Bad parameter: form_fields must be of type Object[] parameters[\"form_fields\"]");
        }
        String url = String.format("%s%s/form_field_sets", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase());
        TypeReference<FormFieldSet> typeReference = new TypeReference<FormFieldSet>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.POST, typeReference, parameters, options);
    }

    public static Export createExport(HashMap<String, Object> parameters) throws RuntimeException {
        return FormFieldSet.createExport(parameters, null);
    }

    public static Export createExport(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (parameters.containsKey("user_id") && !(parameters.get("user_id") instanceof Long)) {
            throw new IllegalArgumentException("Bad parameter: user_id must be of type Long parameters[\"user_id\"]");
        }
        String url = String.format("%s%s/form_field_sets/create_export", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase());
        TypeReference<Export> typeReference = new TypeReference<Export>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.POST, typeReference, parameters, options);
    }

    public static FormFieldSet update(Long id, HashMap<String, Object> parameters) throws RuntimeException {
        return FormFieldSet.update(id, parameters, null);
    }

    public static FormFieldSet update(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return FormFieldSet.update(null, parameters, options);
    }

    public static FormFieldSet update(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (id == null && parameters.containsKey("id") && parameters.get("id") != null) {
            id = (Long)parameters.get("id");
        }
        if (id == null) {
            throw new NullPointerException("Argument or Parameter missing: id parameters[\"id\"]");
        }
        if (!(id instanceof Long)) {
            throw new IllegalArgumentException("Bad parameter: id must be of type Long parameters[\"id\"]");
        }
        if (parameters.containsKey("title") && !(parameters.get("title") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: title must be of type String parameters[\"title\"]");
        }
        if (parameters.containsKey("skip_email") && !(parameters.get("skip_email") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: skip_email must be of type Boolean parameters[\"skip_email\"]");
        }
        if (parameters.containsKey("skip_name") && !(parameters.get("skip_name") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: skip_name must be of type Boolean parameters[\"skip_name\"]");
        }
        if (parameters.containsKey("skip_company") && !(parameters.get("skip_company") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: skip_company must be of type Boolean parameters[\"skip_company\"]");
        }
        if (parameters.containsKey("form_fields") && !(parameters.get("form_fields") instanceof Object[])) {
            throw new IllegalArgumentException("Bad parameter: form_fields must be of type Object[] parameters[\"form_fields\"]");
        }
        Object[] urlParts = new String[]{FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), String.valueOf(id)};
        for (int i = 2; i < urlParts.length; ++i) {
            try {
                urlParts[i] = new URI(null, null, (String)urlParts[i], null).getRawPath();
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        String url = String.format("%s%s/form_field_sets/%s", urlParts);
        TypeReference<FormFieldSet> typeReference = new TypeReference<FormFieldSet>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.PATCH, typeReference, parameters, options);
    }

    public static void delete(Long id, HashMap<String, Object> parameters) throws RuntimeException {
        FormFieldSet.delete(id, parameters, null);
    }

    public static void delete(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        FormFieldSet.delete(null, parameters, options);
    }

    public static void delete(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (id == null && parameters.containsKey("id") && parameters.get("id") != null) {
            id = (Long)parameters.get("id");
        }
        if (id == null) {
            throw new NullPointerException("Argument or Parameter missing: id parameters[\"id\"]");
        }
        if (!(id instanceof Long)) {
            throw new IllegalArgumentException("Bad parameter: id must be of type Long parameters[\"id\"]");
        }
        Object[] urlParts = new String[]{FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), String.valueOf(id)};
        for (int i = 2; i < urlParts.length; ++i) {
            try {
                urlParts[i] = new URI(null, null, (String)urlParts[i], null).getRawPath();
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        String url = String.format("%s%s/form_field_sets/%s", urlParts);
        FilesClient.apiRequest(url, HttpMethods.RequestMethods.DELETE, parameters, options);
    }

    public static void destroy() throws RuntimeException {
        FormFieldSet.destroy(null, null, null);
    }

    public static void destroy(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        FormFieldSet.delete(id, parameters, options);
    }

    @Override
    @Generated
    public void setOptions(HashMap<String, Object> options) {
        this.options = options;
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @JsonProperty(value="title")
    @Generated
    public void setTitle(String title) {
        this.title = title;
    }

    @Generated
    public Long[] getFormLayout() {
        return this.formLayout;
    }

    @JsonProperty(value="form_layout")
    @Generated
    public void setFormLayout(Long[] formLayout) {
        this.formLayout = formLayout;
    }

    @Generated
    public Object[] getFormFields() {
        return this.formFields;
    }

    @JsonProperty(value="form_fields")
    @Generated
    public void setFormFields(Object[] formFields) {
        this.formFields = formFields;
    }

    @Generated
    public Boolean getSkipName() {
        return this.skipName;
    }

    @JsonProperty(value="skip_name")
    @Generated
    public void setSkipName(Boolean skipName) {
        this.skipName = skipName;
    }

    @Generated
    public Boolean getSkipEmail() {
        return this.skipEmail;
    }

    @JsonProperty(value="skip_email")
    @Generated
    public void setSkipEmail(Boolean skipEmail) {
        this.skipEmail = skipEmail;
    }

    @Generated
    public Boolean getSkipCompany() {
        return this.skipCompany;
    }

    @JsonProperty(value="skip_company")
    @Generated
    public void setSkipCompany(Boolean skipCompany) {
        this.skipCompany = skipCompany;
    }

    @Generated
    public Long getUserId() {
        return this.userId;
    }

    @JsonProperty(value="user_id")
    @Generated
    public void setUserId(Long userId) {
        this.userId = userId;
    }
}

