/*
 * Decompiled with CFR 0.152.
 */
package com.files.models;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.files.FilesClient;
import com.files.FilesConfig;
import com.files.ListIterator;
import com.files.models.Action;
import com.files.models.Export;
import com.files.models.ModelInterface;
import com.files.net.HttpMethods;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class History
implements ModelInterface {
    private HashMap<String, Object> options;
    private ObjectMapper objectMapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().disable(new MapperFeature[]{MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS})).disable(new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS})).defaultDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX"))).build();
    @JsonProperty(value="id")
    public Long id;
    @JsonProperty(value="path")
    public String path;
    @JsonProperty(value="when")
    public Date when;
    @JsonProperty(value="destination")
    public String destination;
    @JsonProperty(value="display")
    public String display;
    @JsonProperty(value="ip")
    public String ip;
    @JsonProperty(value="source")
    public String source;
    @JsonProperty(value="targets")
    public Map<String, String> targets;
    @JsonProperty(value="user_id")
    public Long userId;
    @JsonProperty(value="username")
    public String username;
    @JsonProperty(value="user_is_from_parent_site")
    public Boolean userIsFromParentSite;
    @JsonProperty(value="action")
    public String action;
    @JsonProperty(value="failure_type")
    public String failureType;
    @JsonProperty(value="interface")
    public String interfaceName;

    public History() {
        this(null, null);
    }

    public History(HashMap<String, Object> parameters) {
        this(parameters, null);
    }

    public History(HashMap<String, Object> parameters, HashMap<String, Object> options) {
        this.options = options;
        try {
            ObjectReader objectReader = this.objectMapper.readerForUpdating((Object)this);
            objectReader.readValue(this.objectMapper.writeValueAsString(parameters));
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }

    public static ListIterator<Action> listForFile() throws RuntimeException {
        return History.listForFile(null, null, null);
    }

    public static ListIterator<Action> listForFile(String path, HashMap<String, Object> parameters) throws RuntimeException {
        return History.listForFile(path, parameters, null);
    }

    public static ListIterator<Action> listForFile(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return History.listForFile(null, parameters, options);
    }

    public static ListIterator<Action> listForFile(String path, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (path == null && parameters.containsKey("path") && parameters.get("path") != null) {
            path = (String)parameters.get("path");
        }
        if (path == null) {
            throw new NullPointerException("Argument or Parameter missing: path parameters[\"path\"]");
        }
        if (parameters.containsKey("start_at") && !(parameters.get("start_at") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: start_at must be of type String parameters[\"start_at\"]");
        }
        if (parameters.containsKey("end_at") && !(parameters.get("end_at") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: end_at must be of type String parameters[\"end_at\"]");
        }
        if (parameters.containsKey("display") && !(parameters.get("display") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: display must be of type String parameters[\"display\"]");
        }
        if (parameters.containsKey("cursor") && !(parameters.get("cursor") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: cursor must be of type String parameters[\"cursor\"]");
        }
        if (parameters.containsKey("per_page") && !(parameters.get("per_page") instanceof Long)) {
            throw new IllegalArgumentException("Bad parameter: per_page must be of type Long parameters[\"per_page\"]");
        }
        if (parameters.containsKey("sort_by") && !(parameters.get("sort_by") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: sort_by must be of type Map<String, String> parameters[\"sort_by\"]");
        }
        if (!(path instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: path must be of type String parameters[\"path\"]");
        }
        Object[] urlParts = new String[]{FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), path};
        for (int i = 2; i < urlParts.length; ++i) {
            try {
                urlParts[i] = new URI(null, null, (String)urlParts[i], null).getRawPath();
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        String url = String.format("%s%s/history/files/%s", urlParts);
        TypeReference<List<Action>> typeReference = new TypeReference<List<Action>>(){};
        return FilesClient.requestList(url, HttpMethods.RequestMethods.GET, typeReference, parameters, options);
    }

    public static ListIterator<Action> listForFolder() throws RuntimeException {
        return History.listForFolder(null, null, null);
    }

    public static ListIterator<Action> listForFolder(String path, HashMap<String, Object> parameters) throws RuntimeException {
        return History.listForFolder(path, parameters, null);
    }

    public static ListIterator<Action> listForFolder(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return History.listForFolder(null, parameters, options);
    }

    public static ListIterator<Action> listForFolder(String path, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (path == null && parameters.containsKey("path") && parameters.get("path") != null) {
            path = (String)parameters.get("path");
        }
        if (path == null) {
            throw new NullPointerException("Argument or Parameter missing: path parameters[\"path\"]");
        }
        if (parameters.containsKey("start_at") && !(parameters.get("start_at") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: start_at must be of type String parameters[\"start_at\"]");
        }
        if (parameters.containsKey("end_at") && !(parameters.get("end_at") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: end_at must be of type String parameters[\"end_at\"]");
        }
        if (parameters.containsKey("display") && !(parameters.get("display") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: display must be of type String parameters[\"display\"]");
        }
        if (parameters.containsKey("cursor") && !(parameters.get("cursor") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: cursor must be of type String parameters[\"cursor\"]");
        }
        if (parameters.containsKey("per_page") && !(parameters.get("per_page") instanceof Long)) {
            throw new IllegalArgumentException("Bad parameter: per_page must be of type Long parameters[\"per_page\"]");
        }
        if (parameters.containsKey("sort_by") && !(parameters.get("sort_by") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: sort_by must be of type Map<String, String> parameters[\"sort_by\"]");
        }
        if (!(path instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: path must be of type String parameters[\"path\"]");
        }
        Object[] urlParts = new String[]{FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), path};
        for (int i = 2; i < urlParts.length; ++i) {
            try {
                urlParts[i] = new URI(null, null, (String)urlParts[i], null).getRawPath();
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        String url = String.format("%s%s/history/folders/%s", urlParts);
        TypeReference<List<Action>> typeReference = new TypeReference<List<Action>>(){};
        return FilesClient.requestList(url, HttpMethods.RequestMethods.GET, typeReference, parameters, options);
    }

    public static ListIterator<Action> listForUser() throws RuntimeException {
        return History.listForUser(null, null, null);
    }

    public static ListIterator<Action> listForUser(Long user_id, HashMap<String, Object> parameters) throws RuntimeException {
        return History.listForUser(user_id, parameters, null);
    }

    public static ListIterator<Action> listForUser(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return History.listForUser(null, parameters, options);
    }

    public static ListIterator<Action> listForUser(Long user_id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (user_id == null && parameters.containsKey("user_id") && parameters.get("user_id") != null) {
            user_id = (Long)parameters.get("user_id");
        }
        if (user_id == null) {
            throw new NullPointerException("Argument or Parameter missing: user_id parameters[\"user_id\"]");
        }
        if (parameters.containsKey("start_at") && !(parameters.get("start_at") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: start_at must be of type String parameters[\"start_at\"]");
        }
        if (parameters.containsKey("end_at") && !(parameters.get("end_at") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: end_at must be of type String parameters[\"end_at\"]");
        }
        if (parameters.containsKey("display") && !(parameters.get("display") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: display must be of type String parameters[\"display\"]");
        }
        if (parameters.containsKey("cursor") && !(parameters.get("cursor") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: cursor must be of type String parameters[\"cursor\"]");
        }
        if (parameters.containsKey("per_page") && !(parameters.get("per_page") instanceof Long)) {
            throw new IllegalArgumentException("Bad parameter: per_page must be of type Long parameters[\"per_page\"]");
        }
        if (parameters.containsKey("sort_by") && !(parameters.get("sort_by") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: sort_by must be of type Map<String, String> parameters[\"sort_by\"]");
        }
        if (!(user_id instanceof Long)) {
            throw new IllegalArgumentException("Bad parameter: user_id must be of type Long parameters[\"user_id\"]");
        }
        Object[] urlParts = new String[]{FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), String.valueOf(user_id)};
        for (int i = 2; i < urlParts.length; ++i) {
            try {
                urlParts[i] = new URI(null, null, (String)urlParts[i], null).getRawPath();
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        String url = String.format("%s%s/history/users/%s", urlParts);
        TypeReference<List<Action>> typeReference = new TypeReference<List<Action>>(){};
        return FilesClient.requestList(url, HttpMethods.RequestMethods.GET, typeReference, parameters, options);
    }

    public static ListIterator<Action> listLogins() throws RuntimeException {
        return History.listLogins(null, null);
    }

    public static ListIterator<Action> listLogins(HashMap<String, Object> parameters) throws RuntimeException {
        return History.listLogins(parameters, null);
    }

    public static ListIterator<Action> listLogins(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (parameters.containsKey("start_at") && !(parameters.get("start_at") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: start_at must be of type String parameters[\"start_at\"]");
        }
        if (parameters.containsKey("end_at") && !(parameters.get("end_at") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: end_at must be of type String parameters[\"end_at\"]");
        }
        if (parameters.containsKey("display") && !(parameters.get("display") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: display must be of type String parameters[\"display\"]");
        }
        if (parameters.containsKey("cursor") && !(parameters.get("cursor") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: cursor must be of type String parameters[\"cursor\"]");
        }
        if (parameters.containsKey("per_page") && !(parameters.get("per_page") instanceof Long)) {
            throw new IllegalArgumentException("Bad parameter: per_page must be of type Long parameters[\"per_page\"]");
        }
        if (parameters.containsKey("sort_by") && !(parameters.get("sort_by") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: sort_by must be of type Map<String, String> parameters[\"sort_by\"]");
        }
        String url = String.format("%s%s/history/login", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase());
        TypeReference<List<Action>> typeReference = new TypeReference<List<Action>>(){};
        return FilesClient.requestList(url, HttpMethods.RequestMethods.GET, typeReference, parameters, options);
    }

    public static ListIterator<Action> list() throws RuntimeException {
        return History.list(null, null);
    }

    public static ListIterator<Action> list(HashMap<String, Object> parameters) throws RuntimeException {
        return History.list(parameters, null);
    }

    public static ListIterator<Action> list(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (parameters.containsKey("start_at") && !(parameters.get("start_at") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: start_at must be of type String parameters[\"start_at\"]");
        }
        if (parameters.containsKey("end_at") && !(parameters.get("end_at") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: end_at must be of type String parameters[\"end_at\"]");
        }
        if (parameters.containsKey("display") && !(parameters.get("display") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: display must be of type String parameters[\"display\"]");
        }
        if (parameters.containsKey("cursor") && !(parameters.get("cursor") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: cursor must be of type String parameters[\"cursor\"]");
        }
        if (parameters.containsKey("per_page") && !(parameters.get("per_page") instanceof Long)) {
            throw new IllegalArgumentException("Bad parameter: per_page must be of type Long parameters[\"per_page\"]");
        }
        if (parameters.containsKey("sort_by") && !(parameters.get("sort_by") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: sort_by must be of type Map<String, String> parameters[\"sort_by\"]");
        }
        if (parameters.containsKey("filter") && !(parameters.get("filter") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: filter must be of type Map<String, String> parameters[\"filter\"]");
        }
        if (parameters.containsKey("filter_prefix") && !(parameters.get("filter_prefix") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: filter_prefix must be of type Map<String, String> parameters[\"filter_prefix\"]");
        }
        String url = String.format("%s%s/history", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase());
        TypeReference<List<Action>> typeReference = new TypeReference<List<Action>>(){};
        return FilesClient.requestList(url, HttpMethods.RequestMethods.GET, typeReference, parameters, options);
    }

    public static ListIterator<Action> all() throws RuntimeException {
        return History.all(null, null);
    }

    public static ListIterator<Action> all(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return History.list(parameters, options);
    }

    public static ListIterator<Export> listForFileCreateExport(Long path, HashMap<String, Object> parameters) throws RuntimeException {
        return History.listForFileCreateExport(path, parameters, null);
    }

    public static ListIterator<Export> listForFileCreateExport(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return History.listForFileCreateExport(null, parameters, options);
    }

    public static ListIterator<Export> listForFileCreateExport(Long path, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (path == null && parameters.containsKey("path") && parameters.get("path") != null) {
            path = (Long)parameters.get("path");
        }
        if (path == null) {
            throw new NullPointerException("Argument or Parameter missing: path parameters[\"path\"]");
        }
        if (parameters.containsKey("start_at") && !(parameters.get("start_at") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: start_at must be of type String parameters[\"start_at\"]");
        }
        if (parameters.containsKey("end_at") && !(parameters.get("end_at") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: end_at must be of type String parameters[\"end_at\"]");
        }
        if (parameters.containsKey("display") && !(parameters.get("display") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: display must be of type String parameters[\"display\"]");
        }
        if (parameters.containsKey("sort_by") && !(parameters.get("sort_by") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: sort_by must be of type Map<String, String> parameters[\"sort_by\"]");
        }
        if (!(path instanceof Long)) {
            throw new IllegalArgumentException("Bad parameter: path must be of type Long parameters[\"path\"]");
        }
        Object[] urlParts = new String[]{FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), String.valueOf(path)};
        for (int i = 2; i < urlParts.length; ++i) {
            try {
                urlParts[i] = new URI(null, null, (String)urlParts[i], null).getRawPath();
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        String url = String.format("%s%s/history/files/%s/create_export", urlParts);
        TypeReference<List<Export>> typeReference = new TypeReference<List<Export>>(){};
        return FilesClient.requestList(url, HttpMethods.RequestMethods.POST, typeReference, parameters, options);
    }

    public static ListIterator<Export> listForFolderCreateExport(Long path, HashMap<String, Object> parameters) throws RuntimeException {
        return History.listForFolderCreateExport(path, parameters, null);
    }

    public static ListIterator<Export> listForFolderCreateExport(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return History.listForFolderCreateExport(null, parameters, options);
    }

    public static ListIterator<Export> listForFolderCreateExport(Long path, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (path == null && parameters.containsKey("path") && parameters.get("path") != null) {
            path = (Long)parameters.get("path");
        }
        if (path == null) {
            throw new NullPointerException("Argument or Parameter missing: path parameters[\"path\"]");
        }
        if (parameters.containsKey("start_at") && !(parameters.get("start_at") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: start_at must be of type String parameters[\"start_at\"]");
        }
        if (parameters.containsKey("end_at") && !(parameters.get("end_at") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: end_at must be of type String parameters[\"end_at\"]");
        }
        if (parameters.containsKey("display") && !(parameters.get("display") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: display must be of type String parameters[\"display\"]");
        }
        if (parameters.containsKey("sort_by") && !(parameters.get("sort_by") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: sort_by must be of type Map<String, String> parameters[\"sort_by\"]");
        }
        if (!(path instanceof Long)) {
            throw new IllegalArgumentException("Bad parameter: path must be of type Long parameters[\"path\"]");
        }
        Object[] urlParts = new String[]{FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), String.valueOf(path)};
        for (int i = 2; i < urlParts.length; ++i) {
            try {
                urlParts[i] = new URI(null, null, (String)urlParts[i], null).getRawPath();
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        String url = String.format("%s%s/history/folders/%s/create_export", urlParts);
        TypeReference<List<Export>> typeReference = new TypeReference<List<Export>>(){};
        return FilesClient.requestList(url, HttpMethods.RequestMethods.POST, typeReference, parameters, options);
    }

    public static ListIterator<Export> listForUserCreateExport(Long user_id, HashMap<String, Object> parameters) throws RuntimeException {
        return History.listForUserCreateExport(user_id, parameters, null);
    }

    public static ListIterator<Export> listForUserCreateExport(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return History.listForUserCreateExport(null, parameters, options);
    }

    public static ListIterator<Export> listForUserCreateExport(Long user_id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (user_id == null && parameters.containsKey("user_id") && parameters.get("user_id") != null) {
            user_id = (Long)parameters.get("user_id");
        }
        if (user_id == null) {
            throw new NullPointerException("Argument or Parameter missing: user_id parameters[\"user_id\"]");
        }
        if (parameters.containsKey("start_at") && !(parameters.get("start_at") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: start_at must be of type String parameters[\"start_at\"]");
        }
        if (parameters.containsKey("end_at") && !(parameters.get("end_at") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: end_at must be of type String parameters[\"end_at\"]");
        }
        if (parameters.containsKey("display") && !(parameters.get("display") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: display must be of type String parameters[\"display\"]");
        }
        if (parameters.containsKey("sort_by") && !(parameters.get("sort_by") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: sort_by must be of type Map<String, String> parameters[\"sort_by\"]");
        }
        if (!(user_id instanceof Long)) {
            throw new IllegalArgumentException("Bad parameter: user_id must be of type Long parameters[\"user_id\"]");
        }
        Object[] urlParts = new String[]{FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), String.valueOf(user_id)};
        for (int i = 2; i < urlParts.length; ++i) {
            try {
                urlParts[i] = new URI(null, null, (String)urlParts[i], null).getRawPath();
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        String url = String.format("%s%s/history/users/%s/create_export", urlParts);
        TypeReference<List<Export>> typeReference = new TypeReference<List<Export>>(){};
        return FilesClient.requestList(url, HttpMethods.RequestMethods.POST, typeReference, parameters, options);
    }

    public static ListIterator<Export> listLoginsCreateExport(HashMap<String, Object> parameters) throws RuntimeException {
        return History.listLoginsCreateExport(parameters, null);
    }

    public static ListIterator<Export> listLoginsCreateExport(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (parameters.containsKey("start_at") && !(parameters.get("start_at") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: start_at must be of type String parameters[\"start_at\"]");
        }
        if (parameters.containsKey("end_at") && !(parameters.get("end_at") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: end_at must be of type String parameters[\"end_at\"]");
        }
        if (parameters.containsKey("display") && !(parameters.get("display") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: display must be of type String parameters[\"display\"]");
        }
        if (parameters.containsKey("sort_by") && !(parameters.get("sort_by") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: sort_by must be of type Map<String, String> parameters[\"sort_by\"]");
        }
        String url = String.format("%s%s/history/login/create_export", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase());
        TypeReference<List<Export>> typeReference = new TypeReference<List<Export>>(){};
        return FilesClient.requestList(url, HttpMethods.RequestMethods.POST, typeReference, parameters, options);
    }

    public static ListIterator<Export> listCreateExport(HashMap<String, Object> parameters) throws RuntimeException {
        return History.listCreateExport(parameters, null);
    }

    public static ListIterator<Export> listCreateExport(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (parameters.containsKey("start_at") && !(parameters.get("start_at") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: start_at must be of type String parameters[\"start_at\"]");
        }
        if (parameters.containsKey("end_at") && !(parameters.get("end_at") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: end_at must be of type String parameters[\"end_at\"]");
        }
        if (parameters.containsKey("display") && !(parameters.get("display") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: display must be of type String parameters[\"display\"]");
        }
        if (parameters.containsKey("sort_by") && !(parameters.get("sort_by") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: sort_by must be of type Map<String, String> parameters[\"sort_by\"]");
        }
        if (parameters.containsKey("filter") && !(parameters.get("filter") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: filter must be of type Map<String, String> parameters[\"filter\"]");
        }
        if (parameters.containsKey("filter_prefix") && !(parameters.get("filter_prefix") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: filter_prefix must be of type Map<String, String> parameters[\"filter_prefix\"]");
        }
        String url = String.format("%s%s/history/create_export", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase());
        TypeReference<List<Export>> typeReference = new TypeReference<List<Export>>(){};
        return FilesClient.requestList(url, HttpMethods.RequestMethods.POST, typeReference, parameters, options);
    }

    @Override
    @Generated
    public void setOptions(HashMap<String, Object> options) {
        this.options = options;
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getPath() {
        return this.path;
    }

    @Generated
    public Date getWhen() {
        return this.when;
    }

    @Generated
    public String getDestination() {
        return this.destination;
    }

    @Generated
    public String getDisplay() {
        return this.display;
    }

    @Generated
    public String getIp() {
        return this.ip;
    }

    @Generated
    public String getSource() {
        return this.source;
    }

    @Generated
    public Map<String, String> getTargets() {
        return this.targets;
    }

    @Generated
    public Long getUserId() {
        return this.userId;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public Boolean getUserIsFromParentSite() {
        return this.userIsFromParentSite;
    }

    @Generated
    public String getAction() {
        return this.action;
    }

    @Generated
    public String getFailureType() {
        return this.failureType;
    }

    @Generated
    public String getInterfaceName() {
        return this.interfaceName;
    }
}

