/*
 * Decompiled with CFR 0.152.
 */
package com.files.models;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.files.FilesClient;
import com.files.FilesConfig;
import com.files.ListIterator;
import com.files.models.Export;
import com.files.models.ModelInterface;
import com.files.net.HttpMethods;
import com.files.util.ModelUtils;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SiemHttpDestination
implements ModelInterface {
    private HashMap<String, Object> options;
    private ObjectMapper objectMapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().disable(new MapperFeature[]{MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS})).disable(new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS})).defaultDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX"))).build();
    @JsonProperty(value="id")
    public Long id;
    @JsonProperty(value="name")
    public String name;
    @JsonProperty(value="destination_type")
    public String destinationType;
    @JsonProperty(value="destination_url")
    public String destinationUrl;
    @JsonProperty(value="additional_headers")
    public Map<String, String> additionalHeaders;
    @JsonProperty(value="sending_active")
    public Boolean sendingActive;
    @JsonProperty(value="generic_payload_type")
    public String genericPayloadType;
    @JsonProperty(value="splunk_token_masked")
    public String splunkTokenMasked;
    @JsonProperty(value="azure_dcr_immutable_id")
    public String azureDcrImmutableId;
    @JsonProperty(value="azure_stream_name")
    public String azureStreamName;
    @JsonProperty(value="azure_oauth_client_credentials_tenant_id")
    public String azureOauthClientCredentialsTenantId;
    @JsonProperty(value="azure_oauth_client_credentials_client_id")
    public String azureOauthClientCredentialsClientId;
    @JsonProperty(value="azure_oauth_client_credentials_client_secret_masked")
    public String azureOauthClientCredentialsClientSecretMasked;
    @JsonProperty(value="qradar_username")
    public String qradarUsername;
    @JsonProperty(value="qradar_password_masked")
    public String qradarPasswordMasked;
    @JsonProperty(value="solar_winds_token_masked")
    public String solarWindsTokenMasked;
    @JsonProperty(value="new_relic_api_key_masked")
    public String newRelicApiKeyMasked;
    @JsonProperty(value="datadog_api_key_masked")
    public String datadogApiKeyMasked;
    @JsonProperty(value="sftp_action_send_enabled")
    public Boolean sftpActionSendEnabled;
    @JsonProperty(value="sftp_action_records_sent_entries_sent")
    public Long sftpActionRecordsSentEntriesSent;
    @JsonProperty(value="ftp_action_send_enabled")
    public Boolean ftpActionSendEnabled;
    @JsonProperty(value="ftp_action_records_sent_entries_sent")
    public Long ftpActionRecordsSentEntriesSent;
    @JsonProperty(value="web_dav_action_send_enabled")
    public Boolean webDavActionSendEnabled;
    @JsonProperty(value="web_dav_action_records_sent_entries_sent")
    public Long webDavActionRecordsSentEntriesSent;
    @JsonProperty(value="sync_send_enabled")
    public Boolean syncSendEnabled;
    @JsonProperty(value="sync_records_sent_entries_sent")
    public Long syncRecordsSentEntriesSent;
    @JsonProperty(value="outbound_connection_send_enabled")
    public Boolean outboundConnectionSendEnabled;
    @JsonProperty(value="outbound_connection_records_sent_entries_sent")
    public Long outboundConnectionRecordsSentEntriesSent;
    @JsonProperty(value="automation_send_enabled")
    public Boolean automationSendEnabled;
    @JsonProperty(value="automation_records_sent_entries_sent")
    public Long automationRecordsSentEntriesSent;
    @JsonProperty(value="api_request_send_enabled")
    public Boolean apiRequestSendEnabled;
    @JsonProperty(value="api_request_records_sent_entries_sent")
    public Long apiRequestRecordsSentEntriesSent;
    @JsonProperty(value="public_hosting_request_send_enabled")
    public Boolean publicHostingRequestSendEnabled;
    @JsonProperty(value="public_hosting_request_records_sent_entries_sent")
    public Long publicHostingRequestRecordsSentEntriesSent;
    @JsonProperty(value="email_send_enabled")
    public Boolean emailSendEnabled;
    @JsonProperty(value="email_records_sent_entries_sent")
    public Long emailRecordsSentEntriesSent;
    @JsonProperty(value="exavault_api_request_send_enabled")
    public Boolean exavaultApiRequestSendEnabled;
    @JsonProperty(value="exavault_api_request_records_sent_entries_sent")
    public Long exavaultApiRequestRecordsSentEntriesSent;
    @JsonProperty(value="last_http_call_target_type")
    public String lastHttpCallTargetType;
    @JsonProperty(value="last_http_call_success")
    public Boolean lastHttpCallSuccess;
    @JsonProperty(value="last_http_call_response_code")
    public Long lastHttpCallResponseCode;
    @JsonProperty(value="last_http_call_response_body")
    public String lastHttpCallResponseBody;
    @JsonProperty(value="last_http_call_error_message")
    public String lastHttpCallErrorMessage;
    @JsonProperty(value="last_http_call_time")
    public String lastHttpCallTime;
    @JsonProperty(value="last_http_call_duration_ms")
    public Long lastHttpCallDurationMs;
    @JsonProperty(value="most_recent_http_call_success_time")
    public String mostRecentHttpCallSuccessTime;
    @JsonProperty(value="connection_test_entry")
    public String connectionTestEntry;
    @JsonProperty(value="splunk_token")
    public String splunkToken;
    @JsonProperty(value="azure_oauth_client_credentials_client_secret")
    public String azureOauthClientCredentialsClientSecret;
    @JsonProperty(value="qradar_password")
    public String qradarPassword;
    @JsonProperty(value="solar_winds_token")
    public String solarWindsToken;
    @JsonProperty(value="new_relic_api_key")
    public String newRelicApiKey;
    @JsonProperty(value="datadog_api_key")
    public String datadogApiKey;

    public SiemHttpDestination() {
        this(null, null);
    }

    public SiemHttpDestination(HashMap<String, Object> parameters) {
        this(parameters, null);
    }

    public SiemHttpDestination(HashMap<String, Object> parameters, HashMap<String, Object> options) {
        this.options = options;
        try {
            ObjectReader objectReader = this.objectMapper.readerForUpdating((Object)this);
            objectReader.readValue(this.objectMapper.writeValueAsString(parameters));
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }

    public SiemHttpDestination update() throws IOException {
        HashMap<String, Object> parameters = ModelUtils.toParameterMap(this.objectMapper.writeValueAsString((Object)this));
        return SiemHttpDestination.update(this.id, parameters, this.options);
    }

    public void delete() throws IOException {
        HashMap<String, Object> parameters = ModelUtils.toParameterMap(this.objectMapper.writeValueAsString((Object)this));
        SiemHttpDestination.delete(this.id, parameters, this.options);
    }

    public void destroy(HashMap<String, Object> parameters) throws IOException {
        this.delete();
    }

    public void save() throws IOException {
        HashMap<String, Object> parameters = ModelUtils.toParameterMap(this.objectMapper.writeValueAsString((Object)this));
        SiemHttpDestination.create(parameters, this.options);
    }

    public static ListIterator<SiemHttpDestination> list() throws RuntimeException {
        return SiemHttpDestination.list(null, null);
    }

    public static ListIterator<SiemHttpDestination> list(HashMap<String, Object> parameters) throws RuntimeException {
        return SiemHttpDestination.list(parameters, null);
    }

    public static ListIterator<SiemHttpDestination> list(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (parameters.containsKey("cursor") && !(parameters.get("cursor") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: cursor must be of type String parameters[\"cursor\"]");
        }
        if (parameters.containsKey("per_page") && !(parameters.get("per_page") instanceof Long)) {
            throw new IllegalArgumentException("Bad parameter: per_page must be of type Long parameters[\"per_page\"]");
        }
        String url = String.format("%s%s/siem_http_destinations", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase());
        TypeReference<List<SiemHttpDestination>> typeReference = new TypeReference<List<SiemHttpDestination>>(){};
        return FilesClient.requestList(url, HttpMethods.RequestMethods.GET, typeReference, parameters, options);
    }

    public static ListIterator<SiemHttpDestination> all() throws RuntimeException {
        return SiemHttpDestination.all(null, null);
    }

    public static ListIterator<SiemHttpDestination> all(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return SiemHttpDestination.list(parameters, options);
    }

    public static SiemHttpDestination find(Long id, HashMap<String, Object> parameters) throws RuntimeException {
        return SiemHttpDestination.find(id, parameters, null);
    }

    public static SiemHttpDestination find(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return SiemHttpDestination.find(null, parameters, options);
    }

    public static SiemHttpDestination find(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (id == null && parameters.containsKey("id") && parameters.get("id") != null) {
            id = (Long)parameters.get("id");
        }
        if (id == null) {
            throw new NullPointerException("Argument or Parameter missing: id parameters[\"id\"]");
        }
        if (!(id instanceof Long)) {
            throw new IllegalArgumentException("Bad parameter: id must be of type Long parameters[\"id\"]");
        }
        Object[] urlParts = new String[]{FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), String.valueOf(id)};
        for (int i = 2; i < urlParts.length; ++i) {
            try {
                urlParts[i] = new URI(null, null, (String)urlParts[i], null).getRawPath();
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        String url = String.format("%s%s/siem_http_destinations/%s", urlParts);
        TypeReference<SiemHttpDestination> typeReference = new TypeReference<SiemHttpDestination>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.GET, typeReference, parameters, options);
    }

    public static SiemHttpDestination get() throws RuntimeException {
        return SiemHttpDestination.get(null, null, null);
    }

    public static SiemHttpDestination get(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return SiemHttpDestination.find(id, parameters, options);
    }

    public static SiemHttpDestination create(HashMap<String, Object> parameters) throws RuntimeException {
        return SiemHttpDestination.create(parameters, null);
    }

    public static SiemHttpDestination create(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (!parameters.containsKey("destination_type") || parameters.get("destination_type") == null) {
            throw new NullPointerException("Parameter missing: destination_type parameters[\"destination_type\"]");
        }
        if (!parameters.containsKey("destination_url") || parameters.get("destination_url") == null) {
            throw new NullPointerException("Parameter missing: destination_url parameters[\"destination_url\"]");
        }
        if (parameters.containsKey("name") && !(parameters.get("name") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: name must be of type String parameters[\"name\"]");
        }
        if (parameters.containsKey("additional_headers") && !(parameters.get("additional_headers") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: additional_headers must be of type Map<String, String> parameters[\"additional_headers\"]");
        }
        if (parameters.containsKey("sending_active") && !(parameters.get("sending_active") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: sending_active must be of type Boolean parameters[\"sending_active\"]");
        }
        if (parameters.containsKey("generic_payload_type") && !(parameters.get("generic_payload_type") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: generic_payload_type must be of type String parameters[\"generic_payload_type\"]");
        }
        if (parameters.containsKey("splunk_token") && !(parameters.get("splunk_token") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: splunk_token must be of type String parameters[\"splunk_token\"]");
        }
        if (parameters.containsKey("azure_dcr_immutable_id") && !(parameters.get("azure_dcr_immutable_id") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: azure_dcr_immutable_id must be of type String parameters[\"azure_dcr_immutable_id\"]");
        }
        if (parameters.containsKey("azure_stream_name") && !(parameters.get("azure_stream_name") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: azure_stream_name must be of type String parameters[\"azure_stream_name\"]");
        }
        if (parameters.containsKey("azure_oauth_client_credentials_tenant_id") && !(parameters.get("azure_oauth_client_credentials_tenant_id") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: azure_oauth_client_credentials_tenant_id must be of type String parameters[\"azure_oauth_client_credentials_tenant_id\"]");
        }
        if (parameters.containsKey("azure_oauth_client_credentials_client_id") && !(parameters.get("azure_oauth_client_credentials_client_id") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: azure_oauth_client_credentials_client_id must be of type String parameters[\"azure_oauth_client_credentials_client_id\"]");
        }
        if (parameters.containsKey("azure_oauth_client_credentials_client_secret") && !(parameters.get("azure_oauth_client_credentials_client_secret") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: azure_oauth_client_credentials_client_secret must be of type String parameters[\"azure_oauth_client_credentials_client_secret\"]");
        }
        if (parameters.containsKey("qradar_username") && !(parameters.get("qradar_username") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: qradar_username must be of type String parameters[\"qradar_username\"]");
        }
        if (parameters.containsKey("qradar_password") && !(parameters.get("qradar_password") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: qradar_password must be of type String parameters[\"qradar_password\"]");
        }
        if (parameters.containsKey("solar_winds_token") && !(parameters.get("solar_winds_token") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: solar_winds_token must be of type String parameters[\"solar_winds_token\"]");
        }
        if (parameters.containsKey("new_relic_api_key") && !(parameters.get("new_relic_api_key") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: new_relic_api_key must be of type String parameters[\"new_relic_api_key\"]");
        }
        if (parameters.containsKey("datadog_api_key") && !(parameters.get("datadog_api_key") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: datadog_api_key must be of type String parameters[\"datadog_api_key\"]");
        }
        if (parameters.containsKey("sftp_action_send_enabled") && !(parameters.get("sftp_action_send_enabled") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: sftp_action_send_enabled must be of type Boolean parameters[\"sftp_action_send_enabled\"]");
        }
        if (parameters.containsKey("ftp_action_send_enabled") && !(parameters.get("ftp_action_send_enabled") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: ftp_action_send_enabled must be of type Boolean parameters[\"ftp_action_send_enabled\"]");
        }
        if (parameters.containsKey("web_dav_action_send_enabled") && !(parameters.get("web_dav_action_send_enabled") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: web_dav_action_send_enabled must be of type Boolean parameters[\"web_dav_action_send_enabled\"]");
        }
        if (parameters.containsKey("sync_send_enabled") && !(parameters.get("sync_send_enabled") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: sync_send_enabled must be of type Boolean parameters[\"sync_send_enabled\"]");
        }
        if (parameters.containsKey("outbound_connection_send_enabled") && !(parameters.get("outbound_connection_send_enabled") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: outbound_connection_send_enabled must be of type Boolean parameters[\"outbound_connection_send_enabled\"]");
        }
        if (parameters.containsKey("automation_send_enabled") && !(parameters.get("automation_send_enabled") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: automation_send_enabled must be of type Boolean parameters[\"automation_send_enabled\"]");
        }
        if (parameters.containsKey("api_request_send_enabled") && !(parameters.get("api_request_send_enabled") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: api_request_send_enabled must be of type Boolean parameters[\"api_request_send_enabled\"]");
        }
        if (parameters.containsKey("public_hosting_request_send_enabled") && !(parameters.get("public_hosting_request_send_enabled") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: public_hosting_request_send_enabled must be of type Boolean parameters[\"public_hosting_request_send_enabled\"]");
        }
        if (parameters.containsKey("email_send_enabled") && !(parameters.get("email_send_enabled") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: email_send_enabled must be of type Boolean parameters[\"email_send_enabled\"]");
        }
        if (parameters.containsKey("exavault_api_request_send_enabled") && !(parameters.get("exavault_api_request_send_enabled") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: exavault_api_request_send_enabled must be of type Boolean parameters[\"exavault_api_request_send_enabled\"]");
        }
        if (parameters.containsKey("destination_type") && !(parameters.get("destination_type") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: destination_type must be of type String parameters[\"destination_type\"]");
        }
        if (parameters.containsKey("destination_url") && !(parameters.get("destination_url") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: destination_url must be of type String parameters[\"destination_url\"]");
        }
        String url = String.format("%s%s/siem_http_destinations", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase());
        TypeReference<SiemHttpDestination> typeReference = new TypeReference<SiemHttpDestination>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.POST, typeReference, parameters, options);
    }

    public static Export createExport(HashMap<String, Object> parameters) throws RuntimeException {
        return SiemHttpDestination.createExport(parameters, null);
    }

    public static Export createExport(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        options = options != null ? options : new HashMap<String, Object>();
        String url = String.format("%s%s/siem_http_destinations/create_export", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase());
        TypeReference<Export> typeReference = new TypeReference<Export>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.POST, typeReference, parameters, options);
    }

    public static void sendTestEntry(HashMap<String, Object> parameters) throws RuntimeException {
        SiemHttpDestination.sendTestEntry(parameters, null);
    }

    public static void sendTestEntry(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (parameters.containsKey("siem_http_destination_id") && !(parameters.get("siem_http_destination_id") instanceof Long)) {
            throw new IllegalArgumentException("Bad parameter: siem_http_destination_id must be of type Long parameters[\"siem_http_destination_id\"]");
        }
        if (parameters.containsKey("destination_type") && !(parameters.get("destination_type") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: destination_type must be of type String parameters[\"destination_type\"]");
        }
        if (parameters.containsKey("destination_url") && !(parameters.get("destination_url") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: destination_url must be of type String parameters[\"destination_url\"]");
        }
        if (parameters.containsKey("name") && !(parameters.get("name") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: name must be of type String parameters[\"name\"]");
        }
        if (parameters.containsKey("additional_headers") && !(parameters.get("additional_headers") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: additional_headers must be of type Map<String, String> parameters[\"additional_headers\"]");
        }
        if (parameters.containsKey("sending_active") && !(parameters.get("sending_active") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: sending_active must be of type Boolean parameters[\"sending_active\"]");
        }
        if (parameters.containsKey("generic_payload_type") && !(parameters.get("generic_payload_type") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: generic_payload_type must be of type String parameters[\"generic_payload_type\"]");
        }
        if (parameters.containsKey("splunk_token") && !(parameters.get("splunk_token") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: splunk_token must be of type String parameters[\"splunk_token\"]");
        }
        if (parameters.containsKey("azure_dcr_immutable_id") && !(parameters.get("azure_dcr_immutable_id") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: azure_dcr_immutable_id must be of type String parameters[\"azure_dcr_immutable_id\"]");
        }
        if (parameters.containsKey("azure_stream_name") && !(parameters.get("azure_stream_name") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: azure_stream_name must be of type String parameters[\"azure_stream_name\"]");
        }
        if (parameters.containsKey("azure_oauth_client_credentials_tenant_id") && !(parameters.get("azure_oauth_client_credentials_tenant_id") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: azure_oauth_client_credentials_tenant_id must be of type String parameters[\"azure_oauth_client_credentials_tenant_id\"]");
        }
        if (parameters.containsKey("azure_oauth_client_credentials_client_id") && !(parameters.get("azure_oauth_client_credentials_client_id") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: azure_oauth_client_credentials_client_id must be of type String parameters[\"azure_oauth_client_credentials_client_id\"]");
        }
        if (parameters.containsKey("azure_oauth_client_credentials_client_secret") && !(parameters.get("azure_oauth_client_credentials_client_secret") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: azure_oauth_client_credentials_client_secret must be of type String parameters[\"azure_oauth_client_credentials_client_secret\"]");
        }
        if (parameters.containsKey("qradar_username") && !(parameters.get("qradar_username") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: qradar_username must be of type String parameters[\"qradar_username\"]");
        }
        if (parameters.containsKey("qradar_password") && !(parameters.get("qradar_password") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: qradar_password must be of type String parameters[\"qradar_password\"]");
        }
        if (parameters.containsKey("solar_winds_token") && !(parameters.get("solar_winds_token") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: solar_winds_token must be of type String parameters[\"solar_winds_token\"]");
        }
        if (parameters.containsKey("new_relic_api_key") && !(parameters.get("new_relic_api_key") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: new_relic_api_key must be of type String parameters[\"new_relic_api_key\"]");
        }
        if (parameters.containsKey("datadog_api_key") && !(parameters.get("datadog_api_key") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: datadog_api_key must be of type String parameters[\"datadog_api_key\"]");
        }
        if (parameters.containsKey("sftp_action_send_enabled") && !(parameters.get("sftp_action_send_enabled") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: sftp_action_send_enabled must be of type Boolean parameters[\"sftp_action_send_enabled\"]");
        }
        if (parameters.containsKey("ftp_action_send_enabled") && !(parameters.get("ftp_action_send_enabled") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: ftp_action_send_enabled must be of type Boolean parameters[\"ftp_action_send_enabled\"]");
        }
        if (parameters.containsKey("web_dav_action_send_enabled") && !(parameters.get("web_dav_action_send_enabled") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: web_dav_action_send_enabled must be of type Boolean parameters[\"web_dav_action_send_enabled\"]");
        }
        if (parameters.containsKey("sync_send_enabled") && !(parameters.get("sync_send_enabled") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: sync_send_enabled must be of type Boolean parameters[\"sync_send_enabled\"]");
        }
        if (parameters.containsKey("outbound_connection_send_enabled") && !(parameters.get("outbound_connection_send_enabled") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: outbound_connection_send_enabled must be of type Boolean parameters[\"outbound_connection_send_enabled\"]");
        }
        if (parameters.containsKey("automation_send_enabled") && !(parameters.get("automation_send_enabled") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: automation_send_enabled must be of type Boolean parameters[\"automation_send_enabled\"]");
        }
        if (parameters.containsKey("api_request_send_enabled") && !(parameters.get("api_request_send_enabled") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: api_request_send_enabled must be of type Boolean parameters[\"api_request_send_enabled\"]");
        }
        if (parameters.containsKey("public_hosting_request_send_enabled") && !(parameters.get("public_hosting_request_send_enabled") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: public_hosting_request_send_enabled must be of type Boolean parameters[\"public_hosting_request_send_enabled\"]");
        }
        if (parameters.containsKey("email_send_enabled") && !(parameters.get("email_send_enabled") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: email_send_enabled must be of type Boolean parameters[\"email_send_enabled\"]");
        }
        if (parameters.containsKey("exavault_api_request_send_enabled") && !(parameters.get("exavault_api_request_send_enabled") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: exavault_api_request_send_enabled must be of type Boolean parameters[\"exavault_api_request_send_enabled\"]");
        }
        String url = String.format("%s%s/siem_http_destinations/send_test_entry", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase());
        FilesClient.apiRequest(url, HttpMethods.RequestMethods.POST, parameters, options);
    }

    public static SiemHttpDestination update(Long id, HashMap<String, Object> parameters) throws RuntimeException {
        return SiemHttpDestination.update(id, parameters, null);
    }

    public static SiemHttpDestination update(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return SiemHttpDestination.update(null, parameters, options);
    }

    public static SiemHttpDestination update(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (id == null && parameters.containsKey("id") && parameters.get("id") != null) {
            id = (Long)parameters.get("id");
        }
        if (id == null) {
            throw new NullPointerException("Argument or Parameter missing: id parameters[\"id\"]");
        }
        if (!(id instanceof Long)) {
            throw new IllegalArgumentException("Bad parameter: id must be of type Long parameters[\"id\"]");
        }
        if (parameters.containsKey("name") && !(parameters.get("name") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: name must be of type String parameters[\"name\"]");
        }
        if (parameters.containsKey("additional_headers") && !(parameters.get("additional_headers") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: additional_headers must be of type Map<String, String> parameters[\"additional_headers\"]");
        }
        if (parameters.containsKey("sending_active") && !(parameters.get("sending_active") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: sending_active must be of type Boolean parameters[\"sending_active\"]");
        }
        if (parameters.containsKey("generic_payload_type") && !(parameters.get("generic_payload_type") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: generic_payload_type must be of type String parameters[\"generic_payload_type\"]");
        }
        if (parameters.containsKey("splunk_token") && !(parameters.get("splunk_token") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: splunk_token must be of type String parameters[\"splunk_token\"]");
        }
        if (parameters.containsKey("azure_dcr_immutable_id") && !(parameters.get("azure_dcr_immutable_id") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: azure_dcr_immutable_id must be of type String parameters[\"azure_dcr_immutable_id\"]");
        }
        if (parameters.containsKey("azure_stream_name") && !(parameters.get("azure_stream_name") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: azure_stream_name must be of type String parameters[\"azure_stream_name\"]");
        }
        if (parameters.containsKey("azure_oauth_client_credentials_tenant_id") && !(parameters.get("azure_oauth_client_credentials_tenant_id") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: azure_oauth_client_credentials_tenant_id must be of type String parameters[\"azure_oauth_client_credentials_tenant_id\"]");
        }
        if (parameters.containsKey("azure_oauth_client_credentials_client_id") && !(parameters.get("azure_oauth_client_credentials_client_id") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: azure_oauth_client_credentials_client_id must be of type String parameters[\"azure_oauth_client_credentials_client_id\"]");
        }
        if (parameters.containsKey("azure_oauth_client_credentials_client_secret") && !(parameters.get("azure_oauth_client_credentials_client_secret") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: azure_oauth_client_credentials_client_secret must be of type String parameters[\"azure_oauth_client_credentials_client_secret\"]");
        }
        if (parameters.containsKey("qradar_username") && !(parameters.get("qradar_username") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: qradar_username must be of type String parameters[\"qradar_username\"]");
        }
        if (parameters.containsKey("qradar_password") && !(parameters.get("qradar_password") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: qradar_password must be of type String parameters[\"qradar_password\"]");
        }
        if (parameters.containsKey("solar_winds_token") && !(parameters.get("solar_winds_token") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: solar_winds_token must be of type String parameters[\"solar_winds_token\"]");
        }
        if (parameters.containsKey("new_relic_api_key") && !(parameters.get("new_relic_api_key") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: new_relic_api_key must be of type String parameters[\"new_relic_api_key\"]");
        }
        if (parameters.containsKey("datadog_api_key") && !(parameters.get("datadog_api_key") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: datadog_api_key must be of type String parameters[\"datadog_api_key\"]");
        }
        if (parameters.containsKey("sftp_action_send_enabled") && !(parameters.get("sftp_action_send_enabled") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: sftp_action_send_enabled must be of type Boolean parameters[\"sftp_action_send_enabled\"]");
        }
        if (parameters.containsKey("ftp_action_send_enabled") && !(parameters.get("ftp_action_send_enabled") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: ftp_action_send_enabled must be of type Boolean parameters[\"ftp_action_send_enabled\"]");
        }
        if (parameters.containsKey("web_dav_action_send_enabled") && !(parameters.get("web_dav_action_send_enabled") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: web_dav_action_send_enabled must be of type Boolean parameters[\"web_dav_action_send_enabled\"]");
        }
        if (parameters.containsKey("sync_send_enabled") && !(parameters.get("sync_send_enabled") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: sync_send_enabled must be of type Boolean parameters[\"sync_send_enabled\"]");
        }
        if (parameters.containsKey("outbound_connection_send_enabled") && !(parameters.get("outbound_connection_send_enabled") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: outbound_connection_send_enabled must be of type Boolean parameters[\"outbound_connection_send_enabled\"]");
        }
        if (parameters.containsKey("automation_send_enabled") && !(parameters.get("automation_send_enabled") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: automation_send_enabled must be of type Boolean parameters[\"automation_send_enabled\"]");
        }
        if (parameters.containsKey("api_request_send_enabled") && !(parameters.get("api_request_send_enabled") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: api_request_send_enabled must be of type Boolean parameters[\"api_request_send_enabled\"]");
        }
        if (parameters.containsKey("public_hosting_request_send_enabled") && !(parameters.get("public_hosting_request_send_enabled") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: public_hosting_request_send_enabled must be of type Boolean parameters[\"public_hosting_request_send_enabled\"]");
        }
        if (parameters.containsKey("email_send_enabled") && !(parameters.get("email_send_enabled") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: email_send_enabled must be of type Boolean parameters[\"email_send_enabled\"]");
        }
        if (parameters.containsKey("exavault_api_request_send_enabled") && !(parameters.get("exavault_api_request_send_enabled") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: exavault_api_request_send_enabled must be of type Boolean parameters[\"exavault_api_request_send_enabled\"]");
        }
        if (parameters.containsKey("destination_type") && !(parameters.get("destination_type") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: destination_type must be of type String parameters[\"destination_type\"]");
        }
        if (parameters.containsKey("destination_url") && !(parameters.get("destination_url") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: destination_url must be of type String parameters[\"destination_url\"]");
        }
        Object[] urlParts = new String[]{FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), String.valueOf(id)};
        for (int i = 2; i < urlParts.length; ++i) {
            try {
                urlParts[i] = new URI(null, null, (String)urlParts[i], null).getRawPath();
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        String url = String.format("%s%s/siem_http_destinations/%s", urlParts);
        TypeReference<SiemHttpDestination> typeReference = new TypeReference<SiemHttpDestination>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.PATCH, typeReference, parameters, options);
    }

    public static void delete(Long id, HashMap<String, Object> parameters) throws RuntimeException {
        SiemHttpDestination.delete(id, parameters, null);
    }

    public static void delete(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        SiemHttpDestination.delete(null, parameters, options);
    }

    public static void delete(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (id == null && parameters.containsKey("id") && parameters.get("id") != null) {
            id = (Long)parameters.get("id");
        }
        if (id == null) {
            throw new NullPointerException("Argument or Parameter missing: id parameters[\"id\"]");
        }
        if (!(id instanceof Long)) {
            throw new IllegalArgumentException("Bad parameter: id must be of type Long parameters[\"id\"]");
        }
        Object[] urlParts = new String[]{FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), String.valueOf(id)};
        for (int i = 2; i < urlParts.length; ++i) {
            try {
                urlParts[i] = new URI(null, null, (String)urlParts[i], null).getRawPath();
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        String url = String.format("%s%s/siem_http_destinations/%s", urlParts);
        FilesClient.apiRequest(url, HttpMethods.RequestMethods.DELETE, parameters, options);
    }

    public static void destroy() throws RuntimeException {
        SiemHttpDestination.destroy(null, null, null);
    }

    public static void destroy(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        SiemHttpDestination.delete(id, parameters, options);
    }

    @Override
    @Generated
    public void setOptions(HashMap<String, Object> options) {
        this.options = options;
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public String getDestinationType() {
        return this.destinationType;
    }

    @JsonProperty(value="destination_type")
    @Generated
    public void setDestinationType(String destinationType) {
        this.destinationType = destinationType;
    }

    @Generated
    public String getDestinationUrl() {
        return this.destinationUrl;
    }

    @JsonProperty(value="destination_url")
    @Generated
    public void setDestinationUrl(String destinationUrl) {
        this.destinationUrl = destinationUrl;
    }

    @Generated
    public Map<String, String> getAdditionalHeaders() {
        return this.additionalHeaders;
    }

    @JsonProperty(value="additional_headers")
    @Generated
    public void setAdditionalHeaders(Map<String, String> additionalHeaders) {
        this.additionalHeaders = additionalHeaders;
    }

    @Generated
    public Boolean getSendingActive() {
        return this.sendingActive;
    }

    @JsonProperty(value="sending_active")
    @Generated
    public void setSendingActive(Boolean sendingActive) {
        this.sendingActive = sendingActive;
    }

    @Generated
    public String getGenericPayloadType() {
        return this.genericPayloadType;
    }

    @JsonProperty(value="generic_payload_type")
    @Generated
    public void setGenericPayloadType(String genericPayloadType) {
        this.genericPayloadType = genericPayloadType;
    }

    @Generated
    public String getSplunkTokenMasked() {
        return this.splunkTokenMasked;
    }

    @JsonProperty(value="splunk_token_masked")
    @Generated
    public void setSplunkTokenMasked(String splunkTokenMasked) {
        this.splunkTokenMasked = splunkTokenMasked;
    }

    @Generated
    public String getAzureDcrImmutableId() {
        return this.azureDcrImmutableId;
    }

    @JsonProperty(value="azure_dcr_immutable_id")
    @Generated
    public void setAzureDcrImmutableId(String azureDcrImmutableId) {
        this.azureDcrImmutableId = azureDcrImmutableId;
    }

    @Generated
    public String getAzureStreamName() {
        return this.azureStreamName;
    }

    @JsonProperty(value="azure_stream_name")
    @Generated
    public void setAzureStreamName(String azureStreamName) {
        this.azureStreamName = azureStreamName;
    }

    @Generated
    public String getAzureOauthClientCredentialsTenantId() {
        return this.azureOauthClientCredentialsTenantId;
    }

    @JsonProperty(value="azure_oauth_client_credentials_tenant_id")
    @Generated
    public void setAzureOauthClientCredentialsTenantId(String azureOauthClientCredentialsTenantId) {
        this.azureOauthClientCredentialsTenantId = azureOauthClientCredentialsTenantId;
    }

    @Generated
    public String getAzureOauthClientCredentialsClientId() {
        return this.azureOauthClientCredentialsClientId;
    }

    @JsonProperty(value="azure_oauth_client_credentials_client_id")
    @Generated
    public void setAzureOauthClientCredentialsClientId(String azureOauthClientCredentialsClientId) {
        this.azureOauthClientCredentialsClientId = azureOauthClientCredentialsClientId;
    }

    @Generated
    public String getAzureOauthClientCredentialsClientSecretMasked() {
        return this.azureOauthClientCredentialsClientSecretMasked;
    }

    @JsonProperty(value="azure_oauth_client_credentials_client_secret_masked")
    @Generated
    public void setAzureOauthClientCredentialsClientSecretMasked(String azureOauthClientCredentialsClientSecretMasked) {
        this.azureOauthClientCredentialsClientSecretMasked = azureOauthClientCredentialsClientSecretMasked;
    }

    @Generated
    public String getQradarUsername() {
        return this.qradarUsername;
    }

    @JsonProperty(value="qradar_username")
    @Generated
    public void setQradarUsername(String qradarUsername) {
        this.qradarUsername = qradarUsername;
    }

    @Generated
    public String getQradarPasswordMasked() {
        return this.qradarPasswordMasked;
    }

    @JsonProperty(value="qradar_password_masked")
    @Generated
    public void setQradarPasswordMasked(String qradarPasswordMasked) {
        this.qradarPasswordMasked = qradarPasswordMasked;
    }

    @Generated
    public String getSolarWindsTokenMasked() {
        return this.solarWindsTokenMasked;
    }

    @JsonProperty(value="solar_winds_token_masked")
    @Generated
    public void setSolarWindsTokenMasked(String solarWindsTokenMasked) {
        this.solarWindsTokenMasked = solarWindsTokenMasked;
    }

    @Generated
    public String getNewRelicApiKeyMasked() {
        return this.newRelicApiKeyMasked;
    }

    @JsonProperty(value="new_relic_api_key_masked")
    @Generated
    public void setNewRelicApiKeyMasked(String newRelicApiKeyMasked) {
        this.newRelicApiKeyMasked = newRelicApiKeyMasked;
    }

    @Generated
    public String getDatadogApiKeyMasked() {
        return this.datadogApiKeyMasked;
    }

    @JsonProperty(value="datadog_api_key_masked")
    @Generated
    public void setDatadogApiKeyMasked(String datadogApiKeyMasked) {
        this.datadogApiKeyMasked = datadogApiKeyMasked;
    }

    @Generated
    public Boolean getSftpActionSendEnabled() {
        return this.sftpActionSendEnabled;
    }

    @JsonProperty(value="sftp_action_send_enabled")
    @Generated
    public void setSftpActionSendEnabled(Boolean sftpActionSendEnabled) {
        this.sftpActionSendEnabled = sftpActionSendEnabled;
    }

    @Generated
    public Long getSftpActionRecordsSentEntriesSent() {
        return this.sftpActionRecordsSentEntriesSent;
    }

    @JsonProperty(value="sftp_action_records_sent_entries_sent")
    @Generated
    public void setSftpActionRecordsSentEntriesSent(Long sftpActionRecordsSentEntriesSent) {
        this.sftpActionRecordsSentEntriesSent = sftpActionRecordsSentEntriesSent;
    }

    @Generated
    public Boolean getFtpActionSendEnabled() {
        return this.ftpActionSendEnabled;
    }

    @JsonProperty(value="ftp_action_send_enabled")
    @Generated
    public void setFtpActionSendEnabled(Boolean ftpActionSendEnabled) {
        this.ftpActionSendEnabled = ftpActionSendEnabled;
    }

    @Generated
    public Long getFtpActionRecordsSentEntriesSent() {
        return this.ftpActionRecordsSentEntriesSent;
    }

    @JsonProperty(value="ftp_action_records_sent_entries_sent")
    @Generated
    public void setFtpActionRecordsSentEntriesSent(Long ftpActionRecordsSentEntriesSent) {
        this.ftpActionRecordsSentEntriesSent = ftpActionRecordsSentEntriesSent;
    }

    @Generated
    public Boolean getWebDavActionSendEnabled() {
        return this.webDavActionSendEnabled;
    }

    @JsonProperty(value="web_dav_action_send_enabled")
    @Generated
    public void setWebDavActionSendEnabled(Boolean webDavActionSendEnabled) {
        this.webDavActionSendEnabled = webDavActionSendEnabled;
    }

    @Generated
    public Long getWebDavActionRecordsSentEntriesSent() {
        return this.webDavActionRecordsSentEntriesSent;
    }

    @JsonProperty(value="web_dav_action_records_sent_entries_sent")
    @Generated
    public void setWebDavActionRecordsSentEntriesSent(Long webDavActionRecordsSentEntriesSent) {
        this.webDavActionRecordsSentEntriesSent = webDavActionRecordsSentEntriesSent;
    }

    @Generated
    public Boolean getSyncSendEnabled() {
        return this.syncSendEnabled;
    }

    @JsonProperty(value="sync_send_enabled")
    @Generated
    public void setSyncSendEnabled(Boolean syncSendEnabled) {
        this.syncSendEnabled = syncSendEnabled;
    }

    @Generated
    public Long getSyncRecordsSentEntriesSent() {
        return this.syncRecordsSentEntriesSent;
    }

    @JsonProperty(value="sync_records_sent_entries_sent")
    @Generated
    public void setSyncRecordsSentEntriesSent(Long syncRecordsSentEntriesSent) {
        this.syncRecordsSentEntriesSent = syncRecordsSentEntriesSent;
    }

    @Generated
    public Boolean getOutboundConnectionSendEnabled() {
        return this.outboundConnectionSendEnabled;
    }

    @JsonProperty(value="outbound_connection_send_enabled")
    @Generated
    public void setOutboundConnectionSendEnabled(Boolean outboundConnectionSendEnabled) {
        this.outboundConnectionSendEnabled = outboundConnectionSendEnabled;
    }

    @Generated
    public Long getOutboundConnectionRecordsSentEntriesSent() {
        return this.outboundConnectionRecordsSentEntriesSent;
    }

    @JsonProperty(value="outbound_connection_records_sent_entries_sent")
    @Generated
    public void setOutboundConnectionRecordsSentEntriesSent(Long outboundConnectionRecordsSentEntriesSent) {
        this.outboundConnectionRecordsSentEntriesSent = outboundConnectionRecordsSentEntriesSent;
    }

    @Generated
    public Boolean getAutomationSendEnabled() {
        return this.automationSendEnabled;
    }

    @JsonProperty(value="automation_send_enabled")
    @Generated
    public void setAutomationSendEnabled(Boolean automationSendEnabled) {
        this.automationSendEnabled = automationSendEnabled;
    }

    @Generated
    public Long getAutomationRecordsSentEntriesSent() {
        return this.automationRecordsSentEntriesSent;
    }

    @JsonProperty(value="automation_records_sent_entries_sent")
    @Generated
    public void setAutomationRecordsSentEntriesSent(Long automationRecordsSentEntriesSent) {
        this.automationRecordsSentEntriesSent = automationRecordsSentEntriesSent;
    }

    @Generated
    public Boolean getApiRequestSendEnabled() {
        return this.apiRequestSendEnabled;
    }

    @JsonProperty(value="api_request_send_enabled")
    @Generated
    public void setApiRequestSendEnabled(Boolean apiRequestSendEnabled) {
        this.apiRequestSendEnabled = apiRequestSendEnabled;
    }

    @Generated
    public Long getApiRequestRecordsSentEntriesSent() {
        return this.apiRequestRecordsSentEntriesSent;
    }

    @JsonProperty(value="api_request_records_sent_entries_sent")
    @Generated
    public void setApiRequestRecordsSentEntriesSent(Long apiRequestRecordsSentEntriesSent) {
        this.apiRequestRecordsSentEntriesSent = apiRequestRecordsSentEntriesSent;
    }

    @Generated
    public Boolean getPublicHostingRequestSendEnabled() {
        return this.publicHostingRequestSendEnabled;
    }

    @JsonProperty(value="public_hosting_request_send_enabled")
    @Generated
    public void setPublicHostingRequestSendEnabled(Boolean publicHostingRequestSendEnabled) {
        this.publicHostingRequestSendEnabled = publicHostingRequestSendEnabled;
    }

    @Generated
    public Long getPublicHostingRequestRecordsSentEntriesSent() {
        return this.publicHostingRequestRecordsSentEntriesSent;
    }

    @JsonProperty(value="public_hosting_request_records_sent_entries_sent")
    @Generated
    public void setPublicHostingRequestRecordsSentEntriesSent(Long publicHostingRequestRecordsSentEntriesSent) {
        this.publicHostingRequestRecordsSentEntriesSent = publicHostingRequestRecordsSentEntriesSent;
    }

    @Generated
    public Boolean getEmailSendEnabled() {
        return this.emailSendEnabled;
    }

    @JsonProperty(value="email_send_enabled")
    @Generated
    public void setEmailSendEnabled(Boolean emailSendEnabled) {
        this.emailSendEnabled = emailSendEnabled;
    }

    @Generated
    public Long getEmailRecordsSentEntriesSent() {
        return this.emailRecordsSentEntriesSent;
    }

    @JsonProperty(value="email_records_sent_entries_sent")
    @Generated
    public void setEmailRecordsSentEntriesSent(Long emailRecordsSentEntriesSent) {
        this.emailRecordsSentEntriesSent = emailRecordsSentEntriesSent;
    }

    @Generated
    public Boolean getExavaultApiRequestSendEnabled() {
        return this.exavaultApiRequestSendEnabled;
    }

    @JsonProperty(value="exavault_api_request_send_enabled")
    @Generated
    public void setExavaultApiRequestSendEnabled(Boolean exavaultApiRequestSendEnabled) {
        this.exavaultApiRequestSendEnabled = exavaultApiRequestSendEnabled;
    }

    @Generated
    public Long getExavaultApiRequestRecordsSentEntriesSent() {
        return this.exavaultApiRequestRecordsSentEntriesSent;
    }

    @JsonProperty(value="exavault_api_request_records_sent_entries_sent")
    @Generated
    public void setExavaultApiRequestRecordsSentEntriesSent(Long exavaultApiRequestRecordsSentEntriesSent) {
        this.exavaultApiRequestRecordsSentEntriesSent = exavaultApiRequestRecordsSentEntriesSent;
    }

    @Generated
    public String getLastHttpCallTargetType() {
        return this.lastHttpCallTargetType;
    }

    @JsonProperty(value="last_http_call_target_type")
    @Generated
    public void setLastHttpCallTargetType(String lastHttpCallTargetType) {
        this.lastHttpCallTargetType = lastHttpCallTargetType;
    }

    @Generated
    public Boolean getLastHttpCallSuccess() {
        return this.lastHttpCallSuccess;
    }

    @JsonProperty(value="last_http_call_success")
    @Generated
    public void setLastHttpCallSuccess(Boolean lastHttpCallSuccess) {
        this.lastHttpCallSuccess = lastHttpCallSuccess;
    }

    @Generated
    public Long getLastHttpCallResponseCode() {
        return this.lastHttpCallResponseCode;
    }

    @JsonProperty(value="last_http_call_response_code")
    @Generated
    public void setLastHttpCallResponseCode(Long lastHttpCallResponseCode) {
        this.lastHttpCallResponseCode = lastHttpCallResponseCode;
    }

    @Generated
    public String getLastHttpCallResponseBody() {
        return this.lastHttpCallResponseBody;
    }

    @JsonProperty(value="last_http_call_response_body")
    @Generated
    public void setLastHttpCallResponseBody(String lastHttpCallResponseBody) {
        this.lastHttpCallResponseBody = lastHttpCallResponseBody;
    }

    @Generated
    public String getLastHttpCallErrorMessage() {
        return this.lastHttpCallErrorMessage;
    }

    @JsonProperty(value="last_http_call_error_message")
    @Generated
    public void setLastHttpCallErrorMessage(String lastHttpCallErrorMessage) {
        this.lastHttpCallErrorMessage = lastHttpCallErrorMessage;
    }

    @Generated
    public String getLastHttpCallTime() {
        return this.lastHttpCallTime;
    }

    @JsonProperty(value="last_http_call_time")
    @Generated
    public void setLastHttpCallTime(String lastHttpCallTime) {
        this.lastHttpCallTime = lastHttpCallTime;
    }

    @Generated
    public Long getLastHttpCallDurationMs() {
        return this.lastHttpCallDurationMs;
    }

    @JsonProperty(value="last_http_call_duration_ms")
    @Generated
    public void setLastHttpCallDurationMs(Long lastHttpCallDurationMs) {
        this.lastHttpCallDurationMs = lastHttpCallDurationMs;
    }

    @Generated
    public String getMostRecentHttpCallSuccessTime() {
        return this.mostRecentHttpCallSuccessTime;
    }

    @JsonProperty(value="most_recent_http_call_success_time")
    @Generated
    public void setMostRecentHttpCallSuccessTime(String mostRecentHttpCallSuccessTime) {
        this.mostRecentHttpCallSuccessTime = mostRecentHttpCallSuccessTime;
    }

    @Generated
    public String getConnectionTestEntry() {
        return this.connectionTestEntry;
    }

    @JsonProperty(value="connection_test_entry")
    @Generated
    public void setConnectionTestEntry(String connectionTestEntry) {
        this.connectionTestEntry = connectionTestEntry;
    }

    @Generated
    public String getSplunkToken() {
        return this.splunkToken;
    }

    @JsonProperty(value="splunk_token")
    @Generated
    public void setSplunkToken(String splunkToken) {
        this.splunkToken = splunkToken;
    }

    @Generated
    public String getAzureOauthClientCredentialsClientSecret() {
        return this.azureOauthClientCredentialsClientSecret;
    }

    @JsonProperty(value="azure_oauth_client_credentials_client_secret")
    @Generated
    public void setAzureOauthClientCredentialsClientSecret(String azureOauthClientCredentialsClientSecret) {
        this.azureOauthClientCredentialsClientSecret = azureOauthClientCredentialsClientSecret;
    }

    @Generated
    public String getQradarPassword() {
        return this.qradarPassword;
    }

    @JsonProperty(value="qradar_password")
    @Generated
    public void setQradarPassword(String qradarPassword) {
        this.qradarPassword = qradarPassword;
    }

    @Generated
    public String getSolarWindsToken() {
        return this.solarWindsToken;
    }

    @JsonProperty(value="solar_winds_token")
    @Generated
    public void setSolarWindsToken(String solarWindsToken) {
        this.solarWindsToken = solarWindsToken;
    }

    @Generated
    public String getNewRelicApiKey() {
        return this.newRelicApiKey;
    }

    @JsonProperty(value="new_relic_api_key")
    @Generated
    public void setNewRelicApiKey(String newRelicApiKey) {
        this.newRelicApiKey = newRelicApiKey;
    }

    @Generated
    public String getDatadogApiKey() {
        return this.datadogApiKey;
    }

    @JsonProperty(value="datadog_api_key")
    @Generated
    public void setDatadogApiKey(String datadogApiKey) {
        this.datadogApiKey = datadogApiKey;
    }
}

