/*
 * Decompiled with CFR 0.152.
 */
package com.files.net;

import com.files.util.FilesInputStream;
import com.files.util.StreamTransfer;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import okhttp3.Response;

public class FilesOkHttpInputStream
extends FilesInputStream
implements Closeable {
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    Response response;
    InputStream upstreamInputStream;

    public FilesOkHttpInputStream(Response response) {
        this.response = response;
    }

    @Override
    public int read() throws IOException {
        if (this.upstreamInputStream == null) {
            this.loadInputStream();
        }
        return this.upstreamInputStream.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        if (this.upstreamInputStream == null) {
            this.loadInputStream();
        }
        return this.upstreamInputStream.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.upstreamInputStream == null) {
            this.loadInputStream();
        }
        return this.upstreamInputStream.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.upstreamInputStream == null) {
            this.loadInputStream();
        }
        return this.upstreamInputStream.skip(n);
    }

    @Override
    public int available() throws IOException {
        if (this.upstreamInputStream == null) {
            this.loadInputStream();
        }
        return this.upstreamInputStream.available();
    }

    @Override
    public void close() throws IOException {
        if (this.upstreamInputStream != null) {
            this.upstreamInputStream.close();
        }
        this.response.body().close();
    }

    @Override
    public synchronized void mark(int readLimit) {
        if (this.upstreamInputStream == null) {
            this.loadInputStream();
        }
        this.upstreamInputStream.mark(readLimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        if (this.upstreamInputStream == null) {
            this.loadInputStream();
        }
        this.upstreamInputStream.reset();
    }

    @Override
    public boolean markSupported() {
        if (this.upstreamInputStream == null) {
            this.loadInputStream();
        }
        return this.upstreamInputStream.markSupported();
    }

    @Override
    public long transferTo(OutputStream out) throws IOException {
        if (this.upstreamInputStream == null) {
            this.loadInputStream();
        }
        long transferred = StreamTransfer.smartCopy(this.response.body().contentLength(), this, out);
        this.close();
        return transferred;
    }

    private void loadInputStream() {
        this.upstreamInputStream = this.response.body().byteStream();
    }
}

