/*
 * Decompiled with CFR 0.152.
 */
package com.files.models;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.files.FilesClient;
import com.files.FilesConfig;
import com.files.ListIterator;
import com.files.models.ModelInterface;
import com.files.net.HttpMethods;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SyncLog
implements ModelInterface {
    private HashMap<String, Object> options;
    private ObjectMapper objectMapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().disable(new MapperFeature[]{MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS})).disable(new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS})).defaultDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX"))).build();
    @JsonProperty(value="timestamp")
    public Date timestamp;
    @JsonProperty(value="sync_id")
    public Long syncId;
    @JsonProperty(value="external_event_id")
    public Long externalEventId;
    @JsonProperty(value="error_type")
    public String errorType;
    @JsonProperty(value="message")
    public String message;
    @JsonProperty(value="operation")
    public String operation;
    @JsonProperty(value="path")
    public String path;
    @JsonProperty(value="size")
    public String size;
    @JsonProperty(value="file_type")
    public String fileType;
    @JsonProperty(value="status")
    public String status;

    public SyncLog() {
        this(null, null);
    }

    public SyncLog(HashMap<String, Object> parameters) {
        this(parameters, null);
    }

    public SyncLog(HashMap<String, Object> parameters, HashMap<String, Object> options) {
        this.options = options;
        try {
            ObjectReader objectReader = this.objectMapper.readerForUpdating((Object)this);
            objectReader.readValue(this.objectMapper.writeValueAsString(parameters));
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }

    public static ListIterator<SyncLog> list() throws RuntimeException {
        return SyncLog.list(null, null);
    }

    public static ListIterator<SyncLog> list(HashMap<String, Object> parameters) throws RuntimeException {
        return SyncLog.list(parameters, null);
    }

    public static ListIterator<SyncLog> list(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (parameters.containsKey("cursor") && !(parameters.get("cursor") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: cursor must be of type String parameters[\"cursor\"]");
        }
        if (parameters.containsKey("per_page") && !(parameters.get("per_page") instanceof Long)) {
            throw new IllegalArgumentException("Bad parameter: per_page must be of type Long parameters[\"per_page\"]");
        }
        if (parameters.containsKey("filter") && !(parameters.get("filter") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: filter must be of type Map<String, String> parameters[\"filter\"]");
        }
        if (parameters.containsKey("filter_prefix") && !(parameters.get("filter_prefix") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: filter_prefix must be of type Map<String, String> parameters[\"filter_prefix\"]");
        }
        String url = String.format("%s%s/sync_logs", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase());
        TypeReference<List<SyncLog>> typeReference = new TypeReference<List<SyncLog>>(){};
        return FilesClient.requestList(url, HttpMethods.RequestMethods.GET, typeReference, parameters, options);
    }

    public static ListIterator<SyncLog> all() throws RuntimeException {
        return SyncLog.all(null, null);
    }

    public static ListIterator<SyncLog> all(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return SyncLog.list(parameters, options);
    }

    @Override
    @Generated
    public void setOptions(HashMap<String, Object> options) {
        this.options = options;
    }

    @Generated
    public Date getTimestamp() {
        return this.timestamp;
    }

    @Generated
    public Long getSyncId() {
        return this.syncId;
    }

    @Generated
    public Long getExternalEventId() {
        return this.externalEventId;
    }

    @Generated
    public String getErrorType() {
        return this.errorType;
    }

    @Generated
    public String getMessage() {
        return this.message;
    }

    @Generated
    public String getOperation() {
        return this.operation;
    }

    @Generated
    public String getPath() {
        return this.path;
    }

    @Generated
    public String getSize() {
        return this.size;
    }

    @Generated
    public String getFileType() {
        return this.fileType;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }
}

