/*
 * Decompiled with CFR 0.152.
 */
package com.files.models;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.files.FilesClient;
import com.files.FilesConfig;
import com.files.ListIterator;
import com.files.models.ModelInterface;
import com.files.net.HttpMethods;
import com.files.util.ModelUtils;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ApiKey
implements ModelInterface {
    private HashMap<String, Object> options;
    private ObjectMapper objectMapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().disable(new MapperFeature[]{MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS})).disable(new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS})).defaultDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX"))).build();
    @JsonProperty(value="id")
    public Long id;
    @JsonProperty(value="descriptive_label")
    public String descriptiveLabel;
    @JsonProperty(value="description")
    public String description;
    @JsonProperty(value="created_at")
    public Date createdAt;
    @JsonProperty(value="expires_at")
    public Date expiresAt;
    @JsonProperty(value="key")
    public String key;
    @JsonProperty(value="last_use_at")
    public Date lastUseAt;
    @JsonProperty(value="name")
    public String name;
    @JsonProperty(value="permission_set")
    public String permissionSet;
    @JsonProperty(value="platform")
    public String platform;
    @JsonProperty(value="url")
    public String url;
    @JsonProperty(value="user_id")
    public Long userId;
    @JsonProperty(value="path")
    public String path;

    public ApiKey() {
        this(null, null);
    }

    public ApiKey(HashMap<String, Object> parameters) {
        this(parameters, null);
    }

    public ApiKey(HashMap<String, Object> parameters, HashMap<String, Object> options) {
        this.options = options;
        try {
            ObjectReader objectReader = this.objectMapper.readerForUpdating((Object)this);
            objectReader.readValue(this.objectMapper.writeValueAsString(parameters));
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }

    public ApiKey update() throws IOException {
        HashMap<String, Object> parameters = ModelUtils.toParameterMap(this.objectMapper.writeValueAsString((Object)this));
        return ApiKey.update(this.id, parameters, this.options);
    }

    public void delete() throws IOException {
        HashMap<String, Object> parameters = ModelUtils.toParameterMap(this.objectMapper.writeValueAsString((Object)this));
        ApiKey.delete(this.id, parameters, this.options);
    }

    public void destroy(HashMap<String, Object> parameters) throws IOException {
        this.delete();
    }

    public void save() throws IOException {
        HashMap<String, Object> parameters = ModelUtils.toParameterMap(this.objectMapper.writeValueAsString((Object)this));
        ApiKey.create(parameters, this.options);
    }

    public static ListIterator<ApiKey> list() throws RuntimeException {
        return ApiKey.list(null, null);
    }

    public static ListIterator<ApiKey> list(HashMap<String, Object> parameters) throws RuntimeException {
        return ApiKey.list(parameters, null);
    }

    public static ListIterator<ApiKey> list(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (parameters.containsKey("user_id") && !(parameters.get("user_id") instanceof Long)) {
            throw new IllegalArgumentException("Bad parameter: user_id must be of type Long parameters[\"user_id\"]");
        }
        if (parameters.containsKey("cursor") && !(parameters.get("cursor") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: cursor must be of type String parameters[\"cursor\"]");
        }
        if (parameters.containsKey("per_page") && !(parameters.get("per_page") instanceof Long)) {
            throw new IllegalArgumentException("Bad parameter: per_page must be of type Long parameters[\"per_page\"]");
        }
        if (parameters.containsKey("sort_by") && !(parameters.get("sort_by") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: sort_by must be of type Map<String, String> parameters[\"sort_by\"]");
        }
        if (parameters.containsKey("filter") && !(parameters.get("filter") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: filter must be of type Map<String, String> parameters[\"filter\"]");
        }
        if (parameters.containsKey("filter_gt") && !(parameters.get("filter_gt") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: filter_gt must be of type Map<String, String> parameters[\"filter_gt\"]");
        }
        if (parameters.containsKey("filter_gteq") && !(parameters.get("filter_gteq") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: filter_gteq must be of type Map<String, String> parameters[\"filter_gteq\"]");
        }
        if (parameters.containsKey("filter_lt") && !(parameters.get("filter_lt") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: filter_lt must be of type Map<String, String> parameters[\"filter_lt\"]");
        }
        if (parameters.containsKey("filter_lteq") && !(parameters.get("filter_lteq") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: filter_lteq must be of type Map<String, String> parameters[\"filter_lteq\"]");
        }
        String url = String.format("%s%s/api_keys", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase());
        TypeReference<List<ApiKey>> typeReference = new TypeReference<List<ApiKey>>(){};
        return FilesClient.requestList(url, HttpMethods.RequestMethods.GET, typeReference, parameters, options);
    }

    public static ListIterator<ApiKey> all() throws RuntimeException {
        return ApiKey.all(null, null);
    }

    public static ListIterator<ApiKey> all(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return ApiKey.list(parameters, options);
    }

    public static ApiKey findCurrent(HashMap<String, Object> parameters) throws RuntimeException {
        return ApiKey.findCurrent(parameters, null);
    }

    public static ApiKey findCurrent(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        options = options != null ? options : new HashMap<String, Object>();
        String url = String.format("%s%s/api_key", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase());
        TypeReference<ApiKey> typeReference = new TypeReference<ApiKey>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.GET, typeReference, parameters, options);
    }

    public static ApiKey find(Long id, HashMap<String, Object> parameters) throws RuntimeException {
        return ApiKey.find(id, parameters, null);
    }

    public static ApiKey find(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return ApiKey.find(null, parameters, options);
    }

    public static ApiKey find(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (id == null && parameters.containsKey("id") && parameters.get("id") != null) {
            id = (Long)parameters.get("id");
        }
        if (id == null) {
            throw new NullPointerException("Argument or Parameter missing: id parameters[\"id\"]");
        }
        if (!(id instanceof Long)) {
            throw new IllegalArgumentException("Bad parameter: id must be of type Long parameters[\"id\"]");
        }
        Object[] urlParts = new String[]{FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), String.valueOf(id)};
        for (int i = 2; i < urlParts.length; ++i) {
            try {
                urlParts[i] = new URI(null, null, (String)urlParts[i], null).getRawPath();
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        String url = String.format("%s%s/api_keys/%s", urlParts);
        TypeReference<ApiKey> typeReference = new TypeReference<ApiKey>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.GET, typeReference, parameters, options);
    }

    public static ApiKey get() throws RuntimeException {
        return ApiKey.get(null, null, null);
    }

    public static ApiKey get(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return ApiKey.find(id, parameters, options);
    }

    public static ApiKey create(HashMap<String, Object> parameters) throws RuntimeException {
        return ApiKey.create(parameters, null);
    }

    public static ApiKey create(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (!parameters.containsKey("name") || parameters.get("name") == null) {
            throw new NullPointerException("Parameter missing: name parameters[\"name\"]");
        }
        if (parameters.containsKey("user_id") && !(parameters.get("user_id") instanceof Long)) {
            throw new IllegalArgumentException("Bad parameter: user_id must be of type Long parameters[\"user_id\"]");
        }
        if (parameters.containsKey("description") && !(parameters.get("description") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: description must be of type String parameters[\"description\"]");
        }
        if (parameters.containsKey("expires_at") && !(parameters.get("expires_at") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: expires_at must be of type String parameters[\"expires_at\"]");
        }
        if (parameters.containsKey("permission_set") && !(parameters.get("permission_set") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: permission_set must be of type String parameters[\"permission_set\"]");
        }
        if (parameters.containsKey("name") && !(parameters.get("name") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: name must be of type String parameters[\"name\"]");
        }
        if (parameters.containsKey("path") && !(parameters.get("path") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: path must be of type String parameters[\"path\"]");
        }
        String url = String.format("%s%s/api_keys", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase());
        TypeReference<ApiKey> typeReference = new TypeReference<ApiKey>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.POST, typeReference, parameters, options);
    }

    public static ApiKey updateCurrent(HashMap<String, Object> parameters) throws RuntimeException {
        return ApiKey.updateCurrent(parameters, null);
    }

    public static ApiKey updateCurrent(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (parameters.containsKey("expires_at") && !(parameters.get("expires_at") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: expires_at must be of type String parameters[\"expires_at\"]");
        }
        if (parameters.containsKey("name") && !(parameters.get("name") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: name must be of type String parameters[\"name\"]");
        }
        if (parameters.containsKey("permission_set") && !(parameters.get("permission_set") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: permission_set must be of type String parameters[\"permission_set\"]");
        }
        String url = String.format("%s%s/api_key", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase());
        TypeReference<ApiKey> typeReference = new TypeReference<ApiKey>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.PATCH, typeReference, parameters, options);
    }

    public static ApiKey update(Long id, HashMap<String, Object> parameters) throws RuntimeException {
        return ApiKey.update(id, parameters, null);
    }

    public static ApiKey update(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return ApiKey.update(null, parameters, options);
    }

    public static ApiKey update(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (id == null && parameters.containsKey("id") && parameters.get("id") != null) {
            id = (Long)parameters.get("id");
        }
        if (id == null) {
            throw new NullPointerException("Argument or Parameter missing: id parameters[\"id\"]");
        }
        if (!(id instanceof Long)) {
            throw new IllegalArgumentException("Bad parameter: id must be of type Long parameters[\"id\"]");
        }
        if (parameters.containsKey("description") && !(parameters.get("description") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: description must be of type String parameters[\"description\"]");
        }
        if (parameters.containsKey("expires_at") && !(parameters.get("expires_at") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: expires_at must be of type String parameters[\"expires_at\"]");
        }
        if (parameters.containsKey("permission_set") && !(parameters.get("permission_set") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: permission_set must be of type String parameters[\"permission_set\"]");
        }
        if (parameters.containsKey("name") && !(parameters.get("name") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: name must be of type String parameters[\"name\"]");
        }
        Object[] urlParts = new String[]{FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), String.valueOf(id)};
        for (int i = 2; i < urlParts.length; ++i) {
            try {
                urlParts[i] = new URI(null, null, (String)urlParts[i], null).getRawPath();
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        String url = String.format("%s%s/api_keys/%s", urlParts);
        TypeReference<ApiKey> typeReference = new TypeReference<ApiKey>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.PATCH, typeReference, parameters, options);
    }

    public static void deleteCurrent(HashMap<String, Object> parameters) throws RuntimeException {
        ApiKey.deleteCurrent(parameters, null);
    }

    public static void deleteCurrent(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        options = options != null ? options : new HashMap<String, Object>();
        String url = String.format("%s%s/api_key", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase());
        FilesClient.apiRequest(url, HttpMethods.RequestMethods.DELETE, parameters, options);
    }

    public static void delete(Long id, HashMap<String, Object> parameters) throws RuntimeException {
        ApiKey.delete(id, parameters, null);
    }

    public static void delete(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        ApiKey.delete(null, parameters, options);
    }

    public static void delete(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (id == null && parameters.containsKey("id") && parameters.get("id") != null) {
            id = (Long)parameters.get("id");
        }
        if (id == null) {
            throw new NullPointerException("Argument or Parameter missing: id parameters[\"id\"]");
        }
        if (!(id instanceof Long)) {
            throw new IllegalArgumentException("Bad parameter: id must be of type Long parameters[\"id\"]");
        }
        Object[] urlParts = new String[]{FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), String.valueOf(id)};
        for (int i = 2; i < urlParts.length; ++i) {
            try {
                urlParts[i] = new URI(null, null, (String)urlParts[i], null).getRawPath();
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        String url = String.format("%s%s/api_keys/%s", urlParts);
        FilesClient.apiRequest(url, HttpMethods.RequestMethods.DELETE, parameters, options);
    }

    public static void destroy() throws RuntimeException {
        ApiKey.destroy(null, null, null);
    }

    public static void destroy(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        ApiKey.delete(id, parameters, options);
    }

    @Override
    @Generated
    public void setOptions(HashMap<String, Object> options) {
        this.options = options;
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public String getDescriptiveLabel() {
        return this.descriptiveLabel;
    }

    @JsonProperty(value="descriptive_label")
    @Generated
    public void setDescriptiveLabel(String descriptiveLabel) {
        this.descriptiveLabel = descriptiveLabel;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public Date getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public Date getExpiresAt() {
        return this.expiresAt;
    }

    @JsonProperty(value="expires_at")
    @Generated
    public void setExpiresAt(Date expiresAt) {
        this.expiresAt = expiresAt;
    }

    @Generated
    public String getKey() {
        return this.key;
    }

    @JsonProperty(value="key")
    @Generated
    public void setKey(String key) {
        this.key = key;
    }

    @Generated
    public Date getLastUseAt() {
        return this.lastUseAt;
    }

    @JsonProperty(value="last_use_at")
    @Generated
    public void setLastUseAt(Date lastUseAt) {
        this.lastUseAt = lastUseAt;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public String getPermissionSet() {
        return this.permissionSet;
    }

    @JsonProperty(value="permission_set")
    @Generated
    public void setPermissionSet(String permissionSet) {
        this.permissionSet = permissionSet;
    }

    @Generated
    public String getPlatform() {
        return this.platform;
    }

    @JsonProperty(value="platform")
    @Generated
    public void setPlatform(String platform) {
        this.platform = platform;
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @JsonProperty(value="url")
    @Generated
    public void setUrl(String url) {
        this.url = url;
    }

    @Generated
    public Long getUserId() {
        return this.userId;
    }

    @JsonProperty(value="user_id")
    @Generated
    public void setUserId(Long userId) {
        this.userId = userId;
    }

    @Generated
    public String getPath() {
        return this.path;
    }

    @JsonProperty(value="path")
    @Generated
    public void setPath(String path) {
        this.path = path;
    }
}

