/*
 * Decompiled with CFR 0.152.
 */
package com.files.net;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.files.FilesConfig;
import com.files.ResponseError;
import com.files.exceptions.ApiErrorException;
import java.io.IOException;
import lombok.Generated;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilesHttpInterceptor
implements Interceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FilesHttpInterceptor.class);
    private final ObjectMapper objectMapper = ((JsonMapper.Builder)JsonMapper.builder().disable(new MapperFeature[]{MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS})).build();
    private final String userAgent;
    private final FilesConfig filesConfig = FilesConfig.getInstance();

    public FilesHttpInterceptor() {
        this.userAgent = this.filesConfig.getUserAgent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response intercept(Interceptor.Chain chain) throws RuntimeException {
        Response response;
        Request originalRequest = chain.request();
        Request.Builder modifiedAgentRequest = originalRequest.newBuilder();
        modifiedAgentRequest.header("User-Agent", this.userAgent);
        int attempts = 0;
        Integer status = null;
        while (true) {
            block15: {
                try {
                    response = chain.proceed(modifiedAgentRequest.build());
                    status = response.code();
                    if (status != 429 || status <= 501 || ++attempts >= this.filesConfig.getUpstreamMaxAttempts()) break;
                    log.warn(String.format("HttpClient received retry condition of [%s].", status));
                }
                catch (IOException e) {
                    log.error(String.format("HttpClient received retry error condition due to IOException of [%s]", e.getMessage()));
                    if (attempts < this.filesConfig.getUpstreamMaxAttempts()) break block15;
                    throw new ApiErrorException.ApiConnectionException(e.getMessage());
                }
            }
            try {
                Thread.sleep((long)(Math.pow(2.0, attempts - 2) * (double)this.filesConfig.getInitialRetryDelayMillis()));
            }
            catch (InterruptedException e) {
                throw new ApiErrorException.ApiConnectionException("Http Request Interrupted");
            }
        }
        if (status >= 400 && status <= 600 || status == null) {
            String message = String.format("Http Returned Status %d", status);
            log.error(message);
            ResponseError responseError = new ResponseError();
            String body = null;
            try {
                body = response.body().string();
                responseError = (ResponseError)this.objectMapper.readValue(body, ResponseError.class);
            }
            catch (JsonProcessingException e) {
                if (status >= 500) {
                    throw new ApiErrorException.ServerErrorException(body);
                }
                if (status == 403) {
                    throw new ApiErrorException.AuthenticationException(body, response.headers().toMultimap());
                }
                throw new ApiErrorException.InvalidResponseException(e.getMessage());
            }
            catch (IOException e) {
                throw new ApiErrorException.InvalidResponseException(e.getMessage());
            }
            catch (Exception exception) {
            }
            finally {
                response.body().close();
            }
            throw ApiErrorException.forType(message, responseError, response.headers().toMultimap());
        }
        return response;
    }
}

