/*
 * Decompiled with CFR 0.152.
 */
package com.files.models;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.files.FilesClient;
import com.files.FilesConfig;
import com.files.ListIterator;
import com.files.models.ModelInterface;
import com.files.net.HttpMethods;
import com.files.util.ModelUtils;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ExternalEvent
implements ModelInterface {
    private HashMap<String, Object> options;
    private ObjectMapper objectMapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().disable(new MapperFeature[]{MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS})).disable(new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS})).defaultDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX"))).build();
    @JsonProperty(value="id")
    public Long id;
    @JsonProperty(value="event_type")
    public String eventType;
    @JsonProperty(value="status")
    public String status;
    @JsonProperty(value="body")
    public String body;
    @JsonProperty(value="created_at")
    public Date createdAt;
    @JsonProperty(value="body_url")
    public String bodyUrl;
    @JsonProperty(value="folder_behavior_id")
    public Long folderBehaviorId;
    @JsonProperty(value="siem_http_destination_id")
    public Long siemHttpDestinationId;
    @JsonProperty(value="successful_files")
    public Long successfulFiles;
    @JsonProperty(value="errored_files")
    public Long erroredFiles;
    @JsonProperty(value="bytes_synced")
    public Long bytesSynced;
    @JsonProperty(value="compared_files")
    public Long comparedFiles;
    @JsonProperty(value="compared_folders")
    public Long comparedFolders;
    @JsonProperty(value="remote_server_type")
    public String remoteServerType;

    public ExternalEvent() {
        this(null, null);
    }

    public ExternalEvent(HashMap<String, Object> parameters) {
        this(parameters, null);
    }

    public ExternalEvent(HashMap<String, Object> parameters, HashMap<String, Object> options) {
        this.options = options;
        try {
            ObjectReader objectReader = this.objectMapper.readerForUpdating((Object)this);
            objectReader.readValue(this.objectMapper.writeValueAsString(parameters));
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }

    public void save() throws IOException {
        HashMap<String, Object> parameters = ModelUtils.toParameterMap(this.objectMapper.writeValueAsString((Object)this));
        ExternalEvent.create(parameters, this.options);
    }

    public static ListIterator<ExternalEvent> list() throws RuntimeException {
        return ExternalEvent.list(null, null);
    }

    public static ListIterator<ExternalEvent> list(HashMap<String, Object> parameters) throws RuntimeException {
        return ExternalEvent.list(parameters, null);
    }

    public static ListIterator<ExternalEvent> list(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (parameters.containsKey("cursor") && !(parameters.get("cursor") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: cursor must be of type String parameters[\"cursor\"]");
        }
        if (parameters.containsKey("per_page") && !(parameters.get("per_page") instanceof Long)) {
            throw new IllegalArgumentException("Bad parameter: per_page must be of type Long parameters[\"per_page\"]");
        }
        if (parameters.containsKey("sort_by") && !(parameters.get("sort_by") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: sort_by must be of type Map<String, String> parameters[\"sort_by\"]");
        }
        if (parameters.containsKey("filter") && !(parameters.get("filter") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: filter must be of type Map<String, String> parameters[\"filter\"]");
        }
        if (parameters.containsKey("filter_gt") && !(parameters.get("filter_gt") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: filter_gt must be of type Map<String, String> parameters[\"filter_gt\"]");
        }
        if (parameters.containsKey("filter_gteq") && !(parameters.get("filter_gteq") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: filter_gteq must be of type Map<String, String> parameters[\"filter_gteq\"]");
        }
        if (parameters.containsKey("filter_lt") && !(parameters.get("filter_lt") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: filter_lt must be of type Map<String, String> parameters[\"filter_lt\"]");
        }
        if (parameters.containsKey("filter_lteq") && !(parameters.get("filter_lteq") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: filter_lteq must be of type Map<String, String> parameters[\"filter_lteq\"]");
        }
        String url = String.format("%s%s/external_events", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase());
        TypeReference<List<ExternalEvent>> typeReference = new TypeReference<List<ExternalEvent>>(){};
        return FilesClient.requestList(url, HttpMethods.RequestMethods.GET, typeReference, parameters, options);
    }

    public static ListIterator<ExternalEvent> all() throws RuntimeException {
        return ExternalEvent.all(null, null);
    }

    public static ListIterator<ExternalEvent> all(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return ExternalEvent.list(parameters, options);
    }

    public static ExternalEvent find(Long id, HashMap<String, Object> parameters) throws RuntimeException {
        return ExternalEvent.find(id, parameters, null);
    }

    public static ExternalEvent find(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return ExternalEvent.find(null, parameters, options);
    }

    public static ExternalEvent find(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (id == null && parameters.containsKey("id") && parameters.get("id") != null) {
            id = (Long)parameters.get("id");
        }
        if (id == null) {
            throw new NullPointerException("Argument or Parameter missing: id parameters[\"id\"]");
        }
        if (!(id instanceof Long)) {
            throw new IllegalArgumentException("Bad parameter: id must be of type Long parameters[\"id\"]");
        }
        Object[] urlParts = new String[]{FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), String.valueOf(id)};
        for (int i = 2; i < urlParts.length; ++i) {
            try {
                urlParts[i] = new URI(null, null, (String)urlParts[i], null).getRawPath();
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        String url = String.format("%s%s/external_events/%s", urlParts);
        TypeReference<ExternalEvent> typeReference = new TypeReference<ExternalEvent>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.GET, typeReference, parameters, options);
    }

    public static ExternalEvent get() throws RuntimeException {
        return ExternalEvent.get(null, null, null);
    }

    public static ExternalEvent get(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return ExternalEvent.find(id, parameters, options);
    }

    public static ExternalEvent create(HashMap<String, Object> parameters) throws RuntimeException {
        return ExternalEvent.create(parameters, null);
    }

    public static ExternalEvent create(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (!parameters.containsKey("status") || parameters.get("status") == null) {
            throw new NullPointerException("Parameter missing: status parameters[\"status\"]");
        }
        if (!parameters.containsKey("body") || parameters.get("body") == null) {
            throw new NullPointerException("Parameter missing: body parameters[\"body\"]");
        }
        if (parameters.containsKey("status") && !(parameters.get("status") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: status must be of type String parameters[\"status\"]");
        }
        if (parameters.containsKey("body") && !(parameters.get("body") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: body must be of type String parameters[\"body\"]");
        }
        String url = String.format("%s%s/external_events", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase());
        TypeReference<ExternalEvent> typeReference = new TypeReference<ExternalEvent>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.POST, typeReference, parameters, options);
    }

    @Override
    @Generated
    public void setOptions(HashMap<String, Object> options) {
        this.options = options;
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public String getEventType() {
        return this.eventType;
    }

    @JsonProperty(value="event_type")
    @Generated
    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public String getBody() {
        return this.body;
    }

    @JsonProperty(value="body")
    @Generated
    public void setBody(String body) {
        this.body = body;
    }

    @Generated
    public Date getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public String getBodyUrl() {
        return this.bodyUrl;
    }

    @JsonProperty(value="body_url")
    @Generated
    public void setBodyUrl(String bodyUrl) {
        this.bodyUrl = bodyUrl;
    }

    @Generated
    public Long getFolderBehaviorId() {
        return this.folderBehaviorId;
    }

    @JsonProperty(value="folder_behavior_id")
    @Generated
    public void setFolderBehaviorId(Long folderBehaviorId) {
        this.folderBehaviorId = folderBehaviorId;
    }

    @Generated
    public Long getSiemHttpDestinationId() {
        return this.siemHttpDestinationId;
    }

    @JsonProperty(value="siem_http_destination_id")
    @Generated
    public void setSiemHttpDestinationId(Long siemHttpDestinationId) {
        this.siemHttpDestinationId = siemHttpDestinationId;
    }

    @Generated
    public Long getSuccessfulFiles() {
        return this.successfulFiles;
    }

    @JsonProperty(value="successful_files")
    @Generated
    public void setSuccessfulFiles(Long successfulFiles) {
        this.successfulFiles = successfulFiles;
    }

    @Generated
    public Long getErroredFiles() {
        return this.erroredFiles;
    }

    @JsonProperty(value="errored_files")
    @Generated
    public void setErroredFiles(Long erroredFiles) {
        this.erroredFiles = erroredFiles;
    }

    @Generated
    public Long getBytesSynced() {
        return this.bytesSynced;
    }

    @JsonProperty(value="bytes_synced")
    @Generated
    public void setBytesSynced(Long bytesSynced) {
        this.bytesSynced = bytesSynced;
    }

    @Generated
    public Long getComparedFiles() {
        return this.comparedFiles;
    }

    @JsonProperty(value="compared_files")
    @Generated
    public void setComparedFiles(Long comparedFiles) {
        this.comparedFiles = comparedFiles;
    }

    @Generated
    public Long getComparedFolders() {
        return this.comparedFolders;
    }

    @JsonProperty(value="compared_folders")
    @Generated
    public void setComparedFolders(Long comparedFolders) {
        this.comparedFolders = comparedFolders;
    }

    @Generated
    public String getRemoteServerType() {
        return this.remoteServerType;
    }

    @JsonProperty(value="remote_server_type")
    @Generated
    public void setRemoteServerType(String remoteServerType) {
        this.remoteServerType = remoteServerType;
    }
}

