/*
 * Decompiled with CFR 0.152.
 */
package com.files.models;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.files.FilesClient;
import com.files.FilesConfig;
import com.files.ListIterator;
import com.files.net.HttpMethods;
import com.files.util.ModelUtils;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Automation {
    private HashMap<String, Object> options;
    private ObjectMapper objectMapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().disable(new MapperFeature[]{MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS})).disable(new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS})).defaultDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX"))).build();
    @JsonProperty(value="id")
    public Long id;
    @JsonProperty(value="always_overwrite_size_matching_files")
    public Boolean alwaysOverwriteSizeMatchingFiles;
    @JsonProperty(value="automation")
    public String automation;
    @JsonProperty(value="deleted")
    public Boolean deleted;
    @JsonProperty(value="description")
    public String description;
    @JsonProperty(value="destination_replace_from")
    public String destinationReplaceFrom;
    @JsonProperty(value="destination_replace_to")
    public String destinationReplaceTo;
    @JsonProperty(value="destinations")
    public String[] destinations;
    @JsonProperty(value="disabled")
    public Boolean disabled;
    @JsonProperty(value="flatten_destination_structure")
    public Boolean flattenDestinationStructure;
    @JsonProperty(value="group_ids")
    public Long[] groupIds;
    @JsonProperty(value="ignore_locked_folders")
    public Boolean ignoreLockedFolders;
    @JsonProperty(value="interval")
    public String interval;
    @JsonProperty(value="last_modified_at")
    public Date lastModifiedAt;
    @JsonProperty(value="legacy_folder_matching")
    public Boolean legacyFolderMatching;
    @JsonProperty(value="name")
    public String name;
    @JsonProperty(value="overwrite_files")
    public Boolean overwriteFiles;
    @JsonProperty(value="path")
    public String path;
    @JsonProperty(value="path_time_zone")
    public String pathTimeZone;
    @JsonProperty(value="recurring_day")
    public Long recurringDay;
    @JsonProperty(value="schedule")
    public Map<String, String> schedule;
    @JsonProperty(value="human_readable_schedule")
    public String humanReadableSchedule;
    @JsonProperty(value="schedule_days_of_week")
    public Long[] scheduleDaysOfWeek;
    @JsonProperty(value="schedule_times_of_day")
    public String[] scheduleTimesOfDay;
    @JsonProperty(value="schedule_time_zone")
    public String scheduleTimeZone;
    @JsonProperty(value="source")
    public String source;
    @JsonProperty(value="sync_ids")
    public Long[] syncIds;
    @JsonProperty(value="trigger_actions")
    public String[] triggerActions;
    @JsonProperty(value="trigger")
    public String trigger;
    @JsonProperty(value="user_id")
    public Long userId;
    @JsonProperty(value="user_ids")
    public Long[] userIds;
    @JsonProperty(value="value")
    public Map<String, String> value;
    @JsonProperty(value="webhook_url")
    public String webhookUrl;

    public Automation() {
        this(null, null);
    }

    public Automation(HashMap<String, Object> parameters) {
        this(parameters, null);
    }

    public Automation(HashMap<String, Object> parameters, HashMap<String, Object> options) {
        this.options = options;
        try {
            ObjectReader objectReader = this.objectMapper.readerForUpdating((Object)this);
            objectReader.readValue(this.objectMapper.writeValueAsString(parameters));
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }

    public void manualRun() throws IOException {
        HashMap<String, Object> parameters = ModelUtils.toParameterMap(this.objectMapper.writeValueAsString((Object)this));
        Automation.manualRun(this.id, parameters);
    }

    public Automation update() throws IOException {
        HashMap<String, Object> parameters = ModelUtils.toParameterMap(this.objectMapper.writeValueAsString((Object)this));
        return Automation.update(this.id, parameters);
    }

    public void delete() throws IOException {
        HashMap<String, Object> parameters = ModelUtils.toParameterMap(this.objectMapper.writeValueAsString((Object)this));
        Automation.delete(this.id, parameters);
    }

    public void destroy(HashMap<String, Object> parameters) throws IOException {
        this.delete();
    }

    public void save() throws IOException {
        HashMap<String, Object> parameters = ModelUtils.toParameterMap(this.objectMapper.writeValueAsString((Object)this));
        Automation.create(parameters, this.options);
    }

    public static ListIterator<Automation> list() throws RuntimeException {
        return Automation.list(null, null);
    }

    public static ListIterator<Automation> list(HashMap<String, Object> parameters) throws RuntimeException {
        return Automation.list(parameters, null);
    }

    public static ListIterator<Automation> list(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (parameters.containsKey("cursor") && !(parameters.get("cursor") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: cursor must be of type String parameters[\"cursor\"]");
        }
        if (parameters.containsKey("per_page") && !(parameters.get("per_page") instanceof Long)) {
            throw new IllegalArgumentException("Bad parameter: per_page must be of type Long parameters[\"per_page\"]");
        }
        if (parameters.containsKey("sort_by") && !(parameters.get("sort_by") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: sort_by must be of type Map<String, String> parameters[\"sort_by\"]");
        }
        if (parameters.containsKey("filter") && !(parameters.get("filter") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: filter must be of type Map<String, String> parameters[\"filter\"]");
        }
        if (parameters.containsKey("filter_gt") && !(parameters.get("filter_gt") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: filter_gt must be of type Map<String, String> parameters[\"filter_gt\"]");
        }
        if (parameters.containsKey("filter_gteq") && !(parameters.get("filter_gteq") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: filter_gteq must be of type Map<String, String> parameters[\"filter_gteq\"]");
        }
        if (parameters.containsKey("filter_lt") && !(parameters.get("filter_lt") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: filter_lt must be of type Map<String, String> parameters[\"filter_lt\"]");
        }
        if (parameters.containsKey("filter_lteq") && !(parameters.get("filter_lteq") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: filter_lteq must be of type Map<String, String> parameters[\"filter_lteq\"]");
        }
        if (parameters.containsKey("with_deleted") && !(parameters.get("with_deleted") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: with_deleted must be of type Boolean parameters[\"with_deleted\"]");
        }
        String url = String.format("%s%s/automations", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase());
        TypeReference<List<Automation>> typeReference = new TypeReference<List<Automation>>(){};
        return FilesClient.requestList(url, HttpMethods.RequestMethods.GET, typeReference, parameters, options);
    }

    public static ListIterator<Automation> all() throws RuntimeException {
        return Automation.all(null, null);
    }

    public static ListIterator<Automation> all(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return Automation.list(parameters, options);
    }

    public static Automation find(Long id, HashMap<String, Object> parameters) throws RuntimeException {
        return Automation.find(id, parameters, null);
    }

    public static Automation find(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return Automation.find(null, parameters, options);
    }

    public static Automation find(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (id == null && parameters.containsKey("id") && parameters.get("id") != null) {
            id = (Long)parameters.get("id");
        }
        if (id == null) {
            throw new NullPointerException("Argument or Parameter missing: id parameters[\"id\"]");
        }
        if (!(id instanceof Long)) {
            throw new IllegalArgumentException("Bad parameter: id must be of type Long parameters[\"id\"]");
        }
        Object[] urlParts = new String[]{FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), String.valueOf(id)};
        for (int i = 2; i < urlParts.length; ++i) {
            try {
                urlParts[i] = new URI(null, null, (String)urlParts[i], null).getRawPath();
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        String url = String.format("%s%s/automations/%s", urlParts);
        TypeReference<Automation> typeReference = new TypeReference<Automation>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.GET, typeReference, parameters, options);
    }

    public static Automation get() throws RuntimeException {
        return Automation.get(null, null, null);
    }

    public static Automation get(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return Automation.find(id, parameters, options);
    }

    public static Automation create(HashMap<String, Object> parameters) throws RuntimeException {
        return Automation.create(parameters, null);
    }

    public static Automation create(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (!parameters.containsKey("automation") || parameters.get("automation") == null) {
            throw new NullPointerException("Parameter missing: automation parameters[\"automation\"]");
        }
        if (parameters.containsKey("source") && !(parameters.get("source") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: source must be of type String parameters[\"source\"]");
        }
        if (parameters.containsKey("destinations") && !(parameters.get("destinations") instanceof String[])) {
            throw new IllegalArgumentException("Bad parameter: destinations must be of type String[] parameters[\"destinations\"]");
        }
        if (parameters.containsKey("destination_replace_from") && !(parameters.get("destination_replace_from") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: destination_replace_from must be of type String parameters[\"destination_replace_from\"]");
        }
        if (parameters.containsKey("destination_replace_to") && !(parameters.get("destination_replace_to") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: destination_replace_to must be of type String parameters[\"destination_replace_to\"]");
        }
        if (parameters.containsKey("interval") && !(parameters.get("interval") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: interval must be of type String parameters[\"interval\"]");
        }
        if (parameters.containsKey("path") && !(parameters.get("path") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: path must be of type String parameters[\"path\"]");
        }
        if (parameters.containsKey("sync_ids") && !(parameters.get("sync_ids") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: sync_ids must be of type String parameters[\"sync_ids\"]");
        }
        if (parameters.containsKey("user_ids") && !(parameters.get("user_ids") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: user_ids must be of type String parameters[\"user_ids\"]");
        }
        if (parameters.containsKey("group_ids") && !(parameters.get("group_ids") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: group_ids must be of type String parameters[\"group_ids\"]");
        }
        if (parameters.containsKey("schedule_days_of_week") && !(parameters.get("schedule_days_of_week") instanceof Long[])) {
            throw new IllegalArgumentException("Bad parameter: schedule_days_of_week must be of type Long[] parameters[\"schedule_days_of_week\"]");
        }
        if (parameters.containsKey("schedule_times_of_day") && !(parameters.get("schedule_times_of_day") instanceof String[])) {
            throw new IllegalArgumentException("Bad parameter: schedule_times_of_day must be of type String[] parameters[\"schedule_times_of_day\"]");
        }
        if (parameters.containsKey("schedule_time_zone") && !(parameters.get("schedule_time_zone") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: schedule_time_zone must be of type String parameters[\"schedule_time_zone\"]");
        }
        if (parameters.containsKey("always_overwrite_size_matching_files") && !(parameters.get("always_overwrite_size_matching_files") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: always_overwrite_size_matching_files must be of type Boolean parameters[\"always_overwrite_size_matching_files\"]");
        }
        if (parameters.containsKey("description") && !(parameters.get("description") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: description must be of type String parameters[\"description\"]");
        }
        if (parameters.containsKey("disabled") && !(parameters.get("disabled") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: disabled must be of type Boolean parameters[\"disabled\"]");
        }
        if (parameters.containsKey("flatten_destination_structure") && !(parameters.get("flatten_destination_structure") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: flatten_destination_structure must be of type Boolean parameters[\"flatten_destination_structure\"]");
        }
        if (parameters.containsKey("ignore_locked_folders") && !(parameters.get("ignore_locked_folders") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: ignore_locked_folders must be of type Boolean parameters[\"ignore_locked_folders\"]");
        }
        if (parameters.containsKey("legacy_folder_matching") && !(parameters.get("legacy_folder_matching") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: legacy_folder_matching must be of type Boolean parameters[\"legacy_folder_matching\"]");
        }
        if (parameters.containsKey("name") && !(parameters.get("name") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: name must be of type String parameters[\"name\"]");
        }
        if (parameters.containsKey("overwrite_files") && !(parameters.get("overwrite_files") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: overwrite_files must be of type Boolean parameters[\"overwrite_files\"]");
        }
        if (parameters.containsKey("path_time_zone") && !(parameters.get("path_time_zone") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: path_time_zone must be of type String parameters[\"path_time_zone\"]");
        }
        if (parameters.containsKey("trigger") && !(parameters.get("trigger") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: trigger must be of type String parameters[\"trigger\"]");
        }
        if (parameters.containsKey("trigger_actions") && !(parameters.get("trigger_actions") instanceof String[])) {
            throw new IllegalArgumentException("Bad parameter: trigger_actions must be of type String[] parameters[\"trigger_actions\"]");
        }
        if (parameters.containsKey("value") && !(parameters.get("value") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: value must be of type Map<String, String> parameters[\"value\"]");
        }
        if (parameters.containsKey("recurring_day") && !(parameters.get("recurring_day") instanceof Long)) {
            throw new IllegalArgumentException("Bad parameter: recurring_day must be of type Long parameters[\"recurring_day\"]");
        }
        if (parameters.containsKey("automation") && !(parameters.get("automation") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: automation must be of type String parameters[\"automation\"]");
        }
        String url = String.format("%s%s/automations", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase());
        TypeReference<Automation> typeReference = new TypeReference<Automation>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.POST, typeReference, parameters, options);
    }

    public static void manualRun(Long id, HashMap<String, Object> parameters) throws RuntimeException {
        Automation.manualRun(id, parameters, null);
    }

    public static void manualRun(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        Automation.manualRun(null, parameters, options);
    }

    public static void manualRun(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (id == null && parameters.containsKey("id") && parameters.get("id") != null) {
            id = (Long)parameters.get("id");
        }
        if (id == null) {
            throw new NullPointerException("Argument or Parameter missing: id parameters[\"id\"]");
        }
        if (!(id instanceof Long)) {
            throw new IllegalArgumentException("Bad parameter: id must be of type Long parameters[\"id\"]");
        }
        Object[] urlParts = new String[]{FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), String.valueOf(id)};
        for (int i = 2; i < urlParts.length; ++i) {
            try {
                urlParts[i] = new URI(null, null, (String)urlParts[i], null).getRawPath();
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        String url = String.format("%s%s/automations/%s/manual_run", urlParts);
        FilesClient.apiRequest(url, HttpMethods.RequestMethods.POST, parameters, options);
    }

    public static Automation update(Long id, HashMap<String, Object> parameters) throws RuntimeException {
        return Automation.update(id, parameters, null);
    }

    public static Automation update(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return Automation.update(null, parameters, options);
    }

    public static Automation update(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (id == null && parameters.containsKey("id") && parameters.get("id") != null) {
            id = (Long)parameters.get("id");
        }
        if (id == null) {
            throw new NullPointerException("Argument or Parameter missing: id parameters[\"id\"]");
        }
        if (!(id instanceof Long)) {
            throw new IllegalArgumentException("Bad parameter: id must be of type Long parameters[\"id\"]");
        }
        if (parameters.containsKey("source") && !(parameters.get("source") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: source must be of type String parameters[\"source\"]");
        }
        if (parameters.containsKey("destinations") && !(parameters.get("destinations") instanceof String[])) {
            throw new IllegalArgumentException("Bad parameter: destinations must be of type String[] parameters[\"destinations\"]");
        }
        if (parameters.containsKey("destination_replace_from") && !(parameters.get("destination_replace_from") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: destination_replace_from must be of type String parameters[\"destination_replace_from\"]");
        }
        if (parameters.containsKey("destination_replace_to") && !(parameters.get("destination_replace_to") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: destination_replace_to must be of type String parameters[\"destination_replace_to\"]");
        }
        if (parameters.containsKey("interval") && !(parameters.get("interval") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: interval must be of type String parameters[\"interval\"]");
        }
        if (parameters.containsKey("path") && !(parameters.get("path") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: path must be of type String parameters[\"path\"]");
        }
        if (parameters.containsKey("sync_ids") && !(parameters.get("sync_ids") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: sync_ids must be of type String parameters[\"sync_ids\"]");
        }
        if (parameters.containsKey("user_ids") && !(parameters.get("user_ids") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: user_ids must be of type String parameters[\"user_ids\"]");
        }
        if (parameters.containsKey("group_ids") && !(parameters.get("group_ids") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: group_ids must be of type String parameters[\"group_ids\"]");
        }
        if (parameters.containsKey("schedule_days_of_week") && !(parameters.get("schedule_days_of_week") instanceof Long[])) {
            throw new IllegalArgumentException("Bad parameter: schedule_days_of_week must be of type Long[] parameters[\"schedule_days_of_week\"]");
        }
        if (parameters.containsKey("schedule_times_of_day") && !(parameters.get("schedule_times_of_day") instanceof String[])) {
            throw new IllegalArgumentException("Bad parameter: schedule_times_of_day must be of type String[] parameters[\"schedule_times_of_day\"]");
        }
        if (parameters.containsKey("schedule_time_zone") && !(parameters.get("schedule_time_zone") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: schedule_time_zone must be of type String parameters[\"schedule_time_zone\"]");
        }
        if (parameters.containsKey("always_overwrite_size_matching_files") && !(parameters.get("always_overwrite_size_matching_files") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: always_overwrite_size_matching_files must be of type Boolean parameters[\"always_overwrite_size_matching_files\"]");
        }
        if (parameters.containsKey("description") && !(parameters.get("description") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: description must be of type String parameters[\"description\"]");
        }
        if (parameters.containsKey("disabled") && !(parameters.get("disabled") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: disabled must be of type Boolean parameters[\"disabled\"]");
        }
        if (parameters.containsKey("flatten_destination_structure") && !(parameters.get("flatten_destination_structure") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: flatten_destination_structure must be of type Boolean parameters[\"flatten_destination_structure\"]");
        }
        if (parameters.containsKey("ignore_locked_folders") && !(parameters.get("ignore_locked_folders") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: ignore_locked_folders must be of type Boolean parameters[\"ignore_locked_folders\"]");
        }
        if (parameters.containsKey("legacy_folder_matching") && !(parameters.get("legacy_folder_matching") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: legacy_folder_matching must be of type Boolean parameters[\"legacy_folder_matching\"]");
        }
        if (parameters.containsKey("name") && !(parameters.get("name") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: name must be of type String parameters[\"name\"]");
        }
        if (parameters.containsKey("overwrite_files") && !(parameters.get("overwrite_files") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: overwrite_files must be of type Boolean parameters[\"overwrite_files\"]");
        }
        if (parameters.containsKey("path_time_zone") && !(parameters.get("path_time_zone") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: path_time_zone must be of type String parameters[\"path_time_zone\"]");
        }
        if (parameters.containsKey("trigger") && !(parameters.get("trigger") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: trigger must be of type String parameters[\"trigger\"]");
        }
        if (parameters.containsKey("trigger_actions") && !(parameters.get("trigger_actions") instanceof String[])) {
            throw new IllegalArgumentException("Bad parameter: trigger_actions must be of type String[] parameters[\"trigger_actions\"]");
        }
        if (parameters.containsKey("value") && !(parameters.get("value") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: value must be of type Map<String, String> parameters[\"value\"]");
        }
        if (parameters.containsKey("recurring_day") && !(parameters.get("recurring_day") instanceof Long)) {
            throw new IllegalArgumentException("Bad parameter: recurring_day must be of type Long parameters[\"recurring_day\"]");
        }
        if (parameters.containsKey("automation") && !(parameters.get("automation") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: automation must be of type String parameters[\"automation\"]");
        }
        Object[] urlParts = new String[]{FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), String.valueOf(id)};
        for (int i = 2; i < urlParts.length; ++i) {
            try {
                urlParts[i] = new URI(null, null, (String)urlParts[i], null).getRawPath();
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        String url = String.format("%s%s/automations/%s", urlParts);
        TypeReference<Automation> typeReference = new TypeReference<Automation>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.PATCH, typeReference, parameters, options);
    }

    public static void delete(Long id, HashMap<String, Object> parameters) throws RuntimeException {
        Automation.delete(id, parameters, null);
    }

    public static void delete(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        Automation.delete(null, parameters, options);
    }

    public static void delete(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (id == null && parameters.containsKey("id") && parameters.get("id") != null) {
            id = (Long)parameters.get("id");
        }
        if (id == null) {
            throw new NullPointerException("Argument or Parameter missing: id parameters[\"id\"]");
        }
        if (!(id instanceof Long)) {
            throw new IllegalArgumentException("Bad parameter: id must be of type Long parameters[\"id\"]");
        }
        Object[] urlParts = new String[]{FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), String.valueOf(id)};
        for (int i = 2; i < urlParts.length; ++i) {
            try {
                urlParts[i] = new URI(null, null, (String)urlParts[i], null).getRawPath();
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        String url = String.format("%s%s/automations/%s", urlParts);
        FilesClient.apiRequest(url, HttpMethods.RequestMethods.DELETE, parameters, options);
    }

    public static void destroy() throws RuntimeException {
        Automation.destroy(null, null, null);
    }

    public static void destroy(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        Automation.delete(id, parameters, options);
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public Boolean getAlwaysOverwriteSizeMatchingFiles() {
        return this.alwaysOverwriteSizeMatchingFiles;
    }

    @JsonProperty(value="always_overwrite_size_matching_files")
    @Generated
    public void setAlwaysOverwriteSizeMatchingFiles(Boolean alwaysOverwriteSizeMatchingFiles) {
        this.alwaysOverwriteSizeMatchingFiles = alwaysOverwriteSizeMatchingFiles;
    }

    @Generated
    public String getAutomation() {
        return this.automation;
    }

    @JsonProperty(value="automation")
    @Generated
    public void setAutomation(String automation) {
        this.automation = automation;
    }

    @Generated
    public Boolean getDeleted() {
        return this.deleted;
    }

    @JsonProperty(value="deleted")
    @Generated
    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public String getDestinationReplaceFrom() {
        return this.destinationReplaceFrom;
    }

    @JsonProperty(value="destination_replace_from")
    @Generated
    public void setDestinationReplaceFrom(String destinationReplaceFrom) {
        this.destinationReplaceFrom = destinationReplaceFrom;
    }

    @Generated
    public String getDestinationReplaceTo() {
        return this.destinationReplaceTo;
    }

    @JsonProperty(value="destination_replace_to")
    @Generated
    public void setDestinationReplaceTo(String destinationReplaceTo) {
        this.destinationReplaceTo = destinationReplaceTo;
    }

    @Generated
    public String[] getDestinations() {
        return this.destinations;
    }

    @JsonProperty(value="destinations")
    @Generated
    public void setDestinations(String[] destinations) {
        this.destinations = destinations;
    }

    @Generated
    public Boolean getDisabled() {
        return this.disabled;
    }

    @JsonProperty(value="disabled")
    @Generated
    public void setDisabled(Boolean disabled) {
        this.disabled = disabled;
    }

    @Generated
    public Boolean getFlattenDestinationStructure() {
        return this.flattenDestinationStructure;
    }

    @JsonProperty(value="flatten_destination_structure")
    @Generated
    public void setFlattenDestinationStructure(Boolean flattenDestinationStructure) {
        this.flattenDestinationStructure = flattenDestinationStructure;
    }

    @Generated
    public Long[] getGroupIds() {
        return this.groupIds;
    }

    @JsonProperty(value="group_ids")
    @Generated
    public void setGroupIds(Long[] groupIds) {
        this.groupIds = groupIds;
    }

    @Generated
    public Boolean getIgnoreLockedFolders() {
        return this.ignoreLockedFolders;
    }

    @JsonProperty(value="ignore_locked_folders")
    @Generated
    public void setIgnoreLockedFolders(Boolean ignoreLockedFolders) {
        this.ignoreLockedFolders = ignoreLockedFolders;
    }

    @Generated
    public String getInterval() {
        return this.interval;
    }

    @JsonProperty(value="interval")
    @Generated
    public void setInterval(String interval) {
        this.interval = interval;
    }

    @Generated
    public Date getLastModifiedAt() {
        return this.lastModifiedAt;
    }

    @JsonProperty(value="last_modified_at")
    @Generated
    public void setLastModifiedAt(Date lastModifiedAt) {
        this.lastModifiedAt = lastModifiedAt;
    }

    @Generated
    public Boolean getLegacyFolderMatching() {
        return this.legacyFolderMatching;
    }

    @JsonProperty(value="legacy_folder_matching")
    @Generated
    public void setLegacyFolderMatching(Boolean legacyFolderMatching) {
        this.legacyFolderMatching = legacyFolderMatching;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public Boolean getOverwriteFiles() {
        return this.overwriteFiles;
    }

    @JsonProperty(value="overwrite_files")
    @Generated
    public void setOverwriteFiles(Boolean overwriteFiles) {
        this.overwriteFiles = overwriteFiles;
    }

    @Generated
    public String getPath() {
        return this.path;
    }

    @JsonProperty(value="path")
    @Generated
    public void setPath(String path) {
        this.path = path;
    }

    @Generated
    public String getPathTimeZone() {
        return this.pathTimeZone;
    }

    @JsonProperty(value="path_time_zone")
    @Generated
    public void setPathTimeZone(String pathTimeZone) {
        this.pathTimeZone = pathTimeZone;
    }

    @Generated
    public Long getRecurringDay() {
        return this.recurringDay;
    }

    @JsonProperty(value="recurring_day")
    @Generated
    public void setRecurringDay(Long recurringDay) {
        this.recurringDay = recurringDay;
    }

    @Generated
    public Map<String, String> getSchedule() {
        return this.schedule;
    }

    @JsonProperty(value="schedule")
    @Generated
    public void setSchedule(Map<String, String> schedule) {
        this.schedule = schedule;
    }

    @Generated
    public String getHumanReadableSchedule() {
        return this.humanReadableSchedule;
    }

    @JsonProperty(value="human_readable_schedule")
    @Generated
    public void setHumanReadableSchedule(String humanReadableSchedule) {
        this.humanReadableSchedule = humanReadableSchedule;
    }

    @Generated
    public Long[] getScheduleDaysOfWeek() {
        return this.scheduleDaysOfWeek;
    }

    @JsonProperty(value="schedule_days_of_week")
    @Generated
    public void setScheduleDaysOfWeek(Long[] scheduleDaysOfWeek) {
        this.scheduleDaysOfWeek = scheduleDaysOfWeek;
    }

    @Generated
    public String[] getScheduleTimesOfDay() {
        return this.scheduleTimesOfDay;
    }

    @JsonProperty(value="schedule_times_of_day")
    @Generated
    public void setScheduleTimesOfDay(String[] scheduleTimesOfDay) {
        this.scheduleTimesOfDay = scheduleTimesOfDay;
    }

    @Generated
    public String getScheduleTimeZone() {
        return this.scheduleTimeZone;
    }

    @JsonProperty(value="schedule_time_zone")
    @Generated
    public void setScheduleTimeZone(String scheduleTimeZone) {
        this.scheduleTimeZone = scheduleTimeZone;
    }

    @Generated
    public String getSource() {
        return this.source;
    }

    @JsonProperty(value="source")
    @Generated
    public void setSource(String source) {
        this.source = source;
    }

    @Generated
    public Long[] getSyncIds() {
        return this.syncIds;
    }

    @JsonProperty(value="sync_ids")
    @Generated
    public void setSyncIds(Long[] syncIds) {
        this.syncIds = syncIds;
    }

    @Generated
    public String[] getTriggerActions() {
        return this.triggerActions;
    }

    @JsonProperty(value="trigger_actions")
    @Generated
    public void setTriggerActions(String[] triggerActions) {
        this.triggerActions = triggerActions;
    }

    @Generated
    public String getTrigger() {
        return this.trigger;
    }

    @JsonProperty(value="trigger")
    @Generated
    public void setTrigger(String trigger) {
        this.trigger = trigger;
    }

    @Generated
    public Long getUserId() {
        return this.userId;
    }

    @JsonProperty(value="user_id")
    @Generated
    public void setUserId(Long userId) {
        this.userId = userId;
    }

    @Generated
    public Long[] getUserIds() {
        return this.userIds;
    }

    @JsonProperty(value="user_ids")
    @Generated
    public void setUserIds(Long[] userIds) {
        this.userIds = userIds;
    }

    @Generated
    public Map<String, String> getValue() {
        return this.value;
    }

    @JsonProperty(value="value")
    @Generated
    public void setValue(Map<String, String> value) {
        this.value = value;
    }

    @Generated
    public String getWebhookUrl() {
        return this.webhookUrl;
    }

    @JsonProperty(value="webhook_url")
    @Generated
    public void setWebhookUrl(String webhookUrl) {
        this.webhookUrl = webhookUrl;
    }
}

