/*
 * Decompiled with CFR 0.152.
 */
package com.files.models;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.files.FilesClient;
import com.files.models.File;
import com.files.net.HttpMethods;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class FileUploadPart {
    private HashMap<String, Object> options;
    private ObjectMapper objectMapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().disable(new MapperFeature[]{MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS})).disable(new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS})).defaultDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX"))).build();
    @JsonProperty(value="send")
    public Map<String, String> send;
    @JsonProperty(value="action")
    public String action;
    @JsonProperty(value="ask_about_overwrites")
    public Boolean askAboutOverwrites;
    @JsonProperty(value="available_parts")
    public Long availableParts;
    @JsonProperty(value="expires")
    public String expires;
    @JsonProperty(value="headers")
    public Map<String, String> headers;
    @JsonProperty(value="http_method")
    public String httpMethod;
    @JsonProperty(value="next_partsize")
    public Long nextPartsize;
    @JsonProperty(value="parallel_parts")
    public Boolean parallelParts;
    @JsonProperty(value="retry_parts")
    public Boolean retryParts;
    @JsonProperty(value="parameters")
    public Map<String, String> parameters;
    @JsonProperty(value="part_number")
    public Long partNumber;
    @JsonProperty(value="partsize")
    public Long partsize;
    @JsonProperty(value="path")
    public String path;
    @JsonProperty(value="ref")
    public String ref;
    @JsonProperty(value="upload_uri")
    public String uploadUri;

    public File putBufferedInputStream(BufferedInputStream inputStream, long length, Date date) throws IOException {
        HttpMethods.RequestMethods requestMethod = HttpMethods.RequestMethods.PUT;
        if (this.httpMethod == "post") {
            requestMethod = HttpMethods.RequestMethods.POST;
        }
        FilesClient.putBufferedInputStream(this.uploadUri, requestMethod, this.path, inputStream, length);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("action", "end");
        parameters.put("ref", this.ref);
        return File.completeUpload(this.path, parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File putLocalFile(String source) throws IOException {
        HttpMethods.RequestMethods requestMethod = HttpMethods.RequestMethods.PUT;
        if (this.httpMethod == "post") {
            requestMethod = HttpMethods.RequestMethods.POST;
        }
        java.io.File file = new java.io.File(source);
        long fileLength = file.length();
        FileInputStream fileInputStream = null;
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            FilesClient.putBufferedInputStream(this.uploadUri, requestMethod, this.path, bufferedInputStream, fileLength);
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("action", "end");
            parameters.put("ref", this.ref);
            File file2 = File.completeUpload(this.path, parameters);
            return file2;
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
            if (bufferedInputStream != null) {
                bufferedInputStream.close();
            }
        }
    }

    public FileUploadPart() {
        this(null, null);
    }

    public FileUploadPart(HashMap<String, Object> parameters) {
        this(parameters, null);
    }

    public FileUploadPart(HashMap<String, Object> parameters, HashMap<String, Object> options) {
        this.options = options;
        try {
            ObjectReader objectReader = this.objectMapper.readerForUpdating((Object)this);
            objectReader.readValue(this.objectMapper.writeValueAsString(parameters));
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }

    @Generated
    public Map<String, String> getSend() {
        return this.send;
    }

    @Generated
    public String getAction() {
        return this.action;
    }

    @Generated
    public Boolean getAskAboutOverwrites() {
        return this.askAboutOverwrites;
    }

    @Generated
    public Long getAvailableParts() {
        return this.availableParts;
    }

    @Generated
    public String getExpires() {
        return this.expires;
    }

    @Generated
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Generated
    public String getHttpMethod() {
        return this.httpMethod;
    }

    @Generated
    public Long getNextPartsize() {
        return this.nextPartsize;
    }

    @Generated
    public Boolean getParallelParts() {
        return this.parallelParts;
    }

    @Generated
    public Boolean getRetryParts() {
        return this.retryParts;
    }

    @Generated
    public Map<String, String> getParameters() {
        return this.parameters;
    }

    @Generated
    public Long getPartNumber() {
        return this.partNumber;
    }

    @Generated
    public Long getPartsize() {
        return this.partsize;
    }

    @Generated
    public String getPath() {
        return this.path;
    }

    @Generated
    public String getRef() {
        return this.ref;
    }

    @Generated
    public String getUploadUri() {
        return this.uploadUri;
    }
}

