/*
 * Decompiled with CFR 0.152.
 */
package com.files.models;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.files.FilesClient;
import com.files.FilesConfig;
import com.files.ListIterator;
import com.files.net.HttpMethods;
import com.files.util.ModelUtils;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Message {
    private HashMap<String, Object> options;
    private ObjectMapper objectMapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().disable(new MapperFeature[]{MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS})).disable(new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS})).defaultDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX"))).build();
    @JsonProperty(value="id")
    public Long id;
    @JsonProperty(value="subject")
    public String subject;
    @JsonProperty(value="body")
    public String body;
    @JsonProperty(value="comments")
    public Object[] comments;
    @JsonProperty(value="user_id")
    public Long userId;
    @JsonProperty(value="project_id")
    public Long projectId;

    public Message() {
        this(null, null);
    }

    public Message(HashMap<String, Object> parameters) {
        this(parameters, null);
    }

    public Message(HashMap<String, Object> parameters, HashMap<String, Object> options) {
        this.options = options;
        try {
            ObjectReader objectReader = this.objectMapper.readerForUpdating((Object)this);
            objectReader.readValue(this.objectMapper.writeValueAsString(parameters));
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }

    public Message update() throws IOException {
        HashMap<String, Object> parameters = ModelUtils.toParameterMap(this.objectMapper.writeValueAsString((Object)this));
        return Message.update(this.id, parameters);
    }

    public void delete() throws IOException {
        HashMap<String, Object> parameters = ModelUtils.toParameterMap(this.objectMapper.writeValueAsString((Object)this));
        Message.delete(this.id, parameters);
    }

    public void destroy(HashMap<String, Object> parameters) throws IOException {
        this.delete();
    }

    public void save() throws IOException {
        HashMap<String, Object> parameters = ModelUtils.toParameterMap(this.objectMapper.writeValueAsString((Object)this));
        Message.create(parameters, this.options);
    }

    public static ListIterator<Message> list() throws RuntimeException {
        return Message.list(null, null);
    }

    public static ListIterator<Message> list(HashMap<String, Object> parameters) throws RuntimeException {
        return Message.list(parameters, null);
    }

    public static ListIterator<Message> list(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (!parameters.containsKey("project_id") || parameters.get("project_id") == null) {
            throw new NullPointerException("Parameter missing: project_id parameters[\"project_id\"]");
        }
        if (parameters.containsKey("user_id") && !(parameters.get("user_id") instanceof Long)) {
            throw new IllegalArgumentException("Bad parameter: user_id must be of type Long parameters[\"user_id\"]");
        }
        if (parameters.containsKey("cursor") && !(parameters.get("cursor") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: cursor must be of type String parameters[\"cursor\"]");
        }
        if (parameters.containsKey("per_page") && !(parameters.get("per_page") instanceof Long)) {
            throw new IllegalArgumentException("Bad parameter: per_page must be of type Long parameters[\"per_page\"]");
        }
        if (parameters.containsKey("project_id") && !(parameters.get("project_id") instanceof Long)) {
            throw new IllegalArgumentException("Bad parameter: project_id must be of type Long parameters[\"project_id\"]");
        }
        String url = String.format("%s%s/messages", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase());
        TypeReference<List<Message>> typeReference = new TypeReference<List<Message>>(){};
        return FilesClient.requestList(url, HttpMethods.RequestMethods.GET, typeReference, parameters, options);
    }

    public static ListIterator<Message> all() throws RuntimeException {
        return Message.all(null, null);
    }

    public static ListIterator<Message> all(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return Message.list(parameters, options);
    }

    public static Message find(Long id, HashMap<String, Object> parameters) throws RuntimeException {
        return Message.find(id, parameters, null);
    }

    public static Message find(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return Message.find(null, parameters, options);
    }

    public static Message find(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (id == null && parameters.containsKey("id") && parameters.get("id") != null) {
            id = (Long)parameters.get("id");
        }
        if (id == null) {
            throw new NullPointerException("Argument or Parameter missing: id parameters[\"id\"]");
        }
        if (!(id instanceof Long)) {
            throw new IllegalArgumentException("Bad parameter: id must be of type Long parameters[\"id\"]");
        }
        Object[] urlParts = new String[]{FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), String.valueOf(id)};
        for (int i = 2; i < urlParts.length; ++i) {
            try {
                urlParts[i] = new URI(null, null, (String)urlParts[i], null).getRawPath();
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        String url = String.format("%s%s/messages/%s", urlParts);
        TypeReference<Message> typeReference = new TypeReference<Message>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.GET, typeReference, parameters, options);
    }

    public static Message get() throws RuntimeException {
        return Message.get(null, null, null);
    }

    public static Message get(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return Message.find(id, parameters, options);
    }

    public static Message create(HashMap<String, Object> parameters) throws RuntimeException {
        return Message.create(parameters, null);
    }

    public static Message create(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (!parameters.containsKey("project_id") || parameters.get("project_id") == null) {
            throw new NullPointerException("Parameter missing: project_id parameters[\"project_id\"]");
        }
        if (!parameters.containsKey("subject") || parameters.get("subject") == null) {
            throw new NullPointerException("Parameter missing: subject parameters[\"subject\"]");
        }
        if (!parameters.containsKey("body") || parameters.get("body") == null) {
            throw new NullPointerException("Parameter missing: body parameters[\"body\"]");
        }
        if (parameters.containsKey("user_id") && !(parameters.get("user_id") instanceof Long)) {
            throw new IllegalArgumentException("Bad parameter: user_id must be of type Long parameters[\"user_id\"]");
        }
        if (parameters.containsKey("project_id") && !(parameters.get("project_id") instanceof Long)) {
            throw new IllegalArgumentException("Bad parameter: project_id must be of type Long parameters[\"project_id\"]");
        }
        if (parameters.containsKey("subject") && !(parameters.get("subject") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: subject must be of type String parameters[\"subject\"]");
        }
        if (parameters.containsKey("body") && !(parameters.get("body") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: body must be of type String parameters[\"body\"]");
        }
        String url = String.format("%s%s/messages", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase());
        TypeReference<Message> typeReference = new TypeReference<Message>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.POST, typeReference, parameters, options);
    }

    public static Message update(Long id, HashMap<String, Object> parameters) throws RuntimeException {
        return Message.update(id, parameters, null);
    }

    public static Message update(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return Message.update(null, parameters, options);
    }

    public static Message update(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (id == null && parameters.containsKey("id") && parameters.get("id") != null) {
            id = (Long)parameters.get("id");
        }
        if (id == null) {
            throw new NullPointerException("Argument or Parameter missing: id parameters[\"id\"]");
        }
        if (!parameters.containsKey("project_id") || parameters.get("project_id") == null) {
            throw new NullPointerException("Parameter missing: project_id parameters[\"project_id\"]");
        }
        if (!parameters.containsKey("subject") || parameters.get("subject") == null) {
            throw new NullPointerException("Parameter missing: subject parameters[\"subject\"]");
        }
        if (!parameters.containsKey("body") || parameters.get("body") == null) {
            throw new NullPointerException("Parameter missing: body parameters[\"body\"]");
        }
        if (!(id instanceof Long)) {
            throw new IllegalArgumentException("Bad parameter: id must be of type Long parameters[\"id\"]");
        }
        if (parameters.containsKey("project_id") && !(parameters.get("project_id") instanceof Long)) {
            throw new IllegalArgumentException("Bad parameter: project_id must be of type Long parameters[\"project_id\"]");
        }
        if (parameters.containsKey("subject") && !(parameters.get("subject") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: subject must be of type String parameters[\"subject\"]");
        }
        if (parameters.containsKey("body") && !(parameters.get("body") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: body must be of type String parameters[\"body\"]");
        }
        Object[] urlParts = new String[]{FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), String.valueOf(id)};
        for (int i = 2; i < urlParts.length; ++i) {
            try {
                urlParts[i] = new URI(null, null, (String)urlParts[i], null).getRawPath();
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        String url = String.format("%s%s/messages/%s", urlParts);
        TypeReference<Message> typeReference = new TypeReference<Message>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.PATCH, typeReference, parameters, options);
    }

    public static void delete(Long id, HashMap<String, Object> parameters) throws RuntimeException {
        Message.delete(id, parameters, null);
    }

    public static void delete(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        Message.delete(null, parameters, options);
    }

    public static void delete(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (id == null && parameters.containsKey("id") && parameters.get("id") != null) {
            id = (Long)parameters.get("id");
        }
        if (id == null) {
            throw new NullPointerException("Argument or Parameter missing: id parameters[\"id\"]");
        }
        if (!(id instanceof Long)) {
            throw new IllegalArgumentException("Bad parameter: id must be of type Long parameters[\"id\"]");
        }
        Object[] urlParts = new String[]{FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), String.valueOf(id)};
        for (int i = 2; i < urlParts.length; ++i) {
            try {
                urlParts[i] = new URI(null, null, (String)urlParts[i], null).getRawPath();
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        String url = String.format("%s%s/messages/%s", urlParts);
        FilesClient.apiRequest(url, HttpMethods.RequestMethods.DELETE, parameters, options);
    }

    public static void destroy() throws RuntimeException {
        Message.destroy(null, null, null);
    }

    public static void destroy(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        Message.delete(id, parameters, options);
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public String getSubject() {
        return this.subject;
    }

    @JsonProperty(value="subject")
    @Generated
    public void setSubject(String subject) {
        this.subject = subject;
    }

    @Generated
    public String getBody() {
        return this.body;
    }

    @JsonProperty(value="body")
    @Generated
    public void setBody(String body) {
        this.body = body;
    }

    @Generated
    public Object[] getComments() {
        return this.comments;
    }

    @JsonProperty(value="comments")
    @Generated
    public void setComments(Object[] comments) {
        this.comments = comments;
    }

    @Generated
    public Long getUserId() {
        return this.userId;
    }

    @JsonProperty(value="user_id")
    @Generated
    public void setUserId(Long userId) {
        this.userId = userId;
    }

    @Generated
    public Long getProjectId() {
        return this.projectId;
    }

    @JsonProperty(value="project_id")
    @Generated
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
}

