/*
 * Decompiled with CFR 0.152.
 */
package com.files.models;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.files.FilesClient;
import com.files.FilesConfig;
import com.files.models.Auto;
import com.files.net.HttpMethods;
import com.files.util.ModelUtils;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class WebhookTest {
    private HashMap<String, Object> options;
    private ObjectMapper objectMapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().disable(new MapperFeature[]{MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS})).disable(new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS})).defaultDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX"))).build();
    @JsonProperty(value="code")
    public Long code;
    @JsonProperty(value="message")
    public String message;
    @JsonProperty(value="status")
    public String status;
    @JsonProperty(value="data")
    public Auto data;
    @JsonProperty(value="success")
    public Boolean success;
    @JsonProperty(value="url")
    public String url;
    @JsonProperty(value="method")
    public String method;
    @JsonProperty(value="encoding")
    public String encoding;
    @JsonProperty(value="headers")
    public Map<String, String> headers;
    @JsonProperty(value="body")
    public Map<String, String> body;
    @JsonProperty(value="raw_body")
    public String rawBody;
    @JsonProperty(value="file_as_body")
    public Boolean fileAsBody;
    @JsonProperty(value="file_form_field")
    public String fileFormField;
    @JsonProperty(value="action")
    public String action;
    @JsonProperty(value="use_dedicated_ips")
    public Boolean useDedicatedIps;

    public WebhookTest() {
        this(null, null);
    }

    public WebhookTest(HashMap<String, Object> parameters) {
        this(parameters, null);
    }

    public WebhookTest(HashMap<String, Object> parameters, HashMap<String, Object> options) {
        this.options = options;
        try {
            ObjectReader objectReader = this.objectMapper.readerForUpdating((Object)this);
            objectReader.readValue(this.objectMapper.writeValueAsString(parameters));
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }

    public void save() throws IOException {
        HashMap<String, Object> parameters = ModelUtils.toParameterMap(this.objectMapper.writeValueAsString((Object)this));
        WebhookTest.create(parameters, this.options);
    }

    public static WebhookTest create(HashMap<String, Object> parameters) throws RuntimeException {
        return WebhookTest.create(parameters, null);
    }

    public static WebhookTest create(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (!parameters.containsKey("url") || parameters.get("url") == null) {
            throw new NullPointerException("Parameter missing: url parameters[\"url\"]");
        }
        if (parameters.containsKey("url") && !(parameters.get("url") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: url must be of type String parameters[\"url\"]");
        }
        if (parameters.containsKey("method") && !(parameters.get("method") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: method must be of type String parameters[\"method\"]");
        }
        if (parameters.containsKey("encoding") && !(parameters.get("encoding") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: encoding must be of type String parameters[\"encoding\"]");
        }
        if (parameters.containsKey("headers") && !(parameters.get("headers") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: headers must be of type Map<String, String> parameters[\"headers\"]");
        }
        if (parameters.containsKey("body") && !(parameters.get("body") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: body must be of type Map<String, String> parameters[\"body\"]");
        }
        if (parameters.containsKey("raw_body") && !(parameters.get("raw_body") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: raw_body must be of type String parameters[\"raw_body\"]");
        }
        if (parameters.containsKey("file_as_body") && !(parameters.get("file_as_body") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: file_as_body must be of type Boolean parameters[\"file_as_body\"]");
        }
        if (parameters.containsKey("file_form_field") && !(parameters.get("file_form_field") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: file_form_field must be of type String parameters[\"file_form_field\"]");
        }
        if (parameters.containsKey("action") && !(parameters.get("action") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: action must be of type String parameters[\"action\"]");
        }
        if (parameters.containsKey("use_dedicated_ips") && !(parameters.get("use_dedicated_ips") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: use_dedicated_ips must be of type Boolean parameters[\"use_dedicated_ips\"]");
        }
        String url = String.format("%s%s/webhook_tests", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase());
        TypeReference<WebhookTest> typeReference = new TypeReference<WebhookTest>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.POST, typeReference, parameters, options);
    }

    @Generated
    public Long getCode() {
        return this.code;
    }

    @JsonProperty(value="code")
    @Generated
    public void setCode(Long code) {
        this.code = code;
    }

    @Generated
    public String getMessage() {
        return this.message;
    }

    @JsonProperty(value="message")
    @Generated
    public void setMessage(String message) {
        this.message = message;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public Auto getData() {
        return this.data;
    }

    @JsonProperty(value="data")
    @Generated
    public void setData(Auto data) {
        this.data = data;
    }

    @Generated
    public Boolean getSuccess() {
        return this.success;
    }

    @JsonProperty(value="success")
    @Generated
    public void setSuccess(Boolean success) {
        this.success = success;
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @JsonProperty(value="url")
    @Generated
    public void setUrl(String url) {
        this.url = url;
    }

    @Generated
    public String getMethod() {
        return this.method;
    }

    @JsonProperty(value="method")
    @Generated
    public void setMethod(String method) {
        this.method = method;
    }

    @Generated
    public String getEncoding() {
        return this.encoding;
    }

    @JsonProperty(value="encoding")
    @Generated
    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Generated
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @JsonProperty(value="headers")
    @Generated
    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    @Generated
    public Map<String, String> getBody() {
        return this.body;
    }

    @JsonProperty(value="body")
    @Generated
    public void setBody(Map<String, String> body) {
        this.body = body;
    }

    @Generated
    public String getRawBody() {
        return this.rawBody;
    }

    @JsonProperty(value="raw_body")
    @Generated
    public void setRawBody(String rawBody) {
        this.rawBody = rawBody;
    }

    @Generated
    public Boolean getFileAsBody() {
        return this.fileAsBody;
    }

    @JsonProperty(value="file_as_body")
    @Generated
    public void setFileAsBody(Boolean fileAsBody) {
        this.fileAsBody = fileAsBody;
    }

    @Generated
    public String getFileFormField() {
        return this.fileFormField;
    }

    @JsonProperty(value="file_form_field")
    @Generated
    public void setFileFormField(String fileFormField) {
        this.fileFormField = fileFormField;
    }

    @Generated
    public String getAction() {
        return this.action;
    }

    @JsonProperty(value="action")
    @Generated
    public void setAction(String action) {
        this.action = action;
    }

    @Generated
    public Boolean getUseDedicatedIps() {
        return this.useDedicatedIps;
    }

    @JsonProperty(value="use_dedicated_ips")
    @Generated
    public void setUseDedicatedIps(Boolean useDedicatedIps) {
        this.useDedicatedIps = useDedicatedIps;
    }
}

