/*
 * Decompiled with CFR 0.152.
 */
package com.files.models;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.files.FilesClient;
import com.files.FilesConfig;
import com.files.ListIterator;
import com.files.net.HttpMethods;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class BundleRegistration {
    private HashMap<String, Object> options;
    private ObjectMapper objectMapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().disable(new MapperFeature[]{MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS})).disable(new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS})).defaultDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX"))).build();
    @JsonProperty(value="code")
    public String code;
    @JsonProperty(value="name")
    public String name;
    @JsonProperty(value="company")
    public String company;
    @JsonProperty(value="email")
    public String email;
    @JsonProperty(value="ip")
    public String ip;
    @JsonProperty(value="inbox_code")
    public String inboxCode;
    @JsonProperty(value="clickwrap_body")
    public String clickwrapBody;
    @JsonProperty(value="form_field_set_id")
    public Long formFieldSetId;
    @JsonProperty(value="form_field_data")
    public Map<String, String> formFieldData;
    @JsonProperty(value="bundle_code")
    public String bundleCode;
    @JsonProperty(value="bundle_id")
    public Long bundleId;
    @JsonProperty(value="bundle_recipient_id")
    public Long bundleRecipientId;
    @JsonProperty(value="created_at")
    public Date createdAt;

    public BundleRegistration() {
        this(null, null);
    }

    public BundleRegistration(HashMap<String, Object> parameters) {
        this(parameters, null);
    }

    public BundleRegistration(HashMap<String, Object> parameters, HashMap<String, Object> options) {
        this.options = options;
        try {
            ObjectReader objectReader = this.objectMapper.readerForUpdating((Object)this);
            objectReader.readValue(this.objectMapper.writeValueAsString(parameters));
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }

    public static ListIterator<BundleRegistration> list() throws RuntimeException {
        return BundleRegistration.list(null, null);
    }

    public static ListIterator<BundleRegistration> list(HashMap<String, Object> parameters) throws RuntimeException {
        return BundleRegistration.list(parameters, null);
    }

    public static ListIterator<BundleRegistration> list(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (parameters.containsKey("cursor") && !(parameters.get("cursor") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: cursor must be of type String parameters[\"cursor\"]");
        }
        if (parameters.containsKey("per_page") && !(parameters.get("per_page") instanceof Long)) {
            throw new IllegalArgumentException("Bad parameter: per_page must be of type Long parameters[\"per_page\"]");
        }
        if (parameters.containsKey("bundle_id") && !(parameters.get("bundle_id") instanceof Long)) {
            throw new IllegalArgumentException("Bad parameter: bundle_id must be of type Long parameters[\"bundle_id\"]");
        }
        String url = String.format("%s%s/bundle_registrations", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase());
        TypeReference<List<BundleRegistration>> typeReference = new TypeReference<List<BundleRegistration>>(){};
        return FilesClient.requestList(url, HttpMethods.RequestMethods.GET, typeReference, parameters, options);
    }

    public static ListIterator<BundleRegistration> all() throws RuntimeException {
        return BundleRegistration.all(null, null);
    }

    public static ListIterator<BundleRegistration> all(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return BundleRegistration.list(parameters, options);
    }

    @Generated
    public String getCode() {
        return this.code;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getCompany() {
        return this.company;
    }

    @Generated
    public String getEmail() {
        return this.email;
    }

    @Generated
    public String getIp() {
        return this.ip;
    }

    @Generated
    public String getInboxCode() {
        return this.inboxCode;
    }

    @Generated
    public String getClickwrapBody() {
        return this.clickwrapBody;
    }

    @Generated
    public Long getFormFieldSetId() {
        return this.formFieldSetId;
    }

    @Generated
    public Map<String, String> getFormFieldData() {
        return this.formFieldData;
    }

    @Generated
    public String getBundleCode() {
        return this.bundleCode;
    }

    @Generated
    public Long getBundleId() {
        return this.bundleId;
    }

    @Generated
    public Long getBundleRecipientId() {
        return this.bundleRecipientId;
    }

    @Generated
    public Date getCreatedAt() {
        return this.createdAt;
    }
}

