/*
 * Decompiled with CFR 0.152.
 */
package com.files.models;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.files.FilesClient;
import com.files.FilesConfig;
import com.files.ListIterator;
import com.files.models.File;
import com.files.models.Preview;
import com.files.net.HttpMethods;
import com.files.util.ModelUtils;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Folder {
    private HashMap<String, Object> options;
    private ObjectMapper objectMapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().disable(new MapperFeature[]{MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS})).disable(new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS})).defaultDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX"))).build();
    @JsonProperty(value="path")
    public String path;
    @JsonProperty(value="created_by_id")
    public Long createdById;
    @JsonProperty(value="created_by_api_key_id")
    public Long createdByApiKeyId;
    @JsonProperty(value="created_by_as2_incoming_message_id")
    public Long createdByAs2IncomingMessageId;
    @JsonProperty(value="created_by_automation_id")
    public Long createdByAutomationId;
    @JsonProperty(value="created_by_bundle_registration_id")
    public Long createdByBundleRegistrationId;
    @JsonProperty(value="created_by_inbox_id")
    public Long createdByInboxId;
    @JsonProperty(value="created_by_remote_server_id")
    public Long createdByRemoteServerId;
    @JsonProperty(value="created_by_remote_server_sync_id")
    public Long createdByRemoteServerSyncId;
    @JsonProperty(value="custom_metadata")
    public Map<String, String> customMetadata;
    @JsonProperty(value="display_name")
    public String displayName;
    @JsonProperty(value="type")
    public String type;
    @JsonProperty(value="size")
    public Long size;
    @JsonProperty(value="created_at")
    public Date createdAt;
    @JsonProperty(value="last_modified_by_id")
    public Long lastModifiedById;
    @JsonProperty(value="last_modified_by_api_key_id")
    public Long lastModifiedByApiKeyId;
    @JsonProperty(value="last_modified_by_automation_id")
    public Long lastModifiedByAutomationId;
    @JsonProperty(value="last_modified_by_bundle_registration_id")
    public Long lastModifiedByBundleRegistrationId;
    @JsonProperty(value="last_modified_by_remote_server_id")
    public Long lastModifiedByRemoteServerId;
    @JsonProperty(value="last_modified_by_remote_server_sync_id")
    public Long lastModifiedByRemoteServerSyncId;
    @JsonProperty(value="mtime")
    public Date mtime;
    @JsonProperty(value="provided_mtime")
    public Date providedMtime;
    @JsonProperty(value="crc32")
    public String crc32;
    @JsonProperty(value="md5")
    public String md5;
    @JsonProperty(value="mime_type")
    public String mimeType;
    @JsonProperty(value="region")
    public String region;
    @JsonProperty(value="permissions")
    public String permissions;
    @JsonProperty(value="subfolders_locked?")
    public Boolean subfoldersLocked;
    @JsonProperty(value="is_locked")
    public Boolean isLocked;
    @JsonProperty(value="download_uri")
    public String downloadUri;
    @JsonProperty(value="priority_color")
    public String priorityColor;
    @JsonProperty(value="preview_id")
    public Long previewId;
    @JsonProperty(value="preview")
    public Preview preview;
    @JsonProperty(value="mkdir_parents")
    public Boolean mkdirParents;

    public Folder() {
        this(null, null);
    }

    public Folder(HashMap<String, Object> parameters) {
        this(parameters, null);
    }

    public Folder(HashMap<String, Object> parameters, HashMap<String, Object> options) {
        this.options = options;
        try {
            ObjectReader objectReader = this.objectMapper.readerForUpdating((Object)this);
            objectReader.readValue(this.objectMapper.writeValueAsString(parameters));
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }

    public void save() throws IOException {
        HashMap<String, Object> parameters = ModelUtils.toParameterMap(this.objectMapper.writeValueAsString((Object)this));
        Folder.create(parameters, this.options);
    }

    public static ListIterator<File> listFor() throws RuntimeException {
        return Folder.listFor(null, null, null);
    }

    public static ListIterator<File> listFor(String path, HashMap<String, Object> parameters) throws RuntimeException {
        return Folder.listFor(path, parameters, null);
    }

    public static ListIterator<File> listFor(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return Folder.listFor(null, parameters, options);
    }

    public static ListIterator<File> listFor(String path, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (path == null && parameters.containsKey("path") && parameters.get("path") != null) {
            path = (String)parameters.get("path");
        }
        if (path == null) {
            throw new NullPointerException("Argument or Parameter missing: path parameters[\"path\"]");
        }
        if (parameters.containsKey("cursor") && !(parameters.get("cursor") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: cursor must be of type String parameters[\"cursor\"]");
        }
        if (parameters.containsKey("per_page") && !(parameters.get("per_page") instanceof Long)) {
            throw new IllegalArgumentException("Bad parameter: per_page must be of type Long parameters[\"per_page\"]");
        }
        if (!(path instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: path must be of type String parameters[\"path\"]");
        }
        if (parameters.containsKey("filter") && !(parameters.get("filter") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: filter must be of type String parameters[\"filter\"]");
        }
        if (parameters.containsKey("preview_size") && !(parameters.get("preview_size") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: preview_size must be of type String parameters[\"preview_size\"]");
        }
        if (parameters.containsKey("sort_by") && !(parameters.get("sort_by") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: sort_by must be of type Map<String, String> parameters[\"sort_by\"]");
        }
        if (parameters.containsKey("search") && !(parameters.get("search") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: search must be of type String parameters[\"search\"]");
        }
        if (parameters.containsKey("search_all") && !(parameters.get("search_all") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: search_all must be of type Boolean parameters[\"search_all\"]");
        }
        if (parameters.containsKey("with_previews") && !(parameters.get("with_previews") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: with_previews must be of type Boolean parameters[\"with_previews\"]");
        }
        if (parameters.containsKey("with_priority_color") && !(parameters.get("with_priority_color") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: with_priority_color must be of type Boolean parameters[\"with_priority_color\"]");
        }
        Object[] urlParts = new String[]{FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), path};
        for (int i = 2; i < urlParts.length; ++i) {
            try {
                urlParts[i] = new URI(null, null, (String)urlParts[i], null).getRawPath();
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        String url = String.format("%s%s/folders/%s", urlParts);
        TypeReference<List<File>> typeReference = new TypeReference<List<File>>(){};
        return FilesClient.requestList(url, HttpMethods.RequestMethods.GET, typeReference, parameters, options);
    }

    public static Folder create(String path, HashMap<String, Object> parameters) throws RuntimeException {
        return Folder.create(path, parameters, null);
    }

    public static Folder create(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return Folder.create(null, parameters, options);
    }

    public static Folder create(String path, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (path == null && parameters.containsKey("path") && parameters.get("path") != null) {
            path = (String)parameters.get("path");
        }
        if (path == null) {
            throw new NullPointerException("Argument or Parameter missing: path parameters[\"path\"]");
        }
        if (!(path instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: path must be of type String parameters[\"path\"]");
        }
        if (parameters.containsKey("mkdir_parents") && !(parameters.get("mkdir_parents") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: mkdir_parents must be of type Boolean parameters[\"mkdir_parents\"]");
        }
        if (parameters.containsKey("provided_mtime") && !(parameters.get("provided_mtime") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: provided_mtime must be of type String parameters[\"provided_mtime\"]");
        }
        Object[] urlParts = new String[]{FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), path};
        for (int i = 2; i < urlParts.length; ++i) {
            try {
                urlParts[i] = new URI(null, null, (String)urlParts[i], null).getRawPath();
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        String url = String.format("%s%s/folders/%s", urlParts);
        TypeReference<Folder> typeReference = new TypeReference<Folder>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.POST, typeReference, parameters, options);
    }

    @Generated
    public String getPath() {
        return this.path;
    }

    @JsonProperty(value="path")
    @Generated
    public void setPath(String path) {
        this.path = path;
    }

    @Generated
    public Long getCreatedById() {
        return this.createdById;
    }

    @JsonProperty(value="created_by_id")
    @Generated
    public void setCreatedById(Long createdById) {
        this.createdById = createdById;
    }

    @Generated
    public Long getCreatedByApiKeyId() {
        return this.createdByApiKeyId;
    }

    @JsonProperty(value="created_by_api_key_id")
    @Generated
    public void setCreatedByApiKeyId(Long createdByApiKeyId) {
        this.createdByApiKeyId = createdByApiKeyId;
    }

    @Generated
    public Long getCreatedByAs2IncomingMessageId() {
        return this.createdByAs2IncomingMessageId;
    }

    @JsonProperty(value="created_by_as2_incoming_message_id")
    @Generated
    public void setCreatedByAs2IncomingMessageId(Long createdByAs2IncomingMessageId) {
        this.createdByAs2IncomingMessageId = createdByAs2IncomingMessageId;
    }

    @Generated
    public Long getCreatedByAutomationId() {
        return this.createdByAutomationId;
    }

    @JsonProperty(value="created_by_automation_id")
    @Generated
    public void setCreatedByAutomationId(Long createdByAutomationId) {
        this.createdByAutomationId = createdByAutomationId;
    }

    @Generated
    public Long getCreatedByBundleRegistrationId() {
        return this.createdByBundleRegistrationId;
    }

    @JsonProperty(value="created_by_bundle_registration_id")
    @Generated
    public void setCreatedByBundleRegistrationId(Long createdByBundleRegistrationId) {
        this.createdByBundleRegistrationId = createdByBundleRegistrationId;
    }

    @Generated
    public Long getCreatedByInboxId() {
        return this.createdByInboxId;
    }

    @JsonProperty(value="created_by_inbox_id")
    @Generated
    public void setCreatedByInboxId(Long createdByInboxId) {
        this.createdByInboxId = createdByInboxId;
    }

    @Generated
    public Long getCreatedByRemoteServerId() {
        return this.createdByRemoteServerId;
    }

    @JsonProperty(value="created_by_remote_server_id")
    @Generated
    public void setCreatedByRemoteServerId(Long createdByRemoteServerId) {
        this.createdByRemoteServerId = createdByRemoteServerId;
    }

    @Generated
    public Long getCreatedByRemoteServerSyncId() {
        return this.createdByRemoteServerSyncId;
    }

    @JsonProperty(value="created_by_remote_server_sync_id")
    @Generated
    public void setCreatedByRemoteServerSyncId(Long createdByRemoteServerSyncId) {
        this.createdByRemoteServerSyncId = createdByRemoteServerSyncId;
    }

    @Generated
    public Map<String, String> getCustomMetadata() {
        return this.customMetadata;
    }

    @JsonProperty(value="custom_metadata")
    @Generated
    public void setCustomMetadata(Map<String, String> customMetadata) {
        this.customMetadata = customMetadata;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="display_name")
    @Generated
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public Long getSize() {
        return this.size;
    }

    @JsonProperty(value="size")
    @Generated
    public void setSize(Long size) {
        this.size = size;
    }

    @Generated
    public Date getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public Long getLastModifiedById() {
        return this.lastModifiedById;
    }

    @JsonProperty(value="last_modified_by_id")
    @Generated
    public void setLastModifiedById(Long lastModifiedById) {
        this.lastModifiedById = lastModifiedById;
    }

    @Generated
    public Long getLastModifiedByApiKeyId() {
        return this.lastModifiedByApiKeyId;
    }

    @JsonProperty(value="last_modified_by_api_key_id")
    @Generated
    public void setLastModifiedByApiKeyId(Long lastModifiedByApiKeyId) {
        this.lastModifiedByApiKeyId = lastModifiedByApiKeyId;
    }

    @Generated
    public Long getLastModifiedByAutomationId() {
        return this.lastModifiedByAutomationId;
    }

    @JsonProperty(value="last_modified_by_automation_id")
    @Generated
    public void setLastModifiedByAutomationId(Long lastModifiedByAutomationId) {
        this.lastModifiedByAutomationId = lastModifiedByAutomationId;
    }

    @Generated
    public Long getLastModifiedByBundleRegistrationId() {
        return this.lastModifiedByBundleRegistrationId;
    }

    @JsonProperty(value="last_modified_by_bundle_registration_id")
    @Generated
    public void setLastModifiedByBundleRegistrationId(Long lastModifiedByBundleRegistrationId) {
        this.lastModifiedByBundleRegistrationId = lastModifiedByBundleRegistrationId;
    }

    @Generated
    public Long getLastModifiedByRemoteServerId() {
        return this.lastModifiedByRemoteServerId;
    }

    @JsonProperty(value="last_modified_by_remote_server_id")
    @Generated
    public void setLastModifiedByRemoteServerId(Long lastModifiedByRemoteServerId) {
        this.lastModifiedByRemoteServerId = lastModifiedByRemoteServerId;
    }

    @Generated
    public Long getLastModifiedByRemoteServerSyncId() {
        return this.lastModifiedByRemoteServerSyncId;
    }

    @JsonProperty(value="last_modified_by_remote_server_sync_id")
    @Generated
    public void setLastModifiedByRemoteServerSyncId(Long lastModifiedByRemoteServerSyncId) {
        this.lastModifiedByRemoteServerSyncId = lastModifiedByRemoteServerSyncId;
    }

    @Generated
    public Date getMtime() {
        return this.mtime;
    }

    @JsonProperty(value="mtime")
    @Generated
    public void setMtime(Date mtime) {
        this.mtime = mtime;
    }

    @Generated
    public Date getProvidedMtime() {
        return this.providedMtime;
    }

    @JsonProperty(value="provided_mtime")
    @Generated
    public void setProvidedMtime(Date providedMtime) {
        this.providedMtime = providedMtime;
    }

    @Generated
    public String getCrc32() {
        return this.crc32;
    }

    @JsonProperty(value="crc32")
    @Generated
    public void setCrc32(String crc32) {
        this.crc32 = crc32;
    }

    @Generated
    public String getMd5() {
        return this.md5;
    }

    @JsonProperty(value="md5")
    @Generated
    public void setMd5(String md5) {
        this.md5 = md5;
    }

    @Generated
    public String getMimeType() {
        return this.mimeType;
    }

    @JsonProperty(value="mime_type")
    @Generated
    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    @Generated
    public String getRegion() {
        return this.region;
    }

    @JsonProperty(value="region")
    @Generated
    public void setRegion(String region) {
        this.region = region;
    }

    @Generated
    public String getPermissions() {
        return this.permissions;
    }

    @JsonProperty(value="permissions")
    @Generated
    public void setPermissions(String permissions) {
        this.permissions = permissions;
    }

    @Generated
    public Boolean getSubfoldersLocked() {
        return this.subfoldersLocked;
    }

    @JsonProperty(value="subfolders_locked?")
    @Generated
    public void setSubfoldersLocked(Boolean subfoldersLocked) {
        this.subfoldersLocked = subfoldersLocked;
    }

    @Generated
    public Boolean getIsLocked() {
        return this.isLocked;
    }

    @JsonProperty(value="is_locked")
    @Generated
    public void setIsLocked(Boolean isLocked) {
        this.isLocked = isLocked;
    }

    @Generated
    public String getDownloadUri() {
        return this.downloadUri;
    }

    @JsonProperty(value="download_uri")
    @Generated
    public void setDownloadUri(String downloadUri) {
        this.downloadUri = downloadUri;
    }

    @Generated
    public String getPriorityColor() {
        return this.priorityColor;
    }

    @JsonProperty(value="priority_color")
    @Generated
    public void setPriorityColor(String priorityColor) {
        this.priorityColor = priorityColor;
    }

    @Generated
    public Long getPreviewId() {
        return this.previewId;
    }

    @JsonProperty(value="preview_id")
    @Generated
    public void setPreviewId(Long previewId) {
        this.previewId = previewId;
    }

    @Generated
    public Preview getPreview() {
        return this.preview;
    }

    @JsonProperty(value="preview")
    @Generated
    public void setPreview(Preview preview) {
        this.preview = preview;
    }

    @Generated
    public Boolean getMkdirParents() {
        return this.mkdirParents;
    }

    @JsonProperty(value="mkdir_parents")
    @Generated
    public void setMkdirParents(Boolean mkdirParents) {
        this.mkdirParents = mkdirParents;
    }
}

