/*
 * Decompiled with CFR 0.152.
 */
package com.files.models;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.files.FilesClient;
import com.files.FilesConfig;
import com.files.ListIterator;
import com.files.net.HttpMethods;
import com.files.util.ModelUtils;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Notification {
    private HashMap<String, Object> options;
    private ObjectMapper objectMapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().disable(new MapperFeature[]{MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS})).disable(new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS})).defaultDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX"))).build();
    @JsonProperty(value="id")
    public Long id;
    @JsonProperty(value="path")
    public String path;
    @JsonProperty(value="group_id")
    public Long groupId;
    @JsonProperty(value="group_name")
    public String groupName;
    @JsonProperty(value="triggering_group_ids")
    public Long[] triggeringGroupIds;
    @JsonProperty(value="triggering_user_ids")
    public Long[] triggeringUserIds;
    @JsonProperty(value="trigger_by_share_recipients")
    public Boolean triggerByShareRecipients;
    @JsonProperty(value="notify_user_actions")
    public Boolean notifyUserActions;
    @JsonProperty(value="notify_on_copy")
    public Boolean notifyOnCopy;
    @JsonProperty(value="notify_on_delete")
    public Boolean notifyOnDelete;
    @JsonProperty(value="notify_on_download")
    public Boolean notifyOnDownload;
    @JsonProperty(value="notify_on_move")
    public Boolean notifyOnMove;
    @JsonProperty(value="notify_on_upload")
    public Boolean notifyOnUpload;
    @JsonProperty(value="recursive")
    public Boolean recursive;
    @JsonProperty(value="send_interval")
    public String sendInterval;
    @JsonProperty(value="message")
    public String message;
    @JsonProperty(value="triggering_filenames")
    public String[] triggeringFilenames;
    @JsonProperty(value="unsubscribed")
    public Boolean unsubscribed;
    @JsonProperty(value="unsubscribed_reason")
    public String unsubscribedReason;
    @JsonProperty(value="user_id")
    public Long userId;
    @JsonProperty(value="username")
    public String username;
    @JsonProperty(value="suppressed_email")
    public Boolean suppressedEmail;

    public Notification() {
        this(null, null);
    }

    public Notification(HashMap<String, Object> parameters) {
        this(parameters, null);
    }

    public Notification(HashMap<String, Object> parameters, HashMap<String, Object> options) {
        this.options = options;
        try {
            ObjectReader objectReader = this.objectMapper.readerForUpdating((Object)this);
            objectReader.readValue(this.objectMapper.writeValueAsString(parameters));
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }

    public Notification update() throws IOException {
        HashMap<String, Object> parameters = ModelUtils.toParameterMap(this.objectMapper.writeValueAsString((Object)this));
        return Notification.update(this.id, parameters);
    }

    public void delete() throws IOException {
        HashMap<String, Object> parameters = ModelUtils.toParameterMap(this.objectMapper.writeValueAsString((Object)this));
        Notification.delete(this.id, parameters);
    }

    public void destroy(HashMap<String, Object> parameters) throws IOException {
        this.delete();
    }

    public void save() throws IOException {
        HashMap<String, Object> parameters = ModelUtils.toParameterMap(this.objectMapper.writeValueAsString((Object)this));
        Notification.create(parameters, this.options);
    }

    public static ListIterator<Notification> list() throws RuntimeException {
        return Notification.list(null, null);
    }

    public static ListIterator<Notification> list(HashMap<String, Object> parameters) throws RuntimeException {
        return Notification.list(parameters, null);
    }

    public static ListIterator<Notification> list(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (parameters.containsKey("cursor") && !(parameters.get("cursor") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: cursor must be of type String parameters[\"cursor\"]");
        }
        if (parameters.containsKey("per_page") && !(parameters.get("per_page") instanceof Long)) {
            throw new IllegalArgumentException("Bad parameter: per_page must be of type Long parameters[\"per_page\"]");
        }
        if (parameters.containsKey("sort_by") && !(parameters.get("sort_by") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: sort_by must be of type Map<String, String> parameters[\"sort_by\"]");
        }
        if (parameters.containsKey("filter") && !(parameters.get("filter") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: filter must be of type Map<String, String> parameters[\"filter\"]");
        }
        if (parameters.containsKey("filter_prefix") && !(parameters.get("filter_prefix") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: filter_prefix must be of type Map<String, String> parameters[\"filter_prefix\"]");
        }
        if (parameters.containsKey("path") && !(parameters.get("path") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: path must be of type String parameters[\"path\"]");
        }
        if (parameters.containsKey("include_ancestors") && !(parameters.get("include_ancestors") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: include_ancestors must be of type Boolean parameters[\"include_ancestors\"]");
        }
        if (parameters.containsKey("group_id") && !(parameters.get("group_id") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: group_id must be of type String parameters[\"group_id\"]");
        }
        String url = String.format("%s%s/notifications", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase());
        TypeReference<List<Notification>> typeReference = new TypeReference<List<Notification>>(){};
        return FilesClient.requestList(url, HttpMethods.RequestMethods.GET, typeReference, parameters, options);
    }

    public static ListIterator<Notification> all() throws RuntimeException {
        return Notification.all(null, null);
    }

    public static ListIterator<Notification> all(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return Notification.list(parameters, options);
    }

    public static Notification find(Long id, HashMap<String, Object> parameters) throws RuntimeException {
        return Notification.find(id, parameters, null);
    }

    public static Notification find(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return Notification.find(null, parameters, options);
    }

    public static Notification find(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (id == null && parameters.containsKey("id") && parameters.get("id") != null) {
            id = (Long)parameters.get("id");
        }
        if (id == null) {
            throw new NullPointerException("Argument or Parameter missing: id parameters[\"id\"]");
        }
        if (!(id instanceof Long)) {
            throw new IllegalArgumentException("Bad parameter: id must be of type Long parameters[\"id\"]");
        }
        Object[] urlParts = new String[]{FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), String.valueOf(id)};
        for (int i = 2; i < urlParts.length; ++i) {
            try {
                urlParts[i] = new URI(null, null, (String)urlParts[i], null).getRawPath();
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        String url = String.format("%s%s/notifications/%s", urlParts);
        TypeReference<Notification> typeReference = new TypeReference<Notification>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.GET, typeReference, parameters, options);
    }

    public static Notification get() throws RuntimeException {
        return Notification.get(null, null, null);
    }

    public static Notification get(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return Notification.find(id, parameters, options);
    }

    public static Notification create(HashMap<String, Object> parameters) throws RuntimeException {
        return Notification.create(parameters, null);
    }

    public static Notification create(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (parameters.containsKey("user_id") && !(parameters.get("user_id") instanceof Long)) {
            throw new IllegalArgumentException("Bad parameter: user_id must be of type Long parameters[\"user_id\"]");
        }
        if (parameters.containsKey("notify_on_copy") && !(parameters.get("notify_on_copy") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: notify_on_copy must be of type Boolean parameters[\"notify_on_copy\"]");
        }
        if (parameters.containsKey("notify_on_delete") && !(parameters.get("notify_on_delete") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: notify_on_delete must be of type Boolean parameters[\"notify_on_delete\"]");
        }
        if (parameters.containsKey("notify_on_download") && !(parameters.get("notify_on_download") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: notify_on_download must be of type Boolean parameters[\"notify_on_download\"]");
        }
        if (parameters.containsKey("notify_on_move") && !(parameters.get("notify_on_move") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: notify_on_move must be of type Boolean parameters[\"notify_on_move\"]");
        }
        if (parameters.containsKey("notify_on_upload") && !(parameters.get("notify_on_upload") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: notify_on_upload must be of type Boolean parameters[\"notify_on_upload\"]");
        }
        if (parameters.containsKey("notify_user_actions") && !(parameters.get("notify_user_actions") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: notify_user_actions must be of type Boolean parameters[\"notify_user_actions\"]");
        }
        if (parameters.containsKey("recursive") && !(parameters.get("recursive") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: recursive must be of type Boolean parameters[\"recursive\"]");
        }
        if (parameters.containsKey("send_interval") && !(parameters.get("send_interval") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: send_interval must be of type String parameters[\"send_interval\"]");
        }
        if (parameters.containsKey("message") && !(parameters.get("message") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: message must be of type String parameters[\"message\"]");
        }
        if (parameters.containsKey("triggering_filenames") && !(parameters.get("triggering_filenames") instanceof String[])) {
            throw new IllegalArgumentException("Bad parameter: triggering_filenames must be of type String[] parameters[\"triggering_filenames\"]");
        }
        if (parameters.containsKey("triggering_group_ids") && !(parameters.get("triggering_group_ids") instanceof Long[])) {
            throw new IllegalArgumentException("Bad parameter: triggering_group_ids must be of type Long[] parameters[\"triggering_group_ids\"]");
        }
        if (parameters.containsKey("triggering_user_ids") && !(parameters.get("triggering_user_ids") instanceof Long[])) {
            throw new IllegalArgumentException("Bad parameter: triggering_user_ids must be of type Long[] parameters[\"triggering_user_ids\"]");
        }
        if (parameters.containsKey("trigger_by_share_recipients") && !(parameters.get("trigger_by_share_recipients") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: trigger_by_share_recipients must be of type Boolean parameters[\"trigger_by_share_recipients\"]");
        }
        if (parameters.containsKey("group_id") && !(parameters.get("group_id") instanceof Long)) {
            throw new IllegalArgumentException("Bad parameter: group_id must be of type Long parameters[\"group_id\"]");
        }
        if (parameters.containsKey("path") && !(parameters.get("path") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: path must be of type String parameters[\"path\"]");
        }
        if (parameters.containsKey("username") && !(parameters.get("username") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: username must be of type String parameters[\"username\"]");
        }
        String url = String.format("%s%s/notifications", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase());
        TypeReference<Notification> typeReference = new TypeReference<Notification>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.POST, typeReference, parameters, options);
    }

    public static Notification update(Long id, HashMap<String, Object> parameters) throws RuntimeException {
        return Notification.update(id, parameters, null);
    }

    public static Notification update(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return Notification.update(null, parameters, options);
    }

    public static Notification update(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (id == null && parameters.containsKey("id") && parameters.get("id") != null) {
            id = (Long)parameters.get("id");
        }
        if (id == null) {
            throw new NullPointerException("Argument or Parameter missing: id parameters[\"id\"]");
        }
        if (!(id instanceof Long)) {
            throw new IllegalArgumentException("Bad parameter: id must be of type Long parameters[\"id\"]");
        }
        if (parameters.containsKey("notify_on_copy") && !(parameters.get("notify_on_copy") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: notify_on_copy must be of type Boolean parameters[\"notify_on_copy\"]");
        }
        if (parameters.containsKey("notify_on_delete") && !(parameters.get("notify_on_delete") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: notify_on_delete must be of type Boolean parameters[\"notify_on_delete\"]");
        }
        if (parameters.containsKey("notify_on_download") && !(parameters.get("notify_on_download") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: notify_on_download must be of type Boolean parameters[\"notify_on_download\"]");
        }
        if (parameters.containsKey("notify_on_move") && !(parameters.get("notify_on_move") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: notify_on_move must be of type Boolean parameters[\"notify_on_move\"]");
        }
        if (parameters.containsKey("notify_on_upload") && !(parameters.get("notify_on_upload") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: notify_on_upload must be of type Boolean parameters[\"notify_on_upload\"]");
        }
        if (parameters.containsKey("notify_user_actions") && !(parameters.get("notify_user_actions") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: notify_user_actions must be of type Boolean parameters[\"notify_user_actions\"]");
        }
        if (parameters.containsKey("recursive") && !(parameters.get("recursive") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: recursive must be of type Boolean parameters[\"recursive\"]");
        }
        if (parameters.containsKey("send_interval") && !(parameters.get("send_interval") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: send_interval must be of type String parameters[\"send_interval\"]");
        }
        if (parameters.containsKey("message") && !(parameters.get("message") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: message must be of type String parameters[\"message\"]");
        }
        if (parameters.containsKey("triggering_filenames") && !(parameters.get("triggering_filenames") instanceof String[])) {
            throw new IllegalArgumentException("Bad parameter: triggering_filenames must be of type String[] parameters[\"triggering_filenames\"]");
        }
        if (parameters.containsKey("triggering_group_ids") && !(parameters.get("triggering_group_ids") instanceof Long[])) {
            throw new IllegalArgumentException("Bad parameter: triggering_group_ids must be of type Long[] parameters[\"triggering_group_ids\"]");
        }
        if (parameters.containsKey("triggering_user_ids") && !(parameters.get("triggering_user_ids") instanceof Long[])) {
            throw new IllegalArgumentException("Bad parameter: triggering_user_ids must be of type Long[] parameters[\"triggering_user_ids\"]");
        }
        if (parameters.containsKey("trigger_by_share_recipients") && !(parameters.get("trigger_by_share_recipients") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: trigger_by_share_recipients must be of type Boolean parameters[\"trigger_by_share_recipients\"]");
        }
        Object[] urlParts = new String[]{FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), String.valueOf(id)};
        for (int i = 2; i < urlParts.length; ++i) {
            try {
                urlParts[i] = new URI(null, null, (String)urlParts[i], null).getRawPath();
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        String url = String.format("%s%s/notifications/%s", urlParts);
        TypeReference<Notification> typeReference = new TypeReference<Notification>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.PATCH, typeReference, parameters, options);
    }

    public static void delete(Long id, HashMap<String, Object> parameters) throws RuntimeException {
        Notification.delete(id, parameters, null);
    }

    public static void delete(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        Notification.delete(null, parameters, options);
    }

    public static void delete(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (id == null && parameters.containsKey("id") && parameters.get("id") != null) {
            id = (Long)parameters.get("id");
        }
        if (id == null) {
            throw new NullPointerException("Argument or Parameter missing: id parameters[\"id\"]");
        }
        if (!(id instanceof Long)) {
            throw new IllegalArgumentException("Bad parameter: id must be of type Long parameters[\"id\"]");
        }
        Object[] urlParts = new String[]{FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), String.valueOf(id)};
        for (int i = 2; i < urlParts.length; ++i) {
            try {
                urlParts[i] = new URI(null, null, (String)urlParts[i], null).getRawPath();
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        String url = String.format("%s%s/notifications/%s", urlParts);
        FilesClient.apiRequest(url, HttpMethods.RequestMethods.DELETE, parameters, options);
    }

    public static void destroy() throws RuntimeException {
        Notification.destroy(null, null, null);
    }

    public static void destroy(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        Notification.delete(id, parameters, options);
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public String getPath() {
        return this.path;
    }

    @JsonProperty(value="path")
    @Generated
    public void setPath(String path) {
        this.path = path;
    }

    @Generated
    public Long getGroupId() {
        return this.groupId;
    }

    @JsonProperty(value="group_id")
    @Generated
    public void setGroupId(Long groupId) {
        this.groupId = groupId;
    }

    @Generated
    public String getGroupName() {
        return this.groupName;
    }

    @JsonProperty(value="group_name")
    @Generated
    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    @Generated
    public Long[] getTriggeringGroupIds() {
        return this.triggeringGroupIds;
    }

    @JsonProperty(value="triggering_group_ids")
    @Generated
    public void setTriggeringGroupIds(Long[] triggeringGroupIds) {
        this.triggeringGroupIds = triggeringGroupIds;
    }

    @Generated
    public Long[] getTriggeringUserIds() {
        return this.triggeringUserIds;
    }

    @JsonProperty(value="triggering_user_ids")
    @Generated
    public void setTriggeringUserIds(Long[] triggeringUserIds) {
        this.triggeringUserIds = triggeringUserIds;
    }

    @Generated
    public Boolean getTriggerByShareRecipients() {
        return this.triggerByShareRecipients;
    }

    @JsonProperty(value="trigger_by_share_recipients")
    @Generated
    public void setTriggerByShareRecipients(Boolean triggerByShareRecipients) {
        this.triggerByShareRecipients = triggerByShareRecipients;
    }

    @Generated
    public Boolean getNotifyUserActions() {
        return this.notifyUserActions;
    }

    @JsonProperty(value="notify_user_actions")
    @Generated
    public void setNotifyUserActions(Boolean notifyUserActions) {
        this.notifyUserActions = notifyUserActions;
    }

    @Generated
    public Boolean getNotifyOnCopy() {
        return this.notifyOnCopy;
    }

    @JsonProperty(value="notify_on_copy")
    @Generated
    public void setNotifyOnCopy(Boolean notifyOnCopy) {
        this.notifyOnCopy = notifyOnCopy;
    }

    @Generated
    public Boolean getNotifyOnDelete() {
        return this.notifyOnDelete;
    }

    @JsonProperty(value="notify_on_delete")
    @Generated
    public void setNotifyOnDelete(Boolean notifyOnDelete) {
        this.notifyOnDelete = notifyOnDelete;
    }

    @Generated
    public Boolean getNotifyOnDownload() {
        return this.notifyOnDownload;
    }

    @JsonProperty(value="notify_on_download")
    @Generated
    public void setNotifyOnDownload(Boolean notifyOnDownload) {
        this.notifyOnDownload = notifyOnDownload;
    }

    @Generated
    public Boolean getNotifyOnMove() {
        return this.notifyOnMove;
    }

    @JsonProperty(value="notify_on_move")
    @Generated
    public void setNotifyOnMove(Boolean notifyOnMove) {
        this.notifyOnMove = notifyOnMove;
    }

    @Generated
    public Boolean getNotifyOnUpload() {
        return this.notifyOnUpload;
    }

    @JsonProperty(value="notify_on_upload")
    @Generated
    public void setNotifyOnUpload(Boolean notifyOnUpload) {
        this.notifyOnUpload = notifyOnUpload;
    }

    @Generated
    public Boolean getRecursive() {
        return this.recursive;
    }

    @JsonProperty(value="recursive")
    @Generated
    public void setRecursive(Boolean recursive) {
        this.recursive = recursive;
    }

    @Generated
    public String getSendInterval() {
        return this.sendInterval;
    }

    @JsonProperty(value="send_interval")
    @Generated
    public void setSendInterval(String sendInterval) {
        this.sendInterval = sendInterval;
    }

    @Generated
    public String getMessage() {
        return this.message;
    }

    @JsonProperty(value="message")
    @Generated
    public void setMessage(String message) {
        this.message = message;
    }

    @Generated
    public String[] getTriggeringFilenames() {
        return this.triggeringFilenames;
    }

    @JsonProperty(value="triggering_filenames")
    @Generated
    public void setTriggeringFilenames(String[] triggeringFilenames) {
        this.triggeringFilenames = triggeringFilenames;
    }

    @Generated
    public Boolean getUnsubscribed() {
        return this.unsubscribed;
    }

    @JsonProperty(value="unsubscribed")
    @Generated
    public void setUnsubscribed(Boolean unsubscribed) {
        this.unsubscribed = unsubscribed;
    }

    @Generated
    public String getUnsubscribedReason() {
        return this.unsubscribedReason;
    }

    @JsonProperty(value="unsubscribed_reason")
    @Generated
    public void setUnsubscribedReason(String unsubscribedReason) {
        this.unsubscribedReason = unsubscribedReason;
    }

    @Generated
    public Long getUserId() {
        return this.userId;
    }

    @JsonProperty(value="user_id")
    @Generated
    public void setUserId(Long userId) {
        this.userId = userId;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @JsonProperty(value="username")
    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public Boolean getSuppressedEmail() {
        return this.suppressedEmail;
    }

    @JsonProperty(value="suppressed_email")
    @Generated
    public void setSuppressedEmail(Boolean suppressedEmail) {
        this.suppressedEmail = suppressedEmail;
    }
}

