/*
 * Decompiled with CFR 0.152.
 */
package com.files.models;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.files.FilesClient;
import com.files.FilesConfig;
import com.files.ListIterator;
import com.files.net.HttpMethods;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class UsageSnapshot {
    private HashMap<String, Object> options;
    private ObjectMapper objectMapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().disable(new MapperFeature[]{MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS})).disable(new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS})).defaultDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX"))).build();
    @JsonProperty(value="id")
    public Long id;
    @JsonProperty(value="start_at")
    public Date startAt;
    @JsonProperty(value="end_at")
    public Date endAt;
    @JsonProperty(value="high_water_user_count")
    public Double highWaterUserCount;
    @JsonProperty(value="current_storage")
    public Double currentStorage;
    @JsonProperty(value="high_water_storage")
    public Double highWaterStorage;
    @JsonProperty(value="usage_by_top_level_dir")
    public Map<String, String> usageByTopLevelDir;
    @JsonProperty(value="root_storage")
    public Double rootStorage;
    @JsonProperty(value="deleted_files_counted_in_minimum")
    public Double deletedFilesCountedInMinimum;
    @JsonProperty(value="deleted_files_storage")
    public Double deletedFilesStorage;
    @JsonProperty(value="total_billable_usage")
    public Double totalBillableUsage;
    @JsonProperty(value="total_billable_transfer_usage")
    public Double totalBillableTransferUsage;
    @JsonProperty(value="bytes_sent")
    public Double bytesSent;
    @JsonProperty(value="sync_bytes_received")
    public Double syncBytesReceived;
    @JsonProperty(value="sync_bytes_sent")
    public Double syncBytesSent;

    public UsageSnapshot() {
        this(null, null);
    }

    public UsageSnapshot(HashMap<String, Object> parameters) {
        this(parameters, null);
    }

    public UsageSnapshot(HashMap<String, Object> parameters, HashMap<String, Object> options) {
        this.options = options;
        try {
            ObjectReader objectReader = this.objectMapper.readerForUpdating((Object)this);
            objectReader.readValue(this.objectMapper.writeValueAsString(parameters));
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }

    public static ListIterator<UsageSnapshot> list() throws RuntimeException {
        return UsageSnapshot.list(null, null);
    }

    public static ListIterator<UsageSnapshot> list(HashMap<String, Object> parameters) throws RuntimeException {
        return UsageSnapshot.list(parameters, null);
    }

    public static ListIterator<UsageSnapshot> list(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (parameters.containsKey("cursor") && !(parameters.get("cursor") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: cursor must be of type String parameters[\"cursor\"]");
        }
        if (parameters.containsKey("per_page") && !(parameters.get("per_page") instanceof Long)) {
            throw new IllegalArgumentException("Bad parameter: per_page must be of type Long parameters[\"per_page\"]");
        }
        String url = String.format("%s%s/usage_snapshots", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase());
        TypeReference<List<UsageSnapshot>> typeReference = new TypeReference<List<UsageSnapshot>>(){};
        return FilesClient.requestList(url, HttpMethods.RequestMethods.GET, typeReference, parameters, options);
    }

    public static ListIterator<UsageSnapshot> all() throws RuntimeException {
        return UsageSnapshot.all(null, null);
    }

    public static ListIterator<UsageSnapshot> all(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return UsageSnapshot.list(parameters, options);
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Date getStartAt() {
        return this.startAt;
    }

    @Generated
    public Date getEndAt() {
        return this.endAt;
    }

    @Generated
    public Double getHighWaterUserCount() {
        return this.highWaterUserCount;
    }

    @Generated
    public Double getCurrentStorage() {
        return this.currentStorage;
    }

    @Generated
    public Double getHighWaterStorage() {
        return this.highWaterStorage;
    }

    @Generated
    public Map<String, String> getUsageByTopLevelDir() {
        return this.usageByTopLevelDir;
    }

    @Generated
    public Double getRootStorage() {
        return this.rootStorage;
    }

    @Generated
    public Double getDeletedFilesCountedInMinimum() {
        return this.deletedFilesCountedInMinimum;
    }

    @Generated
    public Double getDeletedFilesStorage() {
        return this.deletedFilesStorage;
    }

    @Generated
    public Double getTotalBillableUsage() {
        return this.totalBillableUsage;
    }

    @Generated
    public Double getTotalBillableTransferUsage() {
        return this.totalBillableTransferUsage;
    }

    @Generated
    public Double getBytesSent() {
        return this.bytesSent;
    }

    @Generated
    public Double getSyncBytesReceived() {
        return this.syncBytesReceived;
    }

    @Generated
    public Double getSyncBytesSent() {
        return this.syncBytesSent;
    }
}

