/*
 * Decompiled with CFR 0.152.
 */
package com.files.models;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.files.FilesClient;
import com.files.FilesConfig;
import com.files.ListIterator;
import com.files.models.ModelInterface;
import com.files.net.HttpMethods;
import com.files.util.ModelUtils;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class User
implements ModelInterface {
    private HashMap<String, Object> options;
    private ObjectMapper objectMapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().disable(new MapperFeature[]{MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS})).disable(new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS})).defaultDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX"))).build();
    @JsonProperty(value="id")
    public Long id;
    @JsonProperty(value="username")
    public String username;
    @JsonProperty(value="admin_group_ids")
    public Long[] adminGroupIds;
    @JsonProperty(value="allowed_ips")
    public String allowedIps;
    @JsonProperty(value="attachments_permission")
    public Boolean attachmentsPermission;
    @JsonProperty(value="api_keys_count")
    public Long apiKeysCount;
    @JsonProperty(value="authenticate_until")
    public Date authenticateUntil;
    @JsonProperty(value="authentication_method")
    public String authenticationMethod;
    @JsonProperty(value="avatar_url")
    public String avatarUrl;
    @JsonProperty(value="billing_permission")
    public Boolean billingPermission;
    @JsonProperty(value="bypass_site_allowed_ips")
    public Boolean bypassSiteAllowedIps;
    @JsonProperty(value="bypass_inactive_disable")
    public Boolean bypassInactiveDisable;
    @JsonProperty(value="created_at")
    public Date createdAt;
    @JsonProperty(value="dav_permission")
    public Boolean davPermission;
    @JsonProperty(value="disabled")
    public Boolean disabled;
    @JsonProperty(value="disabled_expired_or_inactive")
    public Boolean disabledExpiredOrInactive;
    @JsonProperty(value="email")
    public String email;
    @JsonProperty(value="first_login_at")
    public Date firstLoginAt;
    @JsonProperty(value="ftp_permission")
    public Boolean ftpPermission;
    @JsonProperty(value="group_ids")
    public String groupIds;
    @JsonProperty(value="header_text")
    public String headerText;
    @JsonProperty(value="language")
    public String language;
    @JsonProperty(value="last_login_at")
    public Date lastLoginAt;
    @JsonProperty(value="last_web_login_at")
    public Date lastWebLoginAt;
    @JsonProperty(value="last_ftp_login_at")
    public Date lastFtpLoginAt;
    @JsonProperty(value="last_sftp_login_at")
    public Date lastSftpLoginAt;
    @JsonProperty(value="last_dav_login_at")
    public Date lastDavLoginAt;
    @JsonProperty(value="last_desktop_login_at")
    public Date lastDesktopLoginAt;
    @JsonProperty(value="last_restapi_login_at")
    public Date lastRestapiLoginAt;
    @JsonProperty(value="last_api_use_at")
    public Date lastApiUseAt;
    @JsonProperty(value="last_active_at")
    public Date lastActiveAt;
    @JsonProperty(value="last_protocol_cipher")
    public String lastProtocolCipher;
    @JsonProperty(value="lockout_expires")
    public Date lockoutExpires;
    @JsonProperty(value="name")
    public String name;
    @JsonProperty(value="company")
    public String company;
    @JsonProperty(value="notes")
    public String notes;
    @JsonProperty(value="notification_daily_send_time")
    public Long notificationDailySendTime;
    @JsonProperty(value="office_integration_enabled")
    public Boolean officeIntegrationEnabled;
    @JsonProperty(value="password_set_at")
    public Date passwordSetAt;
    @JsonProperty(value="password_validity_days")
    public Long passwordValidityDays;
    @JsonProperty(value="public_keys_count")
    public Long publicKeysCount;
    @JsonProperty(value="receive_admin_alerts")
    public Boolean receiveAdminAlerts;
    @JsonProperty(value="require_2fa")
    public String require2fa;
    @JsonProperty(value="require_login_by")
    public Date requireLoginBy;
    @JsonProperty(value="active_2fa")
    public Boolean active2fa;
    @JsonProperty(value="require_password_change")
    public Boolean requirePasswordChange;
    @JsonProperty(value="password_expired")
    public Boolean passwordExpired;
    @JsonProperty(value="readonly_site_admin")
    public Boolean readonlySiteAdmin;
    @JsonProperty(value="restapi_permission")
    public Boolean restapiPermission;
    @JsonProperty(value="self_managed")
    public Boolean selfManaged;
    @JsonProperty(value="sftp_permission")
    public Boolean sftpPermission;
    @JsonProperty(value="site_admin")
    public Boolean siteAdmin;
    @JsonProperty(value="skip_welcome_screen")
    public Boolean skipWelcomeScreen;
    @JsonProperty(value="ssl_required")
    public String sslRequired;
    @JsonProperty(value="sso_strategy_id")
    public Long ssoStrategyId;
    @JsonProperty(value="subscribe_to_newsletter")
    public Boolean subscribeToNewsletter;
    @JsonProperty(value="externally_managed")
    public Boolean externallyManaged;
    @JsonProperty(value="time_zone")
    public String timeZone;
    @JsonProperty(value="type_of_2fa")
    public String typeOf2fa;
    @JsonProperty(value="type_of_2fa_for_display")
    public String typeOf2faForDisplay;
    @JsonProperty(value="user_root")
    public String userRoot;
    @JsonProperty(value="days_remaining_until_password_expire")
    public Long daysRemainingUntilPasswordExpire;
    @JsonProperty(value="password_expire_at")
    public Date passwordExpireAt;
    @JsonProperty(value="avatar_file")
    public byte[] avatarFile;
    @JsonProperty(value="avatar_delete")
    public Boolean avatarDelete;
    @JsonProperty(value="change_password")
    public String changePassword;
    @JsonProperty(value="change_password_confirmation")
    public String changePasswordConfirmation;
    @JsonProperty(value="grant_permission")
    public String grantPermission;
    @JsonProperty(value="group_id")
    public Long groupId;
    @JsonProperty(value="imported_password_hash")
    public String importedPasswordHash;
    @JsonProperty(value="password")
    public String password;
    @JsonProperty(value="password_confirmation")
    public String passwordConfirmation;
    @JsonProperty(value="announcements_read")
    public Boolean announcementsRead;

    public User() {
        this(null, null);
    }

    public User(HashMap<String, Object> parameters) {
        this(parameters, null);
    }

    public User(HashMap<String, Object> parameters, HashMap<String, Object> options) {
        this.options = options;
        try {
            ObjectReader objectReader = this.objectMapper.readerForUpdating((Object)this);
            objectReader.readValue(this.objectMapper.writeValueAsString(parameters));
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }

    public void unlock() throws IOException {
        HashMap<String, Object> parameters = ModelUtils.toParameterMap(this.objectMapper.writeValueAsString((Object)this));
        User.unlock(this.id, parameters, this.options);
    }

    public void resendWelcomeEmail() throws IOException {
        HashMap<String, Object> parameters = ModelUtils.toParameterMap(this.objectMapper.writeValueAsString((Object)this));
        User.resendWelcomeEmail(this.id, parameters, this.options);
    }

    public void user2faReset() throws IOException {
        HashMap<String, Object> parameters = ModelUtils.toParameterMap(this.objectMapper.writeValueAsString((Object)this));
        User.user2faReset(this.id, parameters, this.options);
    }

    public User update() throws IOException {
        HashMap<String, Object> parameters = ModelUtils.toParameterMap(this.objectMapper.writeValueAsString((Object)this));
        return User.update(this.id, parameters, this.options);
    }

    public void delete() throws IOException {
        HashMap<String, Object> parameters = ModelUtils.toParameterMap(this.objectMapper.writeValueAsString((Object)this));
        User.delete(this.id, parameters, this.options);
    }

    public void destroy(HashMap<String, Object> parameters) throws IOException {
        this.delete();
    }

    public void save() throws IOException {
        HashMap<String, Object> parameters = ModelUtils.toParameterMap(this.objectMapper.writeValueAsString((Object)this));
        User.create(parameters, this.options);
    }

    public static ListIterator<User> list() throws RuntimeException {
        return User.list(null, null);
    }

    public static ListIterator<User> list(HashMap<String, Object> parameters) throws RuntimeException {
        return User.list(parameters, null);
    }

    public static ListIterator<User> list(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (parameters.containsKey("cursor") && !(parameters.get("cursor") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: cursor must be of type String parameters[\"cursor\"]");
        }
        if (parameters.containsKey("per_page") && !(parameters.get("per_page") instanceof Long)) {
            throw new IllegalArgumentException("Bad parameter: per_page must be of type Long parameters[\"per_page\"]");
        }
        if (parameters.containsKey("sort_by") && !(parameters.get("sort_by") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: sort_by must be of type Map<String, String> parameters[\"sort_by\"]");
        }
        if (parameters.containsKey("filter") && !(parameters.get("filter") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: filter must be of type Map<String, String> parameters[\"filter\"]");
        }
        if (parameters.containsKey("filter_gt") && !(parameters.get("filter_gt") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: filter_gt must be of type Map<String, String> parameters[\"filter_gt\"]");
        }
        if (parameters.containsKey("filter_gteq") && !(parameters.get("filter_gteq") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: filter_gteq must be of type Map<String, String> parameters[\"filter_gteq\"]");
        }
        if (parameters.containsKey("filter_prefix") && !(parameters.get("filter_prefix") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: filter_prefix must be of type Map<String, String> parameters[\"filter_prefix\"]");
        }
        if (parameters.containsKey("filter_lt") && !(parameters.get("filter_lt") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: filter_lt must be of type Map<String, String> parameters[\"filter_lt\"]");
        }
        if (parameters.containsKey("filter_lteq") && !(parameters.get("filter_lteq") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: filter_lteq must be of type Map<String, String> parameters[\"filter_lteq\"]");
        }
        if (parameters.containsKey("ids") && !(parameters.get("ids") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: ids must be of type String parameters[\"ids\"]");
        }
        if (parameters.containsKey("search") && !(parameters.get("search") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: search must be of type String parameters[\"search\"]");
        }
        String url = String.format("%s%s/users", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase());
        TypeReference<List<User>> typeReference = new TypeReference<List<User>>(){};
        return FilesClient.requestList(url, HttpMethods.RequestMethods.GET, typeReference, parameters, options);
    }

    public static ListIterator<User> all() throws RuntimeException {
        return User.all(null, null);
    }

    public static ListIterator<User> all(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return User.list(parameters, options);
    }

    public static User find(Long id, HashMap<String, Object> parameters) throws RuntimeException {
        return User.find(id, parameters, null);
    }

    public static User find(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return User.find(null, parameters, options);
    }

    public static User find(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (id == null && parameters.containsKey("id") && parameters.get("id") != null) {
            id = (Long)parameters.get("id");
        }
        if (id == null) {
            throw new NullPointerException("Argument or Parameter missing: id parameters[\"id\"]");
        }
        if (!(id instanceof Long)) {
            throw new IllegalArgumentException("Bad parameter: id must be of type Long parameters[\"id\"]");
        }
        Object[] urlParts = new String[]{FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), String.valueOf(id)};
        for (int i = 2; i < urlParts.length; ++i) {
            try {
                urlParts[i] = new URI(null, null, (String)urlParts[i], null).getRawPath();
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        String url = String.format("%s%s/users/%s", urlParts);
        TypeReference<User> typeReference = new TypeReference<User>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.GET, typeReference, parameters, options);
    }

    public static User get() throws RuntimeException {
        return User.get(null, null, null);
    }

    public static User get(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return User.find(id, parameters, options);
    }

    public static User create(HashMap<String, Object> parameters) throws RuntimeException {
        return User.create(parameters, null);
    }

    public static User create(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (!parameters.containsKey("username") || parameters.get("username") == null) {
            throw new NullPointerException("Parameter missing: username parameters[\"username\"]");
        }
        if (parameters.containsKey("avatar_file") && !(parameters.get("avatar_file") instanceof byte[])) {
            throw new IllegalArgumentException("Bad parameter: avatar_file must be of type byte[] parameters[\"avatar_file\"]");
        }
        if (parameters.containsKey("avatar_delete") && !(parameters.get("avatar_delete") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: avatar_delete must be of type Boolean parameters[\"avatar_delete\"]");
        }
        if (parameters.containsKey("change_password") && !(parameters.get("change_password") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: change_password must be of type String parameters[\"change_password\"]");
        }
        if (parameters.containsKey("change_password_confirmation") && !(parameters.get("change_password_confirmation") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: change_password_confirmation must be of type String parameters[\"change_password_confirmation\"]");
        }
        if (parameters.containsKey("email") && !(parameters.get("email") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: email must be of type String parameters[\"email\"]");
        }
        if (parameters.containsKey("grant_permission") && !(parameters.get("grant_permission") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: grant_permission must be of type String parameters[\"grant_permission\"]");
        }
        if (parameters.containsKey("group_id") && !(parameters.get("group_id") instanceof Long)) {
            throw new IllegalArgumentException("Bad parameter: group_id must be of type Long parameters[\"group_id\"]");
        }
        if (parameters.containsKey("group_ids") && !(parameters.get("group_ids") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: group_ids must be of type String parameters[\"group_ids\"]");
        }
        if (parameters.containsKey("imported_password_hash") && !(parameters.get("imported_password_hash") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: imported_password_hash must be of type String parameters[\"imported_password_hash\"]");
        }
        if (parameters.containsKey("password") && !(parameters.get("password") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: password must be of type String parameters[\"password\"]");
        }
        if (parameters.containsKey("password_confirmation") && !(parameters.get("password_confirmation") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: password_confirmation must be of type String parameters[\"password_confirmation\"]");
        }
        if (parameters.containsKey("announcements_read") && !(parameters.get("announcements_read") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: announcements_read must be of type Boolean parameters[\"announcements_read\"]");
        }
        if (parameters.containsKey("allowed_ips") && !(parameters.get("allowed_ips") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: allowed_ips must be of type String parameters[\"allowed_ips\"]");
        }
        if (parameters.containsKey("attachments_permission") && !(parameters.get("attachments_permission") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: attachments_permission must be of type Boolean parameters[\"attachments_permission\"]");
        }
        if (parameters.containsKey("authenticate_until") && !(parameters.get("authenticate_until") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: authenticate_until must be of type String parameters[\"authenticate_until\"]");
        }
        if (parameters.containsKey("authentication_method") && !(parameters.get("authentication_method") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: authentication_method must be of type String parameters[\"authentication_method\"]");
        }
        if (parameters.containsKey("billing_permission") && !(parameters.get("billing_permission") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: billing_permission must be of type Boolean parameters[\"billing_permission\"]");
        }
        if (parameters.containsKey("bypass_inactive_disable") && !(parameters.get("bypass_inactive_disable") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: bypass_inactive_disable must be of type Boolean parameters[\"bypass_inactive_disable\"]");
        }
        if (parameters.containsKey("bypass_site_allowed_ips") && !(parameters.get("bypass_site_allowed_ips") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: bypass_site_allowed_ips must be of type Boolean parameters[\"bypass_site_allowed_ips\"]");
        }
        if (parameters.containsKey("dav_permission") && !(parameters.get("dav_permission") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: dav_permission must be of type Boolean parameters[\"dav_permission\"]");
        }
        if (parameters.containsKey("disabled") && !(parameters.get("disabled") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: disabled must be of type Boolean parameters[\"disabled\"]");
        }
        if (parameters.containsKey("ftp_permission") && !(parameters.get("ftp_permission") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: ftp_permission must be of type Boolean parameters[\"ftp_permission\"]");
        }
        if (parameters.containsKey("header_text") && !(parameters.get("header_text") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: header_text must be of type String parameters[\"header_text\"]");
        }
        if (parameters.containsKey("language") && !(parameters.get("language") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: language must be of type String parameters[\"language\"]");
        }
        if (parameters.containsKey("notification_daily_send_time") && !(parameters.get("notification_daily_send_time") instanceof Long)) {
            throw new IllegalArgumentException("Bad parameter: notification_daily_send_time must be of type Long parameters[\"notification_daily_send_time\"]");
        }
        if (parameters.containsKey("name") && !(parameters.get("name") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: name must be of type String parameters[\"name\"]");
        }
        if (parameters.containsKey("company") && !(parameters.get("company") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: company must be of type String parameters[\"company\"]");
        }
        if (parameters.containsKey("notes") && !(parameters.get("notes") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: notes must be of type String parameters[\"notes\"]");
        }
        if (parameters.containsKey("office_integration_enabled") && !(parameters.get("office_integration_enabled") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: office_integration_enabled must be of type Boolean parameters[\"office_integration_enabled\"]");
        }
        if (parameters.containsKey("password_validity_days") && !(parameters.get("password_validity_days") instanceof Long)) {
            throw new IllegalArgumentException("Bad parameter: password_validity_days must be of type Long parameters[\"password_validity_days\"]");
        }
        if (parameters.containsKey("readonly_site_admin") && !(parameters.get("readonly_site_admin") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: readonly_site_admin must be of type Boolean parameters[\"readonly_site_admin\"]");
        }
        if (parameters.containsKey("receive_admin_alerts") && !(parameters.get("receive_admin_alerts") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: receive_admin_alerts must be of type Boolean parameters[\"receive_admin_alerts\"]");
        }
        if (parameters.containsKey("require_login_by") && !(parameters.get("require_login_by") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: require_login_by must be of type String parameters[\"require_login_by\"]");
        }
        if (parameters.containsKey("require_password_change") && !(parameters.get("require_password_change") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: require_password_change must be of type Boolean parameters[\"require_password_change\"]");
        }
        if (parameters.containsKey("restapi_permission") && !(parameters.get("restapi_permission") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: restapi_permission must be of type Boolean parameters[\"restapi_permission\"]");
        }
        if (parameters.containsKey("self_managed") && !(parameters.get("self_managed") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: self_managed must be of type Boolean parameters[\"self_managed\"]");
        }
        if (parameters.containsKey("sftp_permission") && !(parameters.get("sftp_permission") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: sftp_permission must be of type Boolean parameters[\"sftp_permission\"]");
        }
        if (parameters.containsKey("site_admin") && !(parameters.get("site_admin") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: site_admin must be of type Boolean parameters[\"site_admin\"]");
        }
        if (parameters.containsKey("skip_welcome_screen") && !(parameters.get("skip_welcome_screen") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: skip_welcome_screen must be of type Boolean parameters[\"skip_welcome_screen\"]");
        }
        if (parameters.containsKey("ssl_required") && !(parameters.get("ssl_required") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: ssl_required must be of type String parameters[\"ssl_required\"]");
        }
        if (parameters.containsKey("sso_strategy_id") && !(parameters.get("sso_strategy_id") instanceof Long)) {
            throw new IllegalArgumentException("Bad parameter: sso_strategy_id must be of type Long parameters[\"sso_strategy_id\"]");
        }
        if (parameters.containsKey("subscribe_to_newsletter") && !(parameters.get("subscribe_to_newsletter") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: subscribe_to_newsletter must be of type Boolean parameters[\"subscribe_to_newsletter\"]");
        }
        if (parameters.containsKey("require_2fa") && !(parameters.get("require_2fa") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: require_2fa must be of type String parameters[\"require_2fa\"]");
        }
        if (parameters.containsKey("time_zone") && !(parameters.get("time_zone") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: time_zone must be of type String parameters[\"time_zone\"]");
        }
        if (parameters.containsKey("user_root") && !(parameters.get("user_root") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: user_root must be of type String parameters[\"user_root\"]");
        }
        if (parameters.containsKey("username") && !(parameters.get("username") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: username must be of type String parameters[\"username\"]");
        }
        String url = String.format("%s%s/users", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase());
        TypeReference<User> typeReference = new TypeReference<User>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.POST, typeReference, parameters, options);
    }

    public static void unlock(Long id, HashMap<String, Object> parameters) throws RuntimeException {
        User.unlock(id, parameters, null);
    }

    public static void unlock(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        User.unlock(null, parameters, options);
    }

    public static void unlock(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (id == null && parameters.containsKey("id") && parameters.get("id") != null) {
            id = (Long)parameters.get("id");
        }
        if (id == null) {
            throw new NullPointerException("Argument or Parameter missing: id parameters[\"id\"]");
        }
        if (!(id instanceof Long)) {
            throw new IllegalArgumentException("Bad parameter: id must be of type Long parameters[\"id\"]");
        }
        Object[] urlParts = new String[]{FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), String.valueOf(id)};
        for (int i = 2; i < urlParts.length; ++i) {
            try {
                urlParts[i] = new URI(null, null, (String)urlParts[i], null).getRawPath();
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        String url = String.format("%s%s/users/%s/unlock", urlParts);
        FilesClient.apiRequest(url, HttpMethods.RequestMethods.POST, parameters, options);
    }

    public static void resendWelcomeEmail(Long id, HashMap<String, Object> parameters) throws RuntimeException {
        User.resendWelcomeEmail(id, parameters, null);
    }

    public static void resendWelcomeEmail(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        User.resendWelcomeEmail(null, parameters, options);
    }

    public static void resendWelcomeEmail(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (id == null && parameters.containsKey("id") && parameters.get("id") != null) {
            id = (Long)parameters.get("id");
        }
        if (id == null) {
            throw new NullPointerException("Argument or Parameter missing: id parameters[\"id\"]");
        }
        if (!(id instanceof Long)) {
            throw new IllegalArgumentException("Bad parameter: id must be of type Long parameters[\"id\"]");
        }
        Object[] urlParts = new String[]{FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), String.valueOf(id)};
        for (int i = 2; i < urlParts.length; ++i) {
            try {
                urlParts[i] = new URI(null, null, (String)urlParts[i], null).getRawPath();
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        String url = String.format("%s%s/users/%s/resend_welcome_email", urlParts);
        FilesClient.apiRequest(url, HttpMethods.RequestMethods.POST, parameters, options);
    }

    public static void user2faReset(Long id, HashMap<String, Object> parameters) throws RuntimeException {
        User.user2faReset(id, parameters, null);
    }

    public static void user2faReset(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        User.user2faReset(null, parameters, options);
    }

    public static void user2faReset(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (id == null && parameters.containsKey("id") && parameters.get("id") != null) {
            id = (Long)parameters.get("id");
        }
        if (id == null) {
            throw new NullPointerException("Argument or Parameter missing: id parameters[\"id\"]");
        }
        if (!(id instanceof Long)) {
            throw new IllegalArgumentException("Bad parameter: id must be of type Long parameters[\"id\"]");
        }
        Object[] urlParts = new String[]{FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), String.valueOf(id)};
        for (int i = 2; i < urlParts.length; ++i) {
            try {
                urlParts[i] = new URI(null, null, (String)urlParts[i], null).getRawPath();
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        String url = String.format("%s%s/users/%s/2fa/reset", urlParts);
        FilesClient.apiRequest(url, HttpMethods.RequestMethods.POST, parameters, options);
    }

    public static User update(Long id, HashMap<String, Object> parameters) throws RuntimeException {
        return User.update(id, parameters, null);
    }

    public static User update(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return User.update(null, parameters, options);
    }

    public static User update(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (id == null && parameters.containsKey("id") && parameters.get("id") != null) {
            id = (Long)parameters.get("id");
        }
        if (id == null) {
            throw new NullPointerException("Argument or Parameter missing: id parameters[\"id\"]");
        }
        if (!(id instanceof Long)) {
            throw new IllegalArgumentException("Bad parameter: id must be of type Long parameters[\"id\"]");
        }
        if (parameters.containsKey("avatar_file") && !(parameters.get("avatar_file") instanceof byte[])) {
            throw new IllegalArgumentException("Bad parameter: avatar_file must be of type byte[] parameters[\"avatar_file\"]");
        }
        if (parameters.containsKey("avatar_delete") && !(parameters.get("avatar_delete") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: avatar_delete must be of type Boolean parameters[\"avatar_delete\"]");
        }
        if (parameters.containsKey("change_password") && !(parameters.get("change_password") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: change_password must be of type String parameters[\"change_password\"]");
        }
        if (parameters.containsKey("change_password_confirmation") && !(parameters.get("change_password_confirmation") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: change_password_confirmation must be of type String parameters[\"change_password_confirmation\"]");
        }
        if (parameters.containsKey("email") && !(parameters.get("email") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: email must be of type String parameters[\"email\"]");
        }
        if (parameters.containsKey("grant_permission") && !(parameters.get("grant_permission") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: grant_permission must be of type String parameters[\"grant_permission\"]");
        }
        if (parameters.containsKey("group_id") && !(parameters.get("group_id") instanceof Long)) {
            throw new IllegalArgumentException("Bad parameter: group_id must be of type Long parameters[\"group_id\"]");
        }
        if (parameters.containsKey("group_ids") && !(parameters.get("group_ids") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: group_ids must be of type String parameters[\"group_ids\"]");
        }
        if (parameters.containsKey("imported_password_hash") && !(parameters.get("imported_password_hash") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: imported_password_hash must be of type String parameters[\"imported_password_hash\"]");
        }
        if (parameters.containsKey("password") && !(parameters.get("password") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: password must be of type String parameters[\"password\"]");
        }
        if (parameters.containsKey("password_confirmation") && !(parameters.get("password_confirmation") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: password_confirmation must be of type String parameters[\"password_confirmation\"]");
        }
        if (parameters.containsKey("announcements_read") && !(parameters.get("announcements_read") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: announcements_read must be of type Boolean parameters[\"announcements_read\"]");
        }
        if (parameters.containsKey("allowed_ips") && !(parameters.get("allowed_ips") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: allowed_ips must be of type String parameters[\"allowed_ips\"]");
        }
        if (parameters.containsKey("attachments_permission") && !(parameters.get("attachments_permission") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: attachments_permission must be of type Boolean parameters[\"attachments_permission\"]");
        }
        if (parameters.containsKey("authenticate_until") && !(parameters.get("authenticate_until") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: authenticate_until must be of type String parameters[\"authenticate_until\"]");
        }
        if (parameters.containsKey("authentication_method") && !(parameters.get("authentication_method") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: authentication_method must be of type String parameters[\"authentication_method\"]");
        }
        if (parameters.containsKey("billing_permission") && !(parameters.get("billing_permission") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: billing_permission must be of type Boolean parameters[\"billing_permission\"]");
        }
        if (parameters.containsKey("bypass_inactive_disable") && !(parameters.get("bypass_inactive_disable") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: bypass_inactive_disable must be of type Boolean parameters[\"bypass_inactive_disable\"]");
        }
        if (parameters.containsKey("bypass_site_allowed_ips") && !(parameters.get("bypass_site_allowed_ips") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: bypass_site_allowed_ips must be of type Boolean parameters[\"bypass_site_allowed_ips\"]");
        }
        if (parameters.containsKey("dav_permission") && !(parameters.get("dav_permission") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: dav_permission must be of type Boolean parameters[\"dav_permission\"]");
        }
        if (parameters.containsKey("disabled") && !(parameters.get("disabled") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: disabled must be of type Boolean parameters[\"disabled\"]");
        }
        if (parameters.containsKey("ftp_permission") && !(parameters.get("ftp_permission") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: ftp_permission must be of type Boolean parameters[\"ftp_permission\"]");
        }
        if (parameters.containsKey("header_text") && !(parameters.get("header_text") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: header_text must be of type String parameters[\"header_text\"]");
        }
        if (parameters.containsKey("language") && !(parameters.get("language") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: language must be of type String parameters[\"language\"]");
        }
        if (parameters.containsKey("notification_daily_send_time") && !(parameters.get("notification_daily_send_time") instanceof Long)) {
            throw new IllegalArgumentException("Bad parameter: notification_daily_send_time must be of type Long parameters[\"notification_daily_send_time\"]");
        }
        if (parameters.containsKey("name") && !(parameters.get("name") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: name must be of type String parameters[\"name\"]");
        }
        if (parameters.containsKey("company") && !(parameters.get("company") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: company must be of type String parameters[\"company\"]");
        }
        if (parameters.containsKey("notes") && !(parameters.get("notes") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: notes must be of type String parameters[\"notes\"]");
        }
        if (parameters.containsKey("office_integration_enabled") && !(parameters.get("office_integration_enabled") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: office_integration_enabled must be of type Boolean parameters[\"office_integration_enabled\"]");
        }
        if (parameters.containsKey("password_validity_days") && !(parameters.get("password_validity_days") instanceof Long)) {
            throw new IllegalArgumentException("Bad parameter: password_validity_days must be of type Long parameters[\"password_validity_days\"]");
        }
        if (parameters.containsKey("readonly_site_admin") && !(parameters.get("readonly_site_admin") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: readonly_site_admin must be of type Boolean parameters[\"readonly_site_admin\"]");
        }
        if (parameters.containsKey("receive_admin_alerts") && !(parameters.get("receive_admin_alerts") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: receive_admin_alerts must be of type Boolean parameters[\"receive_admin_alerts\"]");
        }
        if (parameters.containsKey("require_login_by") && !(parameters.get("require_login_by") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: require_login_by must be of type String parameters[\"require_login_by\"]");
        }
        if (parameters.containsKey("require_password_change") && !(parameters.get("require_password_change") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: require_password_change must be of type Boolean parameters[\"require_password_change\"]");
        }
        if (parameters.containsKey("restapi_permission") && !(parameters.get("restapi_permission") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: restapi_permission must be of type Boolean parameters[\"restapi_permission\"]");
        }
        if (parameters.containsKey("self_managed") && !(parameters.get("self_managed") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: self_managed must be of type Boolean parameters[\"self_managed\"]");
        }
        if (parameters.containsKey("sftp_permission") && !(parameters.get("sftp_permission") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: sftp_permission must be of type Boolean parameters[\"sftp_permission\"]");
        }
        if (parameters.containsKey("site_admin") && !(parameters.get("site_admin") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: site_admin must be of type Boolean parameters[\"site_admin\"]");
        }
        if (parameters.containsKey("skip_welcome_screen") && !(parameters.get("skip_welcome_screen") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: skip_welcome_screen must be of type Boolean parameters[\"skip_welcome_screen\"]");
        }
        if (parameters.containsKey("ssl_required") && !(parameters.get("ssl_required") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: ssl_required must be of type String parameters[\"ssl_required\"]");
        }
        if (parameters.containsKey("sso_strategy_id") && !(parameters.get("sso_strategy_id") instanceof Long)) {
            throw new IllegalArgumentException("Bad parameter: sso_strategy_id must be of type Long parameters[\"sso_strategy_id\"]");
        }
        if (parameters.containsKey("subscribe_to_newsletter") && !(parameters.get("subscribe_to_newsletter") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: subscribe_to_newsletter must be of type Boolean parameters[\"subscribe_to_newsletter\"]");
        }
        if (parameters.containsKey("require_2fa") && !(parameters.get("require_2fa") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: require_2fa must be of type String parameters[\"require_2fa\"]");
        }
        if (parameters.containsKey("time_zone") && !(parameters.get("time_zone") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: time_zone must be of type String parameters[\"time_zone\"]");
        }
        if (parameters.containsKey("user_root") && !(parameters.get("user_root") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: user_root must be of type String parameters[\"user_root\"]");
        }
        if (parameters.containsKey("username") && !(parameters.get("username") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: username must be of type String parameters[\"username\"]");
        }
        Object[] urlParts = new String[]{FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), String.valueOf(id)};
        for (int i = 2; i < urlParts.length; ++i) {
            try {
                urlParts[i] = new URI(null, null, (String)urlParts[i], null).getRawPath();
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        String url = String.format("%s%s/users/%s", urlParts);
        TypeReference<User> typeReference = new TypeReference<User>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.PATCH, typeReference, parameters, options);
    }

    public static void delete(Long id, HashMap<String, Object> parameters) throws RuntimeException {
        User.delete(id, parameters, null);
    }

    public static void delete(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        User.delete(null, parameters, options);
    }

    public static void delete(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (id == null && parameters.containsKey("id") && parameters.get("id") != null) {
            id = (Long)parameters.get("id");
        }
        if (id == null) {
            throw new NullPointerException("Argument or Parameter missing: id parameters[\"id\"]");
        }
        if (!(id instanceof Long)) {
            throw new IllegalArgumentException("Bad parameter: id must be of type Long parameters[\"id\"]");
        }
        Object[] urlParts = new String[]{FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), String.valueOf(id)};
        for (int i = 2; i < urlParts.length; ++i) {
            try {
                urlParts[i] = new URI(null, null, (String)urlParts[i], null).getRawPath();
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        String url = String.format("%s%s/users/%s", urlParts);
        FilesClient.apiRequest(url, HttpMethods.RequestMethods.DELETE, parameters, options);
    }

    public static void destroy() throws RuntimeException {
        User.destroy(null, null, null);
    }

    public static void destroy(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        User.delete(id, parameters, options);
    }

    @Override
    @Generated
    public void setOptions(HashMap<String, Object> options) {
        this.options = options;
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @JsonProperty(value="username")
    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public Long[] getAdminGroupIds() {
        return this.adminGroupIds;
    }

    @JsonProperty(value="admin_group_ids")
    @Generated
    public void setAdminGroupIds(Long[] adminGroupIds) {
        this.adminGroupIds = adminGroupIds;
    }

    @Generated
    public String getAllowedIps() {
        return this.allowedIps;
    }

    @JsonProperty(value="allowed_ips")
    @Generated
    public void setAllowedIps(String allowedIps) {
        this.allowedIps = allowedIps;
    }

    @Generated
    public Boolean getAttachmentsPermission() {
        return this.attachmentsPermission;
    }

    @JsonProperty(value="attachments_permission")
    @Generated
    public void setAttachmentsPermission(Boolean attachmentsPermission) {
        this.attachmentsPermission = attachmentsPermission;
    }

    @Generated
    public Long getApiKeysCount() {
        return this.apiKeysCount;
    }

    @JsonProperty(value="api_keys_count")
    @Generated
    public void setApiKeysCount(Long apiKeysCount) {
        this.apiKeysCount = apiKeysCount;
    }

    @Generated
    public Date getAuthenticateUntil() {
        return this.authenticateUntil;
    }

    @JsonProperty(value="authenticate_until")
    @Generated
    public void setAuthenticateUntil(Date authenticateUntil) {
        this.authenticateUntil = authenticateUntil;
    }

    @Generated
    public String getAuthenticationMethod() {
        return this.authenticationMethod;
    }

    @JsonProperty(value="authentication_method")
    @Generated
    public void setAuthenticationMethod(String authenticationMethod) {
        this.authenticationMethod = authenticationMethod;
    }

    @Generated
    public String getAvatarUrl() {
        return this.avatarUrl;
    }

    @JsonProperty(value="avatar_url")
    @Generated
    public void setAvatarUrl(String avatarUrl) {
        this.avatarUrl = avatarUrl;
    }

    @Generated
    public Boolean getBillingPermission() {
        return this.billingPermission;
    }

    @JsonProperty(value="billing_permission")
    @Generated
    public void setBillingPermission(Boolean billingPermission) {
        this.billingPermission = billingPermission;
    }

    @Generated
    public Boolean getBypassSiteAllowedIps() {
        return this.bypassSiteAllowedIps;
    }

    @JsonProperty(value="bypass_site_allowed_ips")
    @Generated
    public void setBypassSiteAllowedIps(Boolean bypassSiteAllowedIps) {
        this.bypassSiteAllowedIps = bypassSiteAllowedIps;
    }

    @Generated
    public Boolean getBypassInactiveDisable() {
        return this.bypassInactiveDisable;
    }

    @JsonProperty(value="bypass_inactive_disable")
    @Generated
    public void setBypassInactiveDisable(Boolean bypassInactiveDisable) {
        this.bypassInactiveDisable = bypassInactiveDisable;
    }

    @Generated
    public Date getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public Boolean getDavPermission() {
        return this.davPermission;
    }

    @JsonProperty(value="dav_permission")
    @Generated
    public void setDavPermission(Boolean davPermission) {
        this.davPermission = davPermission;
    }

    @Generated
    public Boolean getDisabled() {
        return this.disabled;
    }

    @JsonProperty(value="disabled")
    @Generated
    public void setDisabled(Boolean disabled) {
        this.disabled = disabled;
    }

    @Generated
    public Boolean getDisabledExpiredOrInactive() {
        return this.disabledExpiredOrInactive;
    }

    @JsonProperty(value="disabled_expired_or_inactive")
    @Generated
    public void setDisabledExpiredOrInactive(Boolean disabledExpiredOrInactive) {
        this.disabledExpiredOrInactive = disabledExpiredOrInactive;
    }

    @Generated
    public String getEmail() {
        return this.email;
    }

    @JsonProperty(value="email")
    @Generated
    public void setEmail(String email) {
        this.email = email;
    }

    @Generated
    public Date getFirstLoginAt() {
        return this.firstLoginAt;
    }

    @JsonProperty(value="first_login_at")
    @Generated
    public void setFirstLoginAt(Date firstLoginAt) {
        this.firstLoginAt = firstLoginAt;
    }

    @Generated
    public Boolean getFtpPermission() {
        return this.ftpPermission;
    }

    @JsonProperty(value="ftp_permission")
    @Generated
    public void setFtpPermission(Boolean ftpPermission) {
        this.ftpPermission = ftpPermission;
    }

    @Generated
    public String getGroupIds() {
        return this.groupIds;
    }

    @JsonProperty(value="group_ids")
    @Generated
    public void setGroupIds(String groupIds) {
        this.groupIds = groupIds;
    }

    @Generated
    public String getHeaderText() {
        return this.headerText;
    }

    @JsonProperty(value="header_text")
    @Generated
    public void setHeaderText(String headerText) {
        this.headerText = headerText;
    }

    @Generated
    public String getLanguage() {
        return this.language;
    }

    @JsonProperty(value="language")
    @Generated
    public void setLanguage(String language) {
        this.language = language;
    }

    @Generated
    public Date getLastLoginAt() {
        return this.lastLoginAt;
    }

    @JsonProperty(value="last_login_at")
    @Generated
    public void setLastLoginAt(Date lastLoginAt) {
        this.lastLoginAt = lastLoginAt;
    }

    @Generated
    public Date getLastWebLoginAt() {
        return this.lastWebLoginAt;
    }

    @JsonProperty(value="last_web_login_at")
    @Generated
    public void setLastWebLoginAt(Date lastWebLoginAt) {
        this.lastWebLoginAt = lastWebLoginAt;
    }

    @Generated
    public Date getLastFtpLoginAt() {
        return this.lastFtpLoginAt;
    }

    @JsonProperty(value="last_ftp_login_at")
    @Generated
    public void setLastFtpLoginAt(Date lastFtpLoginAt) {
        this.lastFtpLoginAt = lastFtpLoginAt;
    }

    @Generated
    public Date getLastSftpLoginAt() {
        return this.lastSftpLoginAt;
    }

    @JsonProperty(value="last_sftp_login_at")
    @Generated
    public void setLastSftpLoginAt(Date lastSftpLoginAt) {
        this.lastSftpLoginAt = lastSftpLoginAt;
    }

    @Generated
    public Date getLastDavLoginAt() {
        return this.lastDavLoginAt;
    }

    @JsonProperty(value="last_dav_login_at")
    @Generated
    public void setLastDavLoginAt(Date lastDavLoginAt) {
        this.lastDavLoginAt = lastDavLoginAt;
    }

    @Generated
    public Date getLastDesktopLoginAt() {
        return this.lastDesktopLoginAt;
    }

    @JsonProperty(value="last_desktop_login_at")
    @Generated
    public void setLastDesktopLoginAt(Date lastDesktopLoginAt) {
        this.lastDesktopLoginAt = lastDesktopLoginAt;
    }

    @Generated
    public Date getLastRestapiLoginAt() {
        return this.lastRestapiLoginAt;
    }

    @JsonProperty(value="last_restapi_login_at")
    @Generated
    public void setLastRestapiLoginAt(Date lastRestapiLoginAt) {
        this.lastRestapiLoginAt = lastRestapiLoginAt;
    }

    @Generated
    public Date getLastApiUseAt() {
        return this.lastApiUseAt;
    }

    @JsonProperty(value="last_api_use_at")
    @Generated
    public void setLastApiUseAt(Date lastApiUseAt) {
        this.lastApiUseAt = lastApiUseAt;
    }

    @Generated
    public Date getLastActiveAt() {
        return this.lastActiveAt;
    }

    @JsonProperty(value="last_active_at")
    @Generated
    public void setLastActiveAt(Date lastActiveAt) {
        this.lastActiveAt = lastActiveAt;
    }

    @Generated
    public String getLastProtocolCipher() {
        return this.lastProtocolCipher;
    }

    @JsonProperty(value="last_protocol_cipher")
    @Generated
    public void setLastProtocolCipher(String lastProtocolCipher) {
        this.lastProtocolCipher = lastProtocolCipher;
    }

    @Generated
    public Date getLockoutExpires() {
        return this.lockoutExpires;
    }

    @JsonProperty(value="lockout_expires")
    @Generated
    public void setLockoutExpires(Date lockoutExpires) {
        this.lockoutExpires = lockoutExpires;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public String getCompany() {
        return this.company;
    }

    @JsonProperty(value="company")
    @Generated
    public void setCompany(String company) {
        this.company = company;
    }

    @Generated
    public String getNotes() {
        return this.notes;
    }

    @JsonProperty(value="notes")
    @Generated
    public void setNotes(String notes) {
        this.notes = notes;
    }

    @Generated
    public Long getNotificationDailySendTime() {
        return this.notificationDailySendTime;
    }

    @JsonProperty(value="notification_daily_send_time")
    @Generated
    public void setNotificationDailySendTime(Long notificationDailySendTime) {
        this.notificationDailySendTime = notificationDailySendTime;
    }

    @Generated
    public Boolean getOfficeIntegrationEnabled() {
        return this.officeIntegrationEnabled;
    }

    @JsonProperty(value="office_integration_enabled")
    @Generated
    public void setOfficeIntegrationEnabled(Boolean officeIntegrationEnabled) {
        this.officeIntegrationEnabled = officeIntegrationEnabled;
    }

    @Generated
    public Date getPasswordSetAt() {
        return this.passwordSetAt;
    }

    @JsonProperty(value="password_set_at")
    @Generated
    public void setPasswordSetAt(Date passwordSetAt) {
        this.passwordSetAt = passwordSetAt;
    }

    @Generated
    public Long getPasswordValidityDays() {
        return this.passwordValidityDays;
    }

    @JsonProperty(value="password_validity_days")
    @Generated
    public void setPasswordValidityDays(Long passwordValidityDays) {
        this.passwordValidityDays = passwordValidityDays;
    }

    @Generated
    public Long getPublicKeysCount() {
        return this.publicKeysCount;
    }

    @JsonProperty(value="public_keys_count")
    @Generated
    public void setPublicKeysCount(Long publicKeysCount) {
        this.publicKeysCount = publicKeysCount;
    }

    @Generated
    public Boolean getReceiveAdminAlerts() {
        return this.receiveAdminAlerts;
    }

    @JsonProperty(value="receive_admin_alerts")
    @Generated
    public void setReceiveAdminAlerts(Boolean receiveAdminAlerts) {
        this.receiveAdminAlerts = receiveAdminAlerts;
    }

    @Generated
    public String getRequire2fa() {
        return this.require2fa;
    }

    @JsonProperty(value="require_2fa")
    @Generated
    public void setRequire2fa(String require2fa) {
        this.require2fa = require2fa;
    }

    @Generated
    public Date getRequireLoginBy() {
        return this.requireLoginBy;
    }

    @JsonProperty(value="require_login_by")
    @Generated
    public void setRequireLoginBy(Date requireLoginBy) {
        this.requireLoginBy = requireLoginBy;
    }

    @Generated
    public Boolean getActive2fa() {
        return this.active2fa;
    }

    @JsonProperty(value="active_2fa")
    @Generated
    public void setActive2fa(Boolean active2fa) {
        this.active2fa = active2fa;
    }

    @Generated
    public Boolean getRequirePasswordChange() {
        return this.requirePasswordChange;
    }

    @JsonProperty(value="require_password_change")
    @Generated
    public void setRequirePasswordChange(Boolean requirePasswordChange) {
        this.requirePasswordChange = requirePasswordChange;
    }

    @Generated
    public Boolean getPasswordExpired() {
        return this.passwordExpired;
    }

    @JsonProperty(value="password_expired")
    @Generated
    public void setPasswordExpired(Boolean passwordExpired) {
        this.passwordExpired = passwordExpired;
    }

    @Generated
    public Boolean getReadonlySiteAdmin() {
        return this.readonlySiteAdmin;
    }

    @JsonProperty(value="readonly_site_admin")
    @Generated
    public void setReadonlySiteAdmin(Boolean readonlySiteAdmin) {
        this.readonlySiteAdmin = readonlySiteAdmin;
    }

    @Generated
    public Boolean getRestapiPermission() {
        return this.restapiPermission;
    }

    @JsonProperty(value="restapi_permission")
    @Generated
    public void setRestapiPermission(Boolean restapiPermission) {
        this.restapiPermission = restapiPermission;
    }

    @Generated
    public Boolean getSelfManaged() {
        return this.selfManaged;
    }

    @JsonProperty(value="self_managed")
    @Generated
    public void setSelfManaged(Boolean selfManaged) {
        this.selfManaged = selfManaged;
    }

    @Generated
    public Boolean getSftpPermission() {
        return this.sftpPermission;
    }

    @JsonProperty(value="sftp_permission")
    @Generated
    public void setSftpPermission(Boolean sftpPermission) {
        this.sftpPermission = sftpPermission;
    }

    @Generated
    public Boolean getSiteAdmin() {
        return this.siteAdmin;
    }

    @JsonProperty(value="site_admin")
    @Generated
    public void setSiteAdmin(Boolean siteAdmin) {
        this.siteAdmin = siteAdmin;
    }

    @Generated
    public Boolean getSkipWelcomeScreen() {
        return this.skipWelcomeScreen;
    }

    @JsonProperty(value="skip_welcome_screen")
    @Generated
    public void setSkipWelcomeScreen(Boolean skipWelcomeScreen) {
        this.skipWelcomeScreen = skipWelcomeScreen;
    }

    @Generated
    public String getSslRequired() {
        return this.sslRequired;
    }

    @JsonProperty(value="ssl_required")
    @Generated
    public void setSslRequired(String sslRequired) {
        this.sslRequired = sslRequired;
    }

    @Generated
    public Long getSsoStrategyId() {
        return this.ssoStrategyId;
    }

    @JsonProperty(value="sso_strategy_id")
    @Generated
    public void setSsoStrategyId(Long ssoStrategyId) {
        this.ssoStrategyId = ssoStrategyId;
    }

    @Generated
    public Boolean getSubscribeToNewsletter() {
        return this.subscribeToNewsletter;
    }

    @JsonProperty(value="subscribe_to_newsletter")
    @Generated
    public void setSubscribeToNewsletter(Boolean subscribeToNewsletter) {
        this.subscribeToNewsletter = subscribeToNewsletter;
    }

    @Generated
    public Boolean getExternallyManaged() {
        return this.externallyManaged;
    }

    @JsonProperty(value="externally_managed")
    @Generated
    public void setExternallyManaged(Boolean externallyManaged) {
        this.externallyManaged = externallyManaged;
    }

    @Generated
    public String getTimeZone() {
        return this.timeZone;
    }

    @JsonProperty(value="time_zone")
    @Generated
    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    @Generated
    public String getTypeOf2fa() {
        return this.typeOf2fa;
    }

    @JsonProperty(value="type_of_2fa")
    @Generated
    public void setTypeOf2fa(String typeOf2fa) {
        this.typeOf2fa = typeOf2fa;
    }

    @Generated
    public String getTypeOf2faForDisplay() {
        return this.typeOf2faForDisplay;
    }

    @JsonProperty(value="type_of_2fa_for_display")
    @Generated
    public void setTypeOf2faForDisplay(String typeOf2faForDisplay) {
        this.typeOf2faForDisplay = typeOf2faForDisplay;
    }

    @Generated
    public String getUserRoot() {
        return this.userRoot;
    }

    @JsonProperty(value="user_root")
    @Generated
    public void setUserRoot(String userRoot) {
        this.userRoot = userRoot;
    }

    @Generated
    public Long getDaysRemainingUntilPasswordExpire() {
        return this.daysRemainingUntilPasswordExpire;
    }

    @JsonProperty(value="days_remaining_until_password_expire")
    @Generated
    public void setDaysRemainingUntilPasswordExpire(Long daysRemainingUntilPasswordExpire) {
        this.daysRemainingUntilPasswordExpire = daysRemainingUntilPasswordExpire;
    }

    @Generated
    public Date getPasswordExpireAt() {
        return this.passwordExpireAt;
    }

    @JsonProperty(value="password_expire_at")
    @Generated
    public void setPasswordExpireAt(Date passwordExpireAt) {
        this.passwordExpireAt = passwordExpireAt;
    }

    @Generated
    public byte[] getAvatarFile() {
        return this.avatarFile;
    }

    @JsonProperty(value="avatar_file")
    @Generated
    public void setAvatarFile(byte[] avatarFile) {
        this.avatarFile = avatarFile;
    }

    @Generated
    public Boolean getAvatarDelete() {
        return this.avatarDelete;
    }

    @JsonProperty(value="avatar_delete")
    @Generated
    public void setAvatarDelete(Boolean avatarDelete) {
        this.avatarDelete = avatarDelete;
    }

    @Generated
    public String getChangePassword() {
        return this.changePassword;
    }

    @JsonProperty(value="change_password")
    @Generated
    public void setChangePassword(String changePassword) {
        this.changePassword = changePassword;
    }

    @Generated
    public String getChangePasswordConfirmation() {
        return this.changePasswordConfirmation;
    }

    @JsonProperty(value="change_password_confirmation")
    @Generated
    public void setChangePasswordConfirmation(String changePasswordConfirmation) {
        this.changePasswordConfirmation = changePasswordConfirmation;
    }

    @Generated
    public String getGrantPermission() {
        return this.grantPermission;
    }

    @JsonProperty(value="grant_permission")
    @Generated
    public void setGrantPermission(String grantPermission) {
        this.grantPermission = grantPermission;
    }

    @Generated
    public Long getGroupId() {
        return this.groupId;
    }

    @JsonProperty(value="group_id")
    @Generated
    public void setGroupId(Long groupId) {
        this.groupId = groupId;
    }

    @Generated
    public String getImportedPasswordHash() {
        return this.importedPasswordHash;
    }

    @JsonProperty(value="imported_password_hash")
    @Generated
    public void setImportedPasswordHash(String importedPasswordHash) {
        this.importedPasswordHash = importedPasswordHash;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @JsonProperty(value="password")
    @Generated
    public void setPassword(String password) {
        this.password = password;
    }

    @Generated
    public String getPasswordConfirmation() {
        return this.passwordConfirmation;
    }

    @JsonProperty(value="password_confirmation")
    @Generated
    public void setPasswordConfirmation(String passwordConfirmation) {
        this.passwordConfirmation = passwordConfirmation;
    }

    @Generated
    public Boolean getAnnouncementsRead() {
        return this.announcementsRead;
    }

    @JsonProperty(value="announcements_read")
    @Generated
    public void setAnnouncementsRead(Boolean announcementsRead) {
        this.announcementsRead = announcementsRead;
    }
}

